/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.ParentTrackChange;
import java.awt.Color;
import java.io.Serializable;

public class JCStyle
implements Serializable {
    protected ParentTrackChange parent = null;
    protected static final int FILL_STYLE = 1;
    protected static final int LINE_STYLE = 2;
    protected static final int SYMBOL_STYLE = 3;
    private static Color[] standardDefault = new Color[]{Color.red, Color.orange, Color.blue, Color.lightGray, Color.magenta, Color.yellow, Color.gray, Color.green, Color.darkGray, Color.cyan, Color.black, Color.pink, Color.white};
    protected static Color[] defaultColors = standardDefault;

    JCStyle() {
    }

    public static Color[] getDefaultColors() {
        return defaultColors;
    }

    public static void setDefaultColors(Color[] colorArray) {
        defaultColors = colorArray == null || colorArray.length < 1 ? standardDefault : colorArray;
    }

    void setChanged(boolean bl, int n2) {
        if (this.parent != null) {
            this.parent.callParentSetChanged(bl, n2);
        }
    }

    static Color getDefaultColor(JCChart3d jCChart3d, int n2) {
        Color color;
        if (jCChart3d == null || n2 < 1 || n2 > 3) {
            color = defaultColors[0];
        } else {
            JCChart3dArea jCChart3dArea;
            int n3 = jCChart3d.getColorIndex(n2);
            color = defaultColors[n3++];
            if (n3 >= defaultColors.length) {
                n3 = 0;
            }
            if ((jCChart3dArea = jCChart3d.getChart3dArea()) != null) {
                JCPlotCube jCPlotCube = jCChart3dArea.getPlotCube();
                JCFillStyle jCFillStyle = jCPlotCube.getDrawBackground();
                if (JCChart3dUtil.colorsNear(color, jCFillStyle.getBackground())) {
                    color = defaultColors[n3++];
                    if (n3 >= defaultColors.length) {
                        n3 = 0;
                    }
                }
                jCFillStyle.updateAnchorRect(null);
            }
            jCChart3d.setColorIndex(n3, n2);
        }
        return color;
    }
}

