/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Cube;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCProjection;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

public class JCPlotCube
extends ParentTrackChange {
    static final long serialVersionUID = -5542417106751358122L;
    protected double xScale = 1.0;
    protected double yScale = 1.0;
    protected double zScale = 1.0;
    protected JCProjection ceiling = null;
    protected JCProjection floor = null;
    protected Color background = null;
    protected Color foreground = null;
    protected double xNormalizedScale = 1.0;
    protected double yNormalizedScale = 1.0;
    protected double zNormalizedScale = 1.0;
    protected JCChart3dArea area = null;
    private ScreenPoint[] pts = new ScreenPoint[13];
    private Point4d pt = new Point4d();

    public JCPlotCube() {
    }

    public JCPlotCube(JCChart3dArea jCChart3dArea) {
        this.area = jCChart3dArea;
        this.addParent(jCChart3dArea);
    }

    JCPlotCube(JCChart3dArea jCChart3dArea, double d2, double d3, double d4, Color color, Color color2) {
        this(jCChart3dArea);
        this.xScale = d2;
        this.yScale = d3;
        this.zScale = d4;
        this.background = color;
        this.foreground = color2;
        this.normalizeScales();
    }

    public JCChart3dArea getChart3dArea() {
        return this.area;
    }

    public void setChart3dArea(JCChart3dArea jCChart3dArea) {
        if (this.area == jCChart3dArea) {
            return;
        }
        this.area = jCChart3dArea;
        this.clearParents();
        this.addParent(jCChart3dArea);
        this.callParentSetChanged(true, 2);
    }

    public void setXScale(double d2) {
        if (this.xScale == d2) {
            return;
        }
        if (!(d2 > 0.0)) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Must be positive."));
        }
        this.xScale = d2;
        this.normalizeScales();
        this.callParentSetChanged(true, 2);
    }

    public double getXScale() {
        return this.xScale;
    }

    public double getXNormalizedScale() {
        return this.xNormalizedScale;
    }

    public void setYScale(double d2) {
        if (this.yScale == d2) {
            return;
        }
        if (!(d2 > 0.0)) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Must be positive."));
        }
        this.yScale = d2;
        this.normalizeScales();
        this.callParentSetChanged(true, 2);
    }

    public double getYScale() {
        return this.yScale;
    }

    public double getYNormalizedScale() {
        return this.yNormalizedScale;
    }

    public void setZScale(double d2) {
        if (this.zScale == d2) {
            return;
        }
        if (!(d2 > 0.0)) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Must be positive."));
        }
        this.zScale = d2;
        this.normalizeScales();
        this.callParentSetChanged(true, 2);
    }

    public double getZScale() {
        return this.zScale;
    }

    public double getZNormalizedScale() {
        return this.zNormalizedScale;
    }

    protected void normalizeScales() {
        boolean bl = this.area != null && this.area.getChart3d().isProjection();
        double d2 = Math.max(this.xScale, this.yScale);
        if (!bl) {
            d2 = Math.max(d2, this.zScale);
        }
        this.xNormalizedScale = this.xScale / d2;
        this.yNormalizedScale = this.yScale / d2;
        this.zNormalizedScale = bl ? 1.0 : this.zScale / d2;
    }

    public void setBackground(Color color) {
        if (this.background == color) {
            return;
        }
        this.background = color;
        this.callParentSetChanged(true, 1);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setForeground(Color color) {
        if (this.foreground == color) {
            return;
        }
        this.foreground = color;
        this.callParentSetChanged(true, 1);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public JCFillStyle getDrawBackground() {
        Color color = this.background;
        if (color == null) {
            if (this.area != null) {
                color = this.area.getBackground();
                JCFillStyle jCFillStyle = this.area.getFillStyle();
                if (jCFillStyle != null && this.area.isOpaque()) {
                    Rectangle rectangle = GraphicsUtil.getDrawingArea(this.area, null);
                    jCFillStyle.updateAnchorRect(rectangle);
                    return jCFillStyle;
                }
                JCChart3d jCChart3d = this.area.getChart3d();
                jCFillStyle = jCChart3d.fillStyle;
                if (jCFillStyle != null && jCChart3d.isOpaque()) {
                    Rectangle rectangle = GraphicsUtil.getDrawingArea(jCChart3d, null);
                    jCFillStyle.updateAnchorRect(rectangle);
                    return jCFillStyle;
                }
            } else {
                color = Color.white;
            }
        }
        return new JCFillStyle(color, 1);
    }

    public Color getDrawForeground() {
        Color color = this.foreground;
        if (color == null && this.area != null) {
            color = this.area.getForeground();
        }
        return color;
    }

    public void setCeiling(JCProjection jCProjection) {
        if (this.ceiling == jCProjection) {
            return;
        }
        if (jCProjection == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.ceiling = jCProjection;
        this.ceiling.parent = this;
        this.callParentSetChanged(true, 1);
    }

    public JCProjection getCeiling() {
        return this.ceiling;
    }

    public void setFloor(JCProjection jCProjection) {
        if (this.floor == jCProjection) {
            return;
        }
        if (jCProjection == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.floor = jCProjection;
        this.floor.parent = this;
        this.callParentSetChanged(true, 1);
    }

    public JCProjection getFloor() {
        return this.floor;
    }

    public boolean hasCeilingProjection() {
        return this.ceiling != null && (this.ceiling.isContoured() || this.ceiling.isZoned());
    }

    public boolean hasFloorProjection() {
        return this.floor != null && (this.floor.isContoured() || this.floor.isZoned());
    }

    public boolean hasProjections() {
        return this.hasCeilingProjection() || this.hasFloorProjection();
    }

    protected void drawBoundingBox(Graphics graphics, boolean bl) {
        if (this.area == null || !this.area.getChart3d().isProjection()) {
            if (bl) {
                this.draw3dBoundingBox(graphics);
            }
        } else {
            this.draw2dBoundingBox(graphics, bl);
        }
    }

    protected void setPoint(int n2, Matrix4d matrix4d, double d2, double d3, double d4) {
        this.pt.set(d2, d3, d4, 1.0);
        Transform.transformPoint(matrix4d, this.pt);
        if (this.pts[n2] == null) {
            this.pts[n2] = new ScreenPoint();
        }
        this.pts[n2].setXPixel((int)Math.round(this.pt.x));
        this.pts[n2].setYPixel((int)Math.round(this.pt.y));
    }

    protected void drawLine(Graphics graphics, int n2, int n3) {
        if (this.pts[n2] == null) {
            return;
        }
        int n4 = this.pts[n2].getXPixel();
        int n5 = this.pts[n2].getYPixel();
        if (this.pts[n3] == null) {
            return;
        }
        int n6 = this.pts[n3].getXPixel();
        int n7 = this.pts[n3].getYPixel();
        graphics.drawLine(n4, n5, n6, n7);
    }

    protected void drawEdge(Graphics graphics, int n2) {
        this.drawLine(graphics, Cube.edges[n2][0], Cube.edges[n2][1]);
    }

    protected void draw3dBoundingBox(Graphics graphics) {
        int n2;
        if (this.area == null) {
            return;
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.mul(transform.getScreen(), transform.getPerspective());
        matrix4d.mul(transform.getRotation());
        Transform.scaleMatrix(matrix4d, this.getXNormalizedScale(), this.getYNormalizedScale(), this.getZNormalizedScale());
        for (int i2 = 0; i2 < 8; ++i2) {
            this.setPoint(i2, matrix4d, Cube.points[i2][0], Cube.points[i2][1], Cube.points[i2][2]);
        }
        JCFillStyle jCFillStyle = new JCFillStyle(Color.white, 1);
        jCFillStyle.resetGraphics(graphics);
        JCLineStyle jCLineStyle = new JCLineStyle(1, Color.black, 1);
        jCLineStyle.resetGraphics(graphics);
        Cube cube = this.area.getCube();
        if (this.background != null) {
            graphics.setColor(this.background);
            for (n2 = 0; n2 < 6; ++n2) {
                if (!cube.faceVisible[n2]) continue;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int n3 = Cube.faces[n2][i3];
                    nArray[i3] = this.pts[n3].getXPixel();
                    nArray2[i3] = this.pts[n3].getYPixel();
                }
                graphics.fillPolygon(nArray, nArray2, 4);
            }
        }
        graphics.setColor(this.getDrawForeground());
        for (n2 = 0; n2 < 12; ++n2) {
            if (!cube.drawEdge[n2]) continue;
            this.drawEdge(graphics, n2);
        }
    }

    protected void finishEdges(Graphics graphics) {
        if (this.area == null) {
            return;
        }
        boolean bl = false;
        Cube cube = this.area.getCube();
        JCLineStyle jCLineStyle = new JCLineStyle(1, Color.black, 1);
        jCLineStyle.resetGraphics(graphics);
        graphics.setColor(this.getDrawForeground());
        for (int i2 = 0; i2 < 12; ++i2) {
            if (cube.drawEdge[i2]) continue;
            switch (i2 / 4) {
                case 0: {
                    bl = this.area.getAxis(1).isShowing();
                    break;
                }
                case 1: {
                    bl = this.area.getAxis(2).isShowing();
                    break;
                }
                case 2: {
                    bl = this.area.getAxis(3).isShowing();
                }
            }
            if (!bl) continue;
            this.drawEdge(graphics, i2);
        }
    }

    protected void draw2dBoundingBox(Graphics graphics, boolean bl) {
        Cloneable cloneable;
        if (this.area == null) {
            return;
        }
        Transform transform = this.area.getTransform();
        if (bl) {
            cloneable = new Matrix4d();
            ((Matrix4d)cloneable).mul(transform.getScreen(), transform.getRotation());
            Transform.scaleMatrix((Matrix4d)cloneable, this.getXNormalizedScale(), this.getYNormalizedScale(), this.getZNormalizedScale());
            for (int i2 = 0; i2 < 4; ++i2) {
                int n2 = 2 * i2;
                this.setPoint(i2, (Matrix4d)cloneable, Cube.points[n2][0], Cube.points[n2][1], 0.0);
            }
            this.setPoint(4, (Matrix4d)cloneable, Cube.points[0][0], Cube.points[0][1], 0.0);
        }
        cloneable = new JCFillStyle(Color.white, 1);
        ((com.klg.jclass.util.style.JCFillStyle)cloneable).resetGraphics(graphics);
        JCLineStyle jCLineStyle = new JCLineStyle(1, Color.black, 1);
        jCLineStyle.resetGraphics(graphics);
        if (bl && this.background != null) {
            graphics.setColor(this.background);
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            for (int i3 = 0; i3 < 4; ++i3) {
                nArray[i3] = this.pts[i3].getXPixel();
                nArray2[i3] = this.pts[i3].getYPixel();
            }
            graphics.fillPolygon(nArray, nArray2, 4);
        }
        if (!bl) {
            graphics.setColor(this.getDrawForeground());
            for (int i4 = 0; i4 < 4; ++i4) {
                graphics.drawLine(this.pts[i4].getXPixel(), this.pts[i4].getYPixel(), this.pts[i4 + 1].getXPixel(), this.pts[i4 + 1].getYPixel());
            }
        }
    }

    protected void updateBoundingBox(Graphics graphics, int n2, int n3, int n4) {
        int n5;
        if (this.area == null) {
            return;
        }
        Color color = this.area.getBackground();
        JCLineStyle jCLineStyle = new JCLineStyle(1, color, 1);
        JCLineStyle jCLineStyle2 = new JCLineStyle(1, color, 3);
        Cube cube = this.area.getCube();
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.mul(transform.getScreen(), transform.getPerspective());
        matrix4d.mul(transform.getRotation());
        Transform.scaleMatrix(matrix4d, this.getXNormalizedScale(), this.getYNormalizedScale(), this.getZNormalizedScale());
        for (n5 = 0; n5 < 8; ++n5) {
            this.setPoint(n5, matrix4d, Cube.points[n5][0], Cube.points[n5][1], Cube.points[n5][2]);
        }
        this.setPoint(8, matrix4d, -0.8, -0.8, -1.0);
        this.setPoint(9, matrix4d, -0.8, -1.0, -1.0);
        this.setPoint(10, matrix4d, -1.0, -0.8, -1.0);
        switch (n2) {
            case 1: {
                this.setPoint(11, matrix4d, -1.5, 0.0, 0.0);
                this.setPoint(12, matrix4d, 1.5, 0.0, 0.0);
                break;
            }
            case 2: {
                this.setPoint(11, matrix4d, 0.0, -1.5, 0.0);
                this.setPoint(12, matrix4d, 0.0, 1.5, 0.0);
                break;
            }
            case 3: {
                this.setPoint(11, matrix4d, 0.0, 0.0, -1.5);
                this.setPoint(12, matrix4d, 0.0, 0.0, 1.5);
                break;
            }
            case 4: {
                this.setPoint(11, matrix4d, 0.0, 0.0, 0.0);
                if (this.pts[12] == null) {
                    this.pts[12] = new ScreenPoint();
                }
                this.pts[12].setXPixel(n3);
                this.pts[12].setYPixel(n4);
                break;
            }
            default: {
                this.pts[11] = null;
                this.pts[12] = null;
            }
        }
        jCLineStyle.setColor(this.area.getForeground());
        jCLineStyle2.setColor(this.area.getForeground());
        for (n5 = 0; n5 < 12; ++n5) {
            if (cube.drawEdge[n5] || this.area.getChart3d().isProjection()) {
                jCLineStyle.updateGraphics(graphics);
            } else {
                jCLineStyle2.updateGraphics(graphics);
            }
            this.drawEdge(graphics, n5);
        }
        jCLineStyle.updateGraphics(graphics);
        this.drawLine(graphics, 8, 9);
        this.drawLine(graphics, 8, 10);
        this.drawLine(graphics, 11, 12);
    }

    public void createParallelProjection(BufferedImage bufferedImage, JCProjection jCProjection) {
        this.createParallelProjection(bufferedImage, jCProjection, this.getDrawBackground());
    }

    public void createParallelProjection(BufferedImage bufferedImage, JCProjection jCProjection, JCFillStyle jCFillStyle) {
        this.createParallelProjection(bufferedImage, jCProjection, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), jCFillStyle);
    }

    public void createParallelProjection(BufferedImage bufferedImage, JCProjection jCProjection, int n2, int n3, int n4, int n5, JCFillStyle jCFillStyle) {
        Chart3dDataView chart3dDataView = this.area.getChart3d().getDataView(0);
        JCContour jCContour = chart3dDataView.getContour();
        Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dDataView.getElevationData();
        JCAxis jCAxis = this.area.getAxis(1);
        JCAxis jCAxis2 = this.area.getAxis(2);
        double d2 = jCAxis.getMin();
        double d3 = jCAxis2.getMin();
        double d4 = jCAxis.getMax() - jCAxis.getMin();
        double d5 = jCAxis.getDataportMin();
        double d6 = jCAxis2.getDataportMin();
        double d7 = jCAxis.getDataportMax() - jCAxis.getDataportMin();
        double d8 = jCAxis2.getDataportMax() - jCAxis2.getDataportMin();
        double d9 = 2.0 / d7;
        double d10 = 2.0 / d8;
        double d11 = -1.0 - d5 * d9;
        double d12 = -1.0 - d6 * d10;
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.m00 = d9;
        matrix4d.m03 = d11;
        matrix4d.m11 = d10;
        matrix4d.m13 = d12;
        matrix4d.m22 = 1.0;
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        matrix4d2.m00 = n4 / 2;
        matrix4d2.m03 = n2 + n4 / 2;
        matrix4d2.m11 = -n5 / 2;
        matrix4d2.m13 = n5 / 2 - n3;
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d3.mul(matrix4d2, matrix4d);
        this.area.getTransform().absolute = matrix4d;
        this.area.getTransform().view = matrix4d3;
        this.area.getTransform().eyePosition = new Point4d(0.0, 0.0, 1.0, 1.0);
        boolean bl = jCContour.isContoured();
        boolean bl2 = jCContour.isZoned();
        jCContour.setContouredNoUpdate(jCProjection.isContoured());
        jCContour.setZonedNoUpdate(jCProjection.isZoned());
        chart3dGridData.precomputePoints();
        chart3dGridData.calcAnnoLimits();
        jCContour.precompContours();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (jCFillStyle == null) {
            jCFillStyle = new JCFillStyle(Color.white, 1);
        }
        jCFillStyle.fillRect((Graphics)graphics2D, n2, n3, n4, n5);
        jCFillStyle.updateAnchorRect(null);
        double d13 = (d2 - d5) / d7 * (double)n4;
        double d14 = d13 + d4 / d7 * (double)n4;
        double d15 = 0.0;
        double d16 = (d8 - d3 + d6) * ((double)n5 / d8);
        graphics2D.setClip((int)Math.rint(d13), (int)Math.rint(d15), (int)Math.rint(d14), (int)Math.rint(d16));
        jCContour.draw3dZones(graphics2D);
        jCContour.drawContours(graphics2D);
        this.area.getTransform().computeTransformations(graphics2D);
        graphics2D.dispose();
        jCContour.setZonedNoUpdate(bl2);
        jCContour.setContouredNoUpdate(bl);
        chart3dGridData.precomputePoints();
        jCContour.precompContours();
    }

    protected void drawProjection(Graphics graphics, boolean bl) {
        if (this.area == null) {
            return;
        }
        JCProjection jCProjection = bl ? this.floor : this.ceiling;
        Chart3dDataView chart3dDataView = this.area.getChart3d().getDataView(0);
        JCContour jCContour = chart3dDataView.getContour();
        Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dDataView.getElevationData();
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = transform.getAbsolute();
        if (!chart3dDataView.isDataDrawn()) {
            return;
        }
        double d2 = matrix4d.m22;
        double d3 = matrix4d.m23;
        boolean bl2 = jCContour.isContoured();
        boolean bl3 = jCContour.isZoned();
        matrix4d.m22 = 0.0;
        matrix4d.m23 = bl ? -this.zNormalizedScale : this.zNormalizedScale;
        jCContour.setContouredNoUpdate(jCProjection.isContoured());
        jCContour.setZonedNoUpdate(jCProjection.isZoned());
        transform.computeViewMatrix();
        chart3dGridData.precomputePoints();
        jCContour.precompContours();
        jCContour.draw3dZones(graphics);
        jCContour.drawContours(graphics);
        matrix4d.m22 = d2;
        matrix4d.m23 = d3;
        jCContour.setContouredNoUpdate(bl2);
        jCContour.setZonedNoUpdate(bl3);
        transform.computeViewMatrix();
        chart3dGridData.precomputePoints();
        jCContour.precompContours();
    }

    protected void drawGridLines(Graphics graphics) {
        boolean bl;
        if (this.area == null) {
            return;
        }
        JCAxis jCAxis = this.area.getAxis(1);
        JCAxis jCAxis2 = this.area.getAxis(2);
        JCAxis jCAxis3 = this.area.getAxis(3);
        Transform transform = this.area.getTransform();
        Cube cube = this.area.getCube();
        boolean bl2 = jCAxis.getGridLines().getPlaneMask() > 0;
        boolean bl3 = jCAxis2.getGridLines().getPlaneMask() > 0;
        boolean bl4 = jCAxis3.getGridLines().getPlaneMask() > 0;
        boolean bl5 = bl = bl2 || bl3;
        if (!this.area.getChart3d().isProjection()) {
            boolean bl6 = bl = bl || bl4;
        }
        if (!bl) {
            return;
        }
        Matrix4d matrix4d = new Matrix4d();
        if (this.area.getChart3d().isProjection()) {
            matrix4d.mul(transform.getScreen(), transform.getRotation());
        } else {
            matrix4d.mul(transform.getScreen(), transform.getPerspective());
            matrix4d.mul(transform.getRotation());
        }
        Transform.scaleMatrix(matrix4d, this.getXNormalizedScale(), this.getYNormalizedScale(), this.getZNormalizedScale());
        Vector3d[] vector3dArray = new Vector3d[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            vector3dArray[i2] = new Vector3d();
        }
        Point3d point3d = new Point3d();
        for (int i3 = 0; i3 <= 5; ++i3) {
            int n2;
            if (!cube.faceVisible[i3]) continue;
            for (n2 = 0; n2 < 3; ++n2) {
                int n3 = Cube.faces[i3][n2];
                double[] dArray = Cube.points[n3];
                vector3dArray[n2].set(dArray[0], dArray[1], dArray[2]);
                if (n2 != 0) continue;
                point3d.set(vector3dArray[n2]);
            }
            vector3dArray[2].sub(vector3dArray[1]);
            vector3dArray[1].sub(vector3dArray[0]);
            vector3dArray[0].cross(vector3dArray[1], vector3dArray[2]);
            vector3dArray[0].absolute();
            n2 = vector3dArray[0].x > Math.max(vector3dArray[0].y, vector3dArray[0].z) ? 60 : (vector3dArray[0].y > Math.max(vector3dArray[0].x, vector3dArray[0].z) ? 51 : 15);
            if ((n2 & 3) > 0 && jCAxis.isShowing() && bl2) {
                jCAxis.getGridLines().drawGridFace(graphics, matrix4d, n2, point3d);
            }
            if ((n2 & 0xC) > 0 && jCAxis2.isShowing() && bl3) {
                jCAxis2.getGridLines().drawGridFace(graphics, matrix4d, n2, point3d);
            }
            if ((n2 & 0x30) <= 0 || !jCAxis3.isShowing() || !bl4) continue;
            jCAxis3.getGridLines().drawGridFace(graphics, matrix4d, n2, point3d);
        }
    }
}

