/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.CellSide;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.ColorBin;
import com.klg.jclass.chart3d.ContourCell;
import com.klg.jclass.chart3d.ContourLine;
import com.klg.jclass.chart3d.ContourSegment;
import com.klg.jclass.chart3d.DefaultColors;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.Intersection;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourMapping;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCProjection;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.chart3d.PolygonChain;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.data.JCDefault3dPointDataSource;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCContour
extends ParentTrackChange
implements JCContourMapping {
    public static final int ZONE_CONTOURS = 1;
    public static final int ZONE_CELLS_AVERAGE = 2;
    public static final int ZONE_CELLS_CORNER = 3;
    protected static final int CYCLE_CLOCKWISE = 0;
    protected static final int CYCLE_COUNTER_CLOCKWISE = 1;
    protected static final int LEFT_EDGE = 1;
    protected static final int RIGHT_EDGE = 2;
    protected static final int BOTTOM_EDGE = 4;
    protected static final int TOP_EDGE = 8;
    protected static final int BOTTOM_LEFT_CORNER = 5;
    protected static final int TOP_LEFT_CORNER = 9;
    protected static final int TOP_RIGHT_CORNER = 10;
    protected static final int BOTTOM_RIGHT_CORNER = 6;
    protected boolean contoured = false;
    protected boolean zoned = false;
    protected int zoneMethod = 1;
    protected JCContourLevels contourLevels = null;
    protected List<JCContourStyle> contourStyles = null;
    protected boolean defaultContourStyles = false;
    protected JCContourMapping contourMapping = this;
    protected Chart3dDataView dataView = null;
    protected DefaultColors defaultColors = new DefaultColors();
    protected Chart3dGridData data = null;
    protected Chart3dGridData zoneData = null;
    protected int xOffset = -1;
    protected int yOffset = -1;
    protected int numX = -1;
    protected int numY = -1;
    protected double dataHoleValue = Double.MAX_VALUE;
    protected double zoneHoleValue = Double.MAX_VALUE;
    protected List<ContourLine> contourLines = null;
    protected ContourCell[] contourCells = null;
    protected ColorBin[] bins = null;
    protected PolygonChain[] fixedChain = null;
    protected PolygonChain freeList = null;
    protected int pCount = 0;
    protected CellSide[] sides = null;
    protected int nHorizontalSides = 0;
    protected int nVerticalSides = 0;
    protected int firstIndex = 0;
    protected ContourSegment curSegment = null;
    protected int[] xPoints = null;
    protected int[] yPoints = null;

    public JCContour() {
        this.defaultContourStyles();
    }

    public JCContour(Chart3dDataView chart3dDataView) {
        this();
        this.setDataView(chart3dDataView);
    }

    protected void setDataView(Chart3dDataView chart3dDataView) {
        if (this.dataView == chart3dDataView) {
            return;
        }
        this.dataView = chart3dDataView;
        this.clearParents();
        this.addParent(chart3dDataView);
        if (this.contourLevels != null) {
            this.contourLevels.clearParents();
            this.contourLevels.addParent(chart3dDataView);
        }
        for (JCContourStyle jCContourStyle : this.contourStyles) {
            jCContourStyle.clearParents();
            jCContourStyle.addParent(chart3dDataView);
        }
        this.callParentSetChanged(true, 34);
    }

    public Chart3dDataView getDataView() {
        return this.dataView;
    }

    public void setContoured(boolean bl) {
        if (this.contoured == bl) {
            return;
        }
        this.contoured = bl;
        this.callParentSetChanged(true, 34);
    }

    protected void setContouredNoUpdate(boolean bl) {
        this.contoured = bl;
    }

    public boolean isContoured() {
        return this.contoured;
    }

    public void setZoned(boolean bl) {
        if (this.zoned == bl) {
            return;
        }
        this.zoned = bl;
        this.callParentSetChanged(true, 34);
    }

    protected void setZonedNoUpdate(boolean bl) {
        this.zoned = bl;
    }

    public boolean isZoned() {
        return this.zoned;
    }

    public void setZoneMethod(int n2) {
        if (this.zoneMethod == n2) {
            return;
        }
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Should be one of ZONE_CONTOURS or ZONE_CELLS."));
        }
        this.zoneMethod = n2;
        this.callParentSetChanged(true, 34);
    }

    public int getZoneMethod() {
        return this.zoneMethod;
    }

    public void setContourLevels(JCContourLevels jCContourLevels) {
        if (this.contourLevels == jCContourLevels) {
            return;
        }
        this.contourLevels = jCContourLevels;
        if (this.contourLevels == null) {
            this.contourLevels = new JCContourLevels();
        }
        this.contourLevels.clearParents();
        this.contourLevels.addParent(this.dataView);
        this.callParentSetChanged(true, 34);
    }

    public JCContourLevels getContourLevels() {
        return this.contourLevels;
    }

    public void setContourMapping(JCContourMapping jCContourMapping) {
        if (this.contourMapping == jCContourMapping) {
            return;
        }
        this.contourMapping = jCContourMapping;
        if (this.contourMapping == null) {
            this.contourMapping = this;
        }
        this.callParentSetChanged(true, 34);
    }

    public JCContourMapping getContourMapping() {
        return this.contourMapping;
    }

    public void setContourStyles(List<JCContourStyle> list) {
        if (list == null || list.size() == 0) {
            this.defaultContourStyles();
        } else {
            for (JCContourStyle jCContourStyle : list) {
                jCContourStyle.clearParents();
                jCContourStyle.addParent(this.dataView);
            }
            this.contourStyles = list;
            this.defaultContourStyles = false;
        }
        this.callParentSetChanged(true, 34);
    }

    public List<JCContourStyle> getContourStyles() {
        if (this.contourStyles == null) {
            this.defaultContourStyles();
            this.callParentSetChanged(true, 34);
        }
        return this.contourStyles;
    }

    public void resetContourStyles() {
        this.defaultContourStyles();
        this.callParentSetChanged(true, 34);
    }

    public boolean isDefaultContourStyles() {
        return this.defaultContourStyles;
    }

    protected DefaultColors getDefaultColors() {
        return this.defaultColors;
    }

    public List<ContourLine> getContourLines() {
        return this.contourLines;
    }

    public ContourCell[] getContourCells() {
        return this.contourCells;
    }

    protected boolean verticalSide(int n2) {
        return n2 % 2 == 0;
    }

    protected boolean horizontalSide(int n2) {
        return n2 % 2 == 1;
    }

    protected int leftSide(int n2, int n3) {
        return n3 * this.numX + n2;
    }

    protected int rightSide(int n2, int n3) {
        return this.leftSide(n2, n3) + 1;
    }

    protected int bottomSide(int n2, int n3) {
        return this.nVerticalSides + n2 * this.numY + n3;
    }

    protected int topSide(int n2, int n3) {
        return this.bottomSide(n2, n3) + 1;
    }

    protected int getSide(int n2, int n3, int n4) {
        int n5 = this.verticalSide(n4) ? this.rightSide(n2, n3) - n4 / 2 : this.topSide(n2, n3) - n4 / 2;
        return n5;
    }

    protected int cellIndex(int n2, int n3) {
        return n2 * (this.numY - 1) + n3;
    }

    protected void setInternalValues() {
        if (this.dataView == null) {
            return;
        }
        this.data = (Chart3dGridData)this.dataView.getElevationData();
        this.zoneData = this.dataView.getZoneData();
        if (!this.zoneData.isDataOK()) {
            this.zoneData = this.data;
        }
        this.dataHoleValue = this.data.getHoleValue();
        this.zoneHoleValue = this.zoneData.getHoleValue();
        GridLimits gridLimits = this.data.getGridLimits();
        this.xOffset = gridLimits.getXOffset();
        this.yOffset = gridLimits.getYOffset();
        this.numX = gridLimits.getNumX();
        this.numY = gridLimits.getNumY();
    }

    protected boolean avail(int n2, int n3, int n4, int n5, double d2, double d3) {
        int n6 = this.getSide(n2, n3, n4);
        if (n6 == this.firstIndex) {
            return true;
        }
        double[] dArray = this.contourLevels.getLevels();
        double d4 = dArray[n5];
        return !this.sides[n6].isUsed(n5) && (d2 - d4) * (d3 - d4) <= 0.0;
    }

    protected double interp(double d2, double d3, double d4, double d5, double d6) {
        if (d2 == d3) {
            return d4;
        }
        return d4 + (d6 - d2) * (d5 - d4) / (d3 - d2);
    }

    protected void addContourCell(int n2, int n3, int n4, int n5) {
        ContourCell contourCell = this.contourCells[this.cellIndex(n2, n3)];
        contourCell.setNewIntersection(new Intersection(n4, n5, this.curSegment));
    }

    protected void modifyContourCell(int n2, int n3, int n4) {
        boolean bl;
        int n5;
        ContourCell contourCell = this.contourCells[this.cellIndex(n2, n3)];
        Intersection intersection = contourCell.getNewIntersection();
        if (intersection == null) {
            return;
        }
        int n6 = intersection.getSide1();
        ContourSegment contourSegment = intersection.getSegment1();
        Point3d point3d = contourSegment.getPoint();
        Point3d point3d2 = this.curSegment.getPoint();
        if ((n6 - n4) % 2 == 0) {
            n5 = 4;
            bl = this.verticalSide(n4) ? point3d2.x < point3d.x : point3d2.y < point3d.y;
        } else {
            n5 = Math.max(n6, n4);
            if (n5 == 3 && (n4 == 0 || n6 == 0)) {
                n5 = 0;
            }
            boolean bl2 = bl = n5 != n4;
        }
        if (bl) {
            intersection.setSide1(n4);
            intersection.setSegment1(this.curSegment);
            intersection.setSide2(n6);
            intersection.setSegment2(contourSegment);
        } else {
            intersection.setSide2(n4);
            intersection.setSegment2(this.curSegment);
        }
        contourCell.addIntersection(intersection, n5);
        contourCell.setNewIntersection(null);
    }

    protected void reverseArray(Object[] objectArray, int n2) {
        if (objectArray.length < n2) {
            return;
        }
        int n3 = n2 / 2;
        --n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[n2 - i2];
            objectArray[n2 - i2] = object;
        }
    }

    protected void cycleArray(Object[] objectArray, int n2) {
        if (objectArray.length < 4) {
            return;
        }
        for (int i2 = 0; i2 < n2 % 4; ++i2) {
            Object object = objectArray[3];
            objectArray[3] = objectArray[2];
            objectArray[2] = objectArray[1];
            objectArray[1] = objectArray[0];
            objectArray[0] = object;
        }
    }

    protected void addPoint(int n2, int n3, double d2, double d3) {
        int n4 = this.contourLines.size();
        ContourLine contourLine = this.contourLines.get(n4 - 1);
        this.curSegment = new ContourSegment();
        contourLine.addContourSegment(this.curSegment);
        double[] dArray = this.contourLevels.getLevels();
        Point3d point3d = new Point3d();
        point3d.x = d2;
        point3d.y = d3;
        if (this.zoneData == this.data) {
            point3d.z = dArray[contourLine.getLevel()];
        } else {
            double d4 = this.data.getX(n2 += this.xOffset);
            double d5 = this.data.getY(n3 += this.yOffset);
            double d6 = this.data.getZValue(n2, n3);
            double d7 = d4;
            double d8 = this.data.getY(n3 + 1);
            double d9 = this.data.getZValue(n2, n3 + 1);
            double d10 = this.data.getX(n2 + 1);
            double d11 = d8;
            double d12 = this.data.getZValue(n2 + 1, n3 + 1);
            double d13 = d10;
            double d14 = d5;
            double d15 = this.data.getZValue(n2 + 1, n3);
            if (d2 == d4) {
                point3d.z = d6 == this.dataHoleValue || d9 == this.dataHoleValue ? this.dataHoleValue : this.interp(d5, d8, d6, d9, d3);
            } else if (d2 == d10) {
                point3d.z = d12 == this.dataHoleValue || d15 == this.dataHoleValue ? this.dataHoleValue : this.interp(d11, d14, d12, d15, d3);
            } else if (d3 == d5) {
                point3d.z = d6 == this.dataHoleValue || d15 == this.dataHoleValue ? this.dataHoleValue : this.interp(d4, d13, d6, d15, d2);
            } else if (d3 == d8) {
                point3d.z = d9 == this.dataHoleValue || d12 == this.dataHoleValue ? this.dataHoleValue : this.interp(d7, d10, d9, d12, d2);
            } else if (d6 == this.dataHoleValue || d9 == this.dataHoleValue || d12 == this.dataHoleValue || d15 == this.dataHoleValue) {
                point3d.z = this.dataHoleValue;
            } else {
                double d16 = this.interp(d5, d8, d6, d9, d3);
                double d17 = this.interp(d11, d14, d12, d15, d3);
                double d18 = this.interp(d4, d13, d16, d17, d2);
                d16 = this.interp(d4, d13, d6, d15, d2);
                d17 = this.interp(d7, d10, d9, d12, d2);
                double d19 = this.interp(d5, d8, d16, d17, d3);
                point3d.z = (d18 + d19) / 2.0;
            }
        }
        this.curSegment.setPoint(point3d);
    }

    protected void startContour(int n2, int n3, int n4, Point3d point3d, Point3d point3d2) {
        if (this.contourLines == null) {
            this.contourLines = new ArrayList<ContourLine>();
        }
        ContourLine contourLine = new ContourLine(n4);
        this.contourLines.add(contourLine);
        double[] dArray = this.contourLevels.getLevels();
        double d2 = dArray[n4];
        double d3 = point3d2.x * (d2 - point3d.z) - point3d.x * (d2 - point3d2.z);
        double d4 = point3d2.y * (d2 - point3d.z) - point3d.y * (d2 - point3d2.z);
        this.addPoint(n2, n3, d3 /= point3d2.z - point3d.z, d4 /= point3d2.z - point3d.z);
    }

    protected void contour(int n2, int n3, int n4, int n5, int n6) {
        int n7;
        Object[] objectArray = new Integer[4];
        Object[] objectArray2 = new Point3d[4];
        for (n7 = 0; n7 < objectArray2.length; ++n7) {
            objectArray2[n7] = new Point3d();
        }
        boolean bl = false;
        boolean bl2 = true;
        while (!bl && n3 >= 0 && n4 >= 0 && n3 < this.numX - 1 && n4 < this.numY - 1) {
            int n8 = this.xOffset + n3;
            int n9 = this.yOffset + n4;
            objectArray2[3].z = this.zoneData.getZValue(n8, n9);
            objectArray2[0].z = this.zoneData.getZValue(n8 + 1, n9);
            objectArray2[1].z = this.zoneData.getZValue(n8 + 1, n9 + 1);
            objectArray2[2].z = this.zoneData.getZValue(n8, n9 + 1);
            if (objectArray2[0].z == this.zoneHoleValue || objectArray2[1].z == this.zoneHoleValue || objectArray2[2].z == this.zoneHoleValue || objectArray2[3].z == this.zoneHoleValue) break;
            objectArray2[2].x = objectArray2[3].x = this.zoneData.getX(n8);
            objectArray2[0].y = objectArray2[3].y = this.zoneData.getY(n9);
            objectArray2[0].x = objectArray2[1].x = this.zoneData.getX(n8 + 1);
            objectArray2[2].y = objectArray2[1].y = this.zoneData.getY(n9 + 1);
            for (n7 = 0; n7 < objectArray.length; ++n7) {
                objectArray[n7] = new Integer(n7);
            }
            this.cycleArray(objectArray2, 3 - n6);
            this.cycleArray(objectArray, 3 - n6);
            if (n2 == 0) {
                this.reverseArray(objectArray2, 4);
                this.reverseArray(objectArray, 3);
            }
            if (bl2) {
                this.startContour(n3, n4, n5, (Point3d)objectArray2[3], (Point3d)objectArray2[0]);
                bl2 = false;
            }
            for (n7 = 0; n7 < 3; ++n7) {
                double d2;
                double d3;
                int n10 = (Integer)objectArray[n7];
                if (!this.avail(n3, n4, n10, n5, ((Point3d)objectArray2[n7]).z, ((Point3d)objectArray2[n7 + 1]).z)) continue;
                this.addContourCell(n3, n4, n5, n6);
                if (((Point3d)objectArray2[n7]).z == ((Point3d)objectArray2[n7 + 1]).z) {
                    d3 = (((Point3d)objectArray2[n7 + 1]).x + ((Point3d)objectArray2[n7]).x) / 2.0;
                    d2 = (((Point3d)objectArray2[n7 + 1]).y + ((Point3d)objectArray2[n7]).y) / 2.0;
                } else {
                    double[] dArray = this.contourLevels.getLevels();
                    double d4 = dArray[n5];
                    d3 = ((Point3d)objectArray2[n7 + 1]).x * (d4 - ((Point3d)objectArray2[n7]).z) - ((Point3d)objectArray2[n7]).x * (d4 - ((Point3d)objectArray2[n7 + 1]).z);
                    d2 = ((Point3d)objectArray2[n7 + 1]).y * (d4 - ((Point3d)objectArray2[n7]).z) - ((Point3d)objectArray2[n7]).y * (d4 - ((Point3d)objectArray2[n7 + 1]).z);
                    d3 /= ((Point3d)objectArray2[n7 + 1]).z - ((Point3d)objectArray2[n7]).z;
                    d2 /= ((Point3d)objectArray2[n7 + 1]).z - ((Point3d)objectArray2[n7]).z;
                }
                this.addPoint(n3, n4, d3, d2);
                this.modifyContourCell(n3, n4, n10);
                int n11 = this.getSide(n3, n4, n10);
                this.sides[n11].setUsed(n5);
                if (n11 != this.firstIndex) {
                    switch (n10) {
                        case 0: {
                            ++n3;
                            n6 = 2;
                            break;
                        }
                        case 1: {
                            ++n4;
                            n6 = 3;
                            break;
                        }
                        case 2: {
                            --n3;
                            n6 = 0;
                            break;
                        }
                        case 3: {
                            --n4;
                            n6 = 1;
                        }
                    }
                    break;
                }
                bl = true;
                break;
            }
            if (n7 != 3) continue;
            bl = true;
        }
        this.curSegment = null;
    }

    protected void setContourCellHole(int n2, int n3) {
        int n4 = 0;
        if (n2 == 0) {
            n4 |= 1;
        } else if (n2 == this.numX - 1) {
            n4 |= 2;
        }
        if (n3 == 0) {
            n4 |= 4;
        } else if (n3 == this.numY - 1) {
            n4 |= 8;
        }
        switch (n4) {
            case 1: {
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                break;
            }
            case 2: {
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
                break;
            }
            case 4: {
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                break;
            }
            case 8: {
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                break;
            }
            case 5: {
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                break;
            }
            case 9: {
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                break;
            }
            case 6: {
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                break;
            }
            case 10: {
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
                break;
            }
            default: {
                this.contourCells[this.cellIndex(n2, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2, n3 - 1)].setHole(true);
                this.contourCells[this.cellIndex(n2 - 1, n3)].setHole(true);
                this.contourCells[this.cellIndex(n2 - 1, n3 - 1)].setHole(true);
            }
        }
    }

    public void calcContours() {
        int n2;
        this.destroyContours();
        if (this.dataView == null) {
            return;
        }
        this.setInternalValues();
        if (!this.data.isDataOK()) {
            return;
        }
        if (this.dataView.getChartType() != 0) {
            return;
        }
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCProjection jCProjection = jCChart3dArea.getPlotCube().getFloor();
        JCProjection jCProjection2 = jCChart3dArea.getPlotCube().getCeiling();
        boolean bl = this.contoured || jCProjection.isContoured() || jCProjection2.isContoured();
        boolean bl2 = this.zoned || jCProjection.isZoned() || jCProjection2.isZoned();
        boolean bl3 = bl || bl2 && this.zoneMethod == 1;
        int n3 = this.contourLevels.getNumLevelsInternal();
        double[] dArray = this.contourLevels.getLevels();
        if (bl3) {
            this.nVerticalSides = (this.numY - 1) * this.numX;
            this.nHorizontalSides = (this.numX - 1) * this.numY;
            this.sides = new CellSide[this.nVerticalSides + this.nHorizontalSides];
            for (n2 = 0; n2 < this.nVerticalSides + this.nHorizontalSides; ++n2) {
                this.sides[n2] = new CellSide(n3);
            }
        }
        this.contourCells = new ContourCell[(this.numX - 1) * (this.numY - 1)];
        for (n2 = 0; n2 < this.contourCells.length; ++n2) {
            this.contourCells[n2] = new ContourCell();
        }
        n2 = 0;
        int n4 = this.numX - 1;
        int n5 = 0;
        int n6 = this.numY - 1;
        for (int i2 = n5; i2 <= n6; ++i2) {
            double d2;
            double d3 = d2 = this.zoneData.getZValue(this.xOffset + n2, this.yOffset + i2);
            for (int i3 = n2; i3 <= n4; ++i3) {
                if (i3 != n4) {
                    d3 = this.zoneData.getZValue(this.xOffset + i3 + 1, this.yOffset + i2);
                }
                if (d2 != this.zoneHoleValue) {
                    int n7;
                    int n8;
                    int n9;
                    double d4;
                    double d5;
                    if (i3 != n4 && bl3 && d3 != this.zoneHoleValue) {
                        if (d2 <= d3) {
                            d5 = d2;
                            d4 = d3;
                            n9 = 1;
                        } else {
                            d5 = d3;
                            d4 = d2;
                            n9 = 0;
                        }
                        n8 = this.bottomSide(i3, i2);
                        for (n7 = 0; n7 < n3 && dArray[n7] < d5; ++n7) {
                        }
                        while (n7 < n3 && dArray[n7] < d4) {
                            if (!this.sides[n8].isUsed(n7)) {
                                this.firstIndex = n8;
                                this.contour(n9, i3, i2, n7, 3);
                                if (!this.sides[n8].isUsed(n7)) {
                                    this.contour(1 - n9, i3, i2 - 1, n7, 1);
                                }
                            }
                            ++n7;
                        }
                    }
                    if (i2 != n6 && bl3) {
                        double d6 = d2;
                        double d7 = this.zoneData.getZValue(this.xOffset + i3, this.yOffset + i2 + 1);
                        if (d7 != this.zoneHoleValue) {
                            if (d6 <= d7) {
                                d5 = d6;
                                d4 = d7;
                                n9 = 0;
                            } else {
                                d5 = d7;
                                d4 = d6;
                                n9 = 1;
                            }
                            n8 = this.leftSide(i3, i2);
                            for (n7 = 0; n7 < n3 && dArray[n7] < d5; ++n7) {
                            }
                            while (n7 < n3 && dArray[n7] < d4) {
                                if (!this.sides[n8].isUsed(n7)) {
                                    this.firstIndex = n8;
                                    this.contour(n9, i3, i2, n7, 2);
                                    if (!this.sides[n8].isUsed(n7)) {
                                        this.contour(1 - n9, i3 - 1, i2, n7, 0);
                                    }
                                }
                                ++n7;
                            }
                        }
                    }
                } else {
                    this.setContourCellHole(i3, i2);
                }
                d2 = d3;
            }
        }
        if (bl3) {
            for (ContourCell contourCell : this.contourCells) {
                contourCell.sortIntersectionLists();
            }
        }
        this.nVerticalSides = 0;
        this.nHorizontalSides = 0;
        this.sides = null;
    }

    public void recalcContours() {
        boolean bl;
        boolean bl2;
        if (this.dataView == null) {
            return;
        }
        if (!this.dataView.isDataDrawn() || !(this.dataView.getElevationData() instanceof Chart3dGridData)) {
            return;
        }
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCProjection jCProjection = jCChart3dArea.getPlotCube().getFloor();
        JCProjection jCProjection2 = jCChart3dArea.getPlotCube().getCeiling();
        boolean bl3 = this.contoured || jCProjection.isContoured() || jCProjection2.isContoured();
        boolean bl4 = bl2 = this.zoned || jCProjection.isZoned() || jCProjection2.isZoned();
        if (!bl3 && !bl2) {
            this.destroyContours();
            return;
        }
        boolean bl5 = bl = bl3 && (this.contourLines == null || this.contourCells == null);
        if (!bl && bl2) {
            if (this.zoneMethod == 1) {
                bl = this.contourLines == null || this.contourCells == null;
            } else {
                boolean bl6 = bl = this.contourCells == null;
            }
        }
        if (bl) {
            this.calcContours();
        }
    }

    public void destroyContours() {
        this.contourLines = null;
        this.contourCells = null;
    }

    protected void precompContours() {
        if (this.contourLines == null || this.dataView == null) {
            return;
        }
        Point4d point4d = new Point4d();
        Transform transform = this.dataView.getChart3d().getChart3dArea().getTransform();
        ListIterator<ContourLine> listIterator = this.contourLines.listIterator();
        while (listIterator.hasNext()) {
            ContourLine contourLine = listIterator.next();
            LinkedList<ContourSegment> linkedList = contourLine.getSegments();
            ListIterator listIterator2 = linkedList.listIterator();
            while (listIterator2.hasNext()) {
                ContourSegment contourSegment = (ContourSegment)listIterator2.next();
                Point3d point3d = contourSegment.getPoint();
                point4d.set(point3d);
                Matrix4d matrix4d = transform.getAbsolute();
                if (matrix4d.m22 == 0.0) {
                    point4d.z = 0.0;
                }
                Transform.transformPoint(transform.getView(), point4d);
                contourSegment.setXPixel((int)Math.round(point4d.x));
                contourSegment.setYPixel((int)Math.round(point4d.y));
            }
        }
    }

    protected void allocatePoints(int n2) {
        if (this.xPoints == null || this.xPoints.length < n2) {
            this.xPoints = new int[n2];
            this.yPoints = new int[n2];
        }
    }

    protected void defaultContourStyles() {
        this.contourStyles = new ArrayList<JCContourStyle>();
        for (int i2 = 0; i2 < this.defaultColors.getNumColors(); ++i2) {
            JCContourStyle jCContourStyle = new JCContourStyle(this.defaultColors.getColor(i2));
            jCContourStyle.addParent(this.dataView);
            this.contourStyles.add(jCContourStyle);
        }
        this.defaultContourStyles = true;
    }

    protected void allocColorBins(Graphics graphics) {
        int n2 = this.contourLevels.getNumLevelsInternal() + 1;
        this.bins = new ColorBin[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bins[i2] = new ColorBin(this, graphics, i2);
        }
    }

    protected void flushColorBins() {
        if (this.bins == null) {
            return;
        }
        for (ColorBin colorBin : this.bins) {
            colorBin.flushBin();
        }
        this.bins = null;
    }

    @Override
    public int contourIndex(int n2) {
        int n3 = this.contourLevels.getNumLevelsInternal();
        int n4 = 0;
        if (n3 > 0) {
            double d2 = n2 * (this.contourStyles.size() - 1);
            n4 = (int)Math.round(d2 /= (double)n3);
        }
        return n4;
    }

    public JCContourStyle getContourStyleFromLevel(int n2) {
        if (this.contourStyles == null || this.contourStyles.size() == 0) {
            return null;
        }
        int n3 = this.contourMapping.contourIndex(n2);
        JCContourStyle jCContourStyle = this.contourStyles.get(n3);
        if (jCContourStyle == null) {
            return null;
        }
        jCContourStyle.initialize(this, n3);
        return jCContourStyle;
    }

    protected boolean setLineStyle(Graphics graphics, int n2) {
        JCContourStyle jCContourStyle = this.getContourStyleFromLevel(n2);
        if (jCContourStyle == null) {
            return false;
        }
        JCLineStyle jCLineStyle = jCContourStyle.getLineStyle();
        return jCLineStyle.updateGraphics(graphics);
    }

    protected void setFillStyle(Graphics graphics, int n2) {
        JCContourStyle jCContourStyle = this.getContourStyleFromLevel(n2);
        if (jCContourStyle == null) {
            return;
        }
        JCFillStyle jCFillStyle = jCContourStyle.getFillStyle();
        jCFillStyle.updateGraphics(graphics);
    }

    protected void setZLineColor(Graphics graphics, int n2) {
        JCContourStyle jCContourStyle = this.getContourStyleFromLevel(n2);
        if (jCContourStyle == null) {
            return;
        }
        graphics.setColor(jCContourStyle.getFillStyle().getColor());
    }

    protected void fillRectangle(int n2, int n3, boolean bl) {
        int n4 = n2 + this.xOffset;
        int n5 = n3 + this.yOffset;
        double d2 = bl ? (this.zoneData.getZValue(n4, n5) + this.zoneData.getZValue(n4 + 1, n5) + this.zoneData.getZValue(n4, n5 + 1) + this.zoneData.getZValue(n4 + 1, n5 + 1)) / 4.0 : this.zoneData.getZValue(n4, n5);
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        int n6 = screenPointArray[n4][n5].getXPixel();
        int n7 = screenPointArray[n4][n5 + 1].getYPixel();
        int n8 = screenPointArray[n4 + 1][n5].getXPixel() - n6;
        int n9 = screenPointArray[n4][n5].getYPixel() - n7;
        Rectangle rectangle = new Rectangle(n6, n7, n8, n9);
        int n10 = this.contourLevels.getLevelFromValue(d2);
        this.bins[n10].addObjectToBin(rectangle);
    }

    protected PolygonChain makePChain(int n2, int n3, double d2, double d3) {
        PolygonChain polygonChain;
        if (this.fixedChain == null) {
            this.fixedChain = new PolygonChain[20];
            for (int i2 = 0; i2 < this.fixedChain.length; ++i2) {
                this.fixedChain[i2] = polygonChain = new PolygonChain();
                if (i2 <= 0) continue;
                this.fixedChain[i2 - 1].setNext(polygonChain);
            }
            this.freeList = this.fixedChain[0];
        }
        polygonChain = this.freeList;
        this.freeList = this.freeList.getNext();
        polygonChain.setValues(n2, n3, d2, d3);
        polygonChain.setNext(null);
        ++this.pCount;
        return polygonChain;
    }

    protected PolygonChain copyChain(PolygonChain polygonChain) {
        PolygonChain polygonChain2 = null;
        if (polygonChain != null) {
            PolygonChain polygonChain3 = polygonChain2 = this.makePChain(polygonChain.getXPixel(), polygonChain.getYPixel(), polygonChain.getZValue(), polygonChain.getCValue());
            for (PolygonChain polygonChain4 = polygonChain.getNext(); polygonChain4 != null; polygonChain4 = polygonChain4.getNext()) {
                polygonChain3.setNext(this.makePChain(polygonChain4.getXPixel(), polygonChain4.getYPixel(), polygonChain4.getZValue(), polygonChain4.getCValue()));
                polygonChain3 = polygonChain3.getNext();
            }
        }
        return polygonChain2;
    }

    protected PolygonChain appendChain(PolygonChain polygonChain, PolygonChain polygonChain2) {
        if (polygonChain == null) {
            return polygonChain2;
        }
        if (polygonChain2 == null) {
            return polygonChain;
        }
        PolygonChain polygonChain3 = polygonChain;
        while (polygonChain.getNext() != null) {
            polygonChain = polygonChain.getNext();
        }
        polygonChain.setNext(polygonChain2);
        return polygonChain3;
    }

    protected PolygonChain reverseChain(PolygonChain polygonChain) {
        PolygonChain polygonChain2 = null;
        PolygonChain polygonChain3 = polygonChain;
        while (polygonChain3 != null) {
            PolygonChain polygonChain4 = polygonChain3.getNext();
            polygonChain3.setNext(polygonChain2);
            polygonChain2 = polygonChain3;
            polygonChain3 = polygonChain4;
        }
        return polygonChain2;
    }

    protected void destroyChain(PolygonChain polygonChain) {
        if (polygonChain == null) {
            // empty if block
        }
        PolygonChain polygonChain2 = polygonChain;
        PolygonChain polygonChain3 = null;
        while (polygonChain != null) {
            polygonChain3 = polygonChain;
            polygonChain = polygonChain3.getNext();
            --this.pCount;
        }
        if (polygonChain3 != null) {
            polygonChain3.setNext(this.freeList);
        }
        this.freeList = polygonChain2;
    }

    public void processPolygon(Graphics graphics, int n2, int n3) {
        Transform transform = this.dataView.getChart3d().getChart3dArea().getTransform();
        Matrix4d matrix4d = transform.getAbsolute();
        if (matrix4d.m22 != 0.0) {
            this.setFillStyle(graphics, n3);
            graphics.fillPolygon(this.xPoints, this.yPoints, n2);
        } else {
            this.bins[n3].addObjectToBin(new Polygon(this.xPoints, this.yPoints, n2));
        }
    }

    protected void fillChain(Graphics graphics, PolygonChain polygonChain) {
        this.allocatePoints(9);
        int n2 = 0;
        double d2 = 0.0;
        for (PolygonChain polygonChain2 = polygonChain; polygonChain2 != null; polygonChain2 = polygonChain2.getNext()) {
            this.xPoints[n2] = polygonChain2.getXPixel();
            this.yPoints[n2] = polygonChain2.getYPixel();
            if (this.zoneMethod == 3) {
                if (n2 == 1) {
                    d2 = polygonChain2.getCValue();
                }
            } else {
                d2 += polygonChain2.getCValue();
            }
            ++n2;
        }
        if (n2 > 2) {
            double d3 = this.zoneMethod == 3 ? d2 : d2 / (double)n2;
            int n3 = this.contourLevels.getLevelFromValue(d3);
            this.processPolygon(graphics, n2, n3);
        }
    }

    protected void fillCellCorners(Graphics graphics, PolygonChain[] polygonChainArray, int n2) {
        double[] dArray = this.contourLevels.getLevels();
        ContourCell contourCell = this.contourCells[n2];
        for (int i2 = 0; i2 < 4; ++i2) {
            List<Intersection> list = contourCell.getIntersectionList(i2);
            if (list == null) continue;
            for (Intersection intersection : list) {
                ContourSegment contourSegment = intersection.getSegment1();
                PolygonChain polygonChain = this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]);
                contourSegment = intersection.getSegment2();
                polygonChain.setNext(this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]));
                PolygonChain polygonChain2 = this.appendChain(this.reverseChain(polygonChainArray[i2]), this.copyChain(polygonChain));
                this.fillChain(graphics, polygonChain2);
                this.destroyChain(polygonChain2);
                polygonChainArray[i2] = polygonChain;
            }
        }
    }

    protected void fillCellSide(Graphics graphics, PolygonChain[] polygonChainArray, int n2, int n3, int n4) {
        double[] dArray = this.contourLevels.getLevels();
        ContourCell contourCell = this.contourCells[n4];
        List<Intersection> list = contourCell.getIntersectionList(4);
        if (list == null) {
            return;
        }
        for (Intersection intersection : list) {
            ContourSegment contourSegment = intersection.getSegment1();
            PolygonChain polygonChain = this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]);
            contourSegment = intersection.getSegment2();
            PolygonChain polygonChain2 = this.makePChain(contourSegment.getXPixel(), contourSegment.getYPixel(), contourSegment.getPoint().z, dArray[intersection.getLevel()]);
            PolygonChain polygonChain3 = this.appendChain(this.copyChain(polygonChain2), this.copyChain(polygonChain));
            PolygonChain polygonChain4 = this.appendChain(polygonChainArray[n2], polygonChainArray[n3]);
            polygonChain3 = this.appendChain(polygonChain3, polygonChain4);
            this.fillChain(graphics, polygonChain3);
            this.destroyChain(polygonChain3);
            polygonChainArray[n2] = polygonChain;
            polygonChainArray[n3] = polygonChain2;
        }
    }

    protected boolean fillCell(Graphics graphics, int n2, int n3) {
        Serializable serializable;
        Object object;
        int n4 = this.cellIndex(n2, n3);
        ContourCell contourCell = this.contourCells[n4];
        if (contourCell.isHole()) {
            return false;
        }
        int n5 = this.xOffset + n2;
        int n6 = this.yOffset + n3;
        int n7 = n5 + 1;
        int n8 = n6 + 1;
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        PolygonChain[] polygonChainArray = new PolygonChain[]{this.makePChain(screenPointArray[n7][n6].getXPixel(), screenPointArray[n7][n6].getYPixel(), this.data.getZValue(n7, n6), this.zoneData.getZValue(n7, n6)), this.makePChain(screenPointArray[n7][n8].getXPixel(), screenPointArray[n7][n8].getYPixel(), this.data.getZValue(n7, n8), this.zoneData.getZValue(n7, n8)), this.makePChain(screenPointArray[n5][n8].getXPixel(), screenPointArray[n5][n8].getYPixel(), this.data.getZValue(n5, n8), this.zoneData.getZValue(n5, n8)), this.makePChain(screenPointArray[n5][n6].getXPixel(), screenPointArray[n5][n6].getYPixel(), this.data.getZValue(n5, n6), this.zoneData.getZValue(n5, n6))};
        if (this.zoneMethod == 1) {
            this.fillCellCorners(graphics, polygonChainArray, n4);
            object = contourCell.getIntersectionList(4);
            if (object != null && object.size() > 0) {
                serializable = (Intersection)object.get(0);
                if (this.verticalSide(((Intersection)serializable).getSide1())) {
                    this.fillCellSide(graphics, polygonChainArray, 3, 0, n4);
                } else {
                    this.fillCellSide(graphics, polygonChainArray, 0, 1, n4);
                }
            }
        }
        object = this.appendChain(polygonChainArray[2], polygonChainArray[3]);
        serializable = this.appendChain(polygonChainArray[0], polygonChainArray[1]);
        object = this.appendChain((PolygonChain)object, (PolygonChain)serializable);
        this.fillChain(graphics, (PolygonChain)object);
        this.destroyChain((PolygonChain)object);
        if (this.pCount != 0) {
            // empty if block
        }
        return true;
    }

    protected void drawCellContours(Graphics graphics, int n2, int n3) {
        int n4 = this.cellIndex(n2, n3);
        ContourCell contourCell = this.contourCells[n4];
        for (int i2 = 0; i2 < 5; ++i2) {
            List<Intersection> list = contourCell.getIntersectionList(i2);
            if (list == null) continue;
            for (Intersection intersection : list) {
                this.setLineStyle(graphics, intersection.getLevel());
                graphics.drawLine(intersection.getSegment1().getXPixel(), intersection.getSegment1().getYPixel(), intersection.getSegment2().getXPixel(), intersection.getSegment2().getYPixel());
            }
        }
    }

    protected double zoneMeshIntersection(Graphics graphics, List<Intersection> list, Point point, double d2, boolean bl, boolean bl2) {
        Point point2 = new Point();
        double[] dArray = this.contourLevels.getLevels();
        if (list != null && list.size() > 0) {
            int n2 = bl2 ? 0 : list.size() - 1;
            int n3 = bl2 ? list.size() : 0;
            int n4 = bl2 ? 1 : -1;
            int n5 = n2;
            while (bl2 ? n5 < n3 : n5 >= n3) {
                Intersection intersection = list.get(n5);
                ContourSegment contourSegment = bl ? intersection.getSegment1() : intersection.getSegment2();
                point2.x = contourSegment.getXPixel();
                point2.y = contourSegment.getYPixel();
                double d3 = dArray[intersection.getLevel()];
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d3 + d2) / 2.0));
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                point.setLocation(point2);
                d2 = d3;
                n5 += n4;
            }
        }
        return d2;
    }

    protected boolean zoneMeshCell(Graphics graphics, int n2, int n3) {
        double d2;
        Intersection intersection;
        List<Intersection> list;
        double d3;
        ScreenPoint screenPoint;
        JCChart3dArea jCChart3dArea = this.data.getDataView().getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        int n4 = this.cellIndex(n2, n3);
        ContourCell contourCell = this.contourCells[n4];
        if (contourCell.isHole()) {
            return false;
        }
        int n5 = this.xOffset + n2;
        int n6 = this.yOffset + n3;
        Point point = new Point();
        Point point2 = new Point();
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        boolean[] blArray = jCSurface.getXMesh();
        boolean[] blArray2 = jCSurface.getYMesh();
        if (jCSurface.isXMeshShowing()) {
            if (blArray[n6]) {
                screenPoint = screenPointArray[n5 + 1][n6];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5 + 1, n6);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(0), point2, d3, true, true);
                    list = contourCell.getIntersectionList(4);
                    Intersection intersection2 = intersection = list == null ? null : list.get(0);
                    if (intersection != null && this.horizontalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, list, point2, d3, true, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(3), point2, d3, false, false);
                }
                screenPoint = screenPointArray[n5][n6];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5, n6);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            if (blArray[n6 + 1]) {
                screenPoint = screenPointArray[n5 + 1][n6 + 1];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5 + 1, n6 + 1);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(1), point2, d3, false, true);
                    list = contourCell.getIntersectionList(4);
                    Intersection intersection3 = intersection = list == null ? null : list.get(0);
                    if (intersection != null && this.horizontalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, list, point2, d3, false, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(2), point2, d3, true, false);
                }
                screenPoint = screenPointArray[n5][n6 + 1];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5, n6 + 1);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
        if (jCSurface.isYMeshShowing()) {
            if (blArray2[n5 + 1]) {
                screenPoint = screenPointArray[n5 + 1][n6];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5 + 1, n6);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(0), point2, d3, false, true);
                    list = contourCell.getIntersectionList(4);
                    Intersection intersection4 = intersection = list == null ? null : list.get(0);
                    if (intersection != null && this.verticalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, list, point2, d3, false, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(1), point2, d3, true, false);
                }
                screenPoint = screenPointArray[n5 + 1][n6 + 1];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5 + 1, n6 + 1);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            if (blArray2[n5]) {
                screenPoint = screenPointArray[n5][n6];
                point2.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d3 = this.zoneData.getZValue(n5, n6);
                if (this.zoneMethod == 1) {
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(3), point2, d3, true, true);
                    list = contourCell.getIntersectionList(4);
                    Intersection intersection5 = intersection = list == null ? null : list.get(0);
                    if (intersection != null && this.verticalSide(intersection.getSide1())) {
                        d3 = this.zoneMeshIntersection(graphics, list, point2, d3, true, true);
                    }
                    d3 = this.zoneMeshIntersection(graphics, contourCell.getIntersectionList(2), point2, d3, false, false);
                }
                screenPoint = screenPointArray[n5][n6 + 1];
                point.setLocation(screenPoint.getXPixel(), screenPoint.getYPixel());
                d2 = this.zoneData.getZValue(n5, n6 + 1);
                this.setZLineColor(graphics, this.contourLevels.getLevelFromValue((d2 + d3) / 2.0));
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
        }
        return true;
    }

    protected void draw2dZones(Graphics graphics) {
        int n2;
        if (!this.zoned || this.contourCells == null || this.dataView == null) {
            return;
        }
        ScreenPoint[][] screenPointArray = this.data.getScreenPoints();
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCViewport jCViewport = jCChart3dArea.getViewport();
        boolean[] blArray = new boolean[this.numX - 1];
        for (int i2 = 0; i2 < this.numX - 1; ++i2) {
            blArray[i2] = screenPointArray[this.xOffset + i2 + 1][this.yOffset].getXPixel() == screenPointArray[this.xOffset + i2][this.yOffset].getXPixel();
        }
        boolean[] blArray2 = new boolean[this.numY - 1];
        for (n2 = 0; n2 < this.numY - 1; ++n2) {
            blArray2[n2] = screenPointArray[this.xOffset][this.yOffset + n2 + 1].getYPixel() == screenPointArray[this.xOffset][this.yOffset + n2].getYPixel();
        }
        this.allocColorBins(graphics);
        n2 = 0;
        for (int i3 = 0; i3 < this.numX - 1; ++i3) {
            if (blArray[i3]) {
                n2 += this.numY - 1;
                continue;
            }
            int n3 = 0;
            while (n3 < this.numY - 1) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                Rectangle rectangle;
                if (!blArray2[n3] && (jCViewport.isNormalized() || (rectangle = new Rectangle(n9 = screenPointArray[n8 = this.xOffset + i3][n7 = this.yOffset + n3].getXPixel(), n6 = screenPointArray[n8][n7 + 1].getYPixel(), n5 = screenPointArray[n8 + 1][n7].getXPixel() - n9, n4 = screenPointArray[n8][n7].getYPixel() - n6)).intersects(jCChart3dArea.getBounds()))) {
                    if (this.zoneMethod == 1) {
                        ContourCell contourCell = this.contourCells[n2];
                        if (contourCell.getNIntersections() == 0) {
                            if (!contourCell.isHole()) {
                                this.fillRectangle(i3, n3, false);
                            }
                        } else {
                            this.fillCell(graphics, i3, n3);
                        }
                    } else {
                        this.fillRectangle(i3, n3, this.zoneMethod == 2);
                    }
                }
                ++n3;
                ++n2;
            }
        }
        this.flushColorBins();
        this.bins = null;
    }

    protected void draw3dZones(Graphics graphics) {
        if (!this.zoned || this.contourCells == null || this.dataView == null) {
            return;
        }
        this.allocColorBins(graphics);
        ScreenPoint[] screenPointArray = new ScreenPoint[4];
        ScreenPoint[][] screenPointArray2 = this.data.getScreenPoints();
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCViewport jCViewport = jCChart3dArea.getViewport();
        for (int i2 = 0; i2 < this.numX - 1; ++i2) {
            for (int i3 = 0; i3 < this.numY - 1; ++i3) {
                if (!jCViewport.isNormalized()) {
                    int n2;
                    int n3;
                    int n4;
                    int n5 = this.xOffset + i2;
                    int n6 = this.yOffset + i3;
                    screenPointArray[0] = screenPointArray2[n5][n6];
                    screenPointArray[1] = screenPointArray2[n5][n6 + 1];
                    screenPointArray[2] = screenPointArray2[n5 + 1][n6 + 1];
                    screenPointArray[3] = screenPointArray2[n5 + 1][n6];
                    int n7 = JCChart3dUtil.min4(screenPointArray[0].getXPixel(), screenPointArray[1].getXPixel(), screenPointArray[2].getXPixel(), screenPointArray[3].getXPixel());
                    Rectangle rectangle = new Rectangle(n7, n4 = JCChart3dUtil.min4(screenPointArray[0].getYPixel(), screenPointArray[1].getYPixel(), screenPointArray[2].getYPixel(), screenPointArray[3].getYPixel()), (n3 = JCChart3dUtil.max4(screenPointArray[0].getXPixel(), screenPointArray[1].getXPixel(), screenPointArray[2].getXPixel(), screenPointArray[3].getXPixel())) - n7, (n2 = JCChart3dUtil.max4(screenPointArray[0].getYPixel(), screenPointArray[1].getYPixel(), screenPointArray[2].getYPixel(), screenPointArray[3].getYPixel())) - n4);
                    if (!rectangle.intersects(jCChart3dArea.getBounds())) continue;
                }
                this.fillCell(graphics, i2, i3);
            }
        }
        this.flushColorBins();
        this.bins = null;
    }

    protected void drawContours(Graphics graphics) {
        if (!this.contoured || this.contourLines == null) {
            return;
        }
        int n2 = 300;
        this.allocatePoints(n2);
        ListIterator<ContourLine> listIterator = this.contourLines.listIterator();
        while (listIterator.hasNext()) {
            ContourLine contourLine = listIterator.next();
            if (!this.setLineStyle(graphics, contourLine.getLevel())) continue;
            LinkedList<ContourSegment> linkedList = contourLine.getSegments();
            ListIterator listIterator2 = linkedList.listIterator();
            while (listIterator2.hasNext()) {
                int n3;
                for (n3 = 0; n3 < n2 && listIterator2.hasNext(); ++n3) {
                    ContourSegment contourSegment = (ContourSegment)listIterator2.next();
                    this.xPoints[n3] = contourSegment.getXPixel();
                    this.yPoints[n3] = contourSegment.getYPixel();
                }
                graphics.drawPolyline(this.xPoints, this.yPoints, n3);
            }
        }
        this.yPoints = null;
        this.xPoints = null;
    }

    public Chart3dPointDataModel getDataContours(int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        Point3d[][] point3dArray;
        if (this.contourLines == null) {
            this.recalcContours();
        }
        if (this.contourLines == null) {
            return null;
        }
        if (n2 > n3) {
            return null;
        }
        n4 = Math.max(1, n4);
        int n7 = Math.max(0, n2);
        int n8 = Math.min(this.getContourLevels().getNumLevelsInternal() - 1, n3);
        int[] nArray = new int[this.contourLines.size()];
        ListIterator<ContourLine> listIterator = this.contourLines.listIterator();
        int n9 = 0;
        while (listIterator.hasNext()) {
            point3dArray = listIterator.next();
            n6 = point3dArray.getLevel();
            if (n6 < n7 || n6 > n8 || (n6 - n7) % n4 != 0) continue;
            boolean bl2 = false;
            if (bl) {
                for (n5 = 0; n5 < n9; ++n5) {
                    if (nArray[n5] != n6) continue;
                    bl2 = true;
                }
            }
            if (bl2) continue;
            nArray[n9] = n6;
            ++n9;
        }
        if (n9 == 0) {
            return null;
        }
        point3dArray = new Point3d[n9][];
        listIterator = this.contourLines.listIterator();
        n6 = -1;
        while (listIterator.hasNext()) {
            Object object;
            ContourLine contourLine = listIterator.next();
            n5 = contourLine.getLevel();
            if (n5 < n7 || n5 > n8 || (n5 - n7) % n4 != 0) continue;
            LinkedList<ContourSegment> linkedList = contourLine.getSegments();
            if (bl) {
                for (n6 = 0; n6 < n9 && nArray[n6] != n5; ++n6) {
                }
                if (n6 == n9) {
                    return null;
                }
            } else {
                ++n6;
            }
            int n10 = 0;
            if (point3dArray[n6] == null || !bl) {
                point3dArray[n6] = new Point3d[linkedList.size()];
            } else {
                object = point3dArray[n6];
                point3dArray[n6] = new Point3d[((Point3d[])object).length + linkedList.size()];
                System.arraycopy(object, 0, point3dArray[n6], 0, ((Object)object).length);
                n10 = ((Object)object).length;
            }
            object = linkedList.listIterator();
            int n11 = n10;
            while (object.hasNext()) {
                ContourSegment contourSegment = (ContourSegment)object.next();
                point3dArray[n6][n11] = new Point3d(contourSegment.getPoint());
                ++n11;
            }
        }
        return new JCDefault3dPointDataSource("dataContours", point3dArray);
    }
}

