/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dLegendLabelGenerator;
import com.klg.jclass.chart3d.JCChart3dLegendTemplate;
import com.klg.jclass.chart3d.JCChart3dNumberFormat;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourMapping;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCData3dContourIndex;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCMultiFieldString;
import com.klg.jclass.chart3d.JCProjection;
import com.klg.jclass.chart3d.JCScatter;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.LegendEntry;
import com.klg.jclass.chart3d.ParentFormatter;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCChart3dLegendManager
implements JCLegendRenderer,
JCLegendPopulator,
Serializable {
    static final long serialVersionUID = 6132225179285554488L;
    protected JCChart3d chart3d;
    protected JCLegend legend;
    protected Color outlineColor = Color.black;
    protected Vector<List<JCLegendItem>> legendItems = null;
    protected int fieldGap = 2;
    protected int[] maxFieldWidths = null;
    protected static final int STYLE_NONE = 0;
    protected static final int STYLE_BOX_RANGE = 1;
    protected static final int STYLE_LINE_RANGE = 2;
    protected static final int STYLE_SYMBOL_RANGE = 3;
    protected static final int STYLE_CONTOUR = 4;
    protected static final int STYLE_CNTN_H = 5;
    protected static final int STYLE_CNTN_V = 6;

    public JCChart3dLegendManager(JCChart3d jCChart3d, JCLegend jCLegend) {
        this.chart3d = jCChart3d;
        this.legend = jCLegend;
    }

    public void setFieldGap(int n2) {
        this.fieldGap = n2;
    }

    public int getFieldGap() {
        return this.fieldGap;
    }

    @Override
    public List<List<JCLegendItem>> getLegendItems(FontMetrics fontMetrics) {
        this.legendItems = new Vector();
        List<Chart3dDataView> list = this.chart3d.getOriginalDataView();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.legendItems.add(new Vector());
        }
        List<List<String>> list2 = null;
        JCChart3dLegendTemplate jCChart3dLegendTemplate = null;
        if (this.legend instanceof JCChart3dLegendTemplate) {
            jCChart3dLegendTemplate = (JCChart3dLegendTemplate)((Object)this.legend);
            list2 = jCChart3dLegendTemplate.getLabels();
        }
        int n3 = -1;
        int n4 = this.legend.getSymbolSize();
        for (int i3 = 0; i3 < n2; ++i3) {
            Object object;
            ParentTrackChange parentTrackChange;
            Serializable serializable;
            boolean bl;
            Serializable serializable2;
            Serializable serializable3;
            Object object2;
            Serializable serializable4;
            int n5;
            Chart3dData chart3dData;
            List<JCLegendItem> list3 = this.legendItems.get(i3);
            Chart3dDataView chart3dDataView = list.get(i3);
            String string = chart3dDataView.getName();
            JCLegendItem jCLegendItem = new JCLegendItem();
            if (string != null && string.length() > 0) {
                jCLegendItem.textDim = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
                jCLegendItem.contents = string;
            } else {
                jCLegendItem.textDim = new Dimension(0, 0);
                jCLegendItem.contents = null;
            }
            list3.add(jCLegendItem);
            boolean bl2 = chart3dDataView.getChartType() == 2;
            List<String> list4 = null;
            if (jCChart3dLegendTemplate != null && list2 != null && i3 < list2.size()) {
                list4 = list2.get(i3);
            }
            int n6 = 0;
            Chart3dData chart3dData2 = chart3dDataView.getElevationData();
            if (bl2 && chart3dData2 instanceof Chart3dPointData) {
                chart3dData = (Chart3dPointData)chart3dData2;
                n5 = ((Chart3dPointData)chart3dData).getNumSeries();
                for (int i4 = 0; i4 < n5; ++i4) {
                    serializable4 = ((Chart3dPointData)chart3dData).getSeries(i4);
                    object2 = list4 != null && i4 < list4.size() ? list4.get(i4) : ((Chart3dPointSeries)serializable4).getLabel();
                    if (object2 == null) continue;
                    serializable3 = new JCData3dPointIndex(chart3dDataView, i4, -1);
                    serializable2 = ((Chart3dPointSeries)serializable4).getChartStyle();
                    LegendEntry legendEntry = new LegendEntry((JCData3dIndex)serializable3, serializable2, ((JCChart3dStyle)serializable2).getSymbolStyle());
                    JCLegendItem jCLegendItem2 = new JCLegendItem();
                    n3 = this.populate3dLegendItem(jCLegendItem2, fontMetrics, object2, 4, new Dimension(n4, n4), legendEntry, n3);
                    list3.add(jCLegendItem2);
                }
                continue;
            }
            chart3dData = null;
            n5 = 0;
            if (chart3dData2 instanceof Chart3dGridData) {
                chart3dData = (Chart3dGridData)chart3dData2;
                if (bl2) {
                    n5 = 1;
                }
            }
            JCElevation jCElevation = chart3dDataView.getElevation();
            serializable4 = chart3dDataView.getContour();
            object2 = chart3dDataView.getChart3d().getChart3dArea();
            serializable3 = ((JCChart3dArea)object2).getPlotCube().getFloor();
            serializable2 = ((JCChart3dArea)object2).getPlotCube().getCeiling();
            boolean bl3 = ((JCProjection)serializable3).isContoured() || ((JCProjection)serializable2).isContoured();
            boolean bl4 = ((JCProjection)serializable3).isZoned() || ((JCProjection)serializable2).isZoned();
            boolean bl5 = ((JCContour)serializable4).isContoured() || bl3;
            boolean bl6 = bl = ((JCContour)serializable4).isZoned() || bl4;
            if (((JCContour)serializable4).isZoned() && (!jCElevation.isMeshed() || jCElevation.isShaded()) || bl4) {
                if (n5 != 0) {
                    n6 = 3;
                    if (jCChart3dLegendTemplate != null) {
                        jCChart3dLegendTemplate.setContinuousLayout(false);
                    }
                } else if (jCChart3dLegendTemplate != null) {
                    int n7 = jCChart3dLegendTemplate.getLayoutStyle();
                    if (n7 == 0) {
                        n6 = this.legend.getOrientation() == 0 ? 5 : 6;
                        jCChart3dLegendTemplate.setContinuousLayout(true);
                    } else {
                        n6 = 1;
                        jCChart3dLegendTemplate.setContinuousLayout(false);
                    }
                } else {
                    n6 = 1;
                }
            } else if (((JCContour)serializable4).isZoned() && jCElevation.isMeshed() && !jCElevation.isShaded()) {
                n6 = n5 != 0 ? 3 : 2;
                if (jCChart3dLegendTemplate != null) {
                    jCChart3dLegendTemplate.setContinuousLayout(false);
                }
            } else if (!((JCContour)serializable4).isZoned() && bl5) {
                n6 = n5 != 0 ? 3 : 4;
                if (jCChart3dLegendTemplate != null) {
                    jCChart3dLegendTemplate.setContinuousLayout(false);
                }
            } else if (n5 != 0 && !bl5 && !bl && (jCElevation.isMeshed() || jCElevation.isShaded())) {
                String string2;
                if (jCChart3dLegendTemplate != null) {
                    jCChart3dLegendTemplate.setContinuousLayout(false);
                }
                if ((string2 = list4 != null && list4.size() > 0 ? list4.get(i3) : chart3dData.getName()) == null) continue;
                serializable = new JCData3dGridIndex(chart3dDataView, Integer.MAX_VALUE, Integer.MAX_VALUE);
                parentTrackChange = ((Chart3dGridData)chart3dData).getChartStyle();
                object = new LegendEntry((JCData3dIndex)serializable, parentTrackChange, ((JCChart3dStyle)parentTrackChange).getSymbolStyle());
                JCLegendItem jCLegendItem3 = new JCLegendItem();
                n3 = this.populate3dLegendItem(jCLegendItem3, fontMetrics, string2, 4, new Dimension(n4, n4), object, n3);
                list3.add(jCLegendItem3);
                continue;
            }
            if (n6 == 0) {
                if (list3.size() <= 0) continue;
                list3.clear();
                continue;
            }
            JCChart3dLegendLabelGenerator jCChart3dLegendLabelGenerator = null;
            if (jCChart3dLegendTemplate != null) {
                jCChart3dLegendLabelGenerator = jCChart3dLegendTemplate.getLabelGenerator();
            }
            serializable = this.filterLevels(chart3dDataView, n6, jCChart3dLegendTemplate, (JCContour)serializable4);
            parentTrackChange = ((JCContour)serializable4).getContourLevels();
            object = ((ParentFormatter)parentTrackChange).getNumberFormatter();
            int n8 = ((ParentFormatter)parentTrackChange).getNFrac();
            for (int i5 = ((Vector)serializable).size() - 1; i5 >= 0; --i5) {
                JCLegendItem jCLegendItem4;
                LegendEntry legendEntry = (LegendEntry)((Vector)serializable).get(i5);
                Object object3 = this.getNonScatterLabel(n6, (JCChart3dNumberFormat)object, n8, (Vector<LegendEntry>)serializable, list4, i5, jCChart3dLegendLabelGenerator);
                if (object3 == null) continue;
                Dimension dimension = new Dimension(n4 * 2, n4);
                if (n6 == 5 || n6 == 6) {
                    jCLegendItem4 = new JCLegendItem();
                    if (legendEntry.parentStyle != null) {
                        legendEntry.drawStyle = ((JCContourStyle)legendEntry.parentStyle).getFillStyle();
                        if (n6 == 6) {
                            int n9 = fontMetrics.getHeight() + jCChart3dLegendTemplate.getItemGap();
                            dimension.setSize(n4 * 2, n9);
                        } else {
                            dimension.setSize(0, n4);
                        }
                        n3 = this.populate3dLegendItem(jCLegendItem4, fontMetrics, object3, 6, dimension, legendEntry, n3);
                    } else {
                        legendEntry.drawStyle = null;
                        n3 = this.populate3dLegendItem(jCLegendItem4, fontMetrics, object3, 0, dimension, legendEntry, n3);
                    }
                } else {
                    jCLegendItem4 = new JCLegendItem();
                    JCContourStyle jCContourStyle = (JCContourStyle)legendEntry.parentStyle;
                    if (n6 == 1) {
                        legendEntry.drawStyle = jCContourStyle.getFillStyle();
                        n3 = this.populate3dLegendItem(jCLegendItem4, fontMetrics, object3, 1, dimension, legendEntry, n3);
                    } else if (n6 == 2) {
                        legendEntry.drawStyle = jCContourStyle.getFillStyle();
                        n3 = this.populate3dLegendItem(jCLegendItem4, fontMetrics, object3, 7, dimension, legendEntry, n3);
                    } else if (n6 == 3) {
                        legendEntry.drawStyle = jCContourStyle.getSymbolStyle();
                        dimension.setSize(n4, n4);
                        n3 = this.populate3dLegendItem(jCLegendItem4, fontMetrics, object3, 4, dimension, legendEntry, n3);
                    } else if (n6 == 4) {
                        legendEntry.drawStyle = jCContourStyle.getLineStyle();
                        n3 = this.populate3dLegendItem(jCLegendItem4, fontMetrics, object3, 7, dimension, legendEntry, n3);
                    }
                }
                if (jCLegendItem4 == null) continue;
                list3.add(jCLegendItem4);
            }
        }
        this.calcTextWidthsFromFields(n3, this.legendItems, jCChart3dLegendTemplate, fontMetrics);
        return this.legendItems;
    }

    protected Vector<LegendEntry> filterLevels(Chart3dDataView chart3dDataView, int n2, JCChart3dLegendTemplate jCChart3dLegendTemplate, JCContour jCContour) {
        int n3;
        JCData3dContourIndex jCData3dContourIndex;
        Vector<LegendEntry> vector = new Vector<LegendEntry>();
        JCContourLevels jCContourLevels = jCContour.getContourLevels();
        int n4 = jCContourLevels.getNumLevelsInternal();
        double[] dArray = jCContourLevels.getLevels();
        int n5 = jCContourLevels.getNFrac();
        List<JCContourStyle> list = jCContour.getContourStyles();
        JCContourMapping jCContourMapping = jCContour.getContourMapping();
        boolean bl = false;
        if (jCChart3dLegendTemplate != null) {
            int n6 = jCChart3dLegendTemplate.getDistributionRange();
            bl = n6 == 1;
        }
        double d2 = jCContourLevels.getMin();
        double d3 = jCContourLevels.getMax();
        if ((jCContourLevels.isDefault() || bl) && (n2 == 5 || n2 == 6)) {
            jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, -1, d2, d2);
            vector.add(new LegendEntry(jCData3dContourIndex, null));
        }
        int n7 = -1;
        for (n3 = 0; n3 < n4; ++n3) {
            double d4 = dArray[n3];
            if (bl && (d4 < d2 || d4 > d3)) continue;
            int n8 = jCContourMapping.contourIndex(n3);
            JCContourStyle jCContourStyle = list.get(n8);
            if (n2 == 4) {
                jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, n3, d4, d4);
                vector.add(new LegendEntry(jCData3dContourIndex, jCContourStyle));
            } else if (n7 < 0) {
                if (jCContourLevels.isDefault() || bl) {
                    String string;
                    String string2 = JCNumberUtil.format(d2, n5);
                    if (!string2.equals(string = JCNumberUtil.format(d4, n5))) {
                        jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, n3, d2, d4);
                        vector.add(new LegendEntry(jCData3dContourIndex, jCContourStyle));
                    }
                } else if (n2 == 5 || n2 == 6) {
                    jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, n3, d4, d4);
                    vector.add(new LegendEntry(jCData3dContourIndex, null));
                }
            } else {
                jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, n3, dArray[n7], d4);
                vector.add(new LegendEntry(jCData3dContourIndex, jCContourStyle));
            }
            n7 = n3;
        }
        if (jCContourLevels.isDefault() || bl) {
            if (n2 == 5 || n2 == 6 || n2 == 1 || n2 == 2 || n2 == 3) {
                if (n7 < 0) {
                    n3 = jCContourMapping.contourIndex(n4);
                    JCContourStyle jCContourStyle = list.get(n3);
                    jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, n4, d2, d3);
                    vector.add(new LegendEntry(jCData3dContourIndex, jCContourStyle));
                } else {
                    String string;
                    String string3 = JCNumberUtil.format(d3, n5);
                    if (!string3.equals(string = JCNumberUtil.format(dArray[n7], n5))) {
                        int n9 = jCContourMapping.contourIndex(n7 + 1);
                        JCContourStyle jCContourStyle = list.get(n9);
                        jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, n7 + 1, dArray[n7], d3);
                        vector.add(new LegendEntry(jCData3dContourIndex, jCContourStyle));
                    }
                }
            } else if (n2 == 4 && n4 == 0) {
                n3 = jCContourMapping.contourIndex(n4);
                JCContourStyle jCContourStyle = list.get(n3);
                jCData3dContourIndex = new JCData3dContourIndex(chart3dDataView, n4, d3, d3);
                vector.add(new LegendEntry(jCData3dContourIndex, jCContourStyle));
            }
        }
        return vector;
    }

    protected Object getNonScatterLabel(int n2, JCChart3dNumberFormat jCChart3dNumberFormat, int n3, Vector<LegendEntry> vector, List<String> list, int n4, JCChart3dLegendLabelGenerator jCChart3dLegendLabelGenerator) {
        Object object = null;
        LegendEntry legendEntry = vector.get(n4);
        JCData3dContourIndex jCData3dContourIndex = (JCData3dContourIndex)legendEntry.dataIndex;
        double d2 = jCData3dContourIndex.getUpperContourRangeValue();
        double d3 = jCData3dContourIndex.getLowerContourRangeValue();
        String string = JCNumberUtil.format(d2, n3);
        String string2 = JCNumberUtil.format(d3, n3);
        string = jCChart3dNumberFormat.localize(string);
        string2 = jCChart3dNumberFormat.localize(string2);
        if (list != null && list.size() > n4) {
            object = list.get(n4);
        } else if (n2 == 5) {
            object = new JCMultiFieldString("\\c" + string);
            d3 = d2;
        } else if (n2 == 6) {
            object = new JCMultiFieldString("\\r" + string);
            d3 = d2;
        } else if (n2 == 1 || n2 == 2 || n2 == 3) {
            object = new JCMultiFieldString("\\r" + string2 + "\\c" + " .. " + "\\r" + string);
        } else if (n2 == 4) {
            object = new JCMultiFieldString("\\r" + string);
            d3 = d2;
        }
        if (jCChart3dLegendLabelGenerator != null) {
            int n5 = jCData3dContourIndex.getContourStyleIndex();
            object = jCChart3dLegendLabelGenerator.generateLegendLabel(this.chart3d, n5, d3, d2, object);
        }
        return object;
    }

    protected int populate3dLegendItem(JCLegendItem jCLegendItem, FontMetrics fontMetrics, Object object, int n2, Dimension dimension, Object object2, int n3) {
        if (jCLegendItem == null) {
            return n3;
        }
        int n4 = 0;
        int n5 = fontMetrics.getHeight();
        if (object != null) {
            if (object instanceof JCMultiFieldString) {
                JCMultiFieldString jCMultiFieldString = (JCMultiFieldString)object;
                List<Object> list = jCMultiFieldString.getContentList();
                n3 = Math.max(n3, list.size() / 2);
                n4 = 0;
            } else if (object instanceof String) {
                n4 = fontMetrics.stringWidth((String)object);
            }
        }
        jCLegendItem.contents = object;
        jCLegendItem.drawType = n2;
        jCLegendItem.textDim = new Dimension(n4, n5);
        jCLegendItem.symbolDim = dimension;
        jCLegendItem.itemInfo = object2;
        return n3;
    }

    protected void calcTextWidthsFromFields(int n2, List<List<JCLegendItem>> list, JCChart3dLegendTemplate jCChart3dLegendTemplate, FontMetrics fontMetrics) {
        Object object;
        int n3;
        int n4 = list.size();
        if (n2 > 0) {
            this.maxFieldWidths = new int[n2];
            Arrays.fill(this.maxFieldWidths, 0);
        }
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            List<JCLegendItem> list2 = list.get(n3);
            for (JCLegendItem object2 : list2) {
                if (this.isTitleItem(object2)) continue;
                if (object2.contents instanceof JCMultiFieldString) {
                    object = (JCMultiFieldString)object2.contents;
                    List<Object> list3 = ((JCMultiFieldString)object).getContentList();
                    for (int i2 = 0; i2 < list3.size() / 2; ++i2) {
                        String string = (String)list3.get(i2 * 2 + 1);
                        this.maxFieldWidths[i2] = Math.max(this.maxFieldWidths[i2], fontMetrics.stringWidth(string));
                    }
                    continue;
                }
                if (!(object2.contents instanceof String)) continue;
                object = (String)object2.contents;
                n5 = Math.max(n5, fontMetrics.stringWidth((String)object));
            }
        }
        n3 = 0;
        if (n2 > 0) {
            for (int i3 = 0; i3 < this.maxFieldWidths.length; ++i3) {
                n3 += this.maxFieldWidths[i3];
                if (i3 >= this.maxFieldWidths.length - 1) continue;
                n3 += this.fieldGap;
            }
        }
        n3 = Math.max(n3, n5);
        for (int i4 = 0; i4 < n4; ++i4) {
            List<JCLegendItem> list4 = list.get(i4);
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                object = (JCLegendItem)iterator.next();
                if (this.isTitleItem((JCLegendItem)object)) continue;
                if (((JCLegendItem)object).contents instanceof JCMultiFieldString) {
                    ((JCLegendItem)object).textDim.width = n3;
                }
                if (jCChart3dLegendTemplate == null || !jCChart3dLegendTemplate.isContinuousLayout() || this.legend.getOrientation() != 0) continue;
                ((JCLegendItem)object).symbolDim.width = n3 + jCChart3dLegendTemplate.getItemGap();
            }
        }
    }

    @Override
    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        return jCLegendItem.itemInfo == null;
    }

    @Override
    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    @Override
    public void drawLegendItemSymbol(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        if (jCLegendItem.itemInfo == null || jCLegendItem.symbolDim == null || jCLegendItem.symbolPos == null) {
            return;
        }
        int n2 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
        int n3 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
        if (jCLegendItem.itemInfo instanceof LegendEntry) {
            LegendEntry legendEntry = (LegendEntry)jCLegendItem.itemInfo;
            Object object = legendEntry.drawStyle;
            if (object != null && object instanceof JCSymbolStyle) {
                JCSymbolStyle jCSymbolStyle = (JCSymbolStyle)object;
                JCScatter jCScatter = this.chart3d.getChart3dArea().getScatter();
                Object object2 = legendEntry.parentStyle;
                if (jCScatter != null && jCScatter.hasDropLines() && object2 != null) {
                    JCLineStyle jCLineStyle = null;
                    if (object2 instanceof JCContourStyle) {
                        jCLineStyle = ((JCContourStyle)object2).getLineStyle();
                    } else if (object2 instanceof JCChart3dStyle) {
                        jCLineStyle = ((JCChart3dStyle)object2).getLineStyle();
                    }
                    if (jCLineStyle != null) {
                        jCLineStyle.draw(graphics, n2 + (jCLegendItem.symbolDim.width - jCLineStyle.getWidth()) / 2, n3 + 1, n2 + (jCLegendItem.symbolDim.width - jCLineStyle.getWidth()) / 2, n3 + jCLegendItem.symbolDim.height - 1);
                    }
                    jCSymbolStyle.draw(graphics, n2 + jCLegendItem.symbolDim.width / 2, n3 + jCLegendItem.symbolDim.height / 3 + 1, 2 * (jCLegendItem.symbolDim.width / 3) + 1);
                } else {
                    jCSymbolStyle.draw(graphics, n2 + jCLegendItem.symbolDim.width / 2, n3 + jCLegendItem.symbolDim.height / 2, 2 * (jCLegendItem.symbolDim.width / 3) + 1);
                }
            }
        }
    }

    @Override
    public void drawLegendItemText(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        if (jCLegendItem.contents instanceof JCMultiFieldString) {
            JCMultiFieldString jCMultiFieldString = (JCMultiFieldString)jCLegendItem.contents;
            jCMultiFieldString.draw(graphics, font, jCLegendItem.pos.x + jCLegendItem.textPos.x, jCLegendItem.pos.y + jCLegendItem.textPos.y, this.maxFieldWidths, this.fieldGap);
        }
    }

    @Override
    public Color getOutlineColor(JCLegendItem jCLegendItem) {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    @Override
    public void setFillGraphics(Graphics graphics, JCLegendItem jCLegendItem) {
        if (jCLegendItem.itemInfo == null) {
            return;
        }
        if (jCLegendItem.itemInfo instanceof LegendEntry) {
            LegendEntry legendEntry = (LegendEntry)jCLegendItem.itemInfo;
            if (legendEntry.drawStyle instanceof JCSymbolStyle) {
                graphics.setColor(((JCSymbolStyle)legendEntry.drawStyle).getColor());
            } else if (legendEntry.drawStyle instanceof JCFillStyle) {
                graphics.setColor(((JCFillStyle)legendEntry.drawStyle).getColor());
            } else if (legendEntry.drawStyle instanceof JCLineStyle) {
                graphics.setColor(((JCLineStyle)legendEntry.drawStyle).getColor());
            }
        }
    }
}

