/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Anno;
import com.klg.jclass.chart3d.Changeable;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Cube;
import com.klg.jclass.chart3d.JCAction;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dLabelIndex;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCScatter;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.JCView3d;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.graphics.GraphicsUtil;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class JCChart3dArea
extends JComponent
implements Changeable,
Serializable {
    static final long serialVersionUID = -5542417106751358122L;
    protected boolean updateParent = true;
    protected Graphics rbGC = null;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected boolean inAction = false;
    protected transient JCAction actionHandler = null;
    protected Dimension preferredSize = null;
    private transient Graphics prevSetGraphics = null;
    private static boolean errorMessagesPrinted = false;
    protected JCChart3d chart3d = null;
    protected JCAxis xAxis = null;
    protected JCAxis yAxis = null;
    protected JCAxis zAxis = null;
    protected JCAxis[] axes = null;
    protected JCViewport viewport = null;
    protected JCView3d view3d = null;
    protected Cube cube = null;
    protected JCPlotCube plotCube = null;
    protected Transform transform = null;
    protected Anno anno = null;
    protected JCSurface surface = null;
    protected JCBar bar = null;
    protected JCScatter scatter = null;
    protected JCFillStyle fillStyle;
    protected boolean drawError = false;
    protected Point last = new Point(-1, -1);

    public JCChart3dArea() {
    }

    public JCChart3dArea(JCChart3d jCChart3d) {
        this.setOpaque(false);
        this.chart3d = jCChart3d;
    }

    public JCChart3d getChart3d() {
        return this.chart3d;
    }

    public void setChart3d(JCChart3d jCChart3d) {
        if (this.chart3d == jCChart3d) {
            return;
        }
        this.chart3d = jCChart3d;
        this.setChanged(true, 34);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 33);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fillStyle != null) {
            this.fillStyle.setColor(color);
        }
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle != null) {
            this.fillStyle.parent = null;
        }
        this.fillStyle = jCFillStyle;
        if (this.fillStyle != null) {
            this.fillStyle.parent = this;
        }
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        rectangle.setBounds(insets.left, insets.top, Math.max(0, dimension.width - (insets.left + insets.right)), Math.max(0, dimension.height - (insets.top + insets.bottom)));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.preferredSize;
        if (dimension == null || dimension.width <= 0 || dimension.height <= 0) {
            dimension = new Dimension();
            dimension.width = 250;
            dimension.height = 250;
        }
        return dimension;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public JCAxis getAxis(int n2) {
        if (this.axes == null) {
            return null;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.axes[i2].getAxisId() != n2) continue;
            return this.axes[i2];
        }
        return null;
    }

    public void setAxis(JCAxis jCAxis, int n2) {
        if (jCAxis == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        if (n2 < 1 || n2 > 3) {
            return;
        }
        if (jCAxis.getAxisId() != n2) {
            throw new IllegalArgumentException(LocaleBundle.string("AxisId does not match ID of Axis!"));
        }
        this.axes[n2 - 1] = jCAxis;
        if (n2 == 1) {
            if (this.xAxis == jCAxis) {
                return;
            }
            this.xAxis = jCAxis;
        } else if (n2 == 2) {
            if (this.yAxis == jCAxis) {
                return;
            }
            this.yAxis = jCAxis;
        } else if (n2 == 3) {
            if (this.zAxis == jCAxis) {
                return;
            }
            this.zAxis = jCAxis;
        }
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    public JCAxis[] getAxes() {
        return this.axes;
    }

    public void setAxes(JCAxis[] jCAxisArray) {
        if (jCAxisArray.length != 3) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Array has incorrect length!"));
        }
        this.axes = jCAxisArray;
        boolean bl = false;
        if (this.xAxis != jCAxisArray[0]) {
            if (jCAxisArray[0].getAxisId() != 1) {
                throw new IllegalArgumentException(LocaleBundle.string("AxisId does not match ID of Axis!"));
            }
            this.xAxis = jCAxisArray[0];
            jCAxisArray[0].addParent(this);
            bl = true;
        }
        if (this.yAxis != jCAxisArray[1]) {
            if (jCAxisArray[1].getAxisId() != 2) {
                throw new IllegalArgumentException(LocaleBundle.string("AxisId does not match ID of Axis!"));
            }
            this.yAxis = jCAxisArray[1];
            jCAxisArray[1].addParent(this);
            bl = true;
        }
        if (this.zAxis != jCAxisArray[2]) {
            if (jCAxisArray[2].getAxisId() != 3) {
                throw new IllegalArgumentException(LocaleBundle.string("AxisId does not match ID of Axis!"));
            }
            this.zAxis = jCAxisArray[2];
            jCAxisArray[2].addParent(this);
            bl = true;
        }
        if (bl) {
            this.setChanged(true, 34);
        }
    }

    public JCAxis getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(JCAxis jCAxis) {
        if (jCAxis == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        if (jCAxis.getAxisId() != 1) {
            throw new IllegalArgumentException(LocaleBundle.string("AxisId does not match ID of Axis!"));
        }
        this.axes[0] = jCAxis;
        this.xAxis = jCAxis;
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    public JCAxis getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(JCAxis jCAxis) {
        if (jCAxis == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        if (jCAxis.getAxisId() != 2) {
            throw new IllegalArgumentException(LocaleBundle.string("AxisId does not match ID of Axis!"));
        }
        this.axes[1] = jCAxis;
        this.yAxis = jCAxis;
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    public JCAxis getZAxis() {
        return this.zAxis;
    }

    public void setZAxis(JCAxis jCAxis) {
        if (jCAxis == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        if (jCAxis.getAxisId() != 3) {
            throw new IllegalArgumentException(LocaleBundle.string("AxisId does not match ID of Axis!"));
        }
        this.axes[2] = jCAxis;
        this.zAxis = jCAxis;
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    public JCViewport getViewport() {
        return this.viewport;
    }

    public void setViewport(JCViewport jCViewport) {
        if (this.viewport == jCViewport) {
            return;
        }
        this.viewport = jCViewport;
        if (this.viewport == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.viewport.addParent(this);
        this.setChanged(true, 2);
    }

    public JCView3d getView3d() {
        return this.view3d;
    }

    public void setView3d(JCView3d jCView3d) {
        if (this.view3d == jCView3d) {
            return;
        }
        this.view3d = jCView3d;
        if (this.view3d == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.view3d.addParent(this);
        this.setChanged(true, 2);
    }

    public JCPlotCube getPlotCube() {
        return this.plotCube;
    }

    public void setPlotCube(JCPlotCube jCPlotCube) {
        if (this.plotCube == jCPlotCube) {
            return;
        }
        this.plotCube = jCPlotCube;
        if (this.plotCube == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.plotCube.setChart3dArea(this);
    }

    public JCSurface getSurface() {
        return this.surface;
    }

    public void setSurface(JCSurface jCSurface) {
        if (this.surface == jCSurface) {
            return;
        }
        this.surface = jCSurface;
        if (this.surface == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.surface.addParent(this);
        this.setChanged(true, 2);
    }

    public JCBar getBar() {
        return this.bar;
    }

    public void setBar(JCBar jCBar) {
        if (this.bar == jCBar) {
            return;
        }
        this.bar = jCBar;
        if (this.bar == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.bar.addParent(this);
        this.setChanged(true, 2);
    }

    public JCScatter getScatter() {
        return this.scatter;
    }

    public void setScatter(JCScatter jCScatter) {
        if (this.scatter == jCScatter) {
            return;
        }
        this.scatter = jCScatter;
        if (this.scatter == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.scatter.addParent(this);
        this.setChanged(true, 2);
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
        cube.setChart3dArea(this);
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
        transform.setChart3dArea(this);
    }

    public Anno getAnno() {
        return this.anno;
    }

    public void setAnno(Anno anno) {
        this.anno = anno;
        anno.setChart3dArea(this);
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n2) {
        return (this.changedFlag & n2) == n2;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    public void setChanged(boolean bl, int n2) {
        if (this.chart3d == null) {
            return;
        }
        Chart3dDataView chart3dDataView = this.chart3d.getDataView(0);
        if (bl) {
            chart3dDataView.setChanged(true, n2, false);
        } else {
            this.chart3d.getDataView(0).setChanged(false, 0, false);
        }
        this.changed = bl;
        this.changedFlag = this.changed ? (this.changedFlag |= n2) : n2;
        if (this.changed && !this.chart3d.isBatched()) {
            JCLegend jCLegend = this.chart3d.getLegend();
            if (jCLegend != null && (n2 & 0x20) > 0) {
                jCLegend.setChanged(true, 2, false);
                jCLegend.recalc();
            }
            if (jCLegend != null && (n2 & 0x10) > 0) {
                jCLegend.setChanged(true, 1, false);
            }
            if ((n2 & 2) > 0) {
                this.chart3d.redraw();
            } else if ((n2 & 1) > 0) {
                this.chart3d.redraw();
            }
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n2) : n2;
        }
    }

    public JCAction getActionHandler() {
        return this.actionHandler;
    }

    protected void setActionHandler(JCAction jCAction) {
        this.actionHandler = jCAction;
    }

    public boolean isInAction() {
        return this.inAction;
    }

    public void setInAction(boolean bl) {
        this.inAction = bl;
    }

    public Color getBackground() {
        if (this.isOpaque()) {
            return super.getBackground();
        }
        Container container = this.chart3d.getParent();
        if (this.chart3d.isOpaque() || container == null) {
            return this.chart3d.getBackground();
        }
        return container.getBackground();
    }

    protected void fillWithBackgroundColor(Graphics graphics, boolean bl) {
        Color color = this.getBackground();
        if (!graphics.getColor().equals(color)) {
            graphics.setColor(color);
        }
        Rectangle rectangle = this.getBounds();
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        if (this.fillStyle != null && !bl) {
            Insets insets = this.getInsets();
            int n2 = Math.max(0, rectangle.width - insets.left - insets.right);
            int n3 = Math.max(0, rectangle.height - insets.top - insets.bottom);
            Rectangle rectangle2 = new Rectangle(insets.left, insets.top, n2, n3);
            this.fillStyle.updateAnchorRect(rectangle2);
            this.fillStyle.fillRect(graphics, insets.left, insets.top, n2, n3);
            this.fillStyle.updateAnchorRect(null);
        }
    }

    protected void printErrorMessages(String string, String string2, String[] stringArray) {
        if (!errorMessagesPrinted) {
            if (string != null) {
                System.err.println(string);
            }
            if (string2 != null) {
                System.err.println(string2);
            }
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    if (string3 == null) continue;
                    System.err.println(string3);
                }
            }
            errorMessagesPrinted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        Object object;
        if (this.getParent() == null || this.chart3d == null || graphics == null || !this.isVisible()) {
            return;
        }
        boolean bl = false;
        for (Class<?> clazz = this.chart3d.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            object = clazz.getName();
            if (object == null) continue;
            if (((String)object).equals("com.klg.jclass.schart3d.JCServerChart3d")) break;
            if (!((String)object).equals("com.klg.jclass.chart3d.j2d.JCChart3dJava2d") && !((String)object).equals("com.klg.jclass.chart3d.JCChart3d")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            object = graphics.getClipBounds();
            Font font = new Font("Dialog", 1, 12);
            graphics.setColor(Color.blue);
            graphics.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics.setColor(Color.yellow);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String[] stringArray = new String[]{LocaleBundle.string("Invalid use of JCChart3d within JCServerChart3d!"), LocaleBundle.string("It is not recommended that JCServerChart3d and"), LocaleBundle.string("JCChart3d jars be on the same classpath, but if"), LocaleBundle.string("they must, the JCServerChart3d jar must be first.")};
            this.printErrorMessages(null, null, stringArray);
            Rectangle rectangle = fontMetrics.getStringBounds(stringArray[0], graphics2D).getBounds();
            float f2 = (float)(2.0 * rectangle.getHeight());
            float f3 = (float)((double)((Rectangle)object).height / 2.0) - f2 * (float)((double)(stringArray.length + 1) / 2.0);
            for (String string : stringArray) {
                if (string == null) continue;
                rectangle = fontMetrics.getStringBounds(string, graphics2D).getBounds();
                float f4 = (float)(((double)((Rectangle)object).width - rectangle.getWidth()) / 2.0);
                graphics2D.drawString(string, f4, f3 += f2);
            }
            return;
        }
        object = null;
        RenderProperties renderProperties = null;
        try {
            renderProperties = GraphicsUtil.getRenderPropertiesParent(this);
            if (renderProperties != null) {
                object = GraphicsUtil.setAntiAliasing((Graphics2D)graphics, renderProperties.getAntiAliasing());
            }
            Chart3dDataView chart3dDataView = this.chart3d.getDataView(0);
            chart3dDataView.calcDefaults();
            if (this.transform != null) {
                this.transform.computeTransformations(graphics);
            }
            chart3dDataView.getContour().recalcContours();
            if (this.isOpaque()) {
                this.fillWithBackgroundColor(graphics, false);
            }
            chart3dDataView.drawGraph(graphics);
            this.drawError = false;
        }
        catch (Exception exception) {
            this.drawError = true;
            exception.printStackTrace(System.out);
        }
        finally {
            if (renderProperties != null && object != null) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }
        this.rbGC = graphics;
        if (this.actionHandler != null) {
            this.actionHandler.reanimate(this.last.x, this.last.y);
        }
        this.rbGC = null;
        this.setChanged(false, 0);
    }

    public boolean getDrawError() {
        return this.drawError;
    }

    public void updateParent(int n2) {
        JCChart3d jCChart3d = (JCChart3d)this.getParent();
        if (jCChart3d != null) {
            if ((n2 & 2) > 0 || (n2 & 8) > 0) {
                jCChart3d.invalidate();
                if (!jCChart3d.isBatched()) {
                    jCChart3d.validate();
                    jCChart3d.repaint();
                }
            } else if ((n2 & 1) > 0 && !jCChart3d.isBatched()) {
                jCChart3d.repaint();
            }
        }
    }

    public void recalc() {
        this.chart3d.getDataView(0).calcDefaults();
    }

    protected void animateAction(InputEvent inputEvent, int n2, int n3) {
        if (this.actionHandler == null) {
            return;
        }
        if (this.last.x == n2 && this.last.y == n3) {
            return;
        }
        this.last.x = n2;
        this.last.y = n3;
        this.actionHandler.animate(inputEvent, n2, n3);
    }

    protected void endAction(InputEvent inputEvent, int n2, int n3) {
        if (this.actionHandler == null) {
            return;
        }
        JCAction jCAction = this.actionHandler;
        this.actionHandler = null;
        this.last.x = n2;
        this.last.y = n3;
        jCAction.end(inputEvent, n2, n3);
    }

    protected void startAction(InputEvent inputEvent, int n2, int n3) {
        if (this.actionHandler == null) {
            return;
        }
        this.actionHandler.start(inputEvent, n2, n3);
    }

    public void drawPreview(double d2, double d3, double d4, double d5, double d6, double d7, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        this.viewport.scale = d2;
        this.viewport.horizontalShift = d3;
        this.viewport.verticalShift = d4;
        this.viewport.normalized = d2 == 1.0 && d3 == 0.0 && d4 == 0.0;
        this.view3d.xRotation = d5;
        this.view3d.yRotation = d6;
        this.view3d.zRotation = d7;
        this.transform.computeTransformations(graphics);
        this.fillWithBackgroundColor(graphics, true);
        if (this.getChart3d().getDataView(0).getElevationData().isDataOK()) {
            this.plotCube.updateBoundingBox(graphics, n2, n3, n4);
        }
        graphics.dispose();
    }

    public void drawZoomRectangle(Point point, Point point2) {
        int n2;
        Graphics graphics;
        if (point == null) {
            return;
        }
        if (point.x == point2.x || point.y == point2.y) {
            return;
        }
        int n3 = point2.x;
        int n4 = point2.y;
        int n5 = point.x;
        int n6 = point.y;
        if (this.rbGC == null && this.getParent() == null) {
            return;
        }
        Graphics graphics2 = graphics = this.rbGC == null ? this.getGraphics() : this.rbGC.create();
        if (n5 - n3 < 0) {
            n2 = n5;
            n5 = n3;
            n3 = n2;
        }
        if (n6 - n4 < 0) {
            n2 = n6;
            n6 = n4;
            n4 = n2;
        }
        graphics.setXORMode(Color.white);
        graphics.drawRect(n3, n4, n5 - n3, n6 - n4);
        graphics.setXORMode(Color.black);
        graphics.drawRect(n3 + 1, n4 + 1, n5 - n3, n6 - n4);
        graphics.dispose();
    }

    public void reset() {
        if (this.chart3d == null) {
            return;
        }
        boolean bl = this.chart3d.isBatched();
        this.chart3d.setBatched(true);
        this.viewport.setNormalized(true);
        this.actionHandler = null;
        this.inAction = false;
        this.setChanged(true, 2);
        this.chart3d.setBatched(bl);
    }

    public void cancel() {
        this.actionHandler.cancel();
        this.actionHandler = null;
        this.inAction = false;
        this.setChanged(true, 2);
    }

    public boolean isBatched() {
        return false;
    }

    protected JCData3dIndex pick(Point point, Chart3dDataView chart3dDataView) {
        JCData3dIndex jCData3dIndex = null;
        if (point == null || this.chart3d == null) {
            return jCData3dIndex;
        }
        if (chart3dDataView == null) {
            chart3dDataView = this.chart3d.getDataView(0);
        }
        Graphics graphics = this.getGraphics();
        JCValueLabel jCValueLabel = this.anno.pickLabel(graphics, point);
        graphics.dispose();
        if (jCValueLabel != null) {
            JCData3dLabelIndex jCData3dLabelIndex = new JCData3dLabelIndex(jCValueLabel);
            jCData3dLabelIndex.setObject(this);
            return jCData3dLabelIndex;
        }
        chart3dDataView.createDraw();
        jCData3dIndex = chart3dDataView.getDraw().getMapping().pick(point.x, point.y);
        if (jCData3dIndex != null) {
            jCData3dIndex.setObject(this);
            jCData3dIndex.setDataView(chart3dDataView);
        }
        return jCData3dIndex;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        int n2 = this.changedFlag;
        this.changed = true;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n2;
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics.create();
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }
}

