/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.ParentTrackChange;
import com.klg.jclass.chart3d.resources.LocaleBundle;

public class JCBar
extends ParentTrackChange {
    static final long serialVersionUID = -5542417106751358122L;
    public static final int FIXED = 1;
    public static final int HISTOGRAM = 2;
    protected int xFormat = 1;
    protected int yFormat = 1;
    protected double xSpacing = 80.0;
    protected double ySpacing = 80.0;

    public JCBar() {
    }

    public JCBar(int n2, int n3, double d2, double d3) {
        this.xFormat = n2;
        this.yFormat = n3;
        this.xSpacing = d2;
        this.ySpacing = d3;
    }

    public int getXFormat() {
        return this.xFormat;
    }

    public void setXFormat(int n2) {
        if (this.xFormat == n2) {
            return;
        }
        if (n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Should be one of FIXED or HISTOGRAM."));
        }
        this.xFormat = n2;
        this.callParentSetChanged(true, 2);
    }

    public int getYFormat() {
        return this.yFormat;
    }

    public void setYFormat(int n2) {
        if (this.yFormat == n2) {
            return;
        }
        if (n2 < 1 || n2 > 2) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Should be one of FIXED or HISTOGRAM."));
        }
        this.yFormat = n2;
        this.callParentSetChanged(true, 2);
    }

    public double getXSpacing() {
        return this.xSpacing;
    }

    public void setXSpacing(double d2) {
        if (this.xSpacing == d2) {
            return;
        }
        this.xSpacing = JCChart3dUtil.clamp(d2, 0.0, 100.0);
        this.callParentSetChanged(true, 2);
    }

    public double getYSpacing() {
        return this.ySpacing;
    }

    public void setYSpacing(double d2) {
        if (this.ySpacing == d2) {
            return;
        }
        this.ySpacing = JCChart3dUtil.clamp(d2, 0.0, 100.0);
        this.callParentSetChanged(true, 2);
    }
}

