/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dAnnoHandler;
import com.klg.jclass.chart3d.DerivedDouble;
import com.klg.jclass.chart3d.JCGridLines;
import com.klg.jclass.chart3d.JCLabelGenerator;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.ParentFormatter;
import com.klg.jclass.chart3d.resources.LocaleBundle;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JCAxis
extends ParentFormatter {
    static final long serialVersionUID = -5542417106751358122L;
    public static final int MAX_AXIS_FONT_CUBE_SIZE = 1000;
    public static final int AXIS_NONE = 0;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    public static final int AXIS_EYE = 4;
    public static final int NUM_AXES = 3;
    public static final int ANNOTATION_VALUES = 1;
    public static final int ANNOTATION_DATA_LABELS = 2;
    public static final int ANNOTATION_VALUE_LABELS = 3;
    public static final int ANNOTATION_ROTATION_DEFAULT = 0;
    public static final int ANNOTATION_ROTATION_HORIZONTAL = 1;
    public static final int ANNOTATION_ROTATION_VERTICAL = 2;
    protected boolean showing = true;
    protected int annotationMethod = 1;
    protected int annotationRotation = 0;
    protected double origin = 0.0;
    protected String title = null;
    protected DerivedDouble min = new DerivedDouble(Double.MAX_VALUE, true);
    protected DerivedDouble max = new DerivedDouble(Double.MAX_VALUE, true);
    protected JCGridLines gridLines = null;
    protected Font annoFont = null;
    protected int annoFontCubeSize = 80;
    protected Font titleFont = null;
    protected int titleFontCubeSize = 80;
    protected boolean combineLabels = false;
    protected double annoMin = Double.MAX_VALUE;
    protected double annoMax = Double.MAX_VALUE;
    protected double annoStep = Double.MAX_VALUE;
    protected double annoEaseway = 0.0;
    protected int maxAnnoLength = 0;
    protected double dataportMin = Double.MAX_VALUE;
    protected double dataportMax = Double.MAX_VALUE;
    protected Chart3dAnnoHandler annoHandler = new Chart3dAnnoHandler(this);
    protected JCLabelGenerator labelGenerator = null;
    protected int axisId = -1;

    public JCAxis() {
    }

    public JCAxis(int n2, Font font) {
        this.axisId = n2;
        this.annoFont = font;
        this.titleFont = font;
    }

    public int getAxisId() {
        return this.axisId;
    }

    public void setShowing(boolean bl) {
        if (this.showing == bl) {
            return;
        }
        this.showing = bl;
        this.callParentSetChanged(true, 2);
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setAnnotationMethod(int n2) {
        if (this.annotationMethod == n2) {
            return;
        }
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. "));
        }
        this.annotationMethod = n2;
        this.callParentSetChanged(true, 2);
    }

    public int getAnnotationMethod() {
        return this.annotationMethod;
    }

    public void setAnnotationRotation(int n2) {
        if (this.annotationRotation == n2) {
            return;
        }
        if (n2 < 0 || n2 > 2) {
            String string = LocaleBundle.string("Invalid value. ");
            throw new IllegalArgumentException(string);
        }
        this.annotationRotation = n2;
        this.callParentSetChanged(true, 2);
    }

    public int getAnnotationRotation() {
        return this.annotationRotation;
    }

    public void setOrigin(double d2) {
        if (this.origin == d2) {
            return;
        }
        this.origin = d2;
        this.callParentSetChanged(true, 2);
    }

    public double getOrigin() {
        return this.origin;
    }

    public void setAnnoFont(Font font) {
        if (this.annoFont == font) {
            return;
        }
        this.annoFont = font;
        this.callParentSetChanged(true, 1);
    }

    public Font getAnnoFont() {
        return this.annoFont;
    }

    public void setAnnoFontCubeSize(int n2) {
        if (this.annoFontCubeSize == n2) {
            return;
        }
        if (n2 < 0 || n2 > 1000) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Must be between 0 and 1000."));
        }
        this.annoFontCubeSize = n2;
        this.callParentSetChanged(true, 2);
    }

    public int getAnnoFontCubeSize() {
        return this.annoFontCubeSize;
    }

    public void setTitleFont(Font font) {
        if (this.titleFont == font) {
            return;
        }
        this.titleFont = font;
        this.callParentSetChanged(true, 1);
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFontCubeSize(int n2) {
        if (this.titleFontCubeSize == n2) {
            return;
        }
        if (n2 < 0 || n2 > 1000) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Must be between 0 and 1000."));
        }
        this.titleFontCubeSize = n2;
        this.callParentSetChanged(true, 2);
    }

    public int getTitleFontCubeSize() {
        return this.titleFontCubeSize;
    }

    public void setTitle(String string) {
        if (this.title != null ? this.title.equals(string) : string == null) {
            return;
        }
        this.title = string;
        this.callParentSetChanged(true, 2);
    }

    public String getTitle() {
        return this.title;
    }

    public void setMin(double d2) {
        if (!this.min.isDefault && this.min.value == d2) {
            return;
        }
        this.min.value = d2;
        this.min.isDefault = false;
        this.callParentSetChanged(true, 290);
    }

    public double getMin() {
        return this.min.value;
    }

    public void setMinIsDefault(boolean bl) {
        if (this.min.isDefault == bl) {
            return;
        }
        this.min.isDefault = bl;
        this.callParentSetChanged(true, 290);
    }

    public boolean getMinIsDefault() {
        return this.min.isDefault;
    }

    public void setMax(double d2) {
        if (!this.max.isDefault && this.max.value == d2) {
            return;
        }
        this.max.value = d2;
        this.max.isDefault = false;
        this.callParentSetChanged(true, 290);
    }

    public double getMax() {
        return this.max.value;
    }

    public void setMaxIsDefault(boolean bl) {
        if (this.max.isDefault == bl) {
            return;
        }
        this.max.isDefault = bl;
        this.callParentSetChanged(true, 290);
    }

    public boolean getMaxIsDefault() {
        return this.max.isDefault;
    }

    public void setGridLines(JCGridLines jCGridLines) {
        if (this.gridLines == jCGridLines) {
            return;
        }
        this.gridLines = jCGridLines;
        if (this.gridLines == null) {
            throw new IllegalArgumentException(LocaleBundle.string("Invalid value. Cannot be null."));
        }
        this.gridLines.setAxis(this);
    }

    public JCGridLines getGridLines() {
        return this.gridLines;
    }

    protected void setAnnoMin(double d2) {
        this.annoMin = d2;
    }

    public double getAnnoMin() {
        return this.annoMin;
    }

    protected void setAnnoMax(double d2) {
        this.annoMax = d2;
    }

    public double getAnnoMax() {
        return this.annoMax;
    }

    protected void setAnnoStep(double d2) {
        this.annoStep = d2;
    }

    public double getAnnoStep() {
        return this.annoStep;
    }

    protected void setAnnoEaseway(double d2) {
        this.annoEaseway = d2;
    }

    public double getAnnoEaseway() {
        return this.annoEaseway;
    }

    protected int getMaxAnnoLength() {
        return this.maxAnnoLength;
    }

    protected void setDataportMin(double d2) {
        this.dataportMin = d2;
    }

    public double getDataportMin() {
        return this.dataportMin;
    }

    protected void setDataportMax(double d2) {
        this.dataportMax = d2;
    }

    public double getDataportMax() {
        return this.dataportMax;
    }

    public Chart3dAnnoHandler getAnnoHandler() {
        return this.annoHandler;
    }

    protected void checkLimits(double d2, double d3) {
        if (this.max.value <= this.min.value && !this.max.isDefault) {
            this.max.isDefault = true;
            this.max.value = d3;
        }
        if (this.max.value <= this.min.value && !this.min.isDefault) {
            this.min.isDefault = true;
            this.min.value = d2;
        }
        if (this.max.value <= this.min.value) {
            double d4 = 0.0;
            while (d3 <= d2) {
                d3 = d2 + Math.pow(10.0, d4);
                d2 -= d3 - d2;
                d4 += 1.0;
            }
            this.min.value = d2;
            this.max.value = d3;
        }
    }

    protected void setExtents(double d2, double d3) {
        this.min.setValue(d2);
        this.max.setValue(d3);
        this.checkLimits(d2, d3);
    }

    protected void calcMaxAnnoLength() {
        List<JCValueLabel> list = this.annoHandler.getValueLabels();
        this.maxAnnoLength = 0;
        for (JCValueLabel jCValueLabel : list) {
            int n2;
            String string;
            double d2 = jCValueLabel.getValue();
            if (d2 < this.annoMin || d2 > this.annoMax || (string = jCValueLabel.getLabel()) == null || (n2 = string.length()) <= this.maxAnnoLength) continue;
            this.maxAnnoLength = n2;
        }
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        if (this.labelGenerator == jCLabelGenerator) {
            return;
        }
        this.labelGenerator = jCLabelGenerator;
        this.callParentSetChanged(true, 2);
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setCombineLabels(boolean bl) {
        if (this.combineLabels == bl) {
            return;
        }
        this.combineLabels = bl;
        this.callParentSetChanged(true, 2);
    }

    public boolean isCombineLabels() {
        return this.combineLabels;
    }

    public JCValueLabel getValueLabel(double d2) {
        JCValueLabel jCValueLabel = null;
        List<JCValueLabel> list = this.annoHandler.getUserValueLabels();
        for (JCValueLabel jCValueLabel2 : list) {
            if (d2 != jCValueLabel2.value) continue;
            jCValueLabel = jCValueLabel2;
            break;
        }
        return jCValueLabel;
    }

    public JCValueLabel getGeneratedValueLabel(double d2) {
        JCValueLabel jCValueLabel = null;
        List<JCValueLabel> list = this.annoHandler.getValueLabels();
        for (JCValueLabel jCValueLabel2 : list) {
            if (d2 != jCValueLabel2.value) continue;
            jCValueLabel = jCValueLabel2;
            break;
        }
        return jCValueLabel;
    }

    public void addValueLabel(JCValueLabel jCValueLabel) {
        int n2 = -1;
        int n3 = -1;
        List<JCValueLabel> list = this.annoHandler.getUserValueLabels();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            JCValueLabel jCValueLabel2 = list.get(i2);
            if (jCValueLabel2.value > jCValueLabel.value && n3 < 0) {
                n3 = i2;
                break;
            }
            if (jCValueLabel2.value != jCValueLabel.value) continue;
            n2 = i2;
            break;
        }
        if (n2 >= 0) {
            list.set(n2, jCValueLabel);
        } else if (n3 >= 0) {
            list.add(n3, jCValueLabel);
        } else {
            list.add(jCValueLabel);
        }
        this.annoHandler.sortValueLabels();
        this.callParentSetChanged(true, 2);
    }

    public JCValueLabel[] getValueLabels() {
        List<JCValueLabel> list = this.annoHandler.getUserValueLabels();
        JCValueLabel[] jCValueLabelArray = null;
        if (list.size() == 0) {
            return jCValueLabelArray;
        }
        jCValueLabelArray = new JCValueLabel[list.size()];
        for (int i2 = 0; i2 < jCValueLabelArray.length; ++i2) {
            jCValueLabelArray[i2] = list.get(i2);
        }
        return jCValueLabelArray;
    }

    public JCValueLabel[] getGeneratedValueLabels() {
        List<JCValueLabel> list = this.annoHandler.getValueLabels();
        JCValueLabel[] jCValueLabelArray = null;
        if (list.size() == 0) {
            return jCValueLabelArray;
        }
        jCValueLabelArray = new JCValueLabel[list.size()];
        for (int i2 = 0; i2 < jCValueLabelArray.length; ++i2) {
            jCValueLabelArray[i2] = list.get(i2);
        }
        return jCValueLabelArray;
    }

    public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
        ArrayList<JCValueLabel> arrayList = new ArrayList<JCValueLabel>();
        if (jCValueLabelArray != null) {
            arrayList.addAll(Arrays.asList(jCValueLabelArray));
        }
        this.annoHandler.setUserValueLabels(arrayList);
        this.callParentSetChanged(true, 2);
    }

    public JCValueLabel getValueLabels(int n2) {
        List<JCValueLabel> list = this.annoHandler.getUserValueLabels();
        if (list == null) {
            return null;
        }
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        return list.get(n2);
    }

    public JCValueLabel getGeneratedValueLabels(int n2) {
        List<JCValueLabel> list = this.annoHandler.getValueLabels();
        if (list == null) {
            return null;
        }
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        return list.get(n2);
    }

    public void setValueLabels(int n2, JCValueLabel jCValueLabel) {
        List<JCValueLabel> list = this.annoHandler.getUserValueLabels();
        if (n2 < 0 || n2 > list.size()) {
            throw new IllegalArgumentException(LocaleBundle.string("Bad data or index"));
        }
        if (n2 < list.size()) {
            list.set(n2, jCValueLabel);
        } else {
            list.add(jCValueLabel);
        }
        this.annoHandler.sortValueLabels();
        this.callParentSetChanged(true, 2);
    }
}

