/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.Draw;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.SortPoint;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.List;
import javax.vecmath.Point3d;

public class DrawPoint
extends Draw
implements Serializable {
    public DrawPoint() {
    }

    public DrawPoint(Chart3dDataView chart3dDataView) {
        super(chart3dDataView);
    }

    protected Chart3dPointData getPointData() {
        if (this.dataView != null) {
            return (Chart3dPointData)this.dataView.getElevationData();
        }
        return null;
    }

    protected void draw(Graphics graphics) {
        Chart3dPointData chart3dPointData = this.getPointData();
        ScreenPoint[][] screenPointArray = chart3dPointData.getScreenPoints();
        if (!chart3dPointData.isDataOK()) {
            return;
        }
        chart3dPointData.sortPoints();
        List<SortPoint> list = chart3dPointData.getSortPoints();
        if (list == null) {
            return;
        }
        for (SortPoint sortPoint : list) {
            int n2 = sortPoint.getSeries();
            int n3 = sortPoint.getPoint();
            Chart3dPointSeries chart3dPointSeries = chart3dPointData.getSeries(n2);
            JCChart3dStyle jCChart3dStyle = chart3dPointSeries.getChartStyle();
            Point3d point3d = chart3dPointSeries.getPoint(n3);
            ScreenPoint screenPoint = screenPointArray[n2][n3];
            if (screenPoint.isDrawn() || screenPoint.isHoleValue() || screenPoint.isHidden()) continue;
            this.renderPoint(graphics, jCChart3dStyle.getSymbolStyle(), jCChart3dStyle.getLineStyle(), screenPoint, point3d.x, point3d.y);
        }
    }

    protected void draw2dPoints(Graphics graphics) {
        Chart3dPointData chart3dPointData = this.getPointData();
        ScreenPoint[][] screenPointArray = chart3dPointData.getScreenPoints();
        if (!chart3dPointData.isDataOK()) {
            return;
        }
        for (int i2 = 0; i2 < chart3dPointData.getNumSeries(); ++i2) {
            Chart3dPointSeries chart3dPointSeries = chart3dPointData.getSeries(i2);
            JCChart3dStyle jCChart3dStyle = chart3dPointSeries.getChartStyle();
            for (int i3 = 0; i3 < chart3dPointSeries.getNumPoints(); ++i3) {
                Point3d point3d = chart3dPointSeries.getPoint(i3);
                ScreenPoint screenPoint = screenPointArray[i2][i3];
                if (screenPoint.isDrawn() || screenPoint.isHoleValue() || screenPoint.isHidden()) continue;
                this.renderPoint(graphics, jCChart3dStyle.getSymbolStyle(), jCChart3dStyle.getLineStyle(), screenPoint, point3d.x, point3d.y);
            }
        }
    }
}

