/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.Transform;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;

public class Cube
implements Serializable {
    static final long serialVersionUID = -5542417106751358122L;
    public static final int YNEG_ZNEG = 0;
    public static final int YNEG_ZPOS = 1;
    public static final int YPOS_ZNEG = 2;
    public static final int YPOS_ZPOS = 3;
    public static final int XNEG_ZNEG = 4;
    public static final int XNEG_ZPOS = 5;
    public static final int XPOS_ZNEG = 6;
    public static final int XPOS_ZPOS = 7;
    public static final int XNEG_YNEG = 8;
    public static final int XNEG_YPOS = 9;
    public static final int XPOS_YNEG = 10;
    public static final int XPOS_YPOS = 11;
    public static final int FACE_LEFT = 0;
    public static final int FACE_RIGHT = 1;
    public static final int FACE_BOTTOM = 2;
    public static final int FACE_TOP = 3;
    public static final int FACE_FAR = 4;
    public static final int FACE_NEAR = 5;
    public static final int NUM_POINTS = 8;
    public static final int NUM_EDGES = 12;
    public static final int NUM_FACES = 6;
    public static final int NUM_POINTS_IN_FACE = 4;
    public static final int VP_XMAX = 1;
    public static final int VP_XMIN = 2;
    public static final int VP_YMAX = 4;
    public static final int VP_YMIN = 8;
    public static final int VP_ZMAX = 16;
    public static final int VP_ZMIN = 32;
    public static final int VP_XMASK = 3;
    public static final int VP_YMASK = 12;
    public static final int VP_ZMASK = 48;
    protected static final double[][] points = new double[][]{{-1.0, -1.0, -1.0}, {-1.0, -1.0, 1.0}, {-1.0, 1.0, 1.0}, {-1.0, 1.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {1.0, -1.0, -1.0}};
    protected static final int[][] faces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {0, 7, 6, 1}, {2, 5, 4, 3}, {0, 3, 4, 7}, {1, 6, 5, 2}};
    protected static final int[][] edges = new int[][]{{0, 7}, {1, 6}, {3, 4}, {2, 5}, {0, 3}, {1, 2}, {7, 4}, {6, 5}, {0, 1}, {3, 2}, {7, 6}, {4, 5}};
    protected static final int[][] pointEdges = new int[][]{{0, 2, 8}, {0, 3, 9}, {4, 7, 9}, {4, 6, 8}, {5, 6, 10}, {5, 7, 11}, {1, 3, 11}, {1, 2, 10}};
    protected boolean[] faceVisible = new boolean[6];
    protected boolean[] annotateEdge = new boolean[12];
    protected boolean[] drawEdge = new boolean[12];
    protected Point4d[] cubePoints = new Point4d[8];
    protected JCChart3dArea area = null;

    public Cube() {
        for (int i2 = 0; i2 < 8; ++i2) {
            this.cubePoints[i2] = new Point4d(points[i2][0], points[i2][1], points[i2][2], 1.0);
        }
    }

    public Cube(JCChart3dArea jCChart3dArea) {
        this();
        this.area = jCChart3dArea;
    }

    public JCChart3dArea getChart3dArea() {
        return this.area;
    }

    public void setChart3dArea(JCChart3dArea jCChart3dArea) {
        this.area = jCChart3dArea;
    }

    protected Point4d[] getCubePoints() {
        return this.cubePoints;
    }

    protected boolean[] getFaceVisible() {
        return this.faceVisible;
    }

    public boolean[] getAnnotateEdge() {
        return this.annotateEdge;
    }

    protected boolean[] getDrawEdge() {
        return this.drawEdge;
    }

    protected boolean faceBackfacing(int n2) {
        Point4d point4d = new Point4d();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = new Matrix4d(transform.getTextView());
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        Transform.scaleMatrix(matrix4d, jCPlotCube.getXNormalizedScale(), jCPlotCube.getYNormalizedScale(), jCPlotCube.getZNormalizedScale());
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = faces[n2][i2];
            point4d.set(points[n3][0], points[n3][1], points[n3][2], 1.0);
            Transform.transformPoint(matrix4d, point4d);
            int n4 = 4 - i2 - 1;
            nArray[n4] = (int)Math.round(point4d.x);
            nArray2[n4] = (int)Math.round(point4d.y);
        }
        return JCChart3dUtil.backfacing(nArray, nArray2);
    }

    protected int findViewPosition() {
        Point4d point4d = this.area.getTransform().getEyePosition();
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        double d2 = point4d.x / jCPlotCube.getXNormalizedScale();
        double d3 = point4d.y / jCPlotCube.getYNormalizedScale();
        double d4 = point4d.z / jCPlotCube.getZNormalizedScale();
        int n2 = 0;
        if (d2 >= 1.0) {
            n2 |= 1;
        }
        if (d2 <= -1.0) {
            n2 |= 2;
        }
        if (d3 >= 1.0) {
            n2 |= 4;
        }
        if (d3 <= -1.0) {
            n2 |= 8;
        }
        if (d4 >= 1.0) {
            n2 |= 0x10;
        }
        if (d4 <= -1.0) {
            n2 |= 0x20;
        }
        return n2;
    }

    protected boolean edgeInFace(int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < 4; ++i2) {
            bl = bl || faces[n2][i2] == edges[n3][0];
            bl2 = bl2 || faces[n2][i2] == edges[n3][1];
        }
        return bl && bl2;
    }

    protected void calcFace(int n2) {
        int n3;
        for (n3 = 0; n3 <= 11; ++n3) {
            this.annotateEdge[n3] = false;
            this.drawEdge[n3] = true;
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            this.faceVisible[n3] = true;
        }
        switch (n2) {
            case 1: {
                this.annotateEdge[6] = true;
                this.annotateEdge[7] = true;
                this.annotateEdge[10] = true;
                this.annotateEdge[11] = true;
                this.faceVisible[1] = false;
                break;
            }
            case 2: {
                this.annotateEdge[4] = true;
                this.annotateEdge[5] = true;
                this.annotateEdge[8] = true;
                this.annotateEdge[9] = true;
                this.faceVisible[0] = false;
                break;
            }
            case 4: {
                this.annotateEdge[2] = true;
                this.annotateEdge[3] = true;
                this.annotateEdge[9] = true;
                this.annotateEdge[11] = true;
                this.faceVisible[3] = false;
                break;
            }
            case 8: {
                this.annotateEdge[0] = true;
                this.annotateEdge[1] = true;
                this.annotateEdge[8] = true;
                this.annotateEdge[10] = true;
                this.faceVisible[2] = false;
                break;
            }
            case 16: {
                this.annotateEdge[1] = true;
                this.annotateEdge[3] = true;
                this.annotateEdge[5] = true;
                this.annotateEdge[7] = true;
                this.faceVisible[5] = false;
                break;
            }
            case 32: {
                this.annotateEdge[0] = true;
                this.annotateEdge[2] = true;
                this.annotateEdge[4] = true;
                this.annotateEdge[6] = true;
                this.faceVisible[4] = false;
            }
        }
    }

    protected void calcEdge(int n2) {
        this.calculateEdge(n2);
    }

    protected int calculateEdge(int n2) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = 0;
        if ((n2 & 3) == 0) {
            n6 |= (n2 & 4) >> 1;
            n4 = ~(n6 |= (n2 & 0x10) >> 4) & 3;
            for (n3 = 0; n3 <= 3; ++n3) {
                this.annotateEdge[n3] = (n3 & 3) != n6 && (n3 & 3) != n4;
                boolean bl = this.drawEdge[n3] = (n3 & 3) != n6;
                if ((n3 & 3) != n6) continue;
                n5 = n3;
            }
            for (n3 = 4; n3 <= 7; ++n3) {
                this.annotateEdge[n3] = (n3 & 1) == (n6 & 1);
                this.drawEdge[n3] = true;
            }
            for (n3 = 8; n3 <= 11; ++n3) {
                this.annotateEdge[n3] = (n3 & 1) == n6 >> 1;
                this.drawEdge[n3] = true;
            }
        } else if ((n2 & 0xC) == 0) {
            n6 |= (n2 & 1) << 1;
            n4 = ~(n6 |= (n2 & 0x10) >> 4) & 3;
            for (n3 = 4; n3 <= 7; ++n3) {
                this.annotateEdge[n3] = (n3 & 3) != n6 && (n3 & 3) != n4;
                boolean bl = this.drawEdge[n3] = (n3 & 3) != n6;
                if ((n3 & 3) != n6) continue;
                n5 = n3;
            }
            for (n3 = 0; n3 <= 3; ++n3) {
                this.annotateEdge[n3] = (n3 & 1) == (n6 & 1);
                this.drawEdge[n3] = true;
            }
            for (n3 = 8; n3 <= 11; ++n3) {
                this.annotateEdge[n3] = (n3 & 2) == (n6 & 2);
                this.drawEdge[n3] = true;
            }
        } else if ((n2 & 0x30) == 0) {
            n6 |= (n2 & 1) << 1;
            n4 = ~(n6 |= (n2 & 4) >> 2) & 3;
            for (n3 = 8; n3 <= 11; ++n3) {
                this.annotateEdge[n3] = (n3 & 3) != n6 && (n3 & 3) != n4;
                boolean bl = this.drawEdge[n3] = (n3 & 3) != n6;
                if ((n3 & 3) != n6) continue;
                n5 = n3;
            }
            for (n3 = 0; n3 <= 3; ++n3) {
                this.annotateEdge[n3] = (n3 & 2) == (n6 & 1) << 1;
                this.drawEdge[n3] = true;
            }
            for (n3 = 4; n3 <= 7; ++n3) {
                this.annotateEdge[n3] = (n3 & 2) == (n6 & 2);
                this.drawEdge[n3] = true;
            }
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            this.faceVisible[n3] = !this.edgeInFace(n3, n5);
        }
        return n5;
    }

    protected void calcCorner(int n2, int n3) {
        int n4;
        for (n4 = 0; n4 <= 11; ++n4) {
            this.annotateEdge[n4] = edges[n4][0] != n2 && edges[n4][1] != n2 && edges[n4][0] != n3 && edges[n4][1] != n3;
            this.drawEdge[n4] = edges[n4][0] != n3 && edges[n4][1] != n3;
        }
        for (n4 = 0; n4 <= 5; ++n4) {
            this.faceVisible[n4] = faces[n4][0] != n3 && faces[n4][1] != n3 && faces[n4][2] != n3 && faces[n4][3] != n3;
        }
    }

    protected void calc3DAnnoEdges() {
        int n2;
        int n3;
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.m11 = -1.0;
        matrix4d.mul(transform.getPerspective());
        matrix4d.mul(transform.getRotation());
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        Transform.scaleMatrix(matrix4d, jCPlotCube.getXNormalizedScale(), jCPlotCube.getYNormalizedScale(), jCPlotCube.getZNormalizedScale());
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        int n4 = -1;
        int n5 = -1;
        for (n3 = 0; n3 < 8; ++n3) {
            this.cubePoints[n3].set(points[n3][0], points[n3][1], points[n3][2], 1.0);
            Transform.transformPoint(matrix4d, this.cubePoints[n3]);
            if (d2 > this.cubePoints[n3].z) {
                d2 = this.cubePoints[n3].z;
                n5 = n3;
            }
            if (!(d3 < this.cubePoints[n3].z)) continue;
            d3 = this.cubePoints[n3].z;
            n4 = n3;
        }
        n3 = this.findViewPosition();
        int n6 = 0;
        if ((n3 & 3) != 0) {
            ++n6;
        }
        if ((n3 & 0xC) != 0) {
            n6 += 2;
        }
        if ((n3 & 0x30) != 0) {
            n6 += 4;
        }
        switch (n6) {
            case 0: {
                break;
            }
            case 1: {
                this.calcFace(n3);
                break;
            }
            case 2: {
                this.calcFace(n3);
                break;
            }
            case 3: {
                this.calcEdge(n3);
                break;
            }
            case 4: {
                this.calcFace(n3);
                break;
            }
            case 5: {
                this.calcEdge(n3);
                break;
            }
            case 6: {
                this.calcEdge(n3);
                break;
            }
            case 7: {
                this.calcCorner(n5, n4);
            }
        }
        if (!this.area.getAxis(1).isShowing()) {
            for (n2 = 0; n2 <= 3; ++n2) {
                this.annotateEdge[n2] = false;
                this.drawEdge[n2] = false;
            }
        }
        if (!this.area.getAxis(2).isShowing()) {
            for (n2 = 4; n2 <= 7; ++n2) {
                this.annotateEdge[n2] = false;
                this.drawEdge[n2] = false;
            }
        }
        if (!this.area.getAxis(3).isShowing()) {
            for (n2 = 8; n2 <= 11; ++n2) {
                this.annotateEdge[n2] = false;
                this.drawEdge[n2] = false;
            }
        }
    }

    protected void calc2DAnnoEdges() {
        for (int i2 = 0; i2 <= 5; ++i2) {
            this.faceVisible[i2] = i2 == 5;
        }
    }
}

