/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Intersection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContourCell
implements Comparator<Intersection>,
Serializable {
    public static final int SIDE = 4;
    protected boolean hole = false;
    protected int nIntersections = 0;
    protected List<List<Intersection>> corners = new ArrayList<List<Intersection>>();
    protected List<Intersection> side = null;
    protected Intersection newIntersection = null;

    ContourCell() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.corners.add(new ArrayList());
        }
    }

    protected void setHole(boolean bl) {
        this.hole = bl;
    }

    protected boolean isHole() {
        return this.hole;
    }

    protected void addIntersection(Intersection intersection, int n2) {
        if (n2 < 0 || n2 > 4) {
            return;
        }
        if (n2 == 4) {
            if (this.side == null) {
                this.side = new ArrayList<Intersection>();
            }
            this.side.add(intersection);
        } else {
            List<Intersection> list = this.corners.get(n2);
            if (list == null) {
                list = new ArrayList<Intersection>();
                this.corners.set(n2, list);
            }
            list.add(intersection);
        }
        ++this.nIntersections;
    }

    public int getNIntersections() {
        return this.nIntersections;
    }

    protected Intersection getNewIntersection() {
        return this.newIntersection;
    }

    protected void setNewIntersection(Intersection intersection) {
        this.newIntersection = intersection;
    }

    public List<Intersection> getIntersectionList(int n2) {
        List<Intersection> list;
        if (n2 < 0 || n2 > 4) {
            return null;
        }
        List<Intersection> list2 = list = n2 == 4 ? this.side : this.corners.get(n2);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    protected void sortIntersectionLists() {
        for (List<Intersection> list : this.corners) {
            if (list == null || list.size() <= 1) continue;
            Collections.sort(list, this);
        }
        if (this.side != null && this.side.size() > 1) {
            Collections.sort(this.side, this);
        }
    }

    @Override
    public int compare(Intersection intersection, Intersection intersection2) {
        Point3d point3d = intersection.getSegment2().getPoint();
        Point3d point3d2 = intersection2.getSegment2().getPoint();
        int n2 = 0;
        switch (intersection2.side2) {
            case 0: {
                n2 = point3d.y < point3d2.y ? -1 : (point3d.y > point3d2.y ? 1 : 0);
                break;
            }
            case 1: {
                n2 = point3d.x > point3d2.x ? -1 : (point3d.x < point3d2.x ? 1 : 0);
                break;
            }
            case 2: {
                n2 = point3d.y > point3d2.y ? -1 : (point3d.y < point3d2.y ? 1 : 0);
                break;
            }
            case 3: {
                n2 = point3d.x < point3d2.x ? -1 : (point3d.x > point3d2.x ? 1 : 0);
                break;
            }
        }
        return n2;
    }
}

