/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.property;

import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.property.PropertySaveFactory;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.io.JCIOException;
import com.klg.jclass.util.io.XMLTextUtil;
import com.klg.jclass.util.property.PropertyPersistorModel;
import com.klg.jclass.util.property.PropertySaveModel;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;

public class ComponentPropertySave
implements PropertySaveModel {
    protected Component component = null;
    protected Component defaultComponent = null;
    protected Color compBackground;
    protected Color defBackground;
    protected Color compForeground;
    protected Color defForeground;
    protected Font compFont;
    protected Font defFont;
    protected boolean compIsOpaque;
    protected boolean defIsOpaque;
    protected boolean compIsVisible;
    protected boolean defIsVisible;
    protected Border compBorder;
    protected Border defBorder;

    public void setSource(Object object) {
        if (object instanceof Component) {
            this.component = (Component)object;
        }
    }

    public void setDefault(Object object) {
        if (object instanceof Component) {
            this.defaultComponent = (Component)object;
        }
    }

    public boolean checkProperties(PropertyPersistorModel propertyPersistorModel) {
        if (this.component == null || this.defaultComponent == null) {
            return false;
        }
        this.compBackground = this.component.getBackground();
        this.defBackground = this.defaultComponent.getBackground();
        this.compForeground = this.component.getForeground();
        this.defForeground = this.defaultComponent.getForeground();
        this.compFont = this.component.getFont();
        this.defFont = this.defaultComponent.getFont();
        this.compIsOpaque = this.component.isOpaque();
        this.defIsOpaque = this.defaultComponent.isOpaque();
        this.compIsVisible = this.component.isVisible();
        this.defIsVisible = this.defaultComponent.isVisible();
        this.compBorder = ((JComponent)this.component).getBorder();
        this.defBorder = ((JComponent)this.defaultComponent).getBorder();
        return !this.compBackground.equals(this.defBackground) || !this.compForeground.equals(this.defForeground) || !this.compFont.equals(this.defFont) || this.compIsOpaque != this.defIsOpaque || this.compIsVisible != this.defIsVisible || this.compBorder != this.defBorder;
    }

    public void saveProperties(PropertyPersistorModel propertyPersistorModel, String string, int n2) throws JCIOException {
        if (this.component == null || this.defaultComponent == null) {
            System.out.println("FAILURE: No component set ");
            return;
        }
        if (!this.checkProperties(propertyPersistorModel)) {
            return;
        }
        int n3 = propertyPersistorModel.writeBegin("component", n2);
        boolean bl = false;
        if (!this.compBackground.equals(this.defBackground)) {
            bl = true;
            ComponentPropertySave.writeUI(propertyPersistorModel, string, "background", n3, JCSwingTypeConverter.fromColor(this.compBackground));
        }
        if (this.compIsOpaque != this.defIsOpaque || bl && !this.compIsOpaque) {
            propertyPersistorModel.writeProperty(string, "opaque", n3, this.compIsOpaque);
        }
        if (!this.compForeground.equals(this.defForeground)) {
            ComponentPropertySave.writeUI(propertyPersistorModel, string, "foreground", n3, JCSwingTypeConverter.fromColor(this.compForeground));
        }
        if (!this.compFont.equals(this.defFont)) {
            ComponentPropertySave.writeUI(propertyPersistorModel, string, "font", n3, XMLTextUtil.expandReservedCharacters(JCSwingTypeConverter.fromFont(this.compFont)));
        }
        if (this.compIsVisible != this.defIsVisible) {
            propertyPersistorModel.writeProperty(string, "visible", n3, this.compIsVisible);
        }
        if (this.compBorder != this.defBorder) {
            propertyPersistorModel.writeEnd(null, n2, true, true);
            this.writeBorder(propertyPersistorModel, string, n2 + PropertySaveFactory.tabIncrement);
            propertyPersistorModel.writeEnd("component", n2, true, false);
        } else {
            propertyPersistorModel.writeEnd(null, n2, true, false);
        }
    }

    public static void writeInsets(PropertyPersistorModel propertyPersistorModel, String string, int n2, Insets insets) {
        int n3 = propertyPersistorModel.writeBegin("insets", n2);
        propertyPersistorModel.writeProperty(string, "left", n3, new Integer(insets.left));
        propertyPersistorModel.writeProperty(string, "right", n3, new Integer(insets.right));
        propertyPersistorModel.writeProperty(string, "top", n3, new Integer(insets.top));
        propertyPersistorModel.writeProperty(string, "bottom", n3, new Integer(insets.bottom));
        propertyPersistorModel.writeEnd(null, n2, true, false);
    }

    public void writeBorder(PropertyPersistorModel propertyPersistorModel, String string, int n2) {
        this.writeBorder(propertyPersistorModel, string, n2, this.compBorder);
    }

    public void writeBorder(PropertyPersistorModel propertyPersistorModel, String string, int n2, Border border) {
        if (border == null || border instanceof UIResource) {
            return;
        }
        if (propertyPersistorModel.getType().equals("HTML")) {
            String string2 = JCSwingTypeConverter.fromBorder(border, this.component);
            if (string2 != null) {
                propertyPersistorModel.writeProperty(string, "border", n2, string2);
            }
        } else {
            int n3 = PropertySaveFactory.tabIncrement;
            if (border instanceof MatteBorder) {
                MatteBorder matteBorder = (MatteBorder)border;
                int n4 = propertyPersistorModel.writeBegin("matte-border", n2);
                Color color = matteBorder.getMatteColor();
                if (color == null) {
                    color = Color.black;
                }
                propertyPersistorModel.writeProperty(string, "color", n4, JCSwingTypeConverter.fromColor(color));
                propertyPersistorModel.writeEnd(null, n2, true, true);
                ComponentPropertySave.writeInsets(propertyPersistorModel, string, n2 + PropertySaveFactory.tabIncrement, matteBorder.getBorderInsets(this.component));
                propertyPersistorModel.writeEnd("matte-border", n2, true, false);
            } else if (border instanceof EmptyBorder) {
                EmptyBorder emptyBorder = (EmptyBorder)border;
                propertyPersistorModel.writeBegin("empty-border", n2);
                propertyPersistorModel.writeEnd(null, n2, true, true);
                ComponentPropertySave.writeInsets(propertyPersistorModel, string, n2 + PropertySaveFactory.tabIncrement, emptyBorder.getBorderInsets(this.component));
                propertyPersistorModel.writeEnd("empty-border", n2, true, false);
            } else if (border instanceof BevelBorder || border instanceof SoftBevelBorder) {
                BevelBorder bevelBorder = (BevelBorder)border;
                int n5 = propertyPersistorModel.writeBegin("bevel-border", n2);
                propertyPersistorModel.writeProperty(string, "soft", n5, bevelBorder instanceof SoftBevelBorder);
                String string3 = bevelBorder.getBevelType() == 0 ? "Raised" : "Lowered";
                propertyPersistorModel.writeProperty(string, "type", n5, string3);
                Color color = bevelBorder.getHighlightInnerColor();
                Color color2 = bevelBorder.getShadowOuterColor();
                if (color != null || color2 != null) {
                    if (color == null) {
                        color = bevelBorder.getHighlightInnerColor(this.component);
                    }
                    propertyPersistorModel.writeProperty(string, "highlightColor", n5, JCSwingTypeConverter.fromColor(color));
                    if (color2 == null) {
                        color2 = bevelBorder.getShadowOuterColor(this.component);
                    }
                    propertyPersistorModel.writeProperty(string, "shadowColor", n5, JCSwingTypeConverter.fromColor(color2));
                }
                propertyPersistorModel.writeEnd(null, n2, true, false);
            } else if (border instanceof EtchedBorder) {
                Color color;
                EtchedBorder etchedBorder = (EtchedBorder)border;
                int n6 = propertyPersistorModel.writeBegin("etched-border", n2);
                String string4 = etchedBorder.getEtchType() == 0 ? "Raised" : "Lowered";
                propertyPersistorModel.writeProperty(string, "type", n6, string4);
                Color color3 = etchedBorder.getHighlightColor();
                if (color3 != null) {
                    propertyPersistorModel.writeProperty(string, "highlightColor", n6, JCSwingTypeConverter.fromColor(color3));
                }
                if ((color = etchedBorder.getShadowColor()) != null) {
                    propertyPersistorModel.writeProperty(string, "shadowColor", n6, JCSwingTypeConverter.fromColor(color));
                }
                propertyPersistorModel.writeEnd(null, n2, true, false);
            } else if (border instanceof LineBorder) {
                boolean bl;
                LineBorder lineBorder = (LineBorder)border;
                int n7 = propertyPersistorModel.writeBegin("line-border", n2);
                Color color = lineBorder.getLineColor();
                if (color == null) {
                    color = Color.black;
                }
                propertyPersistorModel.writeProperty(string, "color", n7, JCSwingTypeConverter.fromColor(color));
                if (lineBorder.getThickness() > 1) {
                    propertyPersistorModel.writeProperty(string, "thickness", n7, new Integer(lineBorder.getThickness()));
                }
                if (bl = lineBorder.getRoundedCorners()) {
                    propertyPersistorModel.writeProperty(string, "roundedCorners", n7, bl);
                }
                propertyPersistorModel.writeEnd(null, n2, true, false);
            } else if (border instanceof TitledBorder) {
                boolean bl;
                Border border2;
                Color color;
                Object object;
                TitledBorder titledBorder = (TitledBorder)border;
                String string5 = titledBorder.getTitle();
                if (string5 == null || string5.length() == 0) {
                    return;
                }
                int n8 = propertyPersistorModel.writeBegin("titled-border", n2);
                propertyPersistorModel.writeProperty(string, "title", n8, propertyPersistorModel.expandText(string5));
                int n9 = titledBorder.getTitlePosition();
                String[] stringArray = JCSwingTypeConverter.positionStrings;
                int[] nArray = JCSwingTypeConverter.positionValues;
                if (n9 != 0) {
                    String string6 = JCTypeConverter.fromEnum(n9, stringArray, nArray);
                    propertyPersistorModel.writeProperty(string, "titlePosition", n8, string6);
                }
                int n10 = titledBorder.getTitleJustification();
                stringArray = JCSwingTypeConverter.justificationStrings;
                nArray = JCSwingTypeConverter.justificationValues;
                if (n10 != 0) {
                    object = JCTypeConverter.fromEnum(n10, stringArray, nArray);
                    propertyPersistorModel.writeProperty(string, "titleJustification", n8, object);
                }
                if ((color = titledBorder.getTitleColor()) != null) {
                    propertyPersistorModel.writeProperty(string, "color", n8, JCSwingTypeConverter.fromColor(color));
                }
                if ((object = titledBorder.getTitleFont()) != null) {
                    propertyPersistorModel.writeProperty(string, "font", n8, XMLTextUtil.expandReservedCharacters(JCSwingTypeConverter.fromFont((Font)object)));
                }
                boolean bl2 = !((border2 = titledBorder.getBorder()) instanceof CompoundBorder) && !(border2 instanceof TitledBorder);
                boolean bl3 = bl = border2 != null && !(border2 instanceof UIResource) && bl2;
                if (!bl2 && propertyPersistorModel.getPrintErrors()) {
                    System.err.println("Chart XML output: Unsupported border within TitledBorder.  It cannot be a CompoundBorder or another TitledBorder.");
                }
                if (bl) {
                    propertyPersistorModel.writeEnd(null, n2, true, true);
                    this.writeBorder(propertyPersistorModel, string, n2 + n3, border2);
                    propertyPersistorModel.writeEnd("titled-border", n2, true, false);
                } else {
                    propertyPersistorModel.writeEnd(null, n2, true, false);
                }
            } else if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                Border border3 = compoundBorder.getOutsideBorder();
                Border border4 = compoundBorder.getInsideBorder();
                if (border3 == null && border4 == null) {
                    return;
                }
                if (border3 == null) {
                    this.writeBorder(propertyPersistorModel, string, n2, border4);
                    return;
                }
                if (border4 == null) {
                    this.writeBorder(propertyPersistorModel, string, n2, border3);
                    return;
                }
                propertyPersistorModel.writeBegin("compound-border", n2);
                propertyPersistorModel.writeEnd(null, n2, true, true);
                this.writeBorder(propertyPersistorModel, string, n2 + n3, border3);
                this.writeBorder(propertyPersistorModel, string, n2 + n3, border4);
                propertyPersistorModel.writeEnd("compound-border", n2, true, false);
            }
        }
    }

    protected static void writeUI(PropertyPersistorModel propertyPersistorModel, String string, String string2, int n2, Object object) {
        if (object == null || object instanceof UIResource) {
            return;
        }
        propertyPersistorModel.writeProperty(string, string2, n2, object);
    }

    public boolean checkLayoutHints(JCChart jCChart, JComponent jComponent) {
        Rectangle rectangle = jCChart.getLayoutHints(jComponent);
        if (rectangle == null) {
            return false;
        }
        return rectangle.x != Integer.MAX_VALUE || rectangle.y != Integer.MAX_VALUE || rectangle.width != Integer.MAX_VALUE || rectangle.height != Integer.MAX_VALUE;
    }

    public void saveLayoutHints(PropertyPersistorModel propertyPersistorModel, JCChart jCChart, JComponent jComponent, String string, int n2) {
        if (!this.checkLayoutHints(jCChart, jComponent)) {
            return;
        }
        Rectangle rectangle = jCChart.getLayoutHints(jComponent);
        if (rectangle != null) {
            int n3 = propertyPersistorModel.writeBegin("layout-hints", n2);
            if (rectangle.x != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "x", n3, new Integer(rectangle.x));
            }
            if (rectangle.y != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "y", n3, new Integer(rectangle.y));
            }
            if (rectangle.width != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "width", n3, new Integer(rectangle.width));
            }
            if (rectangle.height != Integer.MAX_VALUE) {
                propertyPersistorModel.writeProperty(string, "height", n3, new Integer(rectangle.height));
            }
            propertyPersistorModel.writeEnd(null, n2, true, false);
        }
    }
}

