/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.model.impl;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.DataLabelChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.ImageMapChartDataModel;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataRange;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCMarker;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.JCThreshold;
import com.klg.jclass.chart.LabelledChartDataModel;
import com.klg.jclass.chart.ThresholdChartDataModel;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.chart.TimelineChartDataModel;
import com.klg.jclass.chart.model.AbstractThreshold;
import com.klg.jclass.chart.model.AreaRadarStyleDataSet;
import com.klg.jclass.chart.model.AreaStyleDataSet;
import com.klg.jclass.chart.model.BarDataPoint;
import com.klg.jclass.chart.model.BarDataSet;
import com.klg.jclass.chart.model.BarStyleDataSet;
import com.klg.jclass.chart.model.BasicDataPoint;
import com.klg.jclass.chart.model.BasicDataSet;
import com.klg.jclass.chart.model.CandleStyleDataSet;
import com.klg.jclass.chart.model.ClusterDataSet;
import com.klg.jclass.chart.model.DataIterator;
import com.klg.jclass.chart.model.DataMarker;
import com.klg.jclass.chart.model.DataOrder;
import com.klg.jclass.chart.model.DataPoint;
import com.klg.jclass.chart.model.DataPointException;
import com.klg.jclass.chart.model.DataSet;
import com.klg.jclass.chart.model.DataThreshold;
import com.klg.jclass.chart.model.FinancialDataPoint;
import com.klg.jclass.chart.model.HLOCStyleDataSet;
import com.klg.jclass.chart.model.HiloStyleDataSet;
import com.klg.jclass.chart.model.MarkerIterator;
import com.klg.jclass.chart.model.NumericalTimeDataSet;
import com.klg.jclass.chart.model.PieDataPoint;
import com.klg.jclass.chart.model.PieDataSet;
import com.klg.jclass.chart.model.PieStyleDataSet;
import com.klg.jclass.chart.model.PlotStyleDataSet;
import com.klg.jclass.chart.model.PolarDataPoint;
import com.klg.jclass.chart.model.PolarDataSet;
import com.klg.jclass.chart.model.PolarStyleDataSet;
import com.klg.jclass.chart.model.RadarDataPoint;
import com.klg.jclass.chart.model.RadarDataSet;
import com.klg.jclass.chart.model.RadarStyleDataSet;
import com.klg.jclass.chart.model.SeriesDataSet;
import com.klg.jclass.chart.model.SeriesDataThreshold;
import com.klg.jclass.chart.model.SimplePoint;
import com.klg.jclass.chart.model.SimplePointIterator;
import com.klg.jclass.chart.model.ThresholdIterator;
import com.klg.jclass.chart.model.TimelineDataPoint;
import com.klg.jclass.chart.model.TimelineDataSet;
import com.klg.jclass.chart.model.impl.DataPointWrapper;
import com.klg.jclass.chart.model.impl.DataPointWrapperComparator;
import com.klg.jclass.chart.model.impl.SimplePointWrapper;
import com.klg.jclass.chart.model.impl.ThresholdWrapper;
import com.klg.jclass.util.ImageMapInfo;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetConverter
implements ChartDataModel,
LabelledChartDataModel,
HoleValueChartDataModel,
ImageMapChartDataModel,
ThresholdChartDataModel,
TimelineChartDataModel,
DataLabelChartDataModel,
Serializable {
    public static final String SINGLE_SERIES_ID = "One Series";
    public static final int CHART_SERIES_PER_CANDLE_SERIES = 4;
    public static final int CHART_SERIES_PER_HLOC_SERIES = 4;
    public static final int CHART_SERIES_PER_HILO_SERIES = 2;
    public Class<?> dataTypeNumber;
    public Class<?> dataTypeDate;
    public Class<?> dataTypeObject;
    protected List<Object> seriesIdList;
    protected Hashtable<Object, List<DataPointWrapper>> seriesHash;
    protected LinkedHashSet<Object> pointIdSet;
    protected LinkedHashSet<TimeLineState> timelineStateSet;
    protected Hashtable<Object, ImageMapInfo> clusterMapHash;
    protected Class<?> xDataType;
    protected Class<?> yDataType;
    protected double[] xArray;
    protected double[][] yArray;
    protected String[][] dataLabelArray;
    protected String dataSourceName;
    protected double holeValue;
    protected int chartType;
    protected DataOrder dataOrder;
    protected Date firstXDate;
    protected Date firstYDate;
    protected JCLineStyle outlineStyle;
    protected TimeLineState clearState;
    protected Vector<double[]> xArrays;
    protected Vector<double[]> yArrays;
    protected Vector<String[]> dataLabels;
    protected Vector<String> pointLabels;
    protected Vector<String> seriesLabels;
    protected Vector<String> trackLabels;
    protected Vector<Object> clusterXValues;
    protected Vector<Point> pieExplodeList;
    protected Vector<JCChartStyle> chartStyles;
    protected Vector<JCChartStyle> candleStyles;
    protected Vector<Vector<ImageMapInfo>> pointImageMaps;
    protected Vector<ImageMapInfo> legendImageMaps;
    protected Vector<ImageMapInfo> seriesImageMaps;
    protected Hashtable<Object, List<ThresholdWrapper>> dataThresholds;
    protected Vector<ImageMapInfo> clusterImageMaps;
    protected Set<Object> otherSliceExplodes;
    protected Hashtable<Object, ImageMapInfo> otherSliceImageMapTable;
    protected Vector<ImageMapInfo> otherSliceImageMap;
    int pointCounter = 0;

    public DataSetConverter() {
        try {
            this.dataTypeNumber = Class.forName("java.lang.Number");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.dataTypeDate = Class.forName("java.util.Date");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.dataTypeObject = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void convertToDataView(DataSet dataSet, ChartDataView chartDataView, JCChart jCChart) throws DataPointException {
        if (dataSet == null || chartDataView == null || jCChart == null) {
            return;
        }
        this.initLocalStorage();
        this.retrieveDataSetProperties(dataSet);
        this.retrieveDataPoints(dataSet);
        this.processDataPoints(dataSet, jCChart);
        this.rationalizeData(dataSet);
        this.sortDataPoints(dataSet);
        this.convertDataPoints(dataSet);
        this.applyChartProperties(dataSet, chartDataView, jCChart);
        chartDataView.setDataSource(this);
        this.applyDataSetProperties(dataSet, chartDataView, jCChart);
        this.clearLocalStorage();
    }

    protected void initLocalStorage() {
        this.seriesIdList = new Vector<Object>();
        this.seriesHash = new Hashtable();
        this.pointIdSet = new LinkedHashSet();
        this.timelineStateSet = new LinkedHashSet();
        this.clusterMapHash = new Hashtable();
        this.xDataType = null;
        this.yDataType = null;
        this.xArray = null;
        this.yArray = null;
        this.dataLabelArray = null;
        this.seriesLabels = new Vector();
        this.pointLabels = new Vector();
        this.trackLabels = new Vector();
        this.dataSourceName = null;
        this.chartType = -1;
        this.holeValue = Double.MAX_VALUE;
        this.dataOrder = DataOrder.ORDER_RECEIVED;
        this.clusterXValues = new Vector();
        this.pieExplodeList = null;
        this.chartStyles = new Vector();
        this.candleStyles = new Vector();
        this.outlineStyle = null;
        this.pointImageMaps = new Vector();
        this.legendImageMaps = new Vector();
        this.seriesImageMaps = new Vector();
        this.clusterImageMaps = new Vector();
        this.dataThresholds = new Hashtable();
        this.firstXDate = null;
        this.firstYDate = null;
        this.otherSliceExplodes = new HashSet<Object>();
        this.otherSliceImageMapTable = new Hashtable();
        this.otherSliceImageMap = new Vector();
    }

    protected void retrieveDataSetProperties(DataSet dataSet) {
        Object object;
        DataOrder dataOrder;
        Number number;
        int n2;
        String string = dataSet.getName();
        if (string != null) {
            this.dataSourceName = string;
        }
        if ((n2 = dataSet.getChartType()) >= 0) {
            this.chartType = n2;
        }
        if ((number = dataSet.getHoleValue()) != null) {
            this.holeValue = number.doubleValue();
        }
        if ((dataOrder = dataSet.getDataOrder()) != null) {
            this.dataOrder = dataOrder;
        }
        if (dataSet instanceof BasicDataSet) {
            object = (BasicDataSet)dataSet;
            this.xDataType = this.validateDataType(object.getXDataType());
            this.yDataType = this.validateDataType(object.getYDataType());
        }
        if (dataSet instanceof BarDataSet) {
            object = (BarDataSet)dataSet;
            this.xDataType = this.dataTypeObject;
            this.yDataType = this.validateDataType(object.getYDataType());
        }
        if (dataSet instanceof PieDataSet) {
            this.xDataType = this.dataTypeObject;
            this.yDataType = this.dataTypeNumber;
        }
        if (dataSet instanceof PolarDataSet) {
            object = (PolarDataSet)dataSet;
            this.xDataType = this.dataTypeNumber;
            this.yDataType = this.validateDataType(object.getYDataType());
        }
        if (dataSet instanceof RadarDataSet) {
            object = (RadarDataSet)dataSet;
            this.xDataType = this.dataTypeObject;
            this.yDataType = this.validateDataType(object.getYDataType());
        }
        if (dataSet instanceof TimelineDataSet) {
            object = (TimelineDataSet)dataSet;
            this.xDataType = this.validateDataType(object.getXDataType());
            this.yDataType = this.dataTypeNumber;
        }
        if (dataSet instanceof ClusterDataSet) {
            Iterator<String> iterator;
            object = (ClusterDataSet)((Object)dataSet);
            Iterator<Object> iterator2 = object.getXValues();
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    this.clusterXValues.add(iterator2.next());
                }
            }
            if ((iterator = object.getXLabels()) != null) {
                while (iterator.hasNext()) {
                    this.pointLabels.add(iterator.next());
                }
            }
        }
    }

    public void retrieveDataPoints(DataSet dataSet) throws DataPointException {
        DataIterator dataIterator = dataSet.getDataIterator();
        if (dataIterator == null) {
            throw new DataPointException("DataIterator must not be null");
        }
        while (dataIterator.hasMoreDataPoints()) {
            DataPoint dataPoint = dataIterator.getNextDataPoint();
            try {
                dataPoint = (DataPoint)dataPoint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DataPointException(cloneNotSupportedException);
            }
            this.handleDataPoint(dataPoint, dataSet);
        }
    }

    protected void handleDataPoint(DataPoint dataPoint, DataSet dataSet) {
        Object object;
        Object object2;
        DataPoint dataPoint2;
        Object object3 = null;
        Object object4 = null;
        if (dataPoint instanceof BasicDataPoint) {
            dataPoint2 = (BasicDataPoint)dataPoint;
            if (((BasicDataPoint)dataPoint2).seriesId == null) {
                ((BasicDataPoint)dataPoint2).seriesId = SINGLE_SERIES_ID;
            }
            object3 = ((BasicDataPoint)dataPoint2).seriesId;
            object4 = ((BasicDataPoint)dataPoint2).xValue;
        } else if (dataPoint instanceof BarDataPoint) {
            dataPoint2 = (BarDataPoint)dataPoint;
            if (((BarDataPoint)dataPoint2).seriesId == null) {
                ((BarDataPoint)dataPoint2).seriesId = SINGLE_SERIES_ID;
            }
            object3 = ((BarDataPoint)dataPoint2).seriesId;
            object4 = ((BarDataPoint)dataPoint2).clusterId;
        } else if (dataPoint instanceof PieDataPoint) {
            dataPoint2 = (PieDataPoint)dataPoint;
            if (((PieDataPoint)dataPoint2).sliceId == null) {
                ((PieDataPoint)dataPoint2).sliceId = SINGLE_SERIES_ID;
            }
            object3 = ((PieDataPoint)dataPoint2).sliceId;
            object4 = ((PieDataPoint)dataPoint2).pieId;
        } else if (dataPoint instanceof FinancialDataPoint) {
            dataPoint2 = (FinancialDataPoint)dataPoint;
            if (((FinancialDataPoint)dataPoint2).seriesId == null) {
                ((FinancialDataPoint)dataPoint2).seriesId = SINGLE_SERIES_ID;
            }
            object3 = ((FinancialDataPoint)dataPoint2).seriesId;
            object4 = ((FinancialDataPoint)dataPoint2).xValue;
        } else if (dataPoint instanceof PolarDataPoint) {
            dataPoint2 = (PolarDataPoint)dataPoint;
            if (((PolarDataPoint)dataPoint2).seriesId == null) {
                ((PolarDataPoint)dataPoint2).seriesId = SINGLE_SERIES_ID;
            }
            object3 = ((PolarDataPoint)dataPoint2).seriesId;
            object4 = ((PolarDataPoint)dataPoint2).angle;
        } else if (dataPoint instanceof RadarDataPoint) {
            dataPoint2 = (RadarDataPoint)dataPoint;
            if (((RadarDataPoint)dataPoint2).seriesId == null) {
                ((RadarDataPoint)dataPoint2).seriesId = SINGLE_SERIES_ID;
            }
            object3 = ((RadarDataPoint)dataPoint2).seriesId;
            object4 = ((RadarDataPoint)dataPoint2).spokeId;
        } else if (dataPoint instanceof TimelineDataPoint) {
            dataPoint2 = (TimelineDataPoint)dataPoint;
            if (((TimelineDataPoint)dataPoint2).seriesId == null) {
                ((TimelineDataPoint)dataPoint2).seriesId = SINGLE_SERIES_ID;
            }
            object3 = ((TimelineDataPoint)dataPoint2).seriesId;
            object4 = ((TimelineDataPoint)dataPoint2).xValue;
            object2 = ((TimelineDataPoint)dataPoint2).getState();
            if (object2 == null) {
                object2 = this.getClearState();
            }
            this.timelineStateSet.add((TimeLineState)object2);
        }
        int n2 = 0;
        object2 = this.seriesHash.get(object3);
        if (object2 != null) {
            n2 = object2.size();
        }
        if (this.clusterXValues != null && n2 < this.clusterXValues.size() && (object = this.clusterXValues.get(n2)) != null) {
            object4 = object;
        }
        if (object3 != null) {
            object = new DataPointWrapper(dataPoint, object4, object3);
            if (object4 == null) {
                ((DataPointWrapper)object).xValue = this.calculateSubstituteXValue(this.xDataType, n2);
            }
            this.pointIdSet.add(((DataPointWrapper)object).xValue);
            this.storeDataPointBySeries((DataPointWrapper)object, object3);
        }
    }

    protected TimeLineState getClearState() {
        if (this.clearState == null) {
            this.clearState = new TimeLineState();
            this.clearState.setClearState(true);
            this.clearState.addDataRange(new JCDataRange(this.holeValue, this.holeValue));
            this.timelineStateSet.add(this.clearState);
        }
        return this.clearState;
    }

    protected void storeDataPointBySeries(DataPointWrapper dataPointWrapper, Object object) {
        List<DataPointWrapper> list = this.seriesHash.get(object);
        if (list == null) {
            list = new Vector<DataPointWrapper>();
            this.seriesIdList.add(object);
            this.seriesHash.put(object, list);
        }
        list.add(dataPointWrapper);
    }

    protected void processDataPoints(DataSet dataSet, JCChart jCChart) {
        Serializable serializable;
        Object object;
        Object object2;
        PlotStyleDataSet plotStyleDataSet = null;
        if (dataSet instanceof PlotStyleDataSet) {
            plotStyleDataSet = (PlotStyleDataSet)((Object)dataSet);
        }
        BarStyleDataSet barStyleDataSet = null;
        if (dataSet instanceof BarStyleDataSet) {
            barStyleDataSet = (BarStyleDataSet)((Object)dataSet);
        }
        AreaStyleDataSet areaStyleDataSet = null;
        if (dataSet instanceof AreaStyleDataSet) {
            areaStyleDataSet = (AreaStyleDataSet)((Object)dataSet);
        }
        PieStyleDataSet pieStyleDataSet = null;
        if (dataSet instanceof PieStyleDataSet) {
            pieStyleDataSet = (PieStyleDataSet)((Object)dataSet);
        }
        HiloStyleDataSet hiloStyleDataSet = null;
        if (dataSet instanceof HiloStyleDataSet) {
            hiloStyleDataSet = (HiloStyleDataSet)((Object)dataSet);
        }
        HLOCStyleDataSet hLOCStyleDataSet = null;
        if (dataSet instanceof HLOCStyleDataSet) {
            hLOCStyleDataSet = (HLOCStyleDataSet)((Object)dataSet);
        }
        CandleStyleDataSet candleStyleDataSet = null;
        if (dataSet instanceof CandleStyleDataSet) {
            candleStyleDataSet = (CandleStyleDataSet)((Object)dataSet);
        }
        PolarStyleDataSet polarStyleDataSet = null;
        if (dataSet instanceof PolarStyleDataSet) {
            polarStyleDataSet = (PolarStyleDataSet)((Object)dataSet);
        }
        RadarStyleDataSet radarStyleDataSet = null;
        if (dataSet instanceof RadarStyleDataSet) {
            radarStyleDataSet = (RadarStyleDataSet)((Object)dataSet);
        }
        AreaRadarStyleDataSet areaRadarStyleDataSet = null;
        if (dataSet instanceof AreaRadarStyleDataSet) {
            areaRadarStyleDataSet = (AreaRadarStyleDataSet)((Object)dataSet);
        }
        SeriesDataSet seriesDataSet = null;
        if (dataSet instanceof SeriesDataSet) {
            seriesDataSet = (SeriesDataSet)((Object)dataSet);
        }
        ClusterDataSet clusterDataSet = null;
        if (dataSet instanceof ClusterDataSet) {
            clusterDataSet = (ClusterDataSet)((Object)dataSet);
        }
        PieDataSet pieDataSet = null;
        if (dataSet instanceof PieDataSet) {
            pieDataSet = (PieDataSet)dataSet;
        }
        this.chartStyles.setSize(this.seriesIdList.size());
        this.candleStyles.setSize(this.seriesIdList.size() * 4);
        Iterator<Object> iterator = this.seriesIdList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object3;
            Object object4;
            Serializable serializable2;
            Object object5;
            object2 = iterator.next();
            if (seriesDataSet != null) {
                object5 = seriesDataSet.getSeriesLabel(object2);
                if (object5 != null) {
                    if (this.seriesLabels.size() <= n2) {
                        this.seriesLabels.setSize(n2 + 1);
                    }
                    this.seriesLabels.set(n2, (String)object5);
                }
                if ((object = seriesDataSet.getTrackLabel(object2)) != null) {
                    if (this.trackLabels.size() <= n2) {
                        this.trackLabels.setSize(n2 + 1);
                    }
                    this.trackLabels.set(n2, (String)object);
                }
                if ((serializable = seriesDataSet.getSeriesImageMap(object2)) != null) {
                    serializable2 = new ImageMapInfo(((ImageMapInfo)serializable).getUrl(), ((ImageMapInfo)serializable).getExtra());
                    if (n2 >= this.seriesImageMaps.size()) {
                        this.seriesImageMaps.setSize(n2 + 1);
                    }
                    this.seriesImageMaps.set(n2, (ImageMapInfo)serializable2);
                }
                if ((serializable2 = seriesDataSet.getLegendImageMap(object2)) != null) {
                    object4 = new ImageMapInfo(((ImageMapInfo)serializable2).getUrl(), ((ImageMapInfo)serializable2).getExtra());
                    if (n2 >= this.legendImageMaps.size()) {
                        this.legendImageMaps.setSize(n2 + 1);
                    }
                    this.legendImageMaps.set(n2, (ImageMapInfo)object4);
                }
                if ((object4 = seriesDataSet.getDataThresholds(object2)) != null && (object3 = this.processDataThresholds((ThresholdIterator)object4, object2)) != null) {
                    this.dataThresholds.put(object2, (List<ThresholdWrapper>)object3);
                }
            }
            object5 = null;
            object = null;
            serializable = null;
            serializable2 = null;
            if (plotStyleDataSet != null || polarStyleDataSet != null || radarStyleDataSet != null) {
                if (plotStyleDataSet != null) {
                    object5 = plotStyleDataSet.getLineStyle(object2);
                } else if (polarStyleDataSet != null) {
                    object5 = polarStyleDataSet.getLineStyle(object2);
                } else if (radarStyleDataSet != null) {
                    object5 = radarStyleDataSet.getLineStyle(object2);
                }
                if (plotStyleDataSet != null) {
                    serializable = plotStyleDataSet.getSymbolStyle(object2);
                } else if (polarStyleDataSet != null) {
                    serializable = polarStyleDataSet.getSymbolStyle(object2);
                } else if (radarStyleDataSet != null) {
                    serializable = radarStyleDataSet.getSymbolStyle(object2);
                }
            }
            if (barStyleDataSet != null || areaStyleDataSet != null || pieStyleDataSet != null || areaRadarStyleDataSet != null) {
                if (barStyleDataSet != null) {
                    object = barStyleDataSet.getFillStyle(object2);
                } else if (areaStyleDataSet != null) {
                    object = areaStyleDataSet.getFillStyle(object2);
                } else if (pieStyleDataSet != null) {
                    object = pieStyleDataSet.getFillStyle(object2);
                } else if (areaRadarStyleDataSet != null) {
                    object = areaRadarStyleDataSet.getFillStyle(object2);
                }
            }
            if (candleStyleDataSet != null && this.chartType == 7) {
                object4 = candleStyleDataSet.getHiloStyle(object2);
                object3 = candleStyleDataSet.getRisingCandleStyle(object2);
                JCChartStyle jCChartStyle = candleStyleDataSet.getFallingCandleStyle(object2);
                JCChartStyle jCChartStyle2 = candleStyleDataSet.getCandleOutlineStyle(object2);
                this.candleStyles.set(n2 * 4, (JCChartStyle)object4);
                this.candleStyles.set(n2 * 4 + 1, (JCChartStyle)object3);
                this.candleStyles.set(n2 * 4 + 2, jCChartStyle);
                this.candleStyles.set(n2 * 4 + 3, jCChartStyle2);
            } else if (hiloStyleDataSet != null && this.chartType == 5) {
                object5 = hiloStyleDataSet.getLineStyle(object2);
            } else if (hLOCStyleDataSet != null && this.chartType == 6) {
                object5 = hLOCStyleDataSet.getLineStyle(object2);
                serializable2 = hLOCStyleDataSet.getTickSize(object2);
            }
            object4 = null;
            if (object5 != null || object != null || serializable != null || serializable2 != null) {
                object4 = new JCChartStyle();
                if (object5 != null) {
                    ((JCChartStyle)object4).setLineStyle((JCLineStyle)object5);
                }
                if (object != null) {
                    ((JCChartStyle)object4).setFillStyle((JCFillStyle)object);
                }
                if (serializable != null) {
                    ((JCChartStyle)object4).setSymbolStyle((JCSymbolStyle)serializable);
                }
                if (serializable2 != null) {
                    ((JCChartStyle)object4).setSymbolSize((Integer)serializable2);
                }
            }
            this.chartStyles.set(n2, (JCChartStyle)object4);
            ++n2;
        }
        if (barStyleDataSet != null) {
            object2 = barStyleDataSet.getOutlineStyle();
            if (object2 != null) {
                this.outlineStyle = object2;
            }
        } else if (areaStyleDataSet != null) {
            object2 = areaStyleDataSet.getOutlineStyle();
            if (object2 != null) {
                this.outlineStyle = object2;
            }
        } else if (pieStyleDataSet != null) {
            object2 = pieStyleDataSet.getOutlineStyle();
            if (object2 != null) {
                this.outlineStyle = object2;
            }
        } else if (areaRadarStyleDataSet != null && (object2 = areaRadarStyleDataSet.getOutlineStyle()) != null) {
            this.outlineStyle = object2;
        }
        if (clusterDataSet != null) {
            for (Object object5 : this.pointIdSet) {
                object = clusterDataSet.getClusterImageMap(object5);
                if (object == null) continue;
                serializable = new ImageMapInfo(((ImageMapInfo)object).getUrl(), ((ImageMapInfo)object).getExtra());
                this.clusterMapHash.put(object5, (ImageMapInfo)serializable);
            }
        }
        if (pieDataSet != null) {
            for (Object object5 : this.pointIdSet) {
                if (pieDataSet.getOtherSliceExploded(object5)) {
                    this.otherSliceExplodes.add(object5);
                }
                if ((object = pieDataSet.getOtherSliceImageMap(object5)) == null) continue;
                serializable = new ImageMapInfo(((ImageMapInfo)object).getUrl(), ((ImageMapInfo)object).getExtra());
                this.otherSliceImageMapTable.put(object5, (ImageMapInfo)serializable);
            }
        }
    }

    protected List<ThresholdWrapper> processDataThresholds(ThresholdIterator thresholdIterator, Object object) {
        if (thresholdIterator == null) {
            return null;
        }
        ArrayList<ThresholdWrapper> arrayList = new ArrayList<ThresholdWrapper>();
        while (thresholdIterator.hasMoreThresholds()) {
            AbstractThreshold abstractThreshold = thresholdIterator.getNextThreshold();
            if (!(abstractThreshold instanceof SeriesDataThreshold)) continue;
            SeriesDataThreshold seriesDataThreshold = (SeriesDataThreshold)abstractThreshold;
            JCDataThreshold jCDataThreshold = new JCDataThreshold(null, seriesDataThreshold.getLabel(), seriesDataThreshold.getChartStyle(), seriesDataThreshold.isIncludedInDataBounds(), seriesDataThreshold.isDrawnInLegend());
            jCDataThreshold.setLegendImageMapInfo(seriesDataThreshold.getLegendImageMapInfo());
            ThresholdWrapper thresholdWrapper = new ThresholdWrapper(jCDataThreshold, this.getSimplePointList(seriesDataThreshold.getValues(), object), object);
            arrayList.add(thresholdWrapper);
        }
        return arrayList;
    }

    protected List<SimplePointWrapper> getSimplePointList(SimplePointIterator simplePointIterator, Object object) {
        if (simplePointIterator == null) {
            return null;
        }
        int n2 = 0;
        ArrayList<SimplePointWrapper> arrayList = new ArrayList<SimplePointWrapper>();
        while (simplePointIterator.hasMorePoints()) {
            SimplePoint simplePoint = simplePointIterator.getNextPoint();
            if (simplePoint == null) continue;
            SimplePointWrapper simplePointWrapper = new SimplePointWrapper(simplePoint.getX(), simplePoint.getY(), object);
            if (simplePointWrapper.xValue == null || !this.pointIdSet.contains(simplePointWrapper.xValue)) {
                simplePointWrapper.xValue = this.calculateSubstituteXValue(this.xDataType, n2);
            }
            arrayList.add(simplePointWrapper);
            ++n2;
        }
        return arrayList;
    }

    public void rationalizeData(DataSet dataSet) {
        List<SimplePointWrapper> list;
        Object object;
        Object object22;
        List<Serializable> i2;
        Serializable serializable;
        List<Object> list2;
        Object[] objectArray;
        int n2 = dataSet.getChartType();
        if (n2 != 9 && n2 != 10 && n2 != 11 && n2 != 12 && n2 != 3 && n2 != 4) {
            return;
        }
        for (Object iterator2 : this.seriesIdList) {
            Object object3;
            List<DataPointWrapper> n3 = this.seriesHash.get(iterator2);
            if (n3 == null) continue;
            objectArray = new Hashtable();
            Iterator<Object> iterator = n3.iterator();
            while (iterator.hasNext()) {
                object3 = (DataPointWrapper)iterator.next();
                if (objectArray.get(((DataPointWrapper)object3).xValue) == null) {
                    objectArray.put(((DataPointWrapper)object3).xValue, ((DataPointWrapper)object3).xValue);
                    continue;
                }
                iterator.remove();
            }
            object3 = this.dataThresholds.get(iterator2);
            if (object3 == null) continue;
            list2 = object3.iterator();
            while (list2.hasNext()) {
                serializable = (ThresholdWrapper)list2.next();
                i2 = ((ThresholdWrapper)serializable).simplePointList;
                if (i2 == null) continue;
                object22 = new Hashtable();
                object = i2.iterator();
                while (object.hasNext()) {
                    list = (SimplePointWrapper)object.next();
                    if (((Hashtable)object22).get(((SimplePointWrapper)((Object)list)).xValue) == null) {
                        ((Hashtable)object22).put(((SimplePointWrapper)((Object)list)).xValue, ((SimplePointWrapper)((Object)list)).xValue);
                        continue;
                    }
                    object.remove();
                }
            }
        }
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.pointIdSet.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            objectArray = iterator.next();
            hashtable.put(objectArray, new Integer(n3));
            ++n3;
        }
        objectArray = this.pointIdSet.toArray();
        for (Object object3 : this.seriesIdList) {
            list2 = this.seriesHash.get(object3);
            if (list2 == null) {
                list2 = new Vector();
            }
            serializable = new Vector();
            ((Vector)serializable).setSize(this.pointIdSet.size());
            for (Object object22 : list2) {
                object = (Integer)hashtable.get(((DataPointWrapper)object22).xValue);
                if (object == null) continue;
                ((Vector)serializable).set((Integer)object, object22);
            }
            for (int i3 = 0; i3 < ((Vector)serializable).size(); ++i3) {
                object22 = (DataPointWrapper)((Vector)serializable).get(i3);
                if (object22 != null) continue;
                ((Vector)serializable).set(i3, new DataPointWrapper(null, objectArray[i3], object3));
            }
            this.seriesHash.put(object3, (List<DataPointWrapper>)((Object)serializable));
            i2 = this.dataThresholds.get(object3);
            if (i2 == null) continue;
            object22 = i2.iterator();
            while (object22.hasNext()) {
                object = (ThresholdWrapper)object22.next();
                list = ((ThresholdWrapper)object).simplePointList;
                if (list == null) continue;
                Vector<SimplePointWrapper> vector = new Vector<SimplePointWrapper>();
                vector.setSize(this.pointIdSet.size());
                for (SimplePointWrapper simplePointWrapper : list) {
                    Integer n4 = (Integer)hashtable.get(simplePointWrapper.xValue);
                    if (n4 == null) continue;
                    vector.set(n4, simplePointWrapper);
                }
                boolean bl = false;
                int simplePointWrapper = 0;
                for (int n4 = vector.size() - 1; n4 >= 0; --n4) {
                    SimplePointWrapper simplePointWrapper2 = (SimplePointWrapper)vector.get(n4);
                    if (!bl && simplePointWrapper2 == null) continue;
                    if (!bl) {
                        simplePointWrapper = n4 + 1;
                    }
                    bl = true;
                    if (simplePointWrapper2 != null) continue;
                    vector.set(n4, new SimplePointWrapper(objectArray[n4], null, object3));
                }
                vector.setSize(simplePointWrapper);
                ((ThresholdWrapper)object).simplePointList = vector;
            }
        }
    }

    protected void sortDataPoints(DataSet dataSet) {
        if (this.dataOrder != DataOrder.ORDER_RECEIVED) {
            for (Object object : this.seriesIdList) {
                List<ThresholdWrapper> list;
                List<DataPointWrapper> list2 = this.seriesHash.get(object);
                if (list2 == null) continue;
                if (this.dataOrder == DataOrder.ASCENDING) {
                    Collections.sort(list2, DataPointWrapperComparator.ASCENDING);
                }
                if ((list = this.dataThresholds.get(object)) == null) continue;
                for (ThresholdWrapper thresholdWrapper : list) {
                    List<SimplePointWrapper> list3 = thresholdWrapper.simplePointList;
                    if (list3 == null || this.dataOrder != DataOrder.ASCENDING) continue;
                    Collections.sort(list3, DataPointWrapperComparator.ASCENDING);
                }
            }
        }
    }

    protected void convertDataPoints(DataSet dataSet) {
        this.preSeriesConversion(dataSet);
        Iterator<Object> iterator = this.seriesIdList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object;
            Object object2 = iterator.next();
            List<DataPointWrapper> list = this.seriesHash.get(object2);
            if (list == null) continue;
            this.prePointConversion(dataSet, list, n2);
            Iterator<DataPointWrapper> iterator2 = list.iterator();
            int n3 = 0;
            while (iterator2.hasNext()) {
                object = iterator2.next();
                this.convertSeriesPoint(dataSet, (DataPointWrapper)object, n2, n3);
                ++n3;
            }
            this.postPointConversion(dataSet, list, n2);
            object = this.dataThresholds.get(object2);
            if (object != null) {
                Iterator iterator3 = object.iterator();
                while (iterator3.hasNext()) {
                    ThresholdWrapper thresholdWrapper = (ThresholdWrapper)iterator3.next();
                    List<SimplePointWrapper> list2 = thresholdWrapper.simplePointList;
                    if (list2 == null) continue;
                    int n4 = list2.size();
                    double[] dArray = new double[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        SimplePointWrapper simplePointWrapper = list2.get(i2);
                        double d2 = this.holeValue;
                        if (simplePointWrapper != null) {
                            Double d3 = this.convertAxisValue(simplePointWrapper.yValue, false);
                            d2 = d3 == null ? this.holeValue : d3;
                        }
                        dArray[i2] = d2;
                    }
                    if (thresholdWrapper.dataThreshold == null) continue;
                    thresholdWrapper.dataThreshold.setYValues(dArray);
                }
            }
            ++n2;
        }
        this.postSeriesConversion(dataSet);
    }

    protected void preSeriesConversion(DataSet dataSet) {
        this.xArrays = new Vector();
        this.yArrays = new Vector();
        this.dataLabels = new Vector();
        this.pieExplodeList = new Vector();
    }

    protected void prePointConversion(DataSet dataSet, List<DataPointWrapper> list, int n2) {
        this.xArray = new double[list.size()];
        int n3 = this.chartType == 5 ? 2 : (this.chartType == 6 ? 4 : (this.chartType == 7 ? 4 : 1));
        this.yArray = new double[n3][list.size()];
        this.dataLabelArray = new String[n3][list.size()];
    }

    protected void convertSeriesPoint(DataSet dataSet, DataPointWrapper dataPointWrapper, int n2, int n3) {
        Serializable serializable;
        Cloneable cloneable;
        Class<?> clazz = this.xDataType;
        Object object = dataPointWrapper.xValue;
        if (this.xDataType == this.dataTypeNumber && !(object instanceof Number)) {
            clazz = this.dataTypeObject;
        }
        if (clazz == this.dataTypeObject) {
            this.xArray[n3] = n3;
        } else if (clazz == this.dataTypeNumber) {
            this.xArray[n3] = ((Number)object).doubleValue();
        } else if (clazz == this.dataTypeDate) {
            if (!(dataPointWrapper.xValue instanceof Date)) {
                if (this.firstXDate != null) {
                    cloneable = new GregorianCalendar();
                    ((Calendar)cloneable).setTime(this.firstXDate);
                    ((GregorianCalendar)cloneable).add(5, n3);
                    object = ((Calendar)cloneable).getTime();
                } else {
                    object = new Date();
                }
            }
            if (this.firstXDate == null || this.firstXDate.after((Date)object)) {
                this.firstXDate = (Date)object;
            }
            this.xArray[n3] = this.convertDateToNumericalData((Date)object, this.firstXDate);
        }
        cloneable = dataPointWrapper.dataPoint;
        if (cloneable == null) {
            this.storeYValue(0, n3, this.yDataType, new Double(this.holeValue));
            return;
        }
        if (cloneable instanceof BasicDataPoint) {
            serializable = (BasicDataPoint)cloneable;
            this.storeYValue(0, n3, this.yDataType, serializable.yValue);
            this.storeDataLabel(0, n3, serializable.dataLabel);
            this.storePointLabel(n3, serializable.xLabel);
            this.storeSeriesLabel(n2, n3, serializable.seriesLabel);
            this.storePointImageMap(n2, n3, serializable.imageMapURL, serializable.imageMapExtra);
            this.storeLegendImageMap(n2, serializable.legendImageMapURL, serializable.legendImageMapExtra);
        } else if (cloneable instanceof BarDataPoint) {
            serializable = (BarDataPoint)cloneable;
            this.storeYValue(0, n3, this.yDataType, ((BarDataPoint)serializable).yValue);
            this.storeDataLabel(0, n3, ((BarDataPoint)serializable).dataLabel);
            this.storePointLabel(n3, ((BarDataPoint)serializable).clusterLabel);
            this.storeSeriesLabel(n2, n3, ((BarDataPoint)serializable).seriesLabel);
            this.storePointImageMap(n2, n3, ((BarDataPoint)serializable).imageMapURL, ((BarDataPoint)serializable).imageMapExtra);
            this.storeLegendImageMap(n2, ((BarDataPoint)serializable).legendImageMapURL, ((BarDataPoint)serializable).legendImageMapExtra);
        } else if (cloneable instanceof PieDataPoint) {
            ImageMapInfo imageMapInfo;
            serializable = (PieDataPoint)cloneable;
            this.storeYValue(0, n3, this.yDataType, ((PieDataPoint)serializable).sliceValue);
            this.storeDataLabel(0, n3, ((PieDataPoint)serializable).dataLabel);
            this.storePointLabel(n3, ((PieDataPoint)serializable).pieLabel);
            this.storeSeriesLabel(n2, n3, ((PieDataPoint)serializable).sliceLabel);
            this.storePointImageMap(n2, n3, ((PieDataPoint)serializable).imageMapURL, ((PieDataPoint)serializable).imageMapExtra);
            this.storeLegendImageMap(n2, ((PieDataPoint)serializable).legendImageMapURL, ((PieDataPoint)serializable).legendImageMapExtra);
            if (((PieDataPoint)serializable).explode) {
                this.pieExplodeList.add(new Point(n3, n2));
            }
            if (this.otherSliceExplodes.contains(((PieDataPoint)serializable).pieId)) {
                this.pieExplodeList.add(new Point(n3, -10));
                this.otherSliceExplodes.remove(((PieDataPoint)serializable).pieId);
            }
            if ((imageMapInfo = this.otherSliceImageMapTable.get(((PieDataPoint)serializable).pieId)) != null) {
                if (this.otherSliceImageMap.size() <= n3) {
                    this.otherSliceImageMap.setSize(this.pointIdSet.size());
                }
                if (this.otherSliceImageMap.get(n3) == null) {
                    this.otherSliceImageMap.set(n3, imageMapInfo);
                }
            }
        } else if (cloneable instanceof FinancialDataPoint) {
            serializable = (FinancialDataPoint)cloneable;
            this.storeYValue(0, n3, this.yDataType, ((FinancialDataPoint)serializable).highValue);
            this.storeDataLabel(0, n3, ((FinancialDataPoint)serializable).highDataLabel);
            this.storeYValue(1, n3, this.yDataType, ((FinancialDataPoint)serializable).lowValue);
            this.storeDataLabel(1, n3, ((FinancialDataPoint)serializable).lowDataLabel);
            if (this.chartType == 6 || this.chartType == 7) {
                this.storeYValue(2, n3, this.yDataType, ((FinancialDataPoint)serializable).openValue);
                this.storeDataLabel(2, n3, ((FinancialDataPoint)serializable).openDataLabel);
                this.storeYValue(3, n3, this.yDataType, ((FinancialDataPoint)serializable).closeValue);
                this.storeDataLabel(3, n3, ((FinancialDataPoint)serializable).closeDataLabel);
            }
            this.storePointLabel(n3, ((FinancialDataPoint)serializable).xLabel);
            this.storeSeriesLabel(n2, n3, ((FinancialDataPoint)serializable).seriesLabel);
            this.storePointImageMap(n2, n3, ((FinancialDataPoint)serializable).imageMapURL, ((FinancialDataPoint)serializable).imageMapExtra);
            this.storeLegendImageMap(n2, ((FinancialDataPoint)serializable).legendImageMapURL, ((FinancialDataPoint)serializable).legendImageMapExtra);
        } else if (cloneable instanceof PolarDataPoint) {
            serializable = (PolarDataPoint)cloneable;
            this.storeYValue(0, n3, this.yDataType, ((PolarDataPoint)serializable).yValue);
            this.storeDataLabel(0, n3, ((PolarDataPoint)serializable).dataLabel);
            this.storePointLabel(n3, ((PolarDataPoint)serializable).angleLabel);
            this.storeSeriesLabel(n2, n3, ((PolarDataPoint)serializable).seriesLabel);
            this.storePointImageMap(n2, n3, ((PolarDataPoint)serializable).imageMapURL, ((PolarDataPoint)serializable).imageMapExtra);
            this.storeLegendImageMap(n2, ((PolarDataPoint)serializable).legendImageMapURL, ((PolarDataPoint)serializable).legendImageMapExtra);
        } else if (cloneable instanceof RadarDataPoint) {
            serializable = (RadarDataPoint)cloneable;
            this.storeYValue(0, n3, this.yDataType, ((RadarDataPoint)serializable).yValue);
            this.storeDataLabel(0, n3, ((RadarDataPoint)serializable).dataLabel);
            this.storePointLabel(n3, ((RadarDataPoint)serializable).spokeLabel);
            this.storeSeriesLabel(n2, n3, ((RadarDataPoint)serializable).seriesLabel);
            this.storePointImageMap(n2, n3, ((RadarDataPoint)serializable).imageMapURL, ((RadarDataPoint)serializable).imageMapExtra);
            this.storeLegendImageMap(n2, ((RadarDataPoint)serializable).legendImageMapURL, ((RadarDataPoint)serializable).legendImageMapExtra);
        } else if (cloneable instanceof TimelineDataPoint) {
            serializable = (TimelineDataPoint)cloneable;
            TimeLineState timeLineState = ((TimelineDataPoint)serializable).getState();
            if (timeLineState == null) {
                timeLineState = this.getClearState();
            }
            this.storeYValue(0, n3, this.yDataType, new Double(timeLineState.getDataValue()));
            this.storeDataLabel(0, n3, ((TimelineDataPoint)serializable).dataLabel);
            this.storeSeriesLabel(n2, n3, ((TimelineDataPoint)serializable).seriesLabel);
            this.storeTrackLabel(n2, n3, ((TimelineDataPoint)serializable).trackLabel);
            this.storePointImageMap(n2, n3, ((TimelineDataPoint)serializable).imageMapURL, ((TimelineDataPoint)serializable).imageMapExtra);
            this.storeLegendImageMap(n2, ((TimelineDataPoint)serializable).legendImageMapURL, ((TimelineDataPoint)serializable).legendImageMapExtra);
        }
        serializable = this.clusterMapHash.get(dataPointWrapper.xValue);
        if (serializable != null) {
            if (n3 >= this.clusterImageMaps.size()) {
                this.clusterImageMaps.setSize(n3 + 1);
            }
            this.clusterImageMaps.set(n3, (ImageMapInfo)serializable);
        }
    }

    protected void postPointConversion(DataSet dataSet, List<DataPointWrapper> list, int n2) {
        for (int i2 = 0; i2 < this.yArray.length; ++i2) {
            this.xArrays.add(this.xArray);
            this.yArrays.add(this.yArray[i2]);
            this.dataLabels.add(this.dataLabelArray[i2]);
        }
    }

    protected void postSeriesConversion(DataSet dataSet) {
    }

    protected void applyChartProperties(DataSet dataSet, ChartDataView chartDataView, JCChart jCChart) {
        String string;
        String string2;
        DataSet dataSet2;
        if (dataSet == null || chartDataView == null || jCChart == null) {
            return;
        }
        if (dataSet instanceof BasicDataSet) {
            dataSet2 = (BasicDataSet)dataSet;
            string2 = dataSet2.getXAxisName();
            string = dataSet2.getYAxisName();
            this.applyAxisToDataView(string2, true, jCChart, chartDataView);
            this.applyAxisToDataView(string, false, jCChart, chartDataView);
            this.applyMarkers(chartDataView, dataSet2.getXMarkerIterator(), true);
            this.applyMarkers(chartDataView, dataSet2.getYMarkerIterator(), false);
            this.applyThresholds(chartDataView, dataSet2.getXThresholdIterator(), true);
            this.applyThresholds(chartDataView, dataSet2.getYThresholdIterator(), false);
        }
        if (dataSet instanceof BarDataSet) {
            dataSet2 = (BarDataSet)dataSet;
            string2 = dataSet2.getXAxisName();
            string = dataSet2.getYAxisName();
            this.applyAxisToDataView(string2, true, jCChart, chartDataView);
            this.applyAxisToDataView(string, false, jCChart, chartDataView);
            this.applyMarkers(chartDataView, dataSet2.getClusterMarkerIterator(), true);
            this.applyMarkers(chartDataView, dataSet2.getYMarkerIterator(), false);
            this.applyThresholds(chartDataView, dataSet2.getYThresholdIterator(), false);
        }
        if (dataSet instanceof PieDataSet) {
            int n2;
            ImageMapInfo imageMapInfo;
            dataSet2 = (PieDataSet)dataSet;
            JCPieChartFormat jCPieChartFormat = (JCPieChartFormat)chartDataView.getChartFormat(11);
            String string3 = dataSet2.getOtherSliceLabel();
            if (string3 != null) {
                jCPieChartFormat.setOtherLabel(string3);
            }
            if ((imageMapInfo = dataSet2.getOtherSliceLegendImageMap()) != null) {
                ImageMapInfo imageMapInfo2 = new ImageMapInfo(imageMapInfo.getUrl(), imageMapInfo.getExtra());
                jCPieChartFormat.setOtherLegendImageMapInfo(imageMapInfo2);
            }
            if (this.otherSliceImageMap != null && (n2 = this.otherSliceImageMap.size()) > 0) {
                ImageMapInfo[] imageMapInfoArray = this.otherSliceImageMap.toArray(new ImageMapInfo[n2]);
                jCPieChartFormat.setOtherImageMapInfo(imageMapInfoArray);
            }
            if (this.pieExplodeList != null) {
                jCPieChartFormat.setExplodeList(this.pieExplodeList.toArray(new Point[this.pieExplodeList.size()]));
            }
        }
        if (dataSet instanceof PolarDataSet) {
            dataSet2 = (PolarDataSet)dataSet;
            string2 = dataSet2.getThetaAxisName();
            string = dataSet2.getYAxisName();
            this.applyAxisToDataView(string2, true, jCChart, chartDataView);
            this.applyAxisToDataView(string, false, jCChart, chartDataView);
            int n3 = dataSet2.getAngleUnit();
            jCChart.getChartArea().setAngleUnit(n3);
            this.applyMarkers(chartDataView, dataSet2.getThetaMarkerIterator(), true);
            this.applyMarkers(chartDataView, dataSet2.getYMarkerIterator(), false);
            this.applyThresholds(chartDataView, dataSet2.getThetaThresholdIterator(), true);
            this.applyThresholds(chartDataView, dataSet2.getYThresholdIterator(), false);
        }
        if (dataSet instanceof RadarDataSet) {
            dataSet2 = (RadarDataSet)dataSet;
            string = dataSet2.getYAxisName();
            this.applyAxisToDataView(string, false, jCChart, chartDataView);
            this.applyMarkers(chartDataView, dataSet2.getYMarkerIterator(), false);
            this.applyThresholds(chartDataView, dataSet2.getYThresholdIterator(), false);
        }
        if (dataSet instanceof TimelineDataSet) {
            dataSet2 = (TimelineDataSet)dataSet;
            string2 = dataSet2.getXAxisName();
            string = dataSet2.getYAxisName();
            this.applyAxisToDataView(string2, true, jCChart, chartDataView);
            this.applyAxisToDataView(string, false, jCChart, chartDataView);
            this.applyMarkers(chartDataView, dataSet2.getXMarkerIterator(), true);
            this.applyMarkers(chartDataView, dataSet2.getYMarkerIterator(), false);
            this.applyThresholds(chartDataView, dataSet2.getXThresholdIterator(), true);
            this.applyThresholds(chartDataView, dataSet2.getYThresholdIterator(), false);
        }
        if (this.chartType >= 0) {
            chartDataView.setChartType(this.chartType);
        } else {
            this.chartType = chartDataView.getChartType();
        }
    }

    protected void applyDataSetProperties(DataSet dataSet, ChartDataView chartDataView, JCChart jCChart) {
        int n2;
        Cloneable cloneable;
        JCAxis jCAxis = chartDataView.getXAxis();
        JCAxis jCAxis2 = chartDataView.getYAxis();
        if (this.pointLabels != null && this.pointLabels.size() > 0) {
            jCAxis.setAnnotationMethod(3);
        }
        if (this.xDataType == this.dataTypeDate) {
            jCAxis.setTimeBase(this.firstXDate);
            jCAxis.setTimeUnit(1000L);
            jCAxis.setAnnotationMethod(2);
        }
        if (this.yDataType == this.dataTypeDate) {
            jCAxis2.setTimeBase(this.firstYDate);
            jCAxis2.setTimeUnit(1000L);
            jCAxis2.setAnnotationMethod(2);
        }
        if (dataSet instanceof NumericalTimeDataSet) {
            long l2;
            boolean bl;
            NumericalTimeDataSet numericalTimeDataSet = (NumericalTimeDataSet)((Object)dataSet);
            boolean bl2 = numericalTimeDataSet.isXNumericalTimeData() && this.xDataType == this.dataTypeNumber;
            boolean bl3 = bl = numericalTimeDataSet.isYNumericalTimeData() && this.yDataType == this.dataTypeNumber;
            if (bl2) {
                cloneable = numericalTimeDataSet.getXTimeBase();
                if (cloneable == null) {
                    cloneable = new Date();
                }
                jCAxis.setTimeBase((Date)cloneable);
                l2 = numericalTimeDataSet.getXTimeUnit();
                if (l2 >= 0L) {
                    jCAxis.setTimeUnit(l2);
                }
                jCAxis.setAnnotationMethod(2);
            }
            if (bl) {
                cloneable = numericalTimeDataSet.getYTimeBase();
                if (cloneable == null) {
                    cloneable = new Date();
                }
                jCAxis2.setTimeBase((Date)cloneable);
                l2 = numericalTimeDataSet.getYTimeUnit();
                if (l2 >= 0L) {
                    jCAxis2.setTimeUnit(l2);
                }
                jCAxis2.setAnnotationMethod(2);
            }
        }
        if (this.chartType == 5) {
            for (n2 = 0; n2 < this.chartStyles.size(); ++n2) {
                JCChartStyle jCChartStyle = this.chartStyles.get(n2);
                if (jCChartStyle == null) continue;
                chartDataView.setChartStyle(n2 * 2, jCChartStyle);
            }
        } else if (this.chartType == 6) {
            for (n2 = 0; n2 < this.chartStyles.size(); ++n2) {
                JCChartStyle jCChartStyle = this.chartStyles.get(n2);
                if (jCChartStyle == null) continue;
                chartDataView.setChartStyle(n2 * 4, jCChartStyle);
            }
        } else if (this.chartType == 7) {
            for (n2 = 0; n2 < this.candleStyles.size(); ++n2) {
                JCChartStyle jCChartStyle = this.candleStyles.get(n2);
                if (jCChartStyle == null) continue;
                chartDataView.setChartStyle(n2, jCChartStyle);
            }
        } else {
            for (n2 = 0; n2 < this.chartStyles.size(); ++n2) {
                JCChartStyle jCChartStyle = this.chartStyles.get(n2);
                if (jCChartStyle == null) continue;
                chartDataView.setChartStyle(n2, jCChartStyle);
            }
        }
        if (dataSet instanceof PieStyleDataSet) {
            PieStyleDataSet pieStyleDataSet = (PieStyleDataSet)((Object)dataSet);
            JCPieChartFormat jCPieChartFormat = (JCPieChartFormat)chartDataView.getChartFormat(11);
            JCFillStyle jCFillStyle = pieStyleDataSet.getOtherSliceFillStyle();
            if (jCFillStyle != null) {
                cloneable = JCChartStyle.makeDefault(jCChart);
                ((JCChartStyle)cloneable).setFillStyle(jCFillStyle);
                jCPieChartFormat.setOtherStyle((JCChartStyle)cloneable);
            }
        }
        if (this.outlineStyle != null) {
            chartDataView.setOutlineStyle(this.outlineStyle);
        }
        ImageMapInfo imageMapInfo = null;
        ImageMapInfo imageMapInfo2 = dataSet.getLegendImageMap();
        if (imageMapInfo2 != null) {
            imageMapInfo = new ImageMapInfo(imageMapInfo2.getUrl(), imageMapInfo2.getExtra());
        }
        chartDataView.setImageMapInfo(imageMapInfo);
    }

    protected void applyMarkers(ChartDataView chartDataView, MarkerIterator markerIterator, boolean bl) {
        if (chartDataView == null || markerIterator == null) {
            return;
        }
        while (markerIterator.hasMoreMarkers()) {
            DataMarker dataMarker = markerIterator.getNextMarker();
            if (dataMarker == null) continue;
            Double d2 = this.convertAxisValue(dataMarker.value, bl);
            Double d3 = this.convertAxisValue(dataMarker.startPoint, !bl);
            Double d4 = this.convertAxisValue(dataMarker.endPoint, !bl);
            if (d2 == null) continue;
            if (d3 == null) {
                d3 = new Double(-1.7976931348623157E308);
            }
            if (d4 == null) {
                d4 = new Double(Double.MAX_VALUE);
            }
            JCMarker jCMarker = new JCMarker(dataMarker.label, d2, dataMarker.lineStyle, d3, d4, !bl, dataMarker.visibleInLegend, dataMarker.drawnBeforeData, null);
            jCMarker.setIncludedInDataBounds(dataMarker.isIncludedInDataBounds());
            jCMarker.setLegendImageMapInfo(dataMarker.getLegendImageMapInfo());
            chartDataView.addMarker(jCMarker);
        }
    }

    protected void applyThresholds(ChartDataView chartDataView, ThresholdIterator thresholdIterator, boolean bl) {
        if (chartDataView == null || thresholdIterator == null) {
            return;
        }
        while (thresholdIterator.hasMoreThresholds()) {
            AbstractThreshold abstractThreshold = thresholdIterator.getNextThreshold();
            if (!(abstractThreshold instanceof DataThreshold)) continue;
            DataThreshold dataThreshold = (DataThreshold)abstractThreshold;
            Double d2 = this.convertAxisValue(dataThreshold.startValue, bl);
            Double d3 = this.convertAxisValue(dataThreshold.endValue, bl);
            if (d2 == null) {
                d2 = new Double(-1.7976931348623157E308);
            }
            if (d3 == null) {
                d3 = new Double(Double.MAX_VALUE);
            }
            JCThreshold jCThreshold = new JCThreshold(dataThreshold.label, d2, d3, !bl, dataThreshold.getFillStyle(), dataThreshold.startLineStyle, dataThreshold.endLineStyle, dataThreshold.drawnInLegend);
            jCThreshold.setIncludedInDataBounds(dataThreshold.isIncludedInDataBounds());
            jCThreshold.setLegendImageMapInfo(dataThreshold.getLegendImageMapInfo());
            jCThreshold.setStartValues(this.convertPoints(dataThreshold.getStartValues()));
            jCThreshold.setEndValues(this.convertPoints(dataThreshold.getEndValues()));
            jCThreshold.setLimitType(dataThreshold.getLimitType());
            chartDataView.addThreshold(jCThreshold);
        }
    }

    protected Point2D.Double[] convertPoints(SimplePointIterator simplePointIterator) {
        Point2D.Double[] doubleArray;
        if (simplePointIterator == null) {
            return null;
        }
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        while (simplePointIterator.hasMorePoints()) {
            doubleArray = simplePointIterator.getNextPoint();
            if (doubleArray == null) continue;
            Double d2 = this.convertAxisValue(doubleArray.getX(), true);
            Double d3 = this.convertAxisValue(doubleArray.getY(), false);
            if (d2 == null || d3 == null) continue;
            arrayList.add(new Point2D.Double(d2, d3));
        }
        doubleArray = new Point2D.Double[arrayList.size()];
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            doubleArray[i2] = (Point2D.Double)arrayList.get(i2);
        }
        return doubleArray;
    }

    protected Double convertAxisValue(Object object, boolean bl) {
        Double d2;
        block11: {
            block14: {
                block13: {
                    block9: {
                        block12: {
                            block10: {
                                if (object == null) {
                                    return null;
                                }
                                d2 = null;
                                if (!bl) break block9;
                                if (this.xDataType != this.dataTypeDate || !(object instanceof Date)) break block10;
                                if (this.firstXDate == null) {
                                    this.firstXDate = (Date)object;
                                }
                                d2 = new Double(this.convertDateToNumericalData((Date)object, this.firstXDate));
                                break block11;
                            }
                            if (this.xDataType != this.dataTypeNumber || !(object instanceof Number)) break block12;
                            d2 = new Double(((Number)object).doubleValue());
                            break block11;
                        }
                        if (!this.pointIdSet.contains(object)) break block11;
                        boolean bl2 = false;
                        int n2 = 0;
                        Iterator<Object> iterator = this.seriesIdList.iterator();
                        while (iterator.hasNext() && !bl2) {
                            Object object2 = iterator.next();
                            List<DataPointWrapper> list = this.seriesHash.get(object2);
                            if (list == null) {
                                ++n2;
                                continue;
                            }
                            int n3 = 0;
                            Iterator<DataPointWrapper> iterator2 = list.iterator();
                            while (iterator2.hasNext() && !bl2) {
                                DataPointWrapper dataPointWrapper = iterator2.next();
                                if (dataPointWrapper.xValue != null && dataPointWrapper.xValue.equals(object)) {
                                    double[] dArray = this.xArrays.get(n2);
                                    d2 = new Double(dArray[n3]);
                                    bl2 = true;
                                }
                                ++n3;
                            }
                            ++n2;
                        }
                        break block11;
                    }
                    if (this.yDataType != this.dataTypeDate || !(object instanceof Date)) break block13;
                    if (this.firstYDate == null) {
                        this.firstYDate = (Date)object;
                    }
                    d2 = new Double(this.convertDateToNumericalData((Date)object, this.firstYDate));
                    break block11;
                }
                if (this.yDataType != this.dataTypeNumber || !(object instanceof Number)) break block14;
                d2 = new Double(((Number)object).doubleValue());
                break block11;
            }
            if (this.yDataType != this.dataTypeNumber) break block11;
            String string = object.toString();
            try {
                d2 = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = null;
            }
        }
        return d2;
    }

    protected void clearLocalStorage() {
        this.seriesIdList = null;
        this.seriesHash = null;
        this.pointIdSet = null;
        this.clusterMapHash = null;
        this.xDataType = null;
        this.yDataType = null;
        this.xArray = null;
        this.yArray = null;
        this.dataLabelArray = null;
        this.dataSourceName = null;
        this.clusterXValues = null;
        this.pointLabels = null;
        this.seriesLabels = null;
        this.dataLabels = null;
        this.trackLabels = null;
        this.pieExplodeList = null;
        this.chartStyles = null;
        this.candleStyles = null;
        this.outlineStyle = null;
        this.pointImageMaps = null;
        this.legendImageMaps = null;
        this.seriesImageMaps = null;
        this.clusterImageMaps = null;
        this.dataThresholds = null;
        this.clearState = null;
        this.firstXDate = null;
        this.firstYDate = null;
        this.otherSliceExplodes = null;
        this.otherSliceImageMapTable = null;
        this.otherSliceImageMap = null;
    }

    protected void applyAxisToDataView(String string, boolean bl, JCChart jCChart, ChartDataView chartDataView) {
        if (string != null) {
            JCChartArea jCChartArea = jCChart.getChartArea();
            JCAxis jCAxis = jCChartArea.findAxisByName(string);
            if (jCAxis == null) {
                jCAxis = new JCAxis();
                jCAxis.setName(string);
                if (bl) {
                    jCAxis.setVertical(false);
                    jCChartArea.setXAxis(jCChartArea.getXAxes().size(), jCAxis);
                } else {
                    jCAxis.setVertical(true);
                    jCChartArea.setYAxis(jCChartArea.getYAxes().size(), jCAxis);
                }
            }
            if (bl) {
                chartDataView.setXAxis(jCAxis);
            } else {
                chartDataView.setYAxis(jCAxis);
            }
        }
    }

    protected Class<?> validateDataType(Class<?> clazz) {
        if (clazz == null || clazz != this.dataTypeNumber && clazz != this.dataTypeDate && clazz != this.dataTypeObject) {
            clazz = this.dataTypeNumber;
        }
        return clazz;
    }

    protected void storeYValue(int n2, int n3, Class<?> clazz, Object object) {
        Class<?> clazz2 = clazz;
        if (clazz == this.dataTypeNumber && !(object instanceof Number)) {
            clazz2 = this.dataTypeObject;
        }
        if (clazz2 == this.dataTypeObject) {
            double d2;
            String string = object.toString();
            try {
                d2 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = this.holeValue;
            }
            this.yArray[n2][n3] = d2;
        } else if (clazz2 == this.dataTypeNumber) {
            this.yArray[n2][n3] = ((Number)object).doubleValue();
        } else if (clazz2 == this.dataTypeDate) {
            if (!(object instanceof Date)) {
                this.yArray[n2][n3] = this.holeValue;
            } else {
                if (this.firstYDate == null || this.firstYDate.after((Date)object)) {
                    this.firstYDate = (Date)object;
                }
                this.yArray[n2][n3] = this.convertDateToNumericalData((Date)object, this.firstYDate);
            }
        }
    }

    protected void storeDataLabel(int n2, int n3, String string) {
        if (string != null) {
            this.dataLabelArray[n2][n3] = string;
        }
    }

    protected void storePointLabel(int n2, String string) {
        if (string != null) {
            if (this.pointLabels.size() <= n2) {
                this.pointLabels.setSize(n2 + 1);
                this.pointLabels.set(n2, string);
            } else if (this.pointLabels.get(n2) == null) {
                this.pointLabels.set(n2, string);
            }
        }
    }

    protected void storeSeriesLabel(int n2, int n3, String string) {
        if (string != null && n3 == 0) {
            if (this.seriesLabels.size() <= n2) {
                this.seriesLabels.setSize(n2 + 1);
            }
            if (this.seriesLabels.get(n2) == null) {
                this.seriesLabels.set(n2, string);
            }
        }
    }

    protected void storeTrackLabel(int n2, int n3, String string) {
        if (string != null && n3 == 0) {
            if (this.trackLabels.size() <= n2) {
                this.trackLabels.setSize(n2 + 1);
            }
            if (this.trackLabels.get(n2) == null) {
                this.trackLabels.set(n2, string);
            }
        }
    }

    protected void storePointImageMap(int n2, int n3, String string, String string2) {
        Vector<ImageMapInfo> vector;
        ImageMapInfo imageMapInfo = new ImageMapInfo(string, string2);
        if (n2 >= this.pointImageMaps.size()) {
            this.pointImageMaps.setSize(n2 + 1);
            this.pointImageMaps.set(n2, new Vector());
        }
        if ((vector = this.pointImageMaps.get(n2)) == null) {
            vector = new Vector();
            this.pointImageMaps.set(n2, vector);
        }
        if (n3 >= vector.size()) {
            vector.setSize(n3 + 1);
        }
        vector.set(n3, imageMapInfo);
    }

    protected void storeLegendImageMap(int n2, String string, String string2) {
        ImageMapInfo imageMapInfo = new ImageMapInfo(string, string2);
        if (n2 >= this.legendImageMaps.size()) {
            this.legendImageMaps.setSize(n2 + 1);
        }
        if (this.legendImageMaps.get(n2) == null) {
            this.legendImageMaps.set(n2, imageMapInfo);
        }
    }

    protected double convertDateToNumericalData(Date date, Date date2) {
        long l2 = date.getTime();
        return (l2 -= date2.getTime()) / 1000L;
    }

    protected Object calculateSubstituteXValue(Class<?> clazz, int n2) {
        Comparable<Double> comparable = null;
        if (clazz != null) {
            if (clazz == this.dataTypeNumber || clazz == this.dataTypeObject) {
                comparable = new Double(n2);
            } else if (clazz == this.dataTypeDate) {
                comparable = new Date();
            }
        }
        if (comparable == null) {
            comparable = new Double(n2);
        }
        return comparable;
    }

    @Override
    public double[] getXSeries(int n2) {
        if (n2 < 0 || n2 >= this.xArrays.size()) {
            return null;
        }
        return this.xArrays.get(n2);
    }

    @Override
    public double[] getYSeries(int n2) {
        if (n2 < 0 || n2 >= this.yArrays.size()) {
            return null;
        }
        return this.yArrays.get(n2);
    }

    @Override
    public int getNumSeries() {
        if (this.chartType == 5) {
            return this.seriesIdList.size() * 2;
        }
        if (this.chartType == 7) {
            return this.seriesIdList.size() * 4;
        }
        if (this.chartType == 6) {
            return this.seriesIdList.size() * 4;
        }
        return this.seriesIdList.size();
    }

    @Override
    public String[] getPointLabels() {
        if (this.pointLabels == null || this.pointLabels.size() == 0) {
            return null;
        }
        return this.pointLabels.toArray(new String[this.pointLabels.size()]);
    }

    @Override
    public String[] getSeriesLabels() {
        if (this.seriesLabels == null || this.seriesLabels.size() == 0) {
            return null;
        }
        int n2 = 1;
        if (this.chartType == 5) {
            n2 = 2;
        } else if (this.chartType == 6) {
            n2 = 4;
        } else if (this.chartType == 7) {
            n2 = 4;
        }
        String[] stringArray = new String[this.seriesLabels.size() * n2];
        int n3 = 0;
        Iterator<String> iterator = this.seriesLabels.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n3 * n2] = string = iterator.next();
            ++n3;
        }
        return stringArray;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public TimeLineState[] getTimelineStates() {
        int n2 = this.timelineStateSet.size();
        if (n2 == 0) {
            return null;
        }
        TimeLineState[] timeLineStateArray = new TimeLineState[n2];
        return this.timelineStateSet.toArray(timeLineStateArray);
    }

    @Override
    public String[] getTrackLabels() {
        if (this.trackLabels == null || this.trackLabels.size() == 0) {
            return null;
        }
        return this.trackLabels.toArray(new String[this.trackLabels.size()]);
    }

    @Override
    public String[] getDataLabel(int n2) {
        if (n2 < 0 || n2 >= this.dataLabels.size()) {
            return null;
        }
        return this.dataLabels.get(n2);
    }

    @Override
    public double getHoleValue() {
        return this.holeValue;
    }

    @Override
    public ImageMapInfo[] getPointImageMapInfo(int n2) {
        if (this.pointImageMaps.size() == 0) {
            return null;
        }
        int n3 = 1;
        if (this.chartType == 5) {
            n3 = 2;
        } else if (this.chartType == 6) {
            n3 = 4;
        } else if (this.chartType == 7) {
            n3 = 4;
        }
        if (n2 % n3 == 0) {
            Vector<ImageMapInfo> vector = this.pointImageMaps.get(n2 / n3);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            int n4 = vector.size();
            return vector.toArray(new ImageMapInfo[n4]);
        }
        return null;
    }

    @Override
    public ImageMapInfo[] getClusterImageMapInfo() {
        if (this.clusterImageMaps == null || this.clusterImageMaps.size() == 0) {
            return null;
        }
        return this.clusterImageMaps.toArray(new ImageMapInfo[this.clusterImageMaps.size()]);
    }

    @Override
    public ImageMapInfo[] getSeriesImageMapInfo() {
        if (this.seriesImageMaps == null || this.seriesImageMaps.size() == 0) {
            return null;
        }
        int n2 = 1;
        if (this.chartType == 5) {
            n2 = 2;
        } else if (this.chartType == 6) {
            n2 = 4;
        } else if (this.chartType == 7) {
            n2 = 4;
        }
        ImageMapInfo[] imageMapInfoArray = new ImageMapInfo[this.seriesImageMaps.size() * n2];
        int n3 = 0;
        Iterator<ImageMapInfo> iterator = this.seriesImageMaps.iterator();
        while (iterator.hasNext()) {
            ImageMapInfo imageMapInfo;
            imageMapInfoArray[n3 * n2] = imageMapInfo = iterator.next();
            ++n3;
        }
        return imageMapInfoArray;
    }

    @Override
    public ImageMapInfo[] getLegendImageMapInfo() {
        if (this.legendImageMaps == null || this.legendImageMaps.size() == 0) {
            return null;
        }
        return this.legendImageMaps.toArray(new ImageMapInfo[this.legendImageMaps.size()]);
    }

    @Override
    public JCDataThreshold[] getDataThreshold(int n2) {
        if (n2 < 0 || n2 >= this.seriesIdList.size()) {
            return null;
        }
        Object object = this.seriesIdList.get(n2);
        List<ThresholdWrapper> list = this.dataThresholds.get(object);
        if (list != null) {
            int n3 = list.size();
            JCDataThreshold[] jCDataThresholdArray = new JCDataThreshold[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                ThresholdWrapper thresholdWrapper = list.get(i2);
                jCDataThresholdArray[i2] = thresholdWrapper.dataThreshold;
            }
            return jCDataThresholdArray;
        }
        return null;
    }

    public void printDataPoint(DataPoint dataPoint) {
        if (dataPoint instanceof BasicDataPoint) {
            BasicDataPoint basicDataPoint = (BasicDataPoint)dataPoint;
            System.err.println("Basic Data Point #" + this.pointCounter);
            System.err.println("-x value " + basicDataPoint.xValue);
            System.err.println("-y value " + basicDataPoint.yValue);
            System.err.println("-x label " + basicDataPoint.xLabel);
            System.err.println("-series id " + basicDataPoint.seriesId);
            System.err.println("-series label " + basicDataPoint.seriesLabel);
            System.err.println("-image map url " + basicDataPoint.imageMapURL);
            System.err.println("-image map extra " + basicDataPoint.imageMapExtra);
            System.err.println("-legend image map url " + basicDataPoint.legendImageMapURL);
            System.err.println("-legend image map extra " + basicDataPoint.legendImageMapExtra);
            System.err.println("");
        } else if (dataPoint instanceof BarDataPoint) {
            BarDataPoint barDataPoint = (BarDataPoint)dataPoint;
            System.err.println("Bar Data Point #" + this.pointCounter);
            System.err.println("-bar id " + barDataPoint.clusterId);
            System.err.println("-y value " + barDataPoint.yValue);
            System.err.println("-bar label " + barDataPoint.clusterLabel);
            System.err.println("-series id " + barDataPoint.seriesId);
            System.err.println("-series label " + barDataPoint.seriesLabel);
            System.err.println("-image map url " + barDataPoint.imageMapURL);
            System.err.println("-image map extra " + barDataPoint.imageMapExtra);
            System.err.println("-legend image map url " + barDataPoint.legendImageMapURL);
            System.err.println("-legend image map extra " + barDataPoint.legendImageMapExtra);
            System.err.println("");
        } else if (dataPoint instanceof PieDataPoint) {
            PieDataPoint pieDataPoint = (PieDataPoint)dataPoint;
            System.err.println("Pie Data Point #" + this.pointCounter);
            System.err.println("-pie id " + pieDataPoint.pieId);
            System.err.println("-slice value " + pieDataPoint.sliceValue);
            System.err.println("-pie label " + pieDataPoint.pieLabel);
            System.err.println("-slice id " + pieDataPoint.sliceId);
            System.err.println("-slice label " + pieDataPoint.sliceLabel);
            System.err.println("-image map url " + pieDataPoint.imageMapURL);
            System.err.println("-image map extra " + pieDataPoint.imageMapExtra);
            System.err.println("-legend image map url " + pieDataPoint.legendImageMapURL);
            System.err.println("-legend image map extra " + pieDataPoint.legendImageMapExtra);
            System.err.println("");
        } else if (dataPoint instanceof FinancialDataPoint) {
            FinancialDataPoint financialDataPoint = (FinancialDataPoint)dataPoint;
            System.err.println("Financial Data Point #" + this.pointCounter);
            System.err.println("-x value " + financialDataPoint.xValue);
            System.err.println("-high value " + financialDataPoint.highValue);
            System.err.println("-low value " + financialDataPoint.lowValue);
            System.err.println("-open value " + financialDataPoint.openValue);
            System.err.println("-close value " + financialDataPoint.closeValue);
            System.err.println("-x label " + financialDataPoint.xLabel);
            System.err.println("-series id " + financialDataPoint.seriesId);
            System.err.println("-series label " + financialDataPoint.seriesLabel);
            System.err.println("-image map url " + financialDataPoint.imageMapURL);
            System.err.println("-image map extra " + financialDataPoint.imageMapExtra);
            System.err.println("-legend image map url " + financialDataPoint.legendImageMapURL);
            System.err.println("-legend image map extra " + financialDataPoint.legendImageMapExtra);
            System.err.println("");
        } else if (dataPoint instanceof PolarDataPoint) {
            PolarDataPoint polarDataPoint = (PolarDataPoint)dataPoint;
            System.err.println("Polar Data Point #" + this.pointCounter);
            System.err.println("-angle " + polarDataPoint.angle);
            System.err.println("-y value " + polarDataPoint.yValue);
            System.err.println("-angle label " + polarDataPoint.angleLabel);
            System.err.println("-series id " + polarDataPoint.seriesId);
            System.err.println("-series label " + polarDataPoint.seriesLabel);
            System.err.println("-image map url " + polarDataPoint.imageMapURL);
            System.err.println("-image map extra " + polarDataPoint.imageMapExtra);
            System.err.println("-legend image map url " + polarDataPoint.legendImageMapURL);
            System.err.println("-legend image map extra " + polarDataPoint.legendImageMapExtra);
            System.err.println("");
        } else if (dataPoint instanceof RadarDataPoint) {
            RadarDataPoint radarDataPoint = (RadarDataPoint)dataPoint;
            System.err.println("Radar Data Point #" + this.pointCounter);
            System.err.println("-spoke id " + radarDataPoint.spokeId);
            System.err.println("-y value " + radarDataPoint.yValue);
            System.err.println("-spoke label " + radarDataPoint.spokeLabel);
            System.err.println("-series id " + radarDataPoint.seriesId);
            System.err.println("-series label " + radarDataPoint.seriesLabel);
            System.err.println("-image map url " + radarDataPoint.imageMapURL);
            System.err.println("-image map extra " + radarDataPoint.imageMapExtra);
            System.err.println("-legend image map url " + radarDataPoint.legendImageMapURL);
            System.err.println("-legend image map extra " + radarDataPoint.legendImageMapExtra);
            System.err.println("");
        }
        ++this.pointCounter;
    }
}

