/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.model.impl;

import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.model.AbstractThreshold;
import com.klg.jclass.chart.model.ClusterDataSet;
import com.klg.jclass.chart.model.DataIterator;
import com.klg.jclass.chart.model.DataMarker;
import com.klg.jclass.chart.model.DataOrder;
import com.klg.jclass.chart.model.DataPoint;
import com.klg.jclass.chart.model.DataPointException;
import com.klg.jclass.chart.model.DataThreshold;
import com.klg.jclass.chart.model.MarkerIterator;
import com.klg.jclass.chart.model.SeriesDataSet;
import com.klg.jclass.chart.model.ThresholdIterator;
import com.klg.jclass.chart.model.impl.AbstractResultSetBinding;
import com.klg.jclass.chart.model.impl.ResultSetState;
import com.klg.jclass.util.ImageMapInfo;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultSetDataSet
implements DataIterator,
ClusterDataSet,
SeriesDataSet,
Serializable {
    public static final String OTHER_SLICE_ID = "Other Slice";
    protected boolean firstDataIteratorRequest = true;
    public Class<?> dataTypeNumber;
    public Class<?> dataTypeDate;
    public Class<?> dataTypeObject;
    protected Vector<AbstractResultSetBinding> bindings;
    protected Vector<ResultSetState> states;
    protected boolean morePoints;
    protected AbstractResultSetBinding currentBinding;
    protected int currentBindingIndex;
    protected ResultSetState currentState;
    protected int lineStyleCounter = 0;
    protected int symbolStyleCounter = 0;
    protected int fillStyleCounter = 0;
    protected DataOrder xDataOrder;
    protected Class<?> xDataType;
    protected Class<?> yDataType;
    protected String name;
    protected Number holeValue;
    protected ImageMapInfo legendImageMap;
    protected String xAxisName;
    protected String yAxisName;
    protected List<Object> clusterXValues;
    protected List<String> clusterXLabels;
    protected Hashtable<Object, ImageMapInfo> clusterImageMapHash;
    protected Hashtable<Object, String> seriesLabelHash;
    protected Hashtable<Object, ImageMapInfo> seriesImageMapHash;
    protected Hashtable<Object, ImageMapInfo> legendImageMapHash;
    protected int chartType;
    protected MarkerList xMarkerList = null;
    protected MarkerList yMarkerList = null;
    protected ThresholdList xThresholdList = null;
    protected ThresholdList yThresholdList = null;
    protected List<JCLineStyle> lineStylePalette;
    protected List<JCSymbolStyle> symbolStylePalette;
    protected List<JCFillStyle> fillStylePalette;
    protected JCLineStyle outlineStyle;
    protected Hashtable<Object, JCLineStyle> seriesLineStyles;
    protected Hashtable<Object, JCSymbolStyle> seriesSymbolStyles;
    protected Hashtable<Object, JCFillStyle> seriesFillStyles;
    protected boolean useXNumericalTimeData;
    protected boolean useYNumericalTimeData;
    protected Date xTimeBase;
    protected Date yTimeBase;
    protected long xTimeUnit;
    protected long yTimeUnit;

    public AbstractResultSetDataSet() {
        this(DataOrder.ORDER_RECEIVED);
    }

    public AbstractResultSetDataSet(DataOrder dataOrder) {
        try {
            this.dataTypeNumber = Class.forName("java.lang.Number");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.dataTypeDate = Class.forName("java.util.Date");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.dataTypeObject = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.bindings = new Vector();
        this.states = new Vector();
        this.morePoints = false;
        this.currentBinding = null;
        this.currentBindingIndex = -1;
        this.currentState = null;
        this.xMarkerList = new MarkerList();
        this.yMarkerList = new MarkerList();
        this.xThresholdList = new ThresholdList();
        this.yThresholdList = new ThresholdList();
        this.xDataOrder = dataOrder;
        this.xDataType = null;
        this.yDataType = this.dataTypeNumber;
        this.name = null;
        this.holeValue = null;
        this.xAxisName = null;
        this.yAxisName = null;
        this.clusterXValues = null;
        this.clusterXLabels = null;
        this.clusterImageMapHash = null;
        this.seriesLabelHash = null;
        this.seriesImageMapHash = null;
        this.legendImageMapHash = null;
        this.chartType = 0;
        this.lineStylePalette = null;
        this.symbolStylePalette = null;
        this.fillStylePalette = null;
        this.outlineStyle = null;
        this.seriesLineStyles = new Hashtable();
        this.seriesSymbolStyles = new Hashtable();
        this.seriesFillStyles = new Hashtable();
        this.useXNumericalTimeData = false;
        this.useYNumericalTimeData = false;
        this.xTimeBase = null;
        this.yTimeBase = null;
        this.xTimeUnit = 1000L;
        this.yTimeUnit = 1000L;
    }

    public void addResultSetBinding(AbstractResultSetBinding abstractResultSetBinding) throws SQLException {
        if (abstractResultSetBinding.sourceResultSet == null) {
            return;
        }
        this.bindings.add(abstractResultSetBinding);
        ResultSetState resultSetState = new ResultSetState();
        resultSetState.morePoints = abstractResultSetBinding.sourceResultSet.next();
        if (abstractResultSetBinding.rowOrColumn) {
            this.determineRowDataTypes(abstractResultSetBinding);
            resultSetState.morePoints = this.determineRowPoints(abstractResultSetBinding);
        } else {
            this.determineColumnDataTypes(abstractResultSetBinding);
            resultSetState.morePoints = this.determineColumnPoints(abstractResultSetBinding);
            resultSetState.currentColumnIndex = 0;
        }
        this.states.add(resultSetState);
        if (this.currentBinding == null && resultSetState.morePoints) {
            this.currentBinding = abstractResultSetBinding;
            this.currentState = resultSetState;
            this.currentBindingIndex = this.bindings.size() - 1;
        }
        this.morePoints |= resultSetState.morePoints;
    }

    protected void determineColumnDataTypes(AbstractResultSetBinding abstractResultSetBinding) throws SQLException {
        ResultSetMetaData resultSetMetaData = abstractResultSetBinding.sourceResultSet.getMetaData();
        if (this.currentBindingIndex < 0) {
            int n2 = resultSetMetaData.getColumnCount();
            String string = null;
            if (abstractResultSetBinding.col_seriesColumnNames != null && abstractResultSetBinding.col_seriesColumnNames.size() > 0) {
                string = abstractResultSetBinding.col_seriesColumnNames.get(0);
            }
            boolean bl = this.xDataType != null;
            boolean bl2 = false;
            for (int i2 = 1; !(i2 > n2 || bl && bl2); ++i2) {
                String string2 = resultSetMetaData.getColumnName(i2);
                if (!bl && abstractResultSetBinding.col_xColumnName != null && string2.equals(abstractResultSetBinding.col_xColumnName)) {
                    this.xDataType = this.validateDataType(resultSetMetaData.getColumnClassName(i2));
                    bl = true;
                    continue;
                }
                if (bl2 || string == null || !string2.equals(string)) continue;
                this.yDataType = this.validateDataType(resultSetMetaData.getColumnClassName(i2));
                bl2 = true;
            }
        }
    }

    protected void determineRowDataTypes(AbstractResultSetBinding abstractResultSetBinding) throws SQLException {
        ResultSetMetaData resultSetMetaData = abstractResultSetBinding.sourceResultSet.getMetaData();
        if (this.currentBindingIndex < 0) {
            int n2 = resultSetMetaData.getColumnCount();
            boolean bl = this.xDataType != null;
            boolean bl2 = false;
            for (int i2 = 1; !(i2 > n2 || bl && bl2); ++i2) {
                String string = resultSetMetaData.getColumnName(i2);
                if (!bl && abstractResultSetBinding.row_xColumnName != null && string.equals(abstractResultSetBinding.row_xColumnName)) {
                    this.xDataType = this.validateDataType(resultSetMetaData.getColumnClassName(i2));
                    bl = true;
                    continue;
                }
                if (bl2 || abstractResultSetBinding.row_yColumnName == null || !string.equals(abstractResultSetBinding.row_yColumnName)) continue;
                this.yDataType = this.validateDataType(resultSetMetaData.getColumnClassName(i2));
                bl2 = true;
            }
        }
    }

    protected Class<?> validateDataType(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.validateDataType(clazz);
    }

    protected Class<?> validateDataType(Class<?> clazz) {
        while (clazz != null) {
            if (clazz == this.dataTypeDate) {
                return clazz;
            }
            if (clazz == this.dataTypeNumber) {
                return clazz;
            }
            if (clazz == this.dataTypeObject) {
                return clazz;
            }
            clazz = clazz.getSuperclass();
        }
        return this.dataTypeNumber;
    }

    protected boolean determineRowPoints(AbstractResultSetBinding abstractResultSetBinding) {
        return abstractResultSetBinding.row_yColumnName != null;
    }

    protected boolean determineColumnPoints(AbstractResultSetBinding abstractResultSetBinding) {
        return abstractResultSetBinding.col_seriesColumnNames != null && abstractResultSetBinding.col_seriesColumnNames.size() != 0;
    }

    protected abstract DataPoint createDataPoint(Object var1, Object var2, Object var3, String var4, String var5, String var6, String var7, String var8, String var9);

    protected void setName(String string) {
        this.name = string;
    }

    protected void setHoleValue(Number number) {
        this.holeValue = number;
    }

    protected void setChartType(int n2) {
        this.chartType = n2;
    }

    public void setLegendImageMap(ImageMapInfo imageMapInfo) {
        this.legendImageMap = imageMapInfo;
    }

    protected void setXAxisName(String string) {
        this.xAxisName = string;
    }

    protected void setYAxisName(String string) {
        this.yAxisName = string;
    }

    protected void setXMarkers(List<DataMarker> list) {
        this.xMarkerList.setMarkers(list);
    }

    protected void setYMarkers(List<DataMarker> list) {
        this.yMarkerList.setMarkers(list);
    }

    protected void setXThresholds(List<DataThreshold> list) {
        this.xThresholdList.setThresholds(list);
    }

    protected void setYThresholds(List<DataThreshold> list) {
        this.yThresholdList.setThresholds(list);
    }

    protected void setXValues(List<Object> list) {
        this.clusterXValues = list;
        Class<?> clazz = this.validateClusterXValuesDataType(list);
        if (this.xDataType == null || clazz != null) {
            this.xDataType = clazz;
        }
    }

    protected Class<?> validateClusterXValuesDataType(List<Object> list) {
        if (list != null && list.size() > 0) {
            for (Object object : list) {
                if (object == null) continue;
                return this.validateDataType(object.getClass().getName());
            }
            return this.dataTypeNumber;
        }
        return null;
    }

    protected void setXLabels(List<String> list) {
        this.clusterXLabels = list;
    }

    protected void setClusterImageMap(Object object, ImageMapInfo imageMapInfo) {
        if (this.clusterImageMapHash == null) {
            this.clusterImageMapHash = new Hashtable();
        }
        this.clusterImageMapHash.put(object, imageMapInfo);
    }

    protected void setSeriesLabel(Object object, String string) {
        if (this.seriesLabelHash == null) {
            this.seriesLabelHash = new Hashtable();
        }
        this.seriesLabelHash.put(object, string);
    }

    protected void setSeriesImageMap(Object object, ImageMapInfo imageMapInfo) {
        if (this.seriesImageMapHash == null) {
            this.seriesImageMapHash = new Hashtable();
        }
        this.seriesImageMapHash.put(object, imageMapInfo);
    }

    protected void setLegendImageMap(Object object, ImageMapInfo imageMapInfo) {
        if (this.legendImageMapHash == null) {
            this.legendImageMapHash = new Hashtable();
        }
        this.legendImageMapHash.put(object, imageMapInfo);
    }

    protected void setLineStylePalette(List<JCLineStyle> list) {
        this.lineStylePalette = list;
    }

    protected void setSymbolStylePalette(List<JCSymbolStyle> list) {
        this.symbolStylePalette = list;
    }

    protected void setFillStylePalette(List<JCFillStyle> list) {
        this.fillStylePalette = list;
    }

    protected void setOutlineLineStyle(JCLineStyle jCLineStyle) {
        this.outlineStyle = jCLineStyle;
    }

    protected void setSeriesLineStyle(Object object, JCLineStyle jCLineStyle) {
        if (object == null) {
            return;
        }
        this.seriesLineStyles.put(object, jCLineStyle);
    }

    protected void setSeriesSymbolStyle(Object object, JCSymbolStyle jCSymbolStyle) {
        if (object == null) {
            return;
        }
        this.seriesSymbolStyles.put(object, jCSymbolStyle);
    }

    protected void setSeriesFillStyle(Object object, JCFillStyle jCFillStyle) {
        if (object == null) {
            return;
        }
        this.seriesFillStyles.put(object, jCFillStyle);
    }

    protected void setXNumericalTimeData(boolean bl) {
        this.useXNumericalTimeData = true;
    }

    protected void setYNumericalTimeData(boolean bl) {
        this.useYNumericalTimeData = true;
    }

    protected void setXNumericalTimeBase(Date date) {
        this.xTimeBase = date;
    }

    protected void setYNumericalTimeBase(Date date) {
        this.yTimeBase = date;
    }

    protected void setXNumericalTimeUnit(long l2) {
        this.xTimeUnit = l2;
    }

    protected void setYNumericalTimeUnit(long l2) {
        this.yTimeUnit = l2;
    }

    public String getName() {
        return this.name;
    }

    public int getChartType() {
        return this.chartType;
    }

    public DataIterator getDataIterator() {
        if (!this.firstDataIteratorRequest) {
            try {
                this.resetBindings();
            }
            catch (SQLException sQLException) {
                return null;
            }
        }
        this.firstDataIteratorRequest = false;
        return this;
    }

    public Number getHoleValue() {
        return this.holeValue;
    }

    public DataOrder getDataOrder() {
        return this.xDataOrder;
    }

    public ImageMapInfo getLegendImageMap() {
        return this.legendImageMap;
    }

    public Class<?> getXDataType() {
        return this.xDataType;
    }

    public Class<?> getYDataType() {
        return this.yDataType;
    }

    public String getXAxisName() {
        return this.xAxisName;
    }

    public String getYAxisName() {
        return this.yAxisName;
    }

    public MarkerIterator getXMarkerIterator() {
        return this.xMarkerList;
    }

    public MarkerIterator getYMarkerIterator() {
        return this.yMarkerList;
    }

    public ThresholdIterator getXThresholdIterator() {
        return this.xThresholdList;
    }

    public ThresholdIterator getYThresholdIterator() {
        return this.yThresholdList;
    }

    public boolean isXNumericalTimeData() {
        return this.useXNumericalTimeData;
    }

    public boolean isYNumericalTimeData() {
        return this.useYNumericalTimeData;
    }

    public Date getXTimeBase() {
        return this.xTimeBase;
    }

    public Date getYTimeBase() {
        return this.yTimeBase;
    }

    public long getXTimeUnit() {
        return this.xTimeUnit;
    }

    public long getYTimeUnit() {
        return this.yTimeUnit;
    }

    public JCLineStyle getLineStyle(Object object) {
        JCLineStyle jCLineStyle = null;
        if (object != null) {
            jCLineStyle = this.seriesLineStyles.get(object);
        }
        if (jCLineStyle == null && this.lineStylePalette != null) {
            if (this.lineStyleCounter >= this.lineStylePalette.size()) {
                this.lineStyleCounter = 0;
            }
            jCLineStyle = this.lineStylePalette.get(this.lineStyleCounter);
            if (object != null) {
                this.seriesLineStyles.put(object, jCLineStyle);
            }
            ++this.lineStyleCounter;
        }
        return jCLineStyle;
    }

    public JCSymbolStyle getSymbolStyle(Object object) {
        JCSymbolStyle jCSymbolStyle = null;
        if (object != null) {
            jCSymbolStyle = this.seriesSymbolStyles.get(object);
        }
        if (jCSymbolStyle == null && this.symbolStylePalette != null) {
            if (this.symbolStyleCounter >= this.symbolStylePalette.size()) {
                this.symbolStyleCounter = 0;
            }
            jCSymbolStyle = this.symbolStylePalette.get(this.symbolStyleCounter);
            if (object != null) {
                this.seriesSymbolStyles.put(object, jCSymbolStyle);
            }
            ++this.symbolStyleCounter;
        }
        return jCSymbolStyle;
    }

    public JCFillStyle getFillStyle(Object object) {
        JCFillStyle jCFillStyle = null;
        if (object != null) {
            jCFillStyle = this.seriesFillStyles.get(object);
        }
        if (jCFillStyle == null && this.fillStylePalette != null) {
            if (this.fillStyleCounter >= this.fillStylePalette.size()) {
                this.fillStyleCounter = 0;
            }
            jCFillStyle = this.fillStylePalette.get(this.fillStyleCounter);
            if (object != null) {
                this.seriesFillStyles.put(object, jCFillStyle);
            }
            ++this.fillStyleCounter;
        }
        return jCFillStyle;
    }

    public JCLineStyle getOutlineStyle() {
        return this.outlineStyle;
    }

    public JCFillStyle getOtherSliceFillStyle() {
        return this.getFillStyle(OTHER_SLICE_ID);
    }

    @Override
    public Iterator<Object> getXValues() {
        if (this.clusterXValues == null) {
            return null;
        }
        return this.clusterXValues.iterator();
    }

    @Override
    public Iterator<String> getXLabels() {
        if (this.clusterXLabels == null) {
            return null;
        }
        return this.clusterXLabels.iterator();
    }

    @Override
    public ImageMapInfo getClusterImageMap(Object object) {
        if (object == null || this.clusterImageMapHash == null) {
            return null;
        }
        return this.clusterImageMapHash.get(object);
    }

    @Override
    public String getSeriesLabel(Object object) {
        if (object == null || this.seriesLabelHash == null) {
            return null;
        }
        return this.seriesLabelHash.get(object);
    }

    @Override
    public String getTrackLabel(Object object) {
        return null;
    }

    @Override
    public ImageMapInfo getSeriesImageMap(Object object) {
        if (object == null || this.seriesImageMapHash == null) {
            return null;
        }
        return this.seriesImageMapHash.get(object);
    }

    @Override
    public ImageMapInfo getLegendImageMap(Object object) {
        if (object == null || this.legendImageMapHash == null) {
            return null;
        }
        return this.legendImageMapHash.get(object);
    }

    @Override
    public ThresholdIterator getDataThresholds(Object object) {
        return null;
    }

    @Override
    public boolean hasMoreDataPoints() {
        return this.morePoints;
    }

    @Override
    public DataPoint getNextDataPoint() throws DataPointException {
        if (this.xDataType == null) {
            this.xDataType = this.dataTypeNumber;
        }
        try {
            if (this.currentBinding.rowOrColumn) {
                return this.getNextRowDataPoint();
            }
            return this.getNextColumnDataPoint();
        }
        catch (SQLException sQLException) {
            throw new DataPointException(sQLException);
        }
    }

    protected DataPoint getNextColumnDataPoint() throws SQLException {
        String string;
        String string2;
        Object object;
        Object object2;
        List<String> list;
        Object object3;
        Object object4 = this.getColumnDataPointXValue();
        Object object5 = this.getColumnDataPointYValue();
        Object object6 = this.getColumnDataPointSeriesId();
        String string3 = this.getColumnDataPointXLabel();
        String string4 = this.getColumnDataPointSeriesLabel();
        List<String> list2 = this.currentBinding.col_imageMapURLFormatStrings;
        if (list2 != null) {
            object3 = list2.get(this.currentState.currentColumnIndex);
            if (object3 != null) {
                Object object7;
                List<String> list3;
                list = this.currentBinding.col_imageMapURLColumnNames;
                ResultSet resultSet = this.currentBinding.sourceResultSet;
                if (list != null) {
                    list3 = list.get(this.currentState.currentColumnIndex);
                    if (list3 != null) {
                        object7 = new Object[list3.size()];
                        for (int i2 = 0; i2 < list3.size(); ++i2) {
                            object7[i2] = resultSet.getString(list3.get(i2));
                        }
                        object2 = MessageFormat.format((String)object3, object7);
                    } else {
                        object2 = object3;
                    }
                } else {
                    object2 = object3;
                }
                list3 = this.currentBinding.col_imageMapExtraFormatStrings;
                if (list3 != null) {
                    object7 = list3.get(this.currentState.currentColumnIndex);
                    if (object7 != null) {
                        List<List<String>> list4 = this.currentBinding.col_imageMapExtraColumnNames;
                        if (list4 != null) {
                            List<String> list5 = list4.get(this.currentState.currentColumnIndex);
                            if (list5 != null) {
                                Object[] objectArray = new Object[list5.size()];
                                for (int i3 = 0; i3 < list5.size(); ++i3) {
                                    objectArray[i3] = resultSet.getString(list5.get(i3));
                                }
                                object = MessageFormat.format((String)object7, objectArray);
                            } else {
                                object = object7;
                            }
                        } else {
                            object = object7;
                        }
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
            } else {
                object2 = null;
                object = null;
            }
        } else {
            object2 = null;
            object = null;
        }
        object3 = this.currentBinding.col_legendImageMapURLStrings;
        if (object3 != null) {
            string2 = (String)object3.get(this.currentState.currentColumnIndex);
            list = this.currentBinding.col_legendImageMapExtraStrings;
            string = list != null ? (String)list.get(this.currentState.currentColumnIndex) : null;
        } else {
            string2 = null;
            string = null;
        }
        list = this.createDataPoint(object4, object5, object6, string3, string4, (String)object2, (String)object, string2, string);
        this.moveToNextColumn();
        if (!this.morePoints) {
            this.moveToNextBinding();
        }
        return list;
    }

    protected Object getColumnDataPointXValue() throws SQLException {
        ResultSet resultSet = this.currentBinding.sourceResultSet;
        Object object = this.currentBinding.col_xColumnName != null ? resultSet.getObject(this.currentBinding.col_xColumnName) : new Integer(resultSet.getRow() - 1);
        return object;
    }

    protected Object getColumnDataPointYValue() throws SQLException {
        Object object = null;
        List<String> list = this.currentBinding.col_seriesColumnNames;
        if (list != null) {
            ResultSet resultSet = this.currentBinding.sourceResultSet;
            int n2 = this.currentState.currentColumnIndex;
            object = resultSet.getObject(list.get(n2));
        }
        return object;
    }

    protected Object getColumnDataPointSeriesId() throws SQLException {
        String string = null;
        List<String> list = this.currentBinding.col_seriesColumnNames;
        if (list != null) {
            string = list.get(this.currentState.currentColumnIndex);
        }
        return string;
    }

    protected String getColumnDataPointXLabel() throws SQLException {
        String string = null;
        String string2 = this.currentBinding.col_xLabelColumnName;
        if (string2 != null) {
            string = this.currentBinding.sourceResultSet.getString(string2);
        }
        return string;
    }

    protected String getColumnDataPointSeriesLabel() throws SQLException {
        String string = null;
        List<String> list = this.currentBinding.col_seriesLabels;
        if (list != null && list.size() > this.currentState.currentColumnIndex) {
            string = list.get(this.currentState.currentColumnIndex);
        }
        return string;
    }

    protected void moveToNextColumn() throws SQLException {
        ++this.currentState.currentColumnIndex;
        List<String> list = this.currentBinding.col_seriesColumnNames;
        if (this.currentState.currentColumnIndex == list.size()) {
            this.currentState.currentColumnIndex = 0;
            this.morePoints = this.currentBinding.sourceResultSet.next();
        }
    }

    protected DataPoint getNextRowDataPoint() throws SQLException {
        String string;
        List<String> list;
        Object object;
        String string2;
        Object object2;
        List<String> list2;
        Object object3 = this.getRowDataPointSeriesId();
        if (this.currentState.seriesPointCounts.get(object3) == null) {
            this.currentState.seriesPointCounts.put(object3, new Integer(0));
        }
        Object object4 = this.getRowDataPointXValue(object3);
        Object object5 = this.getRowDataPointYValue();
        String string3 = this.getRowDataPointXLabel();
        String string4 = this.getRowDataPointSeriesLabel();
        ResultSet resultSet = this.currentBinding.sourceResultSet;
        String string5 = this.currentBinding.row_imageMapURLFormatString;
        if (string5 != null) {
            list2 = this.currentBinding.row_imageMapURLColumnNames;
            if (list2 != null) {
                object2 = new Object[list2.size()];
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    object2[i2] = resultSet.getString((String)list2.get(i2));
                }
                string2 = MessageFormat.format(string5, (Object[])object2);
            } else {
                string2 = string5;
            }
            object2 = this.currentBinding.row_imageMapExtraFormatString;
            if (object2 != null) {
                List<String> list3 = this.currentBinding.row_imageMapExtraColumnNames;
                if (list3 != null) {
                    Object[] objectArray = new Object[list3.size()];
                    for (int i3 = 0; i3 < list3.size(); ++i3) {
                        objectArray[i3] = resultSet.getString(list3.get(i3));
                    }
                    object = MessageFormat.format((String)object2, objectArray);
                } else {
                    object = object2;
                }
            } else {
                object = null;
            }
        } else {
            string2 = null;
            object = null;
        }
        list2 = this.currentBinding.row_legendImageMapURLFormatString;
        if (list2 != null) {
            object2 = this.currentBinding.row_legendImageMapURLColumnNames;
            if (object2 != null) {
                Object[] objectArray = new Object[object2.size()];
                for (int i4 = 0; i4 < object2.size(); ++i4) {
                    objectArray[i4] = resultSet.getString((String)object2.get(i4));
                }
                list = MessageFormat.format((String)((Object)list2), objectArray);
            } else {
                list = list2;
            }
            String string6 = this.currentBinding.row_legendImageMapExtraFormatString;
            if (string6 != null) {
                List<String> list4 = this.currentBinding.row_legendImageMapExtraColumnNames;
                if (list4 != null) {
                    Object[] objectArray = new Object[list4.size()];
                    for (int i5 = 0; i5 < list4.size(); ++i5) {
                        objectArray[i5] = resultSet.getString(list4.get(i5));
                    }
                    string = MessageFormat.format(string6, objectArray);
                } else {
                    string = string6;
                }
            } else {
                string = null;
            }
        } else {
            list = null;
            string = null;
        }
        object2 = this.createDataPoint(object4, object5, object3, string3, string4, string2, (String)object, (String)((Object)list), string);
        this.morePoints = resultSet.next();
        if (!this.morePoints) {
            this.moveToNextBinding();
        }
        return object2;
    }

    protected Object getRowDataPointSeriesId() throws SQLException {
        Vector<Object> vector;
        List<String> list = this.currentBinding.row_seriesColumnNames;
        if (list != null && list.size() > 0) {
            ResultSet resultSet = this.currentBinding.sourceResultSet;
            if (list.size() == 1) {
                String string = list.get(0);
                vector = resultSet.getObject(string);
            } else {
                Vector<Object> vector2 = new Vector<Object>();
                for (String string : list) {
                    vector2.add(resultSet.getObject(string));
                }
                vector = vector2;
            }
        } else {
            vector = this.currentBinding.row_yColumnName;
        }
        return vector;
    }

    protected Object getRowDataPointXValue(Object object) throws SQLException {
        Object object2;
        if (this.currentBinding.row_xColumnName != null) {
            ResultSet resultSet = this.currentBinding.sourceResultSet;
            object2 = resultSet.getObject(this.currentBinding.row_xColumnName);
        } else {
            Hashtable<Object, Integer> hashtable = this.currentState.seriesPointCounts;
            object2 = new Integer(hashtable.get(object));
            hashtable.put(object, new Integer(((Number)object2).intValue() + 1));
        }
        return object2;
    }

    protected Object getRowDataPointYValue() throws SQLException {
        Object object = null;
        String string = this.currentBinding.row_yColumnName;
        if (string != null) {
            object = this.currentBinding.sourceResultSet.getObject(string);
        }
        return object;
    }

    protected String getRowDataPointXLabel() throws SQLException {
        String string = null;
        String string2 = this.currentBinding.row_xLabelColumnName;
        if (string2 != null) {
            string = this.currentBinding.sourceResultSet.getString(string2);
        }
        return string;
    }

    protected String getRowDataPointSeriesLabel() throws SQLException {
        String string = null;
        String string2 = this.currentBinding.row_seriesLabelFormatString;
        if (string2 != null) {
            List<String> list = this.currentBinding.row_seriesLabelColumnNames;
            if (list != null) {
                Object[] objectArray = new Object[list.size()];
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    ResultSet resultSet = this.currentBinding.sourceResultSet;
                    objectArray[i2] = resultSet.getString(list.get(i2));
                }
                string = MessageFormat.format(string2, objectArray);
            } else {
                string = string2;
            }
        }
        return string;
    }

    protected void moveToNextBinding() {
        ++this.currentBindingIndex;
        while (!this.morePoints && this.currentBindingIndex < this.bindings.size()) {
            this.currentBinding = this.bindings.get(this.currentBindingIndex);
            this.currentState = this.states.get(this.currentBindingIndex);
            this.morePoints = this.currentState.morePoints;
            if (this.morePoints) continue;
            ++this.currentBindingIndex;
        }
    }

    protected void resetBindings() throws SQLException {
        for (int i2 = 0; i2 < this.bindings.size(); ++i2) {
            AbstractResultSetBinding abstractResultSetBinding = this.bindings.get(i2);
            ResultSet resultSet = abstractResultSetBinding.sourceResultSet;
            resultSet.beforeFirst();
            ResultSetState resultSetState = this.states.get(i2);
            int n2 = 0;
            boolean bl = resultSet.next();
            if (bl) {
                bl = abstractResultSetBinding.rowOrColumn ? this.determineRowPoints(abstractResultSetBinding) : this.determineColumnPoints(abstractResultSetBinding);
            }
            resultSetState.reset(bl, n2);
        }
        this.currentBindingIndex = -1;
        this.morePoints = false;
        this.moveToNextBinding();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ThresholdList
    implements ThresholdIterator {
        protected List<DataThreshold> thresholds;
        protected Iterator<DataThreshold> thresholdIterator;

        public void setThresholds(List<DataThreshold> list) {
            this.thresholds = list;
            this.thresholdIterator = null;
        }

        @Override
        public boolean hasMoreThresholds() {
            boolean bl;
            if (this.thresholds == null) {
                return false;
            }
            if (this.thresholdIterator == null) {
                this.thresholdIterator = this.thresholds.iterator();
            }
            if (!(bl = this.thresholdIterator.hasNext())) {
                this.thresholdIterator = null;
            }
            return bl;
        }

        @Override
        public AbstractThreshold getNextThreshold() {
            if (this.thresholds == null) {
                return null;
            }
            if (this.thresholdIterator == null) {
                this.thresholdIterator = this.thresholds.iterator();
            }
            return this.thresholdIterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MarkerList
    implements MarkerIterator {
        protected List<DataMarker> markers;
        protected Iterator<DataMarker> markerIterator;

        public void setMarkers(List<DataMarker> list) {
            this.markers = list;
            this.markerIterator = null;
        }

        @Override
        public boolean hasMoreMarkers() {
            boolean bl;
            if (this.markers == null) {
                return false;
            }
            if (this.markerIterator == null) {
                this.markerIterator = this.markers.iterator();
            }
            if (!(bl = this.markerIterator.hasNext())) {
                this.markerIterator = null;
            }
            return bl;
        }

        @Override
        public DataMarker getNextMarker() {
            if (this.markers == null) {
                return null;
            }
            if (this.markerIterator == null) {
                this.markerIterator = this.markers.iterator();
            }
            return this.markerIterator.next();
        }
    }
}

