/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.chart.data.XMLDataHandler;
import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JCXMLDataInterpreter
extends JCDataInterpreter
implements Serializable {
    public static String DATA_DTD_NAME = "JCChartData.dtd";
    protected LoadProperties loadProperties;

    public JCXMLDataInterpreter() {
        this.loadProperties = new LoadProperties();
    }

    public JCXMLDataInterpreter(LoadProperties loadProperties) {
        this.loadProperties = loadProperties;
    }

    public JCXMLDataInterpreter(BaseDataSource baseDataSource) throws IOException {
        super(baseDataSource);
    }

    public JCXMLDataInterpreter(BaseDataSource baseDataSource, LoadProperties loadProperties) throws IOException {
        this(baseDataSource);
        this.loadProperties = loadProperties;
    }

    protected void ctor(Reader reader) throws IOException {
        this.loadData(new InputSource(reader), true);
    }

    public synchronized void loadData(InputSource inputSource, boolean bl) throws IOException {
        if (inputSource.getSystemId() == null) {
            if (this.loadProperties != null) {
                inputSource.setSystemId(this.loadProperties.getLocalEntitySystemId());
            } else {
                inputSource.setSystemId("");
            }
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(bl);
        if (this.baseDS == null) {
            this.baseDS = new BaseDataSource();
        }
        XMLDataHandler xMLDataHandler = new XMLDataHandler(this.baseDS);
        try {
            ErrorHandler errorHandler;
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(xMLDataHandler);
            ErrorHandler errorHandler2 = errorHandler = this.loadProperties == null ? null : this.loadProperties.getXmlErrorHandler();
            if (errorHandler == null) {
                errorHandler = new JCXMLErrorPrinter();
            }
            xMLReader.setErrorHandler(errorHandler);
            xMLReader.setEntityResolver(new JCXMLDTDResolver(DATA_DTD_NAME, xMLDataHandler.getClass()));
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new JCParseException(sAXException.getMessage(), sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JCParseException(parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }
}

