/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.JCDataInterpreter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class JCInputStreamDataSource
extends BaseDataSource {
    protected JCDataInterpreter interpreter = null;
    protected String charsetName = "JISAutoDetect";

    public JCInputStreamDataSource(InputStream inputStream) throws IOException {
        this.ctor(inputStream);
    }

    public JCInputStreamDataSource(InputStream inputStream, JCDataInterpreter jCDataInterpreter) throws IOException {
        this.interpreter = jCDataInterpreter;
        this.ctor(inputStream);
    }

    public JCInputStreamDataSource(InputStream inputStream, JCDataInterpreter jCDataInterpreter, String string) throws IOException {
        this.interpreter = jCDataInterpreter;
        if (string == null) {
            throw new IllegalArgumentException("charsetName cannot be null");
        }
        this.charsetName = string;
        this.ctor(inputStream);
    }

    protected JCInputStreamDataSource() throws IOException {
    }

    protected JCInputStreamDataSource(JCDataInterpreter jCDataInterpreter) throws IOException {
        this.interpreter = jCDataInterpreter;
    }

    protected JCInputStreamDataSource(JCDataInterpreter jCDataInterpreter, String string) throws IOException {
        this.interpreter = jCDataInterpreter;
        if (string == null) {
            throw new IllegalArgumentException("charsetName cannot be null");
        }
        this.charsetName = string;
    }

    public JCDataInterpreter getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(JCDataInterpreter jCDataInterpreter) {
        this.interpreter = jCDataInterpreter;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("charsetName cannot be null");
        }
        this.charsetName = string;
    }

    protected void ctor(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.charsetName));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.charsetName.equals("JISAutoDetect")) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            throw unsupportedEncodingException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (this.charsetName.equals("JISAutoDetect")) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            throw unsupportedOperationException;
        }
        this.ctor(bufferedReader);
    }

    protected void ctor(Reader reader) throws IOException {
        if (this.interpreter == null) {
            try {
                String string = "com.klg.jclass.chart.data.JCDefaultDataInterpreter";
                this.interpreter = (JCDataInterpreter)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.interpreter = null;
                return;
            }
        }
        this.interpreter.setBaseDataSource(this);
        this.interpreter.ctor(reader);
    }
}

