/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataEvent;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCDataThreshold;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.ChartDataSourceUtil;
import com.klg.jclass.util.ImageMapInfo;
import java.util.Locale;

public class JCDefaultDataSource
extends BaseDataSource {
    protected boolean suppressMultipleGeneration = false;
    protected static double[][] defaultY = new double[][]{{20.0, 22.0, 19.0, 24.0, 25.0}, {8.0, 12.0, 10.0, 12.0, 15.0}, {10.0, 16.0, 17.0, 15.0, 23.0}, {16.0, 19.0, 15.0, 22.0, 18.0}};

    public JCDefaultDataSource() {
        this(Locale.getDefault());
    }

    public JCDefaultDataSource(Locale locale) {
        this(null, defaultY, null, null, null);
        this.generateLabels(locale);
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String string) {
        this(dArray, dArray2, stringArray, stringArray2, string, null, null, null, null, null);
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String[][] stringArray3, String string) {
        this(dArray, dArray2, stringArray, stringArray2, stringArray3, string, (JCDataThreshold[][])null, null, null, (ImageMapInfo[][])null, null, null, null);
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[][] stringArray2, TimeLineState[] timeLineStateArray, String[] stringArray3, String string) {
        this(dArray, dArray2, null, stringArray, stringArray2, string, (JCDataThreshold[][])null, timeLineStateArray, stringArray3, (ImageMapInfo[][])null, null, null, null);
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String string, JCDataThreshold[][] jCDataThresholdArray) {
        this(dArray, dArray2, stringArray, stringArray2, string, jCDataThresholdArray, null, null, null, null);
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String string, String[][] stringArray3, String[][] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, String[] stringArray8, String[] stringArray9, String[] stringArray10) {
        this(dArray, dArray2, stringArray, stringArray2, string, null, ImageMapInfo.createImageMapInfoArray(stringArray3, stringArray4), ImageMapInfo.createImageMapInfoArray(stringArray5, stringArray6), ImageMapInfo.createImageMapInfoArray(stringArray7, stringArray8), ImageMapInfo.createImageMapInfoArray(stringArray9, stringArray10));
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String string, ImageMapInfo[][] imageMapInfoArray, ImageMapInfo[] imageMapInfoArray2, ImageMapInfo[] imageMapInfoArray3, ImageMapInfo[] imageMapInfoArray4) {
        this(dArray, dArray2, stringArray, stringArray2, string, null, imageMapInfoArray, imageMapInfoArray2, imageMapInfoArray3, imageMapInfoArray4);
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String string, JCDataThreshold[][] jCDataThresholdArray, ImageMapInfo[][] imageMapInfoArray, ImageMapInfo[] imageMapInfoArray2, ImageMapInfo[] imageMapInfoArray3, ImageMapInfo[] imageMapInfoArray4) {
        this.xvalues = dArray;
        this.yvalues = dArray2;
        this.pointLabels = stringArray;
        this.seriesLabels = stringArray2;
        this.name = string;
        this.dataThresholds = jCDataThresholdArray;
        this.pointImageMapInfo = imageMapInfoArray;
        this.clusterImageMapInfo = imageMapInfoArray2;
        this.seriesImageMapInfo = imageMapInfoArray3;
        this.legendImageMapInfo = imageMapInfoArray4;
        this.check();
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String[][] stringArray3, String string, JCDataThreshold[][] jCDataThresholdArray, TimeLineState[] timeLineStateArray, String[] stringArray4, ImageMapInfo[][] imageMapInfoArray, ImageMapInfo[] imageMapInfoArray2, ImageMapInfo[] imageMapInfoArray3, ImageMapInfo[] imageMapInfoArray4) {
        this.xvalues = dArray;
        this.yvalues = dArray2;
        this.pointLabels = stringArray;
        this.seriesLabels = stringArray2;
        this.dataLabels = stringArray3;
        this.name = string;
        this.dataThresholds = jCDataThresholdArray;
        this.timelineStates = timeLineStateArray;
        this.trackLabels = stringArray4;
        this.pointImageMapInfo = imageMapInfoArray;
        this.clusterImageMapInfo = imageMapInfoArray2;
        this.seriesImageMapInfo = imageMapInfoArray3;
        this.legendImageMapInfo = imageMapInfoArray4;
        this.check();
    }

    public JCDefaultDataSource(BaseDataSource baseDataSource) {
        if (baseDataSource != null) {
            this.xvalues = baseDataSource.xvalues;
            this.yvalues = baseDataSource.yvalues;
            this.pointLabels = baseDataSource.pointLabels;
            this.seriesLabels = baseDataSource.seriesLabels;
            this.dataLabels = baseDataSource.dataLabels;
            this.dataThresholds = baseDataSource.dataThresholds;
            this.timelineStates = baseDataSource.timelineStates;
            this.trackLabels = baseDataSource.trackLabels;
            this.name = baseDataSource.name;
            this.holeValue = baseDataSource.holeValue;
            this.pointImageMapInfo = baseDataSource.pointImageMapInfo;
            this.clusterImageMapInfo = baseDataSource.clusterImageMapInfo;
            this.seriesImageMapInfo = baseDataSource.seriesImageMapInfo;
            this.legendImageMapInfo = baseDataSource.legendImageMapInfo;
            this.cloneArrays = baseDataSource.cloneArrays;
            this.check();
        }
    }

    protected void check() {
        if (this.yvalues == null || this.yvalues.length <= 0) {
            return;
        }
        if (this.xvalues == null) {
            int n2 = this.yvalues[0].length;
            if (this.suppressMultipleGeneration) {
                this.xvalues = ChartDataSourceUtil.generateSingleXSeries(n2);
                return;
            }
            boolean bl = false;
            for (int i2 = 1; i2 < this.yvalues.length; ++i2) {
                if (this.yvalues[i2].length == n2) continue;
                bl = true;
                break;
            }
            this.xvalues = bl ? ChartDataSourceUtil.generateMultipleXSeries(this.yvalues) : ChartDataSourceUtil.generateSingleXSeries(n2);
        }
    }

    protected void generateLabels() {
        this.generateLabels(Locale.getDefault());
    }

    protected void generateLabels(Locale locale) {
        int n2;
        this.name = JCChartBundle.string("com.klg.jclass.chart.Key165", locale);
        if (this.yvalues == null) {
            return;
        }
        this.seriesLabels = new String[this.getNumSeries()];
        for (n2 = 0; n2 < this.seriesLabels.length; ++n2) {
            this.seriesLabels[n2] = JCChartBundle.string("com.klg.jclass.chart.Key127", locale) + (n2 + 1);
        }
        this.pointLabels = new String[this.getXSeries(0).length];
        for (n2 = 0; n2 < this.pointLabels.length; ++n2) {
            this.pointLabels[n2] = JCChartBundle.string("com.klg.jclass.chart.Key166", locale) + n2;
        }
    }

    protected void updateChart(int n2, int n3, int n4) {
        try {
            ChartDataEvent chartDataEvent = new ChartDataEvent(this, n2, n3, n4);
            this.fireChartDataEvent(chartDataEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setData(double[][] dArray, double[][] dArray2) {
        this.xvalues = dArray;
        this.yvalues = dArray2;
        this.check();
        this.updateChart(12, 0, 0);
    }

    public void setXSeries(int n2, double[] dArray) {
        if (n2 >= this.xvalues.length) {
            double[][] dArrayArray = new double[n2 + 1][];
            System.arraycopy(this.xvalues, 0, dArrayArray, 0, this.xvalues.length);
            for (int i2 = this.xvalues.length; i2 <= n2; ++i2) {
                dArrayArray[i2] = null;
            }
            this.xvalues = dArrayArray;
            this.xvalues[n2] = dArray;
            this.updateChart(12, 0, 0);
        } else {
            this.xvalues[n2] = dArray;
            this.updateChart(19, n2, 0);
        }
    }

    public void setYSeries(int n2, double[] dArray) {
        if (n2 >= this.yvalues.length) {
            double[][] dArrayArray = new double[n2 + 1][];
            System.arraycopy(this.yvalues, 0, dArrayArray, 0, this.yvalues.length);
            for (int i2 = this.yvalues.length; i2 <= n2; ++i2) {
                dArrayArray[i2] = null;
            }
            this.yvalues = dArrayArray;
            this.yvalues[n2] = dArray;
            this.updateChart(12, 0, 0);
        } else {
            this.yvalues[n2] = dArray;
            this.updateChart(1, n2, 0);
        }
    }

    public void setPointLabels(String[] stringArray) {
        this.pointLabels = stringArray;
        this.updateChart(6, 0, 0);
    }

    public void setSeriesLabels(String[] stringArray) {
        this.seriesLabels = stringArray;
        this.updateChart(8, 0, 0);
    }

    public void setTrackLabels(String[] stringArray) {
        this.trackLabels = stringArray;
        this.updateChart(24, 0, 0);
    }

    public void setTimelineStates(TimeLineState[] timeLineStateArray) {
        this.timelineStates = timeLineStateArray;
        this.updateChart(22, 0, 0);
    }

    public void setDataLabels(String[][] stringArray) {
        this.dataLabels = stringArray;
        this.updateChart(21, 0, 0);
    }

    public void setDataLabels(int n2, String[] stringArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("seriesIndex must be non-negative");
        }
        if (this.dataLabels == null) {
            this.dataLabels = new String[0][];
        }
        if (n2 >= this.dataLabels.length) {
            String[][] stringArrayArray = new String[n2 + 1][];
            if (this.dataLabels.length > 0) {
                System.arraycopy(this.dataLabels, 0, stringArrayArray, 0, this.dataLabels.length);
            }
            for (int i2 = this.dataLabels.length; i2 <= n2; ++i2) {
                stringArrayArray[i2] = null;
            }
            this.dataLabels = stringArrayArray;
            this.dataLabels[n2] = stringArray;
        } else {
            this.dataLabels[n2] = stringArray;
        }
        this.updateChart(20, n2, 0);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDataThresholds(JCDataThreshold[][] jCDataThresholdArray) {
        this.dataThresholds = jCDataThresholdArray;
        this.updateChart(18, 0, 0);
    }

    public void setDataThreshold(int n2, JCDataThreshold[] jCDataThresholdArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("seriesIndex must be non-negative");
        }
        if (this.dataThresholds == null) {
            this.dataThresholds = new JCDataThreshold[0][];
        }
        if (n2 >= this.dataThresholds.length) {
            JCDataThreshold[][] jCDataThresholdArrayArray = new JCDataThreshold[n2 + 1][];
            if (this.dataThresholds.length > 0) {
                System.arraycopy(this.dataThresholds, 0, jCDataThresholdArrayArray, 0, this.dataThresholds.length);
            }
            for (int i2 = this.dataThresholds.length; i2 <= n2; ++i2) {
                jCDataThresholdArrayArray[i2] = null;
            }
            this.dataThresholds = jCDataThresholdArrayArray;
            this.dataThresholds[n2] = jCDataThresholdArray;
        } else {
            this.dataThresholds[n2] = jCDataThresholdArray;
        }
        this.updateChart(17, n2, 0);
    }

    public void setPointImageMapInfo(ImageMapInfo[][] imageMapInfoArray) {
        this.pointImageMapInfo = imageMapInfoArray;
        this.updateChart(16, 0, 0);
    }

    public void setPointImageMapInfo(String[][] stringArray, String[][] stringArray2) {
        this.setPointImageMapInfo(ImageMapInfo.createImageMapInfoArray(stringArray, stringArray2));
    }

    public void setPointImageMapInfo(int n2, ImageMapInfo[] imageMapInfoArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("seriesIndex must be non-negative");
        }
        if (this.pointImageMapInfo == null) {
            this.pointImageMapInfo = new ImageMapInfo[0][];
        }
        if (n2 >= this.pointImageMapInfo.length) {
            ImageMapInfo[][] imageMapInfoArrayArray = new ImageMapInfo[n2 + 1][];
            if (this.pointImageMapInfo.length > 0) {
                System.arraycopy(this.pointImageMapInfo, 0, imageMapInfoArrayArray, 0, this.pointImageMapInfo.length);
            }
            for (int i2 = this.pointImageMapInfo.length; i2 <= n2; ++i2) {
                imageMapInfoArrayArray[i2] = null;
            }
            this.pointImageMapInfo = imageMapInfoArrayArray;
            this.pointImageMapInfo[n2] = imageMapInfoArray;
        } else {
            this.pointImageMapInfo[n2] = imageMapInfoArray;
        }
        this.updateChart(16, 0, 0);
    }

    public void setPointImageMapInfo(int n2, String[] stringArray, String[] stringArray2) {
        this.setPointImageMapInfo(n2, ImageMapInfo.createImageMapInfoArray(stringArray, stringArray2));
    }

    public void setClusterImageMapInfo(ImageMapInfo[] imageMapInfoArray) {
        this.clusterImageMapInfo = imageMapInfoArray;
        this.updateChart(16, 0, 0);
    }

    public void setClusterImageMapInfo(String[] stringArray, String[] stringArray2) {
        this.setClusterImageMapInfo(ImageMapInfo.createImageMapInfoArray(stringArray, stringArray2));
    }

    public void setSeriesImageMapInfo(ImageMapInfo[] imageMapInfoArray) {
        this.seriesImageMapInfo = imageMapInfoArray;
        this.updateChart(16, 0, 0);
    }

    public void setSeriesImageMapInfo(String[] stringArray, String[] stringArray2) {
        this.setSeriesImageMapInfo(ImageMapInfo.createImageMapInfoArray(stringArray, stringArray2));
    }

    public void setLegendImageMapInfo(ImageMapInfo[] imageMapInfoArray) {
        this.legendImageMapInfo = imageMapInfoArray;
        this.updateChart(16, 0, 0);
    }

    public void setLegendImageMapInfo(String[] stringArray, String[] stringArray2) {
        this.setLegendImageMapInfo(ImageMapInfo.createImageMapInfoArray(stringArray, stringArray2));
    }

    public String buildDataSourceString() {
        return ChartDataSourceUtil.buildDataSourceString(this);
    }
}

