/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.util.io.HTMLTextUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;

public class JCDefaultDataInterpreter
extends JCDataInterpreter
implements Serializable {
    private StreamTokenizer tokenizer;
    private final char QUOTE = (char)39;

    public JCDefaultDataInterpreter(BaseDataSource baseDataSource) {
        super(baseDataSource);
    }

    public JCDefaultDataInterpreter() {
    }

    protected void ctor(Reader reader) throws IOException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(true);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
        this.init();
        this.tokenizer = null;
    }

    private double getNextDouble() throws IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            if (this.tokenizer.ttype == -3) {
                String string = this.tokenizer.sval;
                Double d2 = null;
                if (string.equalsIgnoreCase("HOLE")) {
                    d2 = new Double(this.baseDS.holeValue);
                } else if (string.equalsIgnoreCase("MAX")) {
                    d2 = new Double(Double.MAX_VALUE);
                } else if (string.equalsIgnoreCase("MIN")) {
                    d2 = new Double(Double.MIN_VALUE);
                } else if (string.equalsIgnoreCase("INFINITY")) {
                    d2 = new Double(Double.POSITIVE_INFINITY);
                } else {
                    try {
                        d2 = Double.valueOf(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (d2 != null) {
                    return d2;
                }
            }
            this.displayErrorMessage(2);
            throw new IOException("Error in data file format - " + this.tokenizer);
        }
        double d3 = this.tokenizer.nval;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -3 && this.tokenizer.sval != null && (this.tokenizer.sval.charAt(0) == 'e' || this.tokenizer.sval.charAt(0) == 'E')) {
            if (this.tokenizer.sval.length() == 1) {
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == -2) {
                    d3 *= Math.pow(10.0, this.tokenizer.nval);
                }
            } else {
                String string = this.tokenizer.sval;
                int n2 = Integer.valueOf(string.substring(1));
                d3 *= Math.pow(10.0, n2);
            }
        } else {
            this.tokenizer.pushBack();
        }
        return d3;
    }

    private void displayErrorMessage(int n2) {
        String string = "Error reading data: line " + this.tokenizer.lineno() + ": ";
        switch (n2) {
            case 1: {
                string = string + "Data must start with ARRAY or GENERAL and not";
                break;
            }
            case 2: {
                string = string + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string = string + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        string = this.tokenizer.ttype == 39 ? string + "'" + this.tokenizer.sval + "'" : (this.tokenizer.ttype == -3 ? string + this.tokenizer.sval : (this.tokenizer.ttype == -2 ? string + this.tokenizer.nval : string + this.tokenizer.toString()));
        System.err.println(string);
    }

    private synchronized void init() throws IOException {
        boolean bl;
        boolean bl2 = false;
        if (this.tokenizer.nextToken() != -3) {
            bl2 = true;
        } else if (this.tokenizer.sval.equals("debug") && this.tokenizer.nextToken() != -3) {
            bl2 = true;
        }
        if (bl2 || !this.tokenizer.sval.equals("array") && !this.tokenizer.sval.equals("general")) {
            this.displayErrorMessage(1);
            throw new IOException("Data must start with ARRAY or GENERAL");
        }
        boolean bl3 = this.tokenizer.sval.equals("array");
        if (this.tokenizer.nextToken() == 39) {
            String string = this.tokenizer.sval;
            if (string != null && string.length() > 0) {
                this.baseDS.name = HTMLTextUtil.processText(string);
            }
        } else {
            this.tokenizer.pushBack();
        }
        int n2 = (int)this.getNextDouble();
        int n3 = (int)this.getNextDouble();
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("t")) {
            bl = true;
        } else {
            bl = false;
            this.tokenizer.pushBack();
        }
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("hole")) {
            this.baseDS.holeValue = this.getNextDouble();
        } else {
            this.tokenizer.pushBack();
        }
        if (bl3) {
            this.readArrayData(n2, n3, bl);
        } else {
            this.readGeneralData(n2, n3, bl);
        }
        this.baseDS.seriesLabels = this.processStrings(this.baseDS.seriesLabels);
        this.baseDS.pointLabels = this.processStrings(this.baseDS.pointLabels);
    }

    protected String[] processStrings(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        boolean bl = false;
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            bl = true;
            break;
        }
        return bl ? stringArray : null;
    }

    private void readArrayData(int n2, int n3, boolean bl) throws IOException {
        this.baseDS.xvalues = new double[1][n3];
        this.baseDS.yvalues = new double[n2][n3];
        this.baseDS.seriesLabels = new String[n2];
        this.baseDS.pointLabels = new String[n3];
        if (bl) {
            String string;
            int n4;
            for (n4 = 0; n4 < n2 + 1; ++n4) {
                if (this.tokenizer.nextToken() == 39) {
                    if (n4 <= 0) continue;
                    string = this.tokenizer.sval;
                    this.baseDS.seriesLabels[n4 - 1] = HTMLTextUtil.processText(string);
                    continue;
                }
                this.tokenizer.pushBack();
                break;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (this.tokenizer.nextToken() == 39) {
                    string = this.tokenizer.sval;
                    this.baseDS.pointLabels[n4] = HTMLTextUtil.processText(string);
                } else {
                    this.tokenizer.pushBack();
                }
                this.baseDS.xvalues[0][n4] = this.getNextDouble();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.baseDS.yvalues[i2][n4] = this.getNextDouble();
                }
            }
        } else {
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                if (this.tokenizer.nextToken() == 39) {
                    String string = this.tokenizer.sval;
                    this.baseDS.pointLabels[n5] = HTMLTextUtil.processText(string);
                    continue;
                }
                this.tokenizer.pushBack();
            }
            for (int i3 = 0; i3 < n2 + 1; ++i3) {
                if (this.tokenizer.nextToken() == 39) {
                    if (i3 > 0) {
                        String string = this.tokenizer.sval;
                        this.baseDS.seriesLabels[i3 - 1] = HTMLTextUtil.processText(string);
                    }
                } else {
                    this.tokenizer.pushBack();
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    double d2 = this.getNextDouble();
                    if (i3 == 0) {
                        this.baseDS.xvalues[0][n5] = d2;
                        continue;
                    }
                    this.baseDS.yvalues[i3 - 1][n5] = d2;
                }
            }
        }
    }

    private void readGeneralData(int n2, int n3, boolean bl) throws IOException {
        int n4;
        this.baseDS.xvalues = new double[n2][];
        this.baseDS.yvalues = new double[n2][];
        this.baseDS.seriesLabels = new String[n2];
        this.baseDS.pointLabels = new String[n3];
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("labels")) {
            for (n4 = 0; n4 < n3; ++n4) {
                if (this.tokenizer.nextToken() != 39) {
                    this.displayErrorMessage(3);
                    throw new IOException("Error in reading point labels - " + this.tokenizer);
                }
                String string = this.tokenizer.sval;
                this.baseDS.pointLabels[n4] = HTMLTextUtil.processText(string);
            }
        } else {
            this.tokenizer.pushBack();
            this.baseDS.pointLabels = null;
        }
        if (bl) {
            for (n4 = 0; n4 < n2; ++n4) {
                if (this.tokenizer.nextToken() == 39) {
                    String string = this.tokenizer.sval;
                    this.baseDS.seriesLabels[n4] = HTMLTextUtil.processText(string);
                } else {
                    this.tokenizer.pushBack();
                }
                n3 = (int)this.getNextDouble();
                this.baseDS.xvalues[n4] = new double[n3];
                this.baseDS.yvalues[n4] = new double[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.baseDS.xvalues[n4][i2] = this.getNextDouble();
                    this.baseDS.yvalues[n4][i2] = this.getNextDouble();
                }
            }
        } else {
            for (n4 = 0; n4 < n2; ++n4) {
                if (this.tokenizer.nextToken() == 39) {
                    String string = this.tokenizer.sval;
                    this.baseDS.seriesLabels[n4] = HTMLTextUtil.processText(string);
                } else {
                    this.tokenizer.pushBack();
                }
                n3 = (int)this.getNextDouble();
                this.baseDS.xvalues[n4] = new double[n3];
                this.baseDS.yvalues[n4] = new double[n3];
                for (int i3 = 0; i3 < 2; ++i3) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        double d2 = this.getNextDouble();
                        if (i3 == 0) {
                            this.baseDS.xvalues[n4][i4] = d2;
                            continue;
                        }
                        this.baseDS.yvalues[n4][i4] = d2;
                    }
                }
            }
        }
    }
}

