/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataManageable;
import com.klg.jclass.chart.ChartDataManager;
import com.klg.jclass.chart.ChartDataSupport;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.LabelledChartDataModel;
import com.klg.jclass.chart.data.ChartDataSourceUtil;
import java.io.Serializable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JCChartSwingDataSource
extends ChartDataSupport
implements EditableChartDataModel,
LabelledChartDataModel,
HoleValueChartDataModel,
TableModelListener,
ChartDataManageable,
Serializable {
    protected TableModel tableModel = null;
    protected String[] pLabels = null;
    protected String dsName = "Legend";

    public JCChartSwingDataSource() {
    }

    public JCChartSwingDataSource(TableModel tableModel) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
    }

    public JCChartSwingDataSource(TableModel tableModel, String[] stringArray, String string) {
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this);
        this.pLabels = stringArray;
        this.dsName = string;
    }

    public synchronized boolean setDataItem(int n2, int n3, double d2) {
        if (this.tableModel == null || n2 < 0) {
            return false;
        }
        this.tableModel.setValueAt(new Double(d2), n3, n2);
        return true;
    }

    public double[] getXSeries(int n2) {
        if (this.tableModel == null) {
            return null;
        }
        int n3 = this.tableModel.getRowCount();
        return ChartDataSourceUtil.generateSingleXSeries(n3)[0];
    }

    public double[] getYSeries(int n2) {
        if (this.tableModel == null) {
            return null;
        }
        int n3 = this.tableModel.getRowCount();
        if (n3 == 0) {
            return null;
        }
        double[] dArray = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = this.tableModel.getValueAt(i2, n2);
            if (object == null) {
                dArray[i2] = this.getHoleValue();
                continue;
            }
            if (object instanceof Number) {
                dArray[i2] = ((Number)object).doubleValue();
                continue;
            }
            try {
                if (object instanceof String) {
                    dArray[i2] = Double.parseDouble((String)object);
                    continue;
                }
                dArray[i2] = Double.parseDouble(object.toString());
                continue;
            }
            catch (Exception exception) {
                dArray[i2] = 0.0;
            }
        }
        return dArray;
    }

    public int getNumSeries() {
        if (this.tableModel == null) {
            return 0;
        }
        return this.tableModel.getColumnCount();
    }

    public String[] getPointLabels() {
        return this.pLabels;
    }

    public void setPointLabels(String[] stringArray) {
        this.pLabels = stringArray;
    }

    public String[] getSeriesLabels() {
        if (this.tableModel == null) {
            return null;
        }
        int n2 = this.tableModel.getColumnCount();
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = this.tableModel.getColumnName(i2);
            if (string.trim().length() == 0) {
                stringArray[i2] = null;
            }
            stringArray[i2] = string;
        }
        return stringArray;
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setDataSourceName(String string) {
        this.dsName = string;
    }

    public double getHoleValue() {
        return Double.MAX_VALUE;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        if (n2 == -1) {
            this.fireChartDataEvent(12, 0, 0);
            return;
        }
        int n3 = tableModelEvent.getType();
        int n4 = tableModelEvent.getColumn();
        boolean bl = false;
        if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
            bl = true;
        }
        if (n3 == 0) {
            if (n4 == -1) {
                this.fireChartDataEvent(12, 0, 0);
            } else if (bl) {
                this.fireChartDataEvent(1, n4, 0);
            } else {
                this.fireChartDataEvent(1, n4, 0);
            }
        } else if (n3 == 1) {
            this.fireChartDataEvent(12, 0, 0);
        } else if (n3 == -1) {
            this.fireChartDataEvent(12, 0, 0);
        }
    }

    public ChartDataManager getChartDataManager() {
        return this;
    }
}

