/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.customizer;

import com.klg.jclass.chart.customizer.JCustomizerBundle;
import com.klg.jclass.chart.customizer.JPropertyPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JAddRemoveDialog
extends JPropertyPage
implements ActionListener {
    protected JPropertyPage editor;
    protected JPanel controls;
    protected JButton addButton;
    protected JButton previewButton;
    protected JButton removeButton;
    protected JButton cancelButton;
    public static int MODE_ADD = 1;
    public static int MODE_REMOVE = 3;
    private int currentMode = 0;
    private Object target;
    protected Object model;
    private static String[][] editorDialogs = new String[][]{{"ChartDataViewDialog", "DataViewCustomizer"}, {"JCAxisDialog", "AxisCustomizer"}, {"JChartLabelDialog", "ChartLabelTabs"}};

    public void init() {
        super.init();
        this.setToolTipText(JAddRemoveDialog.getPageTitle());
        this.setLayout(new BorderLayout());
        this.controls = new JPanel();
        this.controls.setLayout(new BorderLayout());
        this.editor = JAddRemoveDialog.getPage(this.getEditorName());
        this.editor.init();
        this.controls.add((Component)this.editor, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 2));
        this.addButton = new JButton(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key133"));
        this.addButton.addActionListener(this);
        jPanel.add(this.addButton);
        if (this.hasPreview()) {
            this.previewButton = new JButton(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key134"));
            this.previewButton.addActionListener(this);
            jPanel.add(this.previewButton);
        }
        this.removeButton = new JButton(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key135"));
        this.removeButton.addActionListener(this);
        jPanel.add(this.removeButton);
        this.cancelButton = new JButton(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key136"));
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        this.controls.add((Component)jPanel, "South");
        this.add((Component)this.controls, "Center");
        this.setMode(MODE_ADD);
    }

    public void setMode(int n2) {
        if (n2 != this.currentMode) {
            this.currentMode = n2;
            if (n2 == MODE_ADD) {
                this.addButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else if (n2 == MODE_REMOVE) {
                this.addButton.setEnabled(false);
                this.removeButton.setEnabled(true);
            }
        }
    }

    public int getMode() {
        return this.currentMode;
    }

    public boolean hasPreview() {
        return false;
    }

    public void showPreview() {
    }

    public void setObject(Object object) {
        if (object == null) {
            return;
        }
        this.target = object;
    }

    public void setModel(Object object) {
        if (object == null) {
            return;
        }
        this.model = object;
    }

    public void setValue(Object object) {
        this.setObject(object);
    }

    public Object getValue() {
        return this.target;
    }

    public void cancelAction() {
        JPropertyPage.getFrame(this).dispose();
    }

    public void previewAction() {
        this.showPreview();
    }

    public void removeAction() {
        if (this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.getValue());
        }
    }

    public void addAction() {
        if (this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.getValue());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.cancelAction();
        } else if (actionEvent.getSource() == this.previewButton) {
            this.previewAction();
        } else if (actionEvent.getSource() == this.removeButton) {
            this.removeAction();
        } else {
            this.addAction();
        }
    }

    public String getEditorName() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        for (int i2 = 0; i2 < editorDialogs.length; ++i2) {
            if (!editorDialogs[i2][0].equals(string2)) continue;
            return editorDialogs[i2][1];
        }
        return "JFieldEditor";
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("com.klg.jclass.chart.customizer.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JAddRemoveDialog.getPageTitle());
        serializable = new JAddRemoveDialog();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((JAddRemoveDialog)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        jFrame.setSize(dimension.width + 200, dimension.height + 100);
        jFrame.setVisible(true);
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key137");
    }

    public static String getPageName() {
        return "JAddRemoveDialog";
    }
}

