/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.beans.View3DEditor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class View3DCube
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected View3DEditor parent;
    protected int deltaX;
    protected int deltaY;
    protected boolean inDepthChange = false;
    protected Point first;
    protected Point last;
    protected int firstDepth;
    protected int firstElevation;
    protected int firstRotation;
    protected int scaleWidth;
    protected int scaleHeight;

    View3DCube(View3DEditor view3DEditor) {
        this.parent = view3DEditor;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private int getDepth() {
        return Integer.parseInt(this.parent.textDepth.getText());
    }

    private void setDepth(int n2) {
        this.parent.textDepth.setText(Integer.toString(n2));
        this.parent.setSelectedValue(true);
    }

    private int getElevation() {
        return Integer.parseInt(this.parent.textElevation.getText());
    }

    private void setElevation(int n2) {
        this.parent.textElevation.setText(Integer.toString(n2));
        this.parent.setSelectedValue(true);
    }

    private int getRotation() {
        return Integer.parseInt(this.parent.textRotation.getText());
    }

    private void setRotation(int n2) {
        this.parent.textRotation.setText(Integer.toString(n2));
        this.parent.setSelectedValue(true);
    }

    private boolean getChangeDepth() {
        return this.parent.cbDepth.isSelected();
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.paintComponent(graphics);
        graphics = graphics.create();
        Rectangle rectangle = null;
        rectangle = this.getBounds(rectangle);
        int n2 = rectangle.width / 3;
        int n3 = rectangle.height / 3;
        Color color = Color.black;
        n3 = n2 = Math.min(n2, n3);
        Rectangle rectangle2 = new Rectangle((rectangle.width - n2) / 2, (rectangle.height - n3) / 2, n2, n3);
        JCFillStyle jCFillStyle = new JCFillStyle(Color.red, 1);
        jCFillStyle.fillOutlineRect(graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, color);
        this.scaleWidth = (rectangle.width - rectangle2.width) / 2 - 8;
        this.scaleHeight = (rectangle.height - rectangle2.height) / 2 - 8;
        this.calculateDeltas(this.scaleWidth, this.scaleHeight);
        if (this.deltaX == 0 && this.deltaY == 0) {
            return;
        }
        Point[] pointArray = new Point[]{this.deltaY < 0 ? new Point(rectangle2.x, rectangle2.y) : new Point(rectangle2.x, rectangle2.y + rectangle2.height), new Point(this.deltaX, this.deltaY), new Point(rectangle2.width, 0), new Point(-this.deltaX, -this.deltaY)};
        Polygon polygon = JCChartUtil.pointsToPolygon(pointArray);
        if (this.deltaY <= 0) {
            jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, color);
        } else {
            jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, color);
        }
        pointArray[0] = this.deltaX < 0 ? new Point(rectangle2.x, rectangle2.y) : new Point(rectangle2.x + rectangle2.width, rectangle2.y);
        pointArray[1] = new Point(this.deltaX, this.deltaY);
        pointArray[2] = new Point(0, rectangle2.height);
        pointArray[3] = new Point(-this.deltaX, -this.deltaY);
        polygon = JCChartUtil.pointsToPolygon(pointArray);
        if (this.deltaX <= 0) {
            jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, color);
        } else {
            jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, color);
        }
        graphics.dispose();
    }

    void calculateDeltas(int n2, int n3) {
        if (this.parent == null) {
            return;
        }
        int n4 = this.getDepth();
        int n5 = this.getElevation();
        int n6 = this.getRotation();
        double d2 = JCChartUtil.degToRad(n6);
        double d3 = JCChartUtil.degToRad(n5);
        double d4 = Math.sin(d2);
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = (double)n4 / 80.0;
        double d8 = JCChartUtil.max(1.0, n2);
        double d9 = (d8 /= 1.0 + JCChartUtil.abs(d4) * d6 * d7) * d7;
        this.deltaX = (int)(d9 * d4 * d6);
        this.deltaY = (int)(-d9 * d5);
        int n7 = n2;
        if (Math.abs(this.deltaX) > n7) {
            this.deltaX = this.deltaX < 0 ? -n7 : n7;
        }
        n7 = n3;
        if (Math.abs(this.deltaY) > n7) {
            this.deltaY = this.deltaY < 0 ? -n7 : n7;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.inDepthChange = this.getChangeDepth();
        this.first = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.last = null;
        this.firstDepth = this.getDepth();
        this.firstElevation = this.getElevation();
        this.firstRotation = this.getRotation();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.first = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.first == null) {
            return;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.last == null) {
            this.last = new Point(n2, n3);
            return;
        }
        if (n2 == this.last.x && n3 == this.last.y) {
            return;
        }
        int n4 = n3 - this.first.y;
        int n5 = n2 - this.first.x;
        this.last.x = n2;
        this.last.y = n3;
        if (this.inDepthChange) {
            int n6 = this.firstDepth;
            this.setDepth(n6 += n4);
        } else {
            double d2 = 90.0 / (double)this.scaleWidth;
            double d3 = 90.0 / (double)this.scaleHeight;
            int n7 = this.firstElevation;
            int n8 = this.firstRotation;
            this.setElevation(n7 += (int)((double)n4 * d3));
            this.setRotation(n8 -= (int)((double)n5 * d2));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

