/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioButtonImageEditor
extends JPanel
implements PropertyEditor,
ItemListener {
    protected transient Image[] images;
    protected String[] strings;
    protected int[] values;
    protected String prepend = "";
    protected int rows;
    protected int cols;
    protected int numImages;
    protected boolean upperCaseEnum = true;
    private JPanel orientPanel = null;
    private Object[] radioButtons = null;
    private JRadioButton currentButton = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public void init(int n2, String[] stringArray, int[] nArray, Image[] imageArray, int n3, int n4, String string) {
        this.numImages = n2;
        this.strings = stringArray;
        this.values = nArray;
        this.images = imageArray;
        this.rows = n3;
        this.cols = n4;
        this.prepend = string;
        this.init();
    }

    protected void init() {
        this.setLayout(new GridLayout(1, 1));
        this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.orientPanel = new JPanel();
        this.orientPanel.setBorder(BorderFactory.createTitledBorder(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key174")));
        this.orientPanel.setLayout(new GridLayout(this.rows, this.cols));
        this.radioButtons = new Object[this.numImages];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i2 = 0; i2 < this.numImages; ++i2) {
            JRadioButton jRadioButton = new JRadioButton(new ImageIcon(this.images[i2]));
            this.radioButtons[i2] = jRadioButton;
            buttonGroup.add(jRadioButton);
            this.orientPanel.add(jRadioButton);
            jRadioButton.addItemListener(this);
        }
        this.add(this.orientPanel);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public String getAsText() {
        return "Click to edit ...";
    }

    public String[] getTags() {
        return null;
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "NULL";
        }
        if (this.upperCaseEnum) {
            return this.prepend + this.getValueAsText().toUpperCase();
        }
        return this.prepend + this.getValueAsText();
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n2);
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    protected String getValueAsText() {
        return JCTypeConverter.fromEnum(this.getButtonValue(this.currentButton), this.strings, this.values);
    }

    public Object getValue() {
        return new Integer(this.getButtonValue(this.currentButton));
    }

    public void setValue(Object object) {
        this.setCurrentButton(this.getRadioButton(((Number)object).intValue()), true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            if (jRadioButton == null || itemEvent.getStateChange() != 1 || jRadioButton == this.currentButton) {
                return;
            }
            boolean bl = jRadioButton.isSelected();
            if (!bl) {
                return;
            }
            this.setCurrentButton(jRadioButton, true);
        }
    }

    protected void setCurrentButton(JRadioButton jRadioButton, boolean bl) {
        if (jRadioButton != null) {
            if (this.currentButton != null) {
                this.currentButton.setBorderPainted(false);
            }
            jRadioButton.setBorderPainted(true);
            this.currentButton = jRadioButton;
            this.currentButton.setSelected(true);
            if (bl) {
                this.support.firePropertyChange("", null, null);
            }
        }
    }

    protected int getButtonValue(JRadioButton jRadioButton) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.radioButtons.length; ++i2) {
            if (this.radioButtons[i2] != jRadioButton) continue;
            n2 = i2;
            break;
        }
        if (n2 >= 0) {
            return this.values[n2];
        }
        return n2;
    }

    protected JRadioButton getRadioButton(int n2) {
        JRadioButton jRadioButton = null;
        for (int i2 = 0; i2 < this.radioButtons.length; ++i2) {
            if (this.values[i2] != n2) continue;
            jRadioButton = (JRadioButton)this.radioButtons[i2];
            break;
        }
        return jRadioButton;
    }
}

