/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.beans.AxisOrientationAdapter;
import com.klg.jclass.chart.beans.AxisOrientationWrapper;
import com.klg.jclass.chart.beans.BeanTextParser;
import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.chart.beans.MultiChart;
import com.klg.jclass.chart.beans.RadioEditor;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AxisOrientationEditor
extends RadioEditor {
    protected AxisOrientationAdapter editor;
    protected JLabel otheraxis_lb;
    protected String[] paxis_names;
    AxisOrientationWrapper wrap = null;

    public AxisOrientationEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    protected JPanel makePropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key213")));
        jPanel.setLayout(new BorderLayout(1, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key214") + " : ", 4));
        this.otheraxis_lb = new JLabel("  ", 2);
        jPanel2.add(this.otheraxis_lb);
        this.editor = new AxisOrientationAdapter(this);
        jPanel.add("North", jPanel2);
        jPanel.add("Center", this.editor);
        this.add("Center", jPanel);
        return jPanel;
    }

    public void setValue(Object object) {
        if (object != null) {
            try {
                this.wrap = (AxisOrientationWrapper)object;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.wrap == null) {
            this.wrap = new AxisOrientationWrapper(this.numOfRadios);
        }
        this.paxis_names = MultiChart.AXIS_RADIO_NAMES;
        this.switchValues(this.radioSel);
    }

    protected void switchValues(int n2) {
        if (n2 < 0 || this.wrap == null) {
            return;
        }
        this.editor.setSelectedValue(this.wrap.orientation[n2], true, false);
        if (this.wrap.other_axis_index[n2] >= 0) {
            this.otheraxis_lb.setText(this.paxis_names[this.wrap.other_axis_index[n2]]);
        } else {
            String string = JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key215");
            this.otheraxis_lb.setText(string);
        }
        this.validate();
    }

    public Object getValue() {
        return this.wrap;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Vector vector = BeanTextParser.parse(string);
        if (vector.size() != 1) {
            throw new IllegalArgumentException();
        }
        AxisOrientationWrapper axisOrientationWrapper = null;
        try {
            axisOrientationWrapper = new AxisOrientationWrapper((String)vector.elementAt(0));
            this.setValue(axisOrientationWrapper);
            this.support.firePropertyChange("", null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public String getAsText() {
        if (this.wrap != null) {
            return this.wrap.toString();
        }
        return null;
    }

    public String getJavaInitializationString() {
        return "new com.klg.jclass.chart.beans.AxisOrientationWrapper(" + this.wrap + ")";
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, 300);
        dimension.height += 300;
        return dimension;
    }

    protected void setProperty(int n2) {
        this.wrap.orientation[this.radioSel] = n2;
        if (this.wrap.other_axis_index[this.radioSel] >= 0) {
            this.wrap.orientation[this.wrap.other_axis_index[this.radioSel]] = n2;
        }
        this.wrap.trigger_index = this.radioSel;
    }
}

