/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.beans.AxisMiscWrapper;
import com.klg.jclass.chart.beans.BeanTextParser;
import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.chart.beans.MultiChart;
import com.klg.jclass.chart.beans.RadioEditor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AxisMiscEditor
extends RadioEditor
implements ItemListener {
    protected JCheckBox show_cb;
    protected JCheckBox edit_cb;
    protected JCheckBox log_cb;
    AxisMiscWrapper wrap = null;

    public AxisMiscEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    protected JPanel makePropertyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key210")));
        jPanel.setLayout(new GridLayout(1, 3));
        this.show_cb = new JCheckBox(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key191"));
        this.edit_cb = new JCheckBox(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key211"));
        this.log_cb = new JCheckBox(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key212"));
        jPanel.add(this.show_cb);
        jPanel.add(this.edit_cb);
        jPanel.add(this.log_cb);
        this.add("Center", jPanel);
        this.show_cb.addItemListener(this);
        this.edit_cb.addItemListener(this);
        this.log_cb.addItemListener(this);
        return jPanel;
    }

    public void setValue(Object object) {
        if (object != null) {
            try {
                this.wrap = (AxisMiscWrapper)object;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.wrap == null) {
            this.wrap = new AxisMiscWrapper(this.numOfRadios);
        }
        this.switchValues(this.radioSel);
    }

    protected void switchValues(int n2) {
        if (n2 < 0 || this.wrap == null) {
            return;
        }
        if (this.show_cb.isSelected() != this.wrap.showing[n2]) {
            this.show_cb.setSelected(this.wrap.showing[n2]);
        }
        if (this.edit_cb.isSelected() != this.wrap.editable[n2]) {
            this.edit_cb.setSelected(this.wrap.editable[n2]);
        }
        if (this.log_cb.isSelected() != this.wrap.logarithmic[n2]) {
            this.log_cb.setSelected(this.wrap.logarithmic[n2]);
        }
    }

    public Object getValue() {
        return this.wrap;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Vector vector = BeanTextParser.parse(string);
        if (vector.size() != 3) {
            throw new IllegalArgumentException();
        }
        AxisMiscWrapper axisMiscWrapper = null;
        try {
            axisMiscWrapper = new AxisMiscWrapper((String)vector.elementAt(0), (String)vector.elementAt(1), (String)vector.elementAt(2));
            this.setValue(axisMiscWrapper);
            this.support.firePropertyChange("", null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public String getAsText() {
        if (this.wrap != null) {
            return this.wrap.toString();
        }
        return null;
    }

    public String getJavaInitializationString() {
        return "new com.klg.jclass.chart.beans.AxisMiscWrapper(" + this.wrap + ")";
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, 400);
        dimension.height += 200;
        return dimension;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object instanceof JCheckBox) {
            if (object == this.show_cb) {
                this.wrap.showing[this.radioSel] = this.show_cb.isSelected();
                this.support.firePropertyChange("", null, null);
            } else if (object == this.edit_cb) {
                this.wrap.editable[this.radioSel] = this.edit_cb.isSelected();
                this.support.firePropertyChange("", null, null);
            } else if (object == this.log_cb) {
                this.wrap.logarithmic[this.radioSel] = this.log_cb.isSelected();
                this.support.firePropertyChange("", null, null);
            }
        }
    }
}

