/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ActionHandler;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import java.awt.Point;
import java.awt.Rectangle;

public class ZoomHandler
extends ActionHandler {
    protected Point first = null;
    protected Point last = null;

    protected ZoomHandler() {
    }

    protected void start(int n2, int n3) {
        this.first = new Point(n2, n3);
        this.last = null;
    }

    protected void animate(int n2, int n3) {
        if (this.first == null) {
            return;
        }
        if (this.last == null) {
            this.last = new Point(n2, n3);
            this.parent.drawRubberBand(this.last, this.first);
            return;
        }
        this.parent.drawRubberBand(this.last, this.first);
        this.last.x = n2;
        this.last.y = n3;
        this.parent.drawRubberBand(this.last, this.first);
    }

    protected void reanimate(int n2, int n3) {
        this.last = new Point(n2, n3);
        this.parent.drawRubberBand(this.last, this.first);
    }

    protected void end(int n2, int n3) {
        double d2;
        double d3;
        JCAxis jCAxis;
        JCAxis jCAxis2;
        boolean bl = false;
        this.parent.drawRubberBand(this.last, this.first);
        Rectangle rectangle = this.parent.getDrawingArea();
        JCAxis jCAxis3 = this.parent.getHorizActionAxis();
        JCAxis jCAxis4 = this.parent.getVertActionAxis();
        if (jCAxis3 == null || jCAxis4 == null) {
            return;
        }
        if (jCAxis3.isVertical() && !jCAxis4.isVertical()) {
            jCAxis2 = jCAxis4;
            jCAxis = jCAxis3;
        } else if (!jCAxis3.isVertical() && jCAxis4.isVertical()) {
            jCAxis2 = jCAxis3;
            jCAxis = jCAxis4;
        } else {
            throw new IllegalStateException("ZoomHandler: Weird axes!");
        }
        int n4 = 7;
        if (Math.abs(n2 - this.first.x) + Math.abs(n3 - this.first.y) < n4) {
            int n5 = 10;
            this.first.x = Math.max(n2 - n5, rectangle.x);
            n2 = Math.min(n2 + n5, rectangle.x + rectangle.width);
            this.first.y = Math.max(n3 - n5, rectangle.y);
            n3 = Math.min(n3 + n5, rectangle.y + rectangle.height);
        }
        JCChart jCChart = this.getChart();
        if (jCAxis2.editable && !jCAxis2.isPolarRadar()) {
            d3 = jCAxis2.toData(this.first.x - rectangle.x);
            d2 = jCAxis2.toData(n2 - rectangle.x);
            if (jCChart != null) {
                jCChart.zoom(d3, d2, jCAxis2, false);
                bl = true;
            }
        }
        if (jCAxis.editable && !jCAxis.isPolarRadar()) {
            d3 = jCAxis.toData(this.first.y - rectangle.y);
            d2 = jCAxis.toData(n3 - rectangle.y);
            if (jCChart != null) {
                jCChart.zoom(d3, d2, jCAxis, false);
                bl = true;
            }
        }
        if (bl) {
            this.parent.setChanged(true, 2);
        }
    }
}

