/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ActionHandler;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import java.awt.Point;

public class TranslateHandler
extends ActionHandler {
    protected JCAxis xAxis;
    protected JCAxis yAxis;
    protected Point last = null;
    protected double xRange;
    protected double yRange;

    protected TranslateHandler() {
    }

    protected void start(int n2, int n3) {
        JCAxis jCAxis = this.parent.getHorizActionAxis();
        JCAxis jCAxis2 = this.parent.getVertActionAxis();
        if (jCAxis != null && jCAxis2 != null && jCAxis.isVertical() == jCAxis2.isVertical()) {
            JCChart jCChart = jCAxis.getParentChart();
            if (jCChart != null) {
                String string = JCChartBundle.string("com.klg.jclass.chart.Key45", this.parent.getLocale());
                jCChart.getErrorLog().logErrorMessage(string);
            }
            return;
        }
        this.parent.setInAction(true);
        this.last = new Point(n2, n3);
        if (jCAxis != null) {
            if (jCAxis.isVertical()) {
                this.yAxis = jCAxis;
            } else {
                this.xAxis = jCAxis;
            }
        }
        if (jCAxis2 != null) {
            if (jCAxis2.isVertical()) {
                this.yAxis = jCAxis2;
            } else {
                this.xAxis = jCAxis2;
            }
        }
        if (this.xAxis != null && this.xAxis.editable && this.getChart() != null) {
            this.getChart().translateStart(this.xAxis);
        }
        if (this.yAxis != null && this.yAxis.editable && this.getChart() != null) {
            this.getChart().translateStart(this.yAxis);
        }
        if (this.xAxis != null) {
            this.xRange = this.xAxis.range();
        }
        if (this.yAxis != null) {
            this.yRange = this.yAxis.range();
        }
    }

    protected void animate(int n2, int n3) {
        double d2;
        int n4;
        if (this.last == null) {
            return;
        }
        boolean bl = false;
        JCChart jCChart = this.getChart();
        if (this.xAxis != null && this.xAxis.editable && (n4 = 100 * (this.last.x - n2) / this.parent.getPlotRect().width) != 0) {
            d2 = this.xRange * (double)n4 / 100.0;
            if (jCChart != null) {
                jCChart.translate(d2, this.xAxis, false);
            }
            bl = true;
            this.last.x = n2;
        }
        if (this.yAxis != null && this.yAxis.editable && (n4 = 100 * (n3 - this.last.y) / this.parent.getPlotRect().height) != 0) {
            d2 = this.yRange * (double)n4 / 100.0;
            if (jCChart != null) {
                jCChart.translate(d2, this.yAxis, false);
            }
            bl = true;
            this.last.y = n3;
        }
        if (bl) {
            this.parent.setChanged(true, 2);
        }
    }

    protected void reanimate(int n2, int n3) {
    }

    protected void end(int n2, int n3) {
        this.parent.setInAction(false);
        if (this.parent.getFastAction()) {
            this.parent.setChanged(true, 2);
        }
    }
}

