/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.DefaultTimeLineLayout;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.JCTimeLineChartFormat;
import com.klg.jclass.chart.JCTimelineDataIndex;
import com.klg.jclass.chart.JCTimelinePoint;
import com.klg.jclass.chart.JCTrackInfo;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.PickShape;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.chart.SteppedTimeLineLayout;
import com.klg.jclass.chart.TimeLineInterval;
import com.klg.jclass.chart.TimeLineLayout;
import com.klg.jclass.chart.TimeLineState;
import com.klg.jclass.chart.TimeLineTrack;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLineChartDraw
extends ChartDraw
implements Serializable {
    protected static final double INVALID = Double.MAX_VALUE;
    protected static final double MIN_Y = 0.0;
    protected static final double MAX_Y = 100.0;
    protected TimeLineLayout timeLineLayout = null;
    protected int trackHeight;
    protected int nTracks;
    protected double yHeightDataCoords;
    protected double vSpaceDataCoords;
    protected JCTimeLineChartFormat format = null;

    @Override
    public void recalc() {
        Hashtable<ChartDataViewSeries, List<TimeLineTrack>> hashtable;
        super.recalc();
        this.format = (JCTimeLineChartFormat)this.dataObject.getChartFormat();
        double d2 = this.format.getPercentageHeight();
        this.seriesList = this.dataObject.getSeries();
        int n2 = this.seriesList.size();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        if (this.xaxis == null || this.yaxis == null) {
            return;
        }
        int n3 = 100;
        double d3 = (double)n3 * d2 / 100.0;
        double d4 = ((double)n3 - d3) * d2 / 100.0;
        this.vSpaceDataCoords = d4 / (double)(n2 + 1);
        if (this.format.getLayoutType() == 1) {
            int object;
            int n4 = (int)Math.round((double)(this.yaxis.toPixel(0.0) - this.yaxis.toPixel(100.0)) * d2 / (double)(n2 * 100));
            int n5 = this.findMaxSymbolSize();
            boolean n6 = false;
            if (this.format.intervalLabelMode != 0) {
                Graphics graphics = this.chartArea.getGraphics();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                object = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            }
            this.trackHeight = Math.max(n5, object);
            this.yHeightDataCoords = this.yaxis.toData(this.yaxis.toPixel(0.0) - this.trackHeight);
            int n7 = n4 / this.trackHeight;
            n7 = Math.max(1, n7);
            this.nTracks = n7 * n2;
            this.timeLineLayout = new SteppedTimeLineLayout(this.dataObject, n7);
            this.timeLineLayout.layoutChart();
            hashtable = this.timeLineLayout.getTracks();
        } else {
            this.timeLineLayout = new DefaultTimeLineLayout(this.dataObject);
            this.timeLineLayout.layoutChart();
            ArrayList<List<TimeLineTrack>> arrayList = new ArrayList<List<TimeLineTrack>>();
            hashtable = this.timeLineLayout.getTracks();
            if (hashtable != null) {
                Collection<List<TimeLineTrack>> collection = hashtable.values();
                Iterator<List<TimeLineTrack>> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    List<TimeLineTrack> list = iterator.next();
                    if (arrayList.contains(list)) continue;
                    arrayList.add(list);
                }
            }
            this.nTracks = 0;
            for (List list : arrayList) {
                this.nTracks += list.size();
            }
            this.yHeightDataCoords = d3 / (double)this.nTracks;
            this.trackHeight = Math.abs(this.yaxis.toPixel(0.0) - this.yaxis.toPixel(this.yHeightDataCoords));
            int n8 = this.format.maxTrackHeight;
            if (this.format.barHeightMode == 1) {
                n8 = this.findMaxSymbolSize();
            }
            if (this.trackHeight > n8) {
                this.trackHeight = n8;
                this.yHeightDataCoords = Math.abs(this.yaxis.toData(0) - this.yaxis.toData(this.trackHeight));
            }
        }
        this.computeTrackCoords();
        this.layoutTrackAnnotations(this.yaxis, hashtable);
    }

    protected int findMaxSymbolSize() {
        int n2 = 0;
        List<TimeLineState> list = this.dataObject.getTimeLineStates();
        for (TimeLineState timeLineState : list) {
            int n3;
            if (timeLineState == null || timeLineState.isClearState() || (n3 = timeLineState.getChartStyle().getSymbolSize()) <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    protected void layoutTrackAnnotations(JCAxis jCAxis, Hashtable<ChartDataViewSeries, List<TimeLineTrack>> hashtable) {
        if (jCAxis.getAnnotationMethod() != 3 || hashtable == null) {
            return;
        }
        Vector<JCValueLabel> vector = jCAxis.getAnnotationHandler().getValueLabels();
        if (vector == null || vector.size() == 0) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            List<TimeLineTrack> list = hashtable.get(chartDataViewSeries);
            if (list == null || list.size() <= 0) continue;
            int n2 = list.get((int)0).yPixel;
            if (i2 >= vector.size()) continue;
            JCValueLabel jCValueLabel = (JCValueLabel)vector.get(i2);
            boolean bl = !arrayList.contains(n2);
            jCValueLabel.setDrawLabel(bl);
            jCValueLabel.setDrawGrid(bl);
            if (!bl) continue;
            arrayList.add(n2);
            double d2 = jCAxis.toData(n2, false);
            jCValueLabel.setValue(d2);
        }
        jCAxis.layoutAnnotations();
    }

    @Override
    public void draw(Graphics graphics) {
        Serializable serializable;
        DefineShape defineShape = null;
        Graphics graphics2 = null;
        if (graphics != null) {
            serializable = graphics.getClipBounds();
            if (serializable.width == 0 || serializable.height == 0) {
                return;
            }
            graphics2 = graphics.create();
            if (graphics2 instanceof DefineShape) {
                defineShape = (DefineShape)((Object)graphics);
            }
        }
        serializable = new RenderShape(graphics, graphics2, this.usingDoublePixels);
        this.processData((ProcessShape)((Object)serializable), defineShape);
        if (graphics2 != null) {
            graphics2.dispose();
        }
    }

    protected void processData(ProcessShape processShape, DefineShape defineShape) {
        if (this.timeLineLayout == null) {
            return;
        }
        Vector<List<TimeLineTrack>> vector = new Vector<List<TimeLineTrack>>();
        Hashtable<ChartDataViewSeries, List<TimeLineTrack>> hashtable = this.timeLineLayout.getTracks();
        for (ChartDataViewSeries chartDataViewSeries : this.seriesList) {
            List<TimeLineTrack> list = hashtable.get(chartDataViewSeries);
            if (list == null || vector.contains(list)) continue;
            for (TimeLineTrack timeLineTrack : list) {
                for (TimeLineInterval timeLineInterval : timeLineTrack) {
                    this.processInterval(processShape, defineShape, timeLineTrack.yPixel, timeLineInterval);
                }
            }
            vector.add(list);
        }
    }

    protected void computeTrackCoords() {
        double d2;
        Vector<List<TimeLineTrack>> vector = new Vector<List<TimeLineTrack>>();
        JCTimeLineChartFormat jCTimeLineChartFormat = (JCTimeLineChartFormat)this.dataObject.getChartFormat();
        int n2 = jCTimeLineChartFormat.isAscendingTracks() ? -1 : 1;
        double d3 = (double)this.nTracks * this.yHeightDataCoords;
        double d4 = (double)(this.seriesList.size() - 1) * this.vSpaceDataCoords;
        double d5 = d3 + d4;
        if (jCTimeLineChartFormat.trackPosition == 1 && !this.yaxis.isReversed() || jCTimeLineChartFormat.trackPosition == 3 && this.yaxis.isReversed()) {
            d2 = 100.0 - this.vSpaceDataCoords - this.yHeightDataCoords / 2.0;
            if (jCTimeLineChartFormat.isAscendingTracks()) {
                d2 -= d5 - this.vSpaceDataCoords;
            }
        } else {
            double d6 = 100.0 - d5;
            d2 = jCTimeLineChartFormat.trackPosition == 0 ? 100.0 - (d6 + this.yHeightDataCoords) / 2.0 : 100.0 - d6 + this.vSpaceDataCoords - this.yHeightDataCoords / 2.0;
            if (jCTimeLineChartFormat.isAscendingTracks()) {
                d2 -= d5 - this.vSpaceDataCoords - this.yHeightDataCoords / 2.0;
            }
        }
        Hashtable<ChartDataViewSeries, List<TimeLineTrack>> hashtable = this.timeLineLayout.getTracks();
        for (ChartDataViewSeries chartDataViewSeries : this.seriesList) {
            List<TimeLineTrack> list = hashtable.get(chartDataViewSeries);
            if (list == null || vector.contains(list)) continue;
            for (TimeLineTrack timeLineTrack : list) {
                timeLineTrack.yPixel = this.yaxis.toPixel(d2);
                d2 -= (double)n2 * this.yHeightDataCoords;
            }
            d2 -= (double)n2 * this.vSpaceDataCoords;
            vector.add(list);
        }
    }

    protected void processInterval(ProcessShape processShape, DefineShape defineShape, int n2, TimeLineInterval timeLineInterval) {
        JCDataIndex jCDataIndex = null;
        if (defineShape != null) {
            jCDataIndex = new JCDataIndex(timeLineInterval.dataIndex.point, timeLineInterval.dataIndex.series, timeLineInterval.dataIndex.seriesIndex);
            defineShape.markShape(jCDataIndex);
        }
        if (jCDataIndex != null) {
            processShape.tagData(jCDataIndex);
        } else {
            processShape.tagData(timeLineInterval.dataIndex.point, timeLineInterval.dataIndex.series, timeLineInterval.dataIndex.seriesIndex);
        }
        JCChartStyle jCChartStyle = timeLineInterval.timeLineState.getChartStyle();
        processShape.setChartStyle(jCChartStyle);
        if (timeLineInterval.startX == timeLineInterval.endX) {
            processShape.drawSymbol(timeLineInterval.startX, n2, jCChartStyle.getSymbolStyle().getColor());
            this.processLabel(processShape, defineShape, n2, timeLineInterval);
        } else {
            JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
            if (!timeLineInterval.startsAndStopsOnSameTimeExclusion) {
                if (jCFillStyle != null && jCFillStyle.getPattern() != 0) {
                    int[] nArray;
                    nArray = new int[]{(int)Math.round(timeLineInterval.startX), nArray[0] + (int)Math.round(timeLineInterval.endX - timeLineInterval.startX), nArray[1], nArray[0]};
                    int[] nArray2 = new int[4];
                    boolean bl = this.format.barHeightMode == 1;
                    int n3 = bl ? jCChartStyle.getSymbolSize() : this.trackHeight;
                    nArray2[0] = n2 + n3 / 2;
                    nArray2[1] = nArray2[0];
                    nArray2[2] = nArray2[0] - n3;
                    nArray2[3] = nArray2[2];
                    Rectangle rectangle = new Rectangle(nArray[3], nArray2[3], (int)Math.round(timeLineInterval.endX - timeLineInterval.startX), n3);
                    jCFillStyle.updateFillOrientation(rectangle, 7);
                    processShape.fillOutlinePolygon(new Polygon(nArray, nArray2, 4));
                    jCFillStyle.resetFillOrientation();
                } else {
                    JCSymbolStyle jCSymbolStyle;
                    JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                    if (jCLineStyle != null && jCLineStyle.getPattern() != 0) {
                        processShape.drawLine(timeLineInterval.startX, n2, timeLineInterval.endX, n2);
                    }
                    if ((jCSymbolStyle = jCChartStyle.getSymbolStyle()) != null && jCSymbolStyle.getShape() != 0) {
                        processShape.drawSymbol(timeLineInterval.startX, n2, jCSymbolStyle.getColor());
                        if (timeLineInterval.startX != timeLineInterval.endX) {
                            processShape.drawSymbol(timeLineInterval.endX, n2, jCSymbolStyle.getColor());
                        }
                    }
                }
                this.processLabel(processShape, defineShape, n2, timeLineInterval);
            }
        }
        if (defineShape != null) {
            defineShape.unmarkShape();
        }
    }

    protected void processLabel(ProcessShape processShape, DefineShape defineShape, int n2, TimeLineInterval timeLineInterval) {
        if (this.format.intervalLabelMode == 0) {
            return;
        }
        int n3 = this.format.getLabelInset();
        double d2 = timeLineInterval.endX - timeLineInterval.startX;
        if (this.format.isTruncateLabels() && d2 > 0.0 && (double)n3 > d2 / 2.0) {
            n3 = (int)(d2 / 2.0);
        }
        if (timeLineInterval.label != null && timeLineInterval.labelStartX >= (double)(this.xaxis.getLeft() + n3) && timeLineInterval.startX <= (double)(this.xaxis.getLeft() + this.xaxis.pixelLength())) {
            int n4 = (int)Math.round(timeLineInterval.labelStartX);
            FontMetrics fontMetrics = processShape.getFontMetrics();
            int n5 = fontMetrics != null ? (int)((double)n2 + (double)fontMetrics.getAscent() / 2.0) - 1 : n2;
            processShape.setColor(this.chartArea.getForeground());
            Shape shape = processShape.getClip();
            double d3 = Math.max(timeLineInterval.endX, timeLineInterval.labelEndX);
            Rectangle rectangle = new Rectangle((int)Math.round(timeLineInterval.startX), n2 - this.trackHeight / 2, (int)Math.round(d3 - timeLineInterval.startX), this.trackHeight);
            processShape.setClip(rectangle);
            processShape.drawString(timeLineInterval.label, n4, n5);
            processShape.setClip(shape);
        }
    }

    public void setTimeLineLayout(TimeLineLayout timeLineLayout) {
        this.timeLineLayout = timeLineLayout;
    }

    public TimeLineLayout getTimeLineLayout() {
        return this.timeLineLayout;
    }

    @Override
    public JCTimelineDataIndex pick(Point point, int n2) {
        if (this.seriesList == null) {
            return null;
        }
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        Picker picker = new Picker(n3, n4, n2);
        PickShape pickShape = new PickShape(picker, false, this.inverted);
        this.processData(pickShape, null);
        JCTimelineDataIndex jCTimelineDataIndex = null;
        if (picker.series >= 0 && picker.series < this.seriesList.size() && picker.point >= 0) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(picker.series);
            TimeLineState timeLineState = this.timeLineLayout.getState(chartDataViewSeries.getY(picker.point));
            jCTimelineDataIndex = new JCTimelineDataIndex(picker.point, chartDataViewSeries, picker.series, timeLineState);
            jCTimelineDataIndex.distance = picker.distance;
        }
        return jCTimelineDataIndex;
    }

    @Override
    public JCTimelinePoint unpick(int n2, int n3) {
        boolean bl;
        if (this.timeLineLayout == null || this.timeLineLayout.getTracks() == null) {
            return null;
        }
        if (this.seriesList == null || n3 >= this.seriesList.size()) {
            return null;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        TimeLineState timeLineState = this.timeLineLayout.getState(chartDataViewSeries.getY(n2));
        boolean bl2 = bl = timeLineState == null || timeLineState.isClearState();
        while (n2 > 0 && bl2) {
            bl2 = (timeLineState = this.timeLineLayout.getState(chartDataViewSeries.getY(--n2))) == null || timeLineState.isClearState();
        }
        if (timeLineState == null) {
            return null;
        }
        Hashtable<ChartDataViewSeries, List<TimeLineTrack>> hashtable = this.timeLineLayout.getTracks();
        List<TimeLineTrack> list = hashtable.get(chartDataViewSeries);
        if (list != null) {
            for (TimeLineTrack timeLineTrack : list) {
                for (TimeLineInterval timeLineInterval : timeLineTrack) {
                    if (timeLineInterval.dataIndex.point != n2 || timeLineInterval.dataIndex.seriesIndex != n3) continue;
                    double d2 = bl ? timeLineInterval.endX : timeLineInterval.startX;
                    JCTrackInfo jCTrackInfo = new JCTrackInfo(timeLineTrack.getId(), timeLineTrack.yPixel, this.trackHeight);
                    return new JCTimelinePoint((int)Math.round(d2), timeLineTrack.yPixel, jCTrackInfo);
                }
            }
        }
        return null;
    }
}

