/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.DefaultTimeLineLayout;
import com.klg.jclass.chart.TimeLineInterval;
import com.klg.jclass.chart.TimeLineTrack;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SteppedTimeLineLayout
extends DefaultTimeLineLayout {
    protected int currentTrackID = 0;
    protected int currentTrackIndex = -1;
    protected int nTracksPerSeries = 0;

    public SteppedTimeLineLayout(ChartDataView chartDataView, int n2) {
        super(chartDataView);
        this.nTracksPerSeries = n2;
    }

    protected TimeLineTrack getNextTrack(List<TimeLineTrack> list) {
        ++this.currentTrackIndex;
        if (this.currentTrackIndex > this.nTracksPerSeries - 1) {
            this.currentTrackIndex = 0;
        }
        return list.get(this.currentTrackIndex);
    }

    @Override
    protected int placeIntervals(List<TimeLineTrack> list, List<TimeLineInterval> list2, int n2) {
        this.currentTrackIndex = -1;
        for (int i2 = 0; i2 < this.nTracksPerSeries; ++i2) {
            list.add(new TimeLineTrack(this.currentTrackID++));
        }
        for (TimeLineInterval timeLineInterval : list2) {
            if (timeLineInterval.startsAndStopsOnSameTimeExclusion) continue;
            TimeLineTrack timeLineTrack = this.getNextTrack(list);
            timeLineTrack.add(timeLineInterval);
        }
        return n2;
    }

    @Override
    protected void mergeTracks() {
    }
}

