/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.BarPoint;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ChartDrawUtil;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.OutlineConfigurable;
import com.klg.jclass.chart.SBarVal;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class SBarChartDraw
extends ChartDraw {
    public static final int OUTLINE_SENSITIVITY = 3;
    protected Point firstLast = null;
    protected JCLineStyle outlineStyle = null;
    protected boolean x_reversed = false;
    protected boolean y_reversed = false;
    protected int delta_x = 0;
    protected int delta_y = 0;
    protected boolean is_3d = false;
    protected double xAxisPos = Double.MAX_VALUE;
    protected double[] xGridLineList = null;
    protected JCLineStyle gridLineStyle = null;
    protected boolean fastAction = false;
    protected boolean inAction = false;
    protected double yOrigin = 0.0;
    protected BarPoint[][] pts = null;
    protected double bar_base;
    protected int left;
    protected int right;
    protected int top;
    protected int bottom;
    protected int height;
    protected MinMax x;
    protected MinMax y;
    protected MinMax datax;
    protected MinMax datay;
    protected boolean is_100_percent;
    protected boolean drawOutline = true;
    protected SBarVal[][] set_pos;
    protected SBarVal[][] set_neg;
    protected double[] ytotal;
    protected double[] ysum;
    protected double[] ysum_neg;
    protected double[][] ywork;
    protected boolean opp_x;
    protected boolean opp_y;
    private Rectangle r = null;
    private boolean editInverted = false;
    Point start = null;
    Point end = null;

    public void recalc() {
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double d2;
        double d3;
        super.recalc();
        JCBarChartFormat jCBarChartFormat = (JCBarChartFormat)this.dataObject.getChartFormat();
        if (jCBarChartFormat == null) {
            return;
        }
        this.is_100_percent = jCBarChartFormat.is100Percent();
        if (jCBarChartFormat.clusterWidth == 0) {
            return;
        }
        this.holeValue = this.dataObject.getHoleValue();
        if (this.dataObject.getXLimits() == null) {
            return;
        }
        if (this.dataObject.getYLimits() == null) {
            return;
        }
        this.datax = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        this.datay = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(this.datax, this.datay);
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        if (this.xaxis == null || this.yaxis == null) {
            return;
        }
        this.bar_base = this.dataObject.step * (double)jCBarChartFormat.clusterWidth / 100.0;
        this.inverted = this.xaxis.i_vertical;
        this.x = new MinMax();
        this.y = new MinMax();
        this.x.min = this.datax.min - this.bar_base / 2.0;
        this.x.max = this.datax.max + this.bar_base / 2.0;
        this.xaxis.setLimits(this.x);
        this.xaxis.calcTransformation();
        this.xaxis.layoutAnnotations();
        this.xaxis.checkAnnotations();
        this.x = this.xaxis.dataLimits;
        this.y = this.yaxis.dataLimits;
        double d4 = this.xaxis.min.value;
        boolean bl = this.xaxis.skipWeekends;
        this.xaxis.skipWeekends = false;
        int n7 = this.xaxis.toPixel(d4, this.drawFront);
        int n8 = this.xaxis.toPixel(d4 + this.bar_base, this.drawFront);
        this.xaxis.skipWeekends = bl;
        this.drawOutline = Math.abs(n8 - n7) > 3;
        int n9 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
        int n10 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
        this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
        this.right = this.left + n9 - 1;
        int n11 = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
        this.yOrigin = this.is_100_percent ? 0.0 : this.yaxis.origin.value;
        int n12 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
        this.firstLast = this.dataObject.getFirstLast();
        this.x_reversed = this.xaxis.isReversed();
        this.y_reversed = this.yaxis.reversed;
        this.delta_x = this.chartArea.getDeltaX();
        this.delta_y = this.chartArea.getDeltaY();
        this.is_3d = this.delta_x != 0 || this.delta_y != 0;
        this.seriesList = this.dataObject.getSeries();
        int n13 = this.seriesList.size();
        if (n13 == 0 || this.firstLast == null) {
            return;
        }
        int n14 = this.firstLast.y - this.firstLast.x + 1;
        this.fastAction = this.chartArea.getFastAction();
        this.inAction = this.chartArea.getInAction();
        if (!this.fastAction || !this.inAction) {
            this.xAxisPos = this.xaxis.getRealPlacementLocation();
            this.xGridLineList = this.xaxis.getGridLineList();
            if (this.xGridLineList == null) {
                this.xGridLineList = new double[0];
            }
            this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
        }
        this.set_pos = new SBarVal[n14][n13];
        this.set_neg = new SBarVal[n14][n13];
        this.ytotal = new double[n14];
        this.ysum = new double[n14];
        this.ysum_neg = new double[n14];
        this.ywork = new double[n13][n14];
        ChartDrawUtil.calcStackingInfo(this.ysum, this.ysum_neg, this.ytotal, this.ywork, this.firstLast.x, this.firstLast.y, this.seriesList, this.is_100_percent, this.holeValue, this.yaxis);
        Point[] pointArray = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
        Point[] pointArray2 = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n13];
        double d5 = this.xaxis.min.value;
        double d6 = this.xaxis.max.value;
        if (this.hasTimeExclusions()) {
            this.checkTimeBase();
            AxisHandler axisHandler = this.xaxis.getAxisHandler();
            d5 = axisHandler.adjustValueForward(d5, this.xaxis.max.value);
            d6 = axisHandler.adjustValueBackward(d6, this.xaxis.min.value);
        }
        if (this.is_3d) {
            if (this.inverted) {
                this.opp_x = this.delta_y > 0 ^ this.x_reversed;
                this.opp_y = this.delta_x <= 0 ^ this.y_reversed;
            } else {
                this.opp_x = this.delta_x <= 0 ^ this.x_reversed;
                this.opp_y = this.delta_y > 0 ^ this.y_reversed;
            }
            for (int i2 = this.firstLast.x; i2 <= this.firstLast.y; ++i2) {
                BarPoint barPoint;
                int n19;
                int n20;
                int n21 = i2 - this.firstLast.x;
                double d7 = ((ChartDataViewSeries)this.seriesList.get(0)).getX(i2);
                if (this.xaxis.isValueExcluded(d7) || (d3 = (d2 = d7 - this.bar_base / 2.0) + this.bar_base) < this.x.min || d2 > this.x.max || d3 < d5 || d2 > d6) continue;
                if (d2 < this.x.min) {
                    d2 = this.x.min;
                }
                if (d3 > this.x.max) {
                    d3 = this.x.max;
                }
                if (this.inverted) {
                    n16 = this.xaxis.toPixel(d2, this.drawFront);
                    n6 = this.xaxis.toPixel(d3, this.drawFront);
                    if (this.hasTimeExclusions()) {
                        AxisHandler.ClusterAdjustment clusterAdjustment;
                        if (n16 == Integer.MAX_VALUE) {
                            clusterAdjustment = this.getClusterAdjustment(d2, d7);
                            n16 = this.xaxis.toPixelInternal(d2, this.drawFront, clusterAdjustment);
                        }
                        if (n6 == Integer.MAX_VALUE) {
                            clusterAdjustment = this.getClusterAdjustment(d3, d7);
                            n6 = this.xaxis.toPixelInternal(d3, this.drawFront, clusterAdjustment);
                        }
                    }
                    n18 = n16 - n6;
                    pointArray[0].y = this.opp_x ? n16 : n16 - n18;
                    pointArray2[0].y = n16 - n18;
                    pointArray2[2].y = n18;
                } else {
                    n15 = this.xaxis.toPixel(d2, this.drawFront);
                    n6 = this.xaxis.toPixel(d3, this.drawFront);
                    if (this.hasTimeExclusions()) {
                        if (n15 == Integer.MAX_VALUE) {
                            AxisHandler.ClusterAdjustment clusterAdjustment = this.getClusterAdjustment(d2, d7);
                            n15 = this.xaxis.toPixelInternal(d2, this.drawFront, clusterAdjustment);
                        }
                        if (n6 == Integer.MAX_VALUE) {
                            AxisHandler.ClusterAdjustment clusterAdjustment = this.getClusterAdjustment(d3, d7);
                            n6 = this.xaxis.toPixelInternal(d3, this.drawFront, clusterAdjustment);
                        }
                    }
                    n17 = n6 - n15;
                    pointArray2[0].x = this.opp_x ? n15 : n15 + n17;
                    pointArray[0].x = n15;
                    pointArray[2].x = n17;
                }
                n6 = 0;
                n5 = 0;
                int n22 = n12;
                n4 = n12;
                for (n3 = 0; n3 < n13; ++n3) {
                    int n23;
                    if (this.ywork[n3][n21] == Double.MAX_VALUE) continue;
                    int n24 = n20 = this.ywork[n3][n21] < this.yOrigin ? 1 : 0;
                    if (n20 != 0) {
                        if (this.ywork[n3][n21] > this.y.max) continue;
                        n2 = this.yaxis.toPixel(Math.max(this.ywork[n3][n21], this.y.min), this.drawFront);
                        n23 = n4;
                    } else {
                        if (this.ywork[n3][n21] < this.y.min) continue;
                        n2 = this.yaxis.toPixel(Math.min(this.ywork[n3][n21], this.y.max), this.drawFront);
                        n23 = n22;
                    }
                    if (this.inverted) {
                        if (n20 != 0) {
                            SBarVal sBarVal = new SBarVal();
                            this.set_neg[n21][n5] = sBarVal;
                            object = sBarVal;
                            ++n5;
                        } else {
                            SBarVal sBarVal = new SBarVal();
                            this.set_pos[n21][n6] = sBarVal;
                            object = sBarVal;
                            ++n6;
                        }
                        ((SBarVal)object).nset_index = n3;
                        ((SBarVal)object).side_point0.x = n2;
                        ((SBarVal)object).side_point2.x = n23 - n2;
                        ((SBarVal)object).top_point.x = !this.opp_y && n20 == 0 || this.opp_y && n20 != 0 ? n2 : n23;
                    } else {
                        if (n20 != 0) {
                            SBarVal sBarVal = new SBarVal();
                            this.set_neg[n21][n5] = sBarVal;
                            object = sBarVal;
                            ++n5;
                        } else {
                            SBarVal sBarVal = new SBarVal();
                            this.set_pos[n21][n6] = sBarVal;
                            object = sBarVal;
                            ++n6;
                        }
                        ((SBarVal)object).nset_index = n3;
                        ((SBarVal)object).side_point0.y = n23;
                        ((SBarVal)object).side_point2.y = n2 - n23;
                        ((SBarVal)object).top_point.y = !this.opp_y && n20 == 0 || this.opp_y && n20 != 0 ? n2 : n23;
                    }
                    if (n20 != 0) {
                        n4 = n2;
                        continue;
                    }
                    n22 = n2;
                }
                if (this.opp_y) {
                    n3 = n6 - 1;
                    n2 = n5;
                } else {
                    n3 = n5 - 1;
                    n2 = n6;
                }
                BarPoint[] barPointArray = this.pts[n21];
                for (n20 = n3; n20 >= 0; --n20) {
                    object = this.opp_y ? this.set_pos[n21][n20] : this.set_neg[n21][n20];
                    n19 = ((SBarVal)object).nset_index;
                    if (barPointArray[n19] == null) {
                        barPointArray[n19] = new BarPoint();
                    }
                    barPoint = barPointArray[n19];
                    if (this.inverted) {
                        pointArray[0].x = ((SBarVal)object).side_point0.x;
                        pointArray[2].x = ((SBarVal)object).side_point2.x;
                        barPoint.top = this.copyPointArray(pointArray);
                        pointArray2[0].x = ((SBarVal)object).top_point.x;
                        barPoint.side = this.copyPointArray(pointArray2);
                        continue;
                    }
                    pointArray2[0].y = ((SBarVal)object).side_point0.y;
                    pointArray2[2].y = ((SBarVal)object).side_point2.y;
                    barPoint.side = this.copyPointArray(pointArray2);
                    pointArray[0].y = ((SBarVal)object).top_point.y;
                    barPoint.top = this.copyPointArray(pointArray);
                }
                for (n20 = 0; n20 < n2; ++n20) {
                    object = this.opp_y ? this.set_neg[n21][n20] : this.set_pos[n21][n20];
                    n19 = ((SBarVal)object).nset_index;
                    if (barPointArray[n19] == null) {
                        barPointArray[n19] = new BarPoint();
                    }
                    barPoint = barPointArray[n19];
                    if (this.inverted) {
                        pointArray[0].x = ((SBarVal)object).side_point0.x;
                        pointArray[2].x = ((SBarVal)object).side_point2.x;
                        barPoint.top = this.copyPointArray(pointArray);
                        pointArray2[0].x = ((SBarVal)object).top_point.x;
                        barPoint.side = this.copyPointArray(pointArray2);
                        continue;
                    }
                    pointArray2[0].y = ((SBarVal)object).side_point0.y;
                    pointArray2[2].y = ((SBarVal)object).side_point2.y;
                    barPoint.side = this.copyPointArray(pointArray2);
                    pointArray[0].y = ((SBarVal)object).top_point.y;
                    barPoint.top = this.copyPointArray(pointArray);
                }
            }
            if (this.is_3d) {
                if (this.inverted) {
                    n16 = this.delta_y > 0 ? n11 + n10 - 1 : n11;
                } else {
                    n15 = this.delta_x <= 0 ? this.left : this.right;
                }
            }
        }
        for (int i3 = this.firstLast.x; i3 <= this.firstLast.y && this.seriesList.size() != 0; ++i3) {
            double d8 = ((ChartDataViewSeries)this.seriesList.get(0)).getX(i3);
            if (this.xaxis.isValueExcluded(d8)) continue;
            int n25 = i3 - this.firstLast.x;
            d2 = d8 - this.bar_base / 2.0;
            d3 = d2 + this.bar_base;
            if (d3 < this.x.min || d2 > this.x.max || d3 < d5 || d2 > d6) continue;
            if (d2 < this.x.min) {
                d2 = this.x.min;
            }
            if (d3 > this.x.max) {
                d3 = this.x.max;
            }
            if (this.inverted) {
                n16 = this.xaxis.toPixel(d2, this.drawFront);
                n6 = this.xaxis.toPixel(d3, this.drawFront);
                if (this.hasTimeExclusions()) {
                    if (n16 == Integer.MAX_VALUE) {
                        AxisHandler.ClusterAdjustment clusterAdjustment = this.getClusterAdjustment(d2, d8);
                        n16 = this.xaxis.toPixelInternal(d2, this.drawFront, clusterAdjustment);
                    }
                    if (n6 == Integer.MAX_VALUE) {
                        AxisHandler.ClusterAdjustment clusterAdjustment = this.getClusterAdjustment(d3, d8);
                        n6 = this.xaxis.toPixelInternal(d3, this.drawFront, clusterAdjustment);
                    }
                }
                n18 = Math.abs(n16 - n6);
                if (!this.x_reversed) {
                    n16 -= n18;
                }
            } else {
                n15 = this.xaxis.toPixel(d2, this.drawFront);
                n6 = this.xaxis.toPixel(d3, this.drawFront);
                if (this.hasTimeExclusions()) {
                    if (n15 == Integer.MAX_VALUE) {
                        AxisHandler.ClusterAdjustment clusterAdjustment = this.getClusterAdjustment(d2, d8);
                        n15 = this.xaxis.toPixelInternal(d2, this.drawFront, clusterAdjustment);
                    }
                    if (n6 == Integer.MAX_VALUE) {
                        AxisHandler.ClusterAdjustment clusterAdjustment = this.getClusterAdjustment(d3, d8);
                        n6 = this.xaxis.toPixelInternal(d3, this.drawFront, clusterAdjustment);
                    }
                }
                n17 = Math.abs(n6 - n15);
                if (this.x_reversed) {
                    n15 -= n17;
                }
            }
            n6 = n12;
            n5 = n12;
            BarPoint[] barPointArray = this.pts[n25];
            for (n4 = 0; n4 < this.seriesList.size(); ++n4) {
                int n26;
                if (this.ywork[n4][n25] == Double.MAX_VALUE) continue;
                if (barPointArray[n4] == null) {
                    barPointArray[n4] = new BarPoint();
                }
                object = barPointArray[n4];
                double d9 = ((ChartDataViewSeries)this.seriesList.get(n4)).getY(i3);
                ((BarPoint)object).x = d2;
                ((BarPoint)object).y = d9;
                int n27 = n3 = this.ywork[n4][n25] < this.yOrigin ? 1 : 0;
                if (n3 != 0) {
                    if (this.ywork[n4][n25] > this.y.max) continue;
                    n2 = this.yaxis.toPixel(Math.max(this.ywork[n4][n25], this.y.min), this.drawFront);
                    n26 = n5;
                } else {
                    if (this.ywork[n4][n25] < this.y.min) continue;
                    n2 = this.yaxis.toPixel(Math.min(this.ywork[n4][n25], this.y.max), this.drawFront);
                    n26 = n6;
                }
                if (this.inverted) {
                    if ((this.y_reversed ^ n3) != 0) {
                        n17 = n26 - n2;
                        n15 = n2;
                    } else {
                        n15 = n26;
                        n17 = n2 - n26;
                    }
                } else if ((this.y_reversed ^ n3) != 0) {
                    n16 = n26;
                    n18 = n2 - n26;
                } else {
                    n16 = n2;
                    n18 = n26 - n2;
                }
                if (this.inverted) {
                    n18 = Math.max(1, n18);
                } else {
                    n17 = Math.max(1, n17);
                }
                ((BarPoint)object).front = new Rectangle(n15, n16, n17, n18);
                if (n3 != 0) {
                    n5 = n2;
                    continue;
                }
                n6 = n2;
            }
        }
    }

    public void draw(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        if (this.pts == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        int n5 = this.seriesList.size();
        if (n5 == 0 || this.firstLast == null) {
            return;
        }
        if (this.is_3d || this.is_100_percent) {
            SBarVal[][] sBarValArray;
            int n6;
            boolean bl = false;
            boolean bl2 = false;
            if (this.opp_x) {
                n4 = this.firstLast.y;
                n3 = -1;
                n2 = n4 >= this.firstLast.x ? 1 : 0;
                n6 = this.xGridLineList.length - 1;
            } else {
                n4 = this.firstLast.x;
                n3 = 1;
                n2 = n4 <= this.firstLast.y ? 1 : 0;
                n6 = 0;
            }
            double d2 = this.xaxis.min.value;
            double d3 = this.xaxis.max.value;
            if (this.hasTimeExclusions()) {
                sBarValArray = this.xaxis.getAxisHandler();
                d2 = sBarValArray.adjustValueForward(d2, this.xaxis.max.value);
                d3 = sBarValArray.adjustValueBackward(d3, this.xaxis.min.value);
            }
            sBarValArray = null;
            int n7 = -1;
            int n8 = n4;
            while (n2 != 0) {
                Point[] pointArray;
                int n9;
                Point[] pointArray2;
                int n10;
                int n11;
                ChartDataViewSeries chartDataViewSeries;
                JCFillStyle jCFillStyle;
                int n12;
                int n13;
                Object object;
                n2 = this.opp_x ? (n8 > this.firstLast.x ? 1 : 0) : (n8 < this.firstLast.y ? 1 : 0);
                int n14 = n8 - this.firstLast.x;
                if (!this.fastAction || !this.inAction) {
                    BarPoint barPoint;
                    object = null;
                    for (n13 = this.set_neg[n14].length - 1; n13 >= 0; --n13) {
                        if (this.set_neg[n14][n13] == null) continue;
                        n12 = this.set_neg[n14][n13].nset_index;
                        barPoint = null;
                        try {
                            barPoint = this.pts[n14][n12];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        if (barPoint == null || barPoint.front == null) continue;
                        object = barPoint;
                        break;
                    }
                    if (object == null) {
                        for (n13 = 0; n13 < this.set_pos[n14].length && this.set_pos[n14][n13] != null; ++n13) {
                            n12 = this.set_pos[n14][n13].nset_index;
                            barPoint = null;
                            try {
                                barPoint = this.pts[n14][n12];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            if (barPoint == null || barPoint.front == null) continue;
                            object = barPoint;
                        }
                    }
                    if (object != null) {
                        if (this.inverted) {
                            n12 = object.front.y + object.front.height;
                            n13 = object.front.y;
                        } else {
                            n13 = object.front.x;
                            n12 = object.front.x + object.front.width;
                        }
                        sBarValArray = object;
                        n7 = n14;
                        if (!bl) {
                            int n15 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n13, n12);
                            if (n15 == 1) {
                                bl = true;
                            } else if (n15 == 2) {
                                bl2 = true;
                                bl = true;
                            }
                        }
                        if (this.xaxis.gridVisible) {
                            n6 = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n13, n12, this.ysum[n14], this.ysum_neg[n14], this.xGridLineList, n6, n3, this.gridLineStyle);
                        }
                    }
                }
                object = this.opp_y ? this.set_pos : this.set_neg;
                for (n13 = object[n14].length - 1; n13 >= 0; --n13) {
                    if (object[n14][n13] == null) continue;
                    n12 = object[n14][n13].nset_index;
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n14][n12];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (barPoint == null || (jCFillStyle = (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n12)).getStyle().getFillStyle()).isCustomStackable()) continue;
                    n11 = this.calcFillOrientation(barPoint.y, 0.0, this.inverted, this.yaxis.reversed);
                    if (this.inverted) {
                        n10 = this.delta_x <= 0 ? barPoint.front.width : -barPoint.front.width;
                        pointArray2 = this.getTranslatedPoints(barPoint.side, n10, 0);
                        this.DrawBarFace(graphics, pointArray2, n12, n8, false, n11, this.drawOutline, false);
                        n9 = this.delta_y <= 0 ? barPoint.front.height : -barPoint.front.height;
                        pointArray = this.getTranslatedPoints(barPoint.top, 0, n9);
                        this.DrawBarFace(graphics, pointArray, n12, n8, false, n11, this.drawOutline, false);
                        this.DrawBarFace(graphics, barPoint.top, n12, n8, true, n11, this.drawOutline, true);
                        this.DrawBarFace(graphics, barPoint.side, n12, n8, false, n11, this.drawOutline, true);
                        continue;
                    }
                    n10 = this.delta_x <= 0 ? barPoint.front.width : -barPoint.front.width;
                    pointArray2 = this.getTranslatedPoints(barPoint.side, n10, 0);
                    this.DrawBarFace(graphics, pointArray2, n12, n8, false, n11, this.drawOutline, false);
                    n9 = this.delta_y <= 0 ? barPoint.front.height : -barPoint.front.height;
                    pointArray = this.getTranslatedPoints(barPoint.top, 0, n9);
                    this.DrawBarFace(graphics, pointArray, n12, n8, true, n11, this.drawOutline, false);
                    this.DrawBarFace(graphics, barPoint.side, n12, n8, false, n11, this.drawOutline, true);
                    this.DrawBarFace(graphics, barPoint.top, n12, n8, true, n11, this.drawOutline, true);
                }
                object = this.opp_y ? this.set_neg : this.set_pos;
                for (n13 = 0; n13 < object[n14].length && object[n14][n13] != null; ++n13) {
                    n12 = object[n14][n13].nset_index;
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n14][n12];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (barPoint == null || (jCFillStyle = (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n12)).getStyle().getFillStyle()).isCustomStackable()) continue;
                    n11 = this.calcFillOrientation(barPoint.y, 0.0, this.inverted, this.yaxis.reversed);
                    if (this.inverted) {
                        n10 = this.delta_x <= 0 ? barPoint.front.width : -barPoint.front.width;
                        pointArray2 = this.getTranslatedPoints(barPoint.side, n10, 0);
                        this.DrawBarFace(graphics, pointArray2, n12, n8, false, n11, this.drawOutline, false);
                        n9 = this.delta_y <= 0 ? barPoint.front.height : -barPoint.front.height;
                        pointArray = this.getTranslatedPoints(barPoint.top, 0, n9);
                        this.DrawBarFace(graphics, pointArray, n12, n8, false, n11, this.drawOutline, false);
                        this.DrawBarFace(graphics, barPoint.top, n12, n8, true, n11, this.drawOutline, true);
                        this.DrawBarFace(graphics, barPoint.side, n12, n8, false, n11, this.drawOutline, true);
                        continue;
                    }
                    n10 = this.delta_x <= 0 ? barPoint.front.width : -barPoint.front.width;
                    pointArray2 = this.getTranslatedPoints(barPoint.side, n10, 0);
                    this.DrawBarFace(graphics, pointArray2, n12, n8, false, n11, this.drawOutline, false);
                    n9 = this.delta_y <= 0 ? barPoint.front.height : -barPoint.front.height;
                    pointArray = this.getTranslatedPoints(barPoint.top, 0, n9);
                    this.DrawBarFace(graphics, pointArray, n12, n8, true, n11, this.drawOutline, false);
                    this.DrawBarFace(graphics, barPoint.side, n12, n8, false, n11, this.drawOutline, true);
                    this.DrawBarFace(graphics, barPoint.top, n12, n8, true, n11, this.drawOutline, true);
                }
                if (bl2) {
                    this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, this.ysum_neg[n14], this.ysum[n14]);
                    bl2 = false;
                }
                n8 += n3;
            }
            if (!this.fastAction || !this.inAction) {
                n8 = 1;
                if (sBarValArray != null) {
                    n8 = this.isDrawFinalGridAndTrough((BarPoint)sBarValArray, this.isDrawOverBar(this.inverted, this.y_reversed, this.delta_y, this.delta_x, this.xAxisPos, this.ysum[n7], this.ysum_neg[n7]), this.inverted, this.xaxis.toPixel(d3, this.drawFront), this.xaxis.toPixel(d2, this.drawFront)) ? 1 : 0;
                }
                if (n8 != 0) {
                    this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, this.opp_x, bl, this.xGridLineList, n6, n3, this.gridLineStyle);
                }
            }
        }
        for (n4 = this.firstLast.x; n4 <= this.firstLast.y && this.seriesList.size() != 0; ++n4) {
            n3 = n4 - this.firstLast.x;
            for (n2 = 0; n2 < this.seriesList.size(); ++n2) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
                if (!chartDataViewSeries.isVisible() || !chartDataViewSeries.isIncluded()) continue;
                BarPoint barPoint = null;
                try {
                    barPoint = this.pts[n3][n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                this.setOutlineStyle(chartDataViewSeries);
                JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
                JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                if (barPoint == null || barPoint.front == null) continue;
                if (jCFillStyle.isCustomStackable()) {
                    jCFillStyle.fillImageRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, barPoint.y >= 0.0, this.inverted);
                    continue;
                }
                int n16 = this.calcFillOrientation(barPoint.y, 0.0, this.inverted, this.yaxis.reversed);
                jCFillStyle.updateFillOrientation(new Rectangle(barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height), n16);
                DefineShape defineShape = null;
                if (graphics instanceof DefineShape) {
                    defineShape = (DefineShape)((Object)graphics);
                }
                if (defineShape != null) {
                    defineShape.beginShape(new JCDataIndex(n4, chartDataViewSeries));
                }
                jCFillStyle.fillRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height);
                if (defineShape != null) {
                    defineShape.endShape(true);
                }
                if (this.drawOutline) {
                    jCFillStyle.drawOutlineRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.outlineStyle);
                }
                jCFillStyle.resetFillOrientation();
            }
        }
    }

    private void setOutlineStyle(ChartDataViewSeries chartDataViewSeries) {
        this.outlineStyle = this.dataObject.getOutlineStyle();
        OutlineConfigurable outlineConfigurable = (OutlineConfigurable)((Object)this.dataObject.getChartFormat(10));
        int n2 = outlineConfigurable.getOutlineStyle();
        if (n2 == 1) {
            JCLineStyle jCLineStyle;
            JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
            JCLineStyle jCLineStyle2 = jCLineStyle = jCChartStyle != null ? jCChartStyle.getLineStyle() : null;
            if (jCLineStyle != null) {
                this.outlineStyle = jCLineStyle;
            }
        } else if (n2 == 2) {
            this.outlineStyle = new JCLineStyle(1, this.chartArea.getForeground(), 1);
        }
    }

    void DrawBarFace(Graphics graphics, Point[] pointArray, int n2, int n3, boolean bl, int n4, boolean bl2, boolean bl3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        this.setOutlineStyle(chartDataViewSeries);
        JCFillStyle jCFillStyle = bl3 ? chartDataViewSeries.getStyle().getFillStyle() : new JCFillStyle(null, 0);
        int n5 = this.chartArea.getDeltaX();
        int n6 = this.chartArea.getDeltaY();
        boolean bl4 = bl && n6 <= 0 || !bl && n5 <= 0;
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
        }
        Polygon polygon = new Polygon();
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            if (i2 == 0) {
                polygon.addPoint(pointArray[i2].x, pointArray[i2].y);
                continue;
            }
            polygon.addPoint(polygon.xpoints[i2 - 1] + pointArray[i2].x, polygon.ypoints[i2 - 1] + pointArray[i2].y);
        }
        jCFillStyle.updateFillOrientation(polygon.getBounds(), n4);
        if (defineShape != null) {
            defineShape.beginShape(new JCDataIndex(n3, chartDataViewSeries));
        }
        if (JCChartUtil.isTransparentColor(jCFillStyle.getColor())) {
            jCFillStyle.fillPolygon(graphics, polygon);
        } else if (bl4) {
            jCFillStyle.fillPolygonHighlight(graphics, polygon);
        } else {
            jCFillStyle.fillPolygonShadow(graphics, polygon);
        }
        if (defineShape != null) {
            defineShape.endShape(true);
        }
        if (bl2) {
            jCFillStyle.drawOutlinePolygon(graphics, polygon, this.outlineStyle);
        }
        jCFillStyle.resetFillOrientation();
    }

    protected int calcFillOrientation(double d2, double d3, boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2 && d2 >= d3 || bl2 && d2 < d3) {
                return 2;
            }
            return 1;
        }
        if (!bl2 && d2 >= d3 || bl2 && d2 < d3) {
            return 3;
        }
        return 4;
    }

    public double getWorkingYValue(int n2, int n3, boolean bl) {
        if (this.dataObject == null || this.seriesList == null || this.ywork == null) {
            return this.holeValue;
        }
        int n4 = this.seriesList.size();
        if (n2 < 0 || n2 >= n4 || this.firstLast == null) {
            return this.holeValue;
        }
        int n5 = n3 - this.firstLast.x;
        if (n5 < 0 || n5 >= this.ywork[n2].length) {
            return this.holeValue;
        }
        double d2 = this.ywork[n2][n5];
        if (bl) {
            return d2;
        }
        boolean bl2 = this.yaxis != null && this.yaxis.isLogarithmic();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (!chartDataViewSeries.isIncluded() || !chartDataViewSeries.isVisible() || chartDataViewSeries.isYHole(n3, bl2)) continue;
            double d3 = this.ywork[i2][n5];
            if (Math.signum(d2) != Math.signum(d3)) continue;
            return d2 - d3;
        }
        return d2;
    }

    public JCDataIndex pick(Point point, int n2) {
        int n3;
        int n4;
        int n5;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = (Point)point.clone();
        point2.x -= rectangle.x;
        point2.y -= rectangle.y;
        int n6 = -1;
        int n7 = -1;
        JCDataIndex jCDataIndex = null;
        int n8 = Integer.MAX_VALUE;
        int n9 = this.chartArea.getDeltaX();
        int n10 = this.chartArea.getDeltaY();
        boolean bl = n9 != 0 || n10 != 0;
        int n11 = this.seriesList.size();
        if (n11 == 0 || this.firstLast == null || this.pts == null) {
            return null;
        }
        if (bl || this.is_100_percent) {
            if (this.opp_x) {
                n5 = this.firstLast.y;
                n4 = -1;
                n3 = n5 >= this.firstLast.x ? 1 : 0;
            } else {
                n5 = this.firstLast.x;
                n4 = 1;
                n3 = n5 <= this.firstLast.y ? 1 : 0;
            }
            int n12 = n5;
            while (n3 != 0) {
                n3 = this.opp_x ? (n12 > this.firstLast.x ? 1 : 0) : (n12 < this.firstLast.y ? 1 : 0);
                int n13 = n12 - this.firstLast.x;
                BarPoint[] barPointArray = this.pts[n13];
                for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
                    if (barPointArray[i2] == null) continue;
                    int n14 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPointArray[i2].top, this.inverted, n2);
                    int n15 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPointArray[i2].side, this.inverted, n2);
                    if (n14 > n8 && n15 > n8) continue;
                    n6 = i2;
                    n7 = n12;
                    n8 = Math.min(n15, n14);
                }
                n12 += n4;
            }
        }
        for (n5 = this.firstLast.x; n5 <= this.firstLast.y; ++n5) {
            n4 = n5 - this.firstLast.x;
            if (this.pts[n4] == null) continue;
            for (n3 = 0; n3 < this.pts[n4].length; ++n3) {
                int n16;
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
                if (!chartDataViewSeries.isVisible()) continue;
                BarPoint barPoint = null;
                try {
                    barPoint = this.pts[n4][n3];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (barPoint == null || barPoint.x == this.holeValue || barPoint.y == this.holeValue || this.xaxis.isValueExcluded(chartDataViewSeries.getX(n4)) || barPoint.front == null || (n16 = JCChartUtil.distance(point2.x, point2.y, barPoint.front)) > n8) continue;
                n6 = n3;
                n7 = n5;
                n8 = n16;
            }
        }
        if (n6 >= 0 && n7 >= 0) {
            jCDataIndex = new JCDataIndex(n7, (ChartDataViewSeries)this.seriesList.get(n6), n6);
            jCDataIndex.distance = n8;
        }
        return jCDataIndex;
    }

    public Point unpick(int n2, int n3) {
        if (this.pts == null) {
            return null;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n2 - this.firstLast.x][n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (barPoint == null) {
            return null;
        }
        double d2 = barPoint.y;
        double d3 = barPoint.x;
        if (d2 != this.holeValue && d3 != this.holeValue) {
            int n4 = barPoint.front.y + barPoint.front.height / 2;
            int n5 = barPoint.front.x + barPoint.front.width / 2;
            return new Point(n5, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.getXAxis().i_vertical;
        this.end = null;
        this.start = null;
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.getDrawingOrder()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n2;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n3;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
        BarPoint barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.getDrawingOrder()];
        int n4 = this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
        int n5 = (this.editInverted ? barPoint.front.x >= n4 : barPoint.front.y < n4) ? (this.editInverted ? n2 - this.r.x - barPoint.front.x : barPoint.front.y + barPoint.front.height - (n3 - this.r.y)) : (this.editInverted ? n2 - this.r.x - (barPoint.front.x + barPoint.front.width) : barPoint.front.y - (n3 - this.r.y));
        return this.editInverted ? n4 + n5 : n4 - n5;
    }

    public Point calcDataIndexPosition(JCChartLabel jCChartLabel, JCDataIndex jCDataIndex, int n2) {
        boolean bl;
        if (jCChartLabel == null || jCChartLabel.getComponent() == null || jCDataIndex == null) {
            return null;
        }
        if (n2 < 1 || n2 > 3) {
            return null;
        }
        int n3 = jCDataIndex.getPoint();
        int n4 = jCDataIndex.getSeriesIndex();
        int n5 = this.dataObject.getNumSeries();
        Point point = this.unpick(n3, n4);
        if (point == null) {
            return null;
        }
        if (n2 == 2) {
            return point;
        }
        int n6 = n3 - this.firstLast.x;
        if (n6 < 0 || n6 >= this.pts.length || n4 < 0 || n4 >= n5) {
            return null;
        }
        BarPoint barPoint = this.pts[n6][n4];
        if (barPoint == null) {
            return null;
        }
        double d2 = barPoint.y;
        double d3 = barPoint.x;
        if (d3 == this.holeValue || d2 == this.holeValue) {
            return null;
        }
        JComponent jComponent = jCChartLabel.getComponent();
        int n7 = jComponent.getWidth() / 2;
        int n8 = jComponent.getHeight() / 2;
        boolean bl2 = this.xaxis.isReversed();
        boolean bl3 = bl = n2 == 3;
        if (this.inverted) {
            point.y = bl ^ bl2 ? barPoint.front.y - n8 - 5 : barPoint.front.y + barPoint.front.height + n8 + 5;
        } else {
            point.x = bl ^ bl2 ? barPoint.front.x + barPoint.front.width + n7 + 5 : barPoint.front.x - n7 - 5;
        }
        return point;
    }
}

