/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaChartDraw;
import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDrawUtil;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.PickShapeArea;
import com.klg.jclass.chart.PickShapeStackingArea;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class SAreaChartDraw
extends AreaChartDraw {
    protected double[] ytotal;
    protected double[] ysum;
    protected double[] ysum_neg;
    protected double[][] ywork;

    public void recalc(int n2, int n3, int n4) {
        this.areaFormat = (JCAreaChartFormat)this.dataObject.getChartFormat(8);
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.yaxis = this.dataObject.getYAxis();
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        int n5 = this.seriesList.size();
        if (n5 == 0 || this.firstLast == null) {
            super.recalc(-1, -1, -1);
            return;
        }
        int n6 = this.firstLast.y - this.firstLast.x + 1;
        this.ytotal = new double[n6];
        this.ysum = new double[n6];
        this.ysum_neg = new double[n6];
        this.ywork = new double[n5][n6];
        ChartDrawUtil.calcStackingAreaInfo(this.ysum, this.ysum_neg, this.ytotal, this.ywork, this.firstLast.x, this.firstLast.y, this.dataObject);
        super.recalc(n2, n3, n4);
    }

    protected int getStartPoint(ChartDataViewSeries chartDataViewSeries) {
        return this.firstLast == null ? 0 : this.firstLast.x;
    }

    protected int getEndPoint(ChartDataViewSeries chartDataViewSeries) {
        return this.firstLast == null ? 0 : this.firstLast.y;
    }

    protected int getDataIndex(int n2) {
        return n2 - this.firstLast.x;
    }

    protected int getPointIndex(int n2) {
        return n2 + this.firstLast.x;
    }

    protected void initPolyEndLines(int n2, int n3) {
        int n4;
        this.polyAboveTopLine = new int[n3 - n2 + 1];
        for (n4 = 0; n4 < this.polyAboveTopLine.length; ++n4) {
            this.polyAboveTopLine[n4] = this.polyAboveBaseLine == null || n4 >= this.polyAboveBaseLine.length ? this.baseValue : this.polyAboveBaseLine[n4];
        }
        this.polyBelowBottomLine = new int[n3 - n2 + 1];
        for (n4 = 0; n4 < this.polyBelowBottomLine.length; ++n4) {
            this.polyBelowBottomLine[n4] = this.polyBelowBaseLine == null || n4 >= this.polyBelowBaseLine.length ? this.baseValue : this.polyBelowBaseLine[n4];
        }
    }

    protected void resetPolyBaseLines() {
        this.polyAboveBaseLine = this.polyAboveTopLine;
        this.polyBelowBaseLine = this.polyBelowBottomLine;
    }

    protected void finishAreaPolygon(AreaPolygon areaPolygon, int n2, boolean bl, ChartDataViewSeries chartDataViewSeries, Point point) {
        Polygon polygon = areaPolygon.poly;
        double[] dArray = this.getXVals(chartDataViewSeries);
        int n3 = areaPolygon.nBottomPoints = areaPolygon.isLeading ? 0 : 1;
        if (n2 > areaPolygon.endPoint) {
            areaPolygon.endPoint = n2;
            areaPolygon.isTrailing = true;
        }
        for (int i2 = areaPolygon.endPoint; i2 > areaPolygon.startPoint; --i2) {
            double d2 = dArray[i2];
            if (this.xaxis.skipValue(d2, this.holeValue)) continue;
            int n4 = this.xaxis.toPixel(d2, this.drawFront);
            int n5 = this.getBaseValue(areaPolygon, i2);
            if (bl) {
                polygon.addPoint(n5, n4);
            } else {
                polygon.addPoint(n4, n5);
            }
            if (i2 == areaPolygon.endPoint && areaPolygon.isTrailing) continue;
            ++areaPolygon.nBottomPoints;
        }
        int[] nArray = areaPolygon.belowOrigin ? this.polyBelowBottomLine : this.polyAboveTopLine;
        int n6 = areaPolygon.isLeading ? 0 : 1;
        for (int i3 = areaPolygon.startPoint; i3 <= areaPolygon.endPoint; ++i3) {
            if (this.xaxis.skipValue(dArray[i3], this.holeValue)) continue;
            nArray[i3] = bl ? areaPolygon.poly.xpoints[n6] : areaPolygon.poly.ypoints[n6];
            ++n6;
        }
    }

    protected double getYOrigin() {
        if (this.dataObject == null) {
            return Double.MAX_VALUE;
        }
        if (this.areaFormat == null) {
            this.areaFormat = (JCAreaChartFormat)this.dataObject.getChartFormat(8);
        }
        return this.areaFormat.is100Percent() ? 0.0 : super.getYOrigin();
    }

    protected boolean isConnectedAcrossOrigin() {
        return false;
    }

    protected int getBaseValue(AreaPolygon areaPolygon, int n2) {
        int[] nArray;
        if (areaPolygon == null) {
            return this.baseValue;
        }
        int n3 = Math.max(0, n2);
        if (areaPolygon.onlyOriginValues && areaPolygon.originalY == this.origin) {
            if (this.polyAboveBaseLine != null && n3 < this.polyAboveBaseLine.length && this.polyAboveBaseLine[n3] < this.baseValue ^ this.inverted) {
                areaPolygon.belowOrigin = true;
            } else if (this.polyBelowBaseLine != null && n3 < this.polyBelowBaseLine.length && this.polyBelowBaseLine[n3] > this.baseValue ^ this.inverted) {
                areaPolygon.belowOrigin = false;
            }
        }
        int[] nArray2 = nArray = areaPolygon.belowOrigin ? this.polyBelowBaseLine : this.polyAboveBaseLine;
        if (nArray == null || n3 >= nArray.length) {
            return this.baseValue;
        }
        return nArray[n3];
    }

    protected double[] getXVals(ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return null;
        }
        int n2 = this.firstLast.y - this.firstLast.x + 1;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = chartDataViewSeries.getX(i2 + this.firstLast.x);
        }
        return dArray;
    }

    protected double[] getCalculatedYVals(ChartDataViewSeries chartDataViewSeries) {
        return this.ywork[chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries)];
    }

    public double getWorkingYValue(int n2, int n3, boolean bl) {
        if (this.dataObject == null || this.seriesList == null || this.ywork == null) {
            return this.holeValue;
        }
        int n4 = this.seriesList.size();
        if (n2 < 0 || n2 >= n4 || this.firstLast == null) {
            return this.holeValue;
        }
        int n5 = n3 - this.firstLast.x;
        if (n5 < 0 || n5 >= this.ywork[n2].length) {
            return this.holeValue;
        }
        double d2 = this.ywork[n2][n5];
        if (bl) {
            return d2;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (!chartDataViewSeries.isIncluded() || !chartDataViewSeries.isVisible()) continue;
            double d3 = this.ywork[i2][n5];
            if (Math.signum(d2) != Math.signum(d3)) continue;
            return d2 - d3;
        }
        return d2;
    }

    public void draw(Graphics graphics, int n2, int n3) {
        super.draw(graphics, n2, n3, true);
    }

    protected PickShapeArea createPickShapeArea(Picker picker) {
        return new PickShapeStackingArea(picker, this.inverted);
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        double d2;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return -1;
        }
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        if (this.xaxis.skipValue(chartDataViewSeries.getX(jCDataIndex.point), this.holeValue)) {
            return -1;
        }
        this.drawRubberLines();
        this.last = null;
        this.next = null;
        this.prev = null;
        double d3 = chartDataViewSeries.getCalculatedY(jCDataIndex.point);
        if (d3 == this.holeValue) {
            return -1;
        }
        if (this.areaFormat.is100Percent() && (d2 = this.ytotal[jCDataIndex.point - this.firstLast.x]) != 0.0) {
            d3 *= 100.0 / d2;
        }
        int n4 = this.yaxis.toPixel(d3, this.drawFront);
        double d4 = this.ywork[chartDataViewSeries.getDrawingOrder()][jCDataIndex.point - this.firstLast.x];
        int n5 = this.yaxis.toPixel(d4, this.drawFront);
        int n6 = this.inverted ? n2 - this.r.x - n5 : n5 - (n3 - this.r.y);
        return this.inverted ? n4 + n6 : n4 - n6;
    }

    private void defineAreaShape(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, ChartDataViewSeries chartDataViewSeries, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        double d2 = n6 - n4;
        double d3 = (double)(n7 - n5) / d2;
        int n10 = n4 + (int)(d2 / 2.0);
        int n11 = n5 - (int)(d3 * (double)(n4 - n10));
        double d4 = (double)(n9 - n8) / d2;
        int n12 = n8 - (int)(d4 * (double)(n4 - n10));
        this.createShape(defineShape, graphics, jCFillStyle, false, chartDataViewSeries, n2, n4, n5, n8, n10, n11, n12);
        this.createShape(defineShape, graphics, jCFillStyle, false, chartDataViewSeries, n3, n10, n11, n12, n6, n7, n9);
    }

    private void defineAreaShapeInverted(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, ChartDataViewSeries chartDataViewSeries, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        double d2 = n7 - n5;
        double d3 = (double)(n6 - n4) / d2;
        int n10 = n5 + (int)(d2 / 2.0);
        int n11 = n4 - (int)(d3 * (double)(n5 - n10));
        double d4 = (double)(n9 - n8) / d2;
        int n12 = n8 - (int)(d4 * (double)(n5 - n10));
        this.createShape(defineShape, graphics, jCFillStyle, true, chartDataViewSeries, n2, n4, n5, n8, n11, n10, n12);
        this.createShape(defineShape, graphics, jCFillStyle, true, chartDataViewSeries, n3, n11, n10, n12, n6, n7, n9);
    }

    protected void defineAreaShapes(DefineShape defineShape, Graphics graphics, JCFillStyle jCFillStyle, boolean bl, AreaPolygon areaPolygon, ChartDataViewSeries chartDataViewSeries) {
        int n2;
        double[] dArray = this.getXVals(chartDataViewSeries);
        Polygon polygon = areaPolygon.poly;
        int n3 = n2 = areaPolygon.isLeading ? 0 : 1;
        for (int i2 = areaPolygon.startPoint; i2 < areaPolygon.endPoint; ++i2) {
            int n4;
            int n5;
            if (this.xaxis.skipValue(dArray[i2], this.holeValue)) continue;
            int n6 = polygon.xpoints[n3];
            int n7 = polygon.ypoints[n3];
            int n8 = areaPolygon.getBottomVertex(n3);
            int n9 = i2 - areaPolygon.startPoint + n2 + 1;
            int n10 = polygon.xpoints[n9];
            int n11 = polygon.ypoints[n9];
            int n12 = areaPolygon.getBottomVertex(n9);
            if (bl) {
                n5 = polygon.xpoints[n8];
                n4 = polygon.xpoints[n12];
                this.defineAreaShapeInverted(defineShape, graphics, jCFillStyle, chartDataViewSeries, i2 + 1 - (n9 - n3), i2 + 1, n6, n7, n10, n11, n5, n4);
            } else {
                n5 = polygon.ypoints[n8];
                n4 = polygon.ypoints[n12];
                this.defineAreaShape(defineShape, graphics, jCFillStyle, chartDataViewSeries, i2 + 1 - (n9 - n3), i2 + 1, n6, n7, n10, n11, n5, n4);
            }
            n3 = n9;
        }
    }
}

