/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.ProcessShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class RenderShape
implements ProcessShape,
Serializable {
    protected Graphics gc = null;
    protected Graphics lineGC = null;
    protected JCLineStyle lStyle = null;
    protected JCFillStyle fStyle = null;
    protected JCSymbolStyle sStyle = null;
    protected boolean usingDoublePixels = false;
    protected int chartType = -1;

    public RenderShape(Graphics graphics) {
        this.gc = graphics;
        this.lineGC = graphics;
    }

    public RenderShape(Graphics graphics, Graphics graphics2, boolean bl) {
        this.gc = graphics;
        this.lineGC = graphics2;
        this.usingDoublePixels = bl;
    }

    public RenderShape(Graphics graphics, JCLineStyle jCLineStyle, JCFillStyle jCFillStyle, JCSymbolStyle jCSymbolStyle) {
        this(graphics);
        this.setLineStyle(jCLineStyle);
        this.setFillStyle(jCFillStyle);
        this.setSymbolStyle(jCSymbolStyle);
    }

    public RenderShape(Graphics graphics, JCChartStyle jCChartStyle) {
        this(graphics);
        this.setChartStyle(jCChartStyle);
    }

    public int getShapeType() {
        return 0;
    }

    public Graphics getGC() {
        return this.gc;
    }

    public Graphics getLineGC() {
        return this.lineGC;
    }

    public void setChartType(int n2) {
        this.chartType = n2;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        this.lStyle = jCLineStyle;
        if (jCLineStyle != null && this.lineGC != null) {
            jCLineStyle.updateGraphics(this.lineGC);
        }
    }

    public JCLineStyle getLineStyle() {
        return this.lStyle;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        this.fStyle = jCFillStyle;
    }

    public JCFillStyle getFillStyle() {
        return this.fStyle;
    }

    public void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
        this.sStyle = jCSymbolStyle;
    }

    public JCSymbolStyle getSymbolStyle() {
        return this.sStyle;
    }

    public void setChartStyle(JCChartStyle jCChartStyle) {
        if (jCChartStyle != null) {
            this.lStyle = jCChartStyle.getLineStyle();
            this.fStyle = jCChartStyle.getFillStyle();
            this.sStyle = jCChartStyle.getSymbolStyle();
        }
    }

    public void tagData(JCDataIndex jCDataIndex) {
    }

    public void tagData(int n2, ChartDataViewSeries chartDataViewSeries, int n3) {
    }

    public void tagDataLine(int n2, int n3, ChartDataViewSeries chartDataViewSeries, int n4) {
    }

    public void updateFillOrientation(Rectangle2D rectangle2D, int n2) {
        if (this.fStyle != null) {
            this.fStyle.updateFillOrientation(rectangle2D, n2);
        }
    }

    public void resetFillOrientation() {
        if (this.fStyle != null) {
            this.fStyle.resetFillOrientation();
        }
    }

    public void fillPolygon(Shape shape) {
        if (this.gc != null && this.fStyle != null) {
            this.fStyle.fillPolygon(this.gc, shape);
        }
    }

    public void fillPolygonShadow(Shape shape) {
        if (this.gc != null && this.fStyle != null) {
            this.fStyle.fillPolygonShadow(this.gc, shape);
        }
    }

    public void fillOutlinePolygon(Shape shape) {
        if (this.fStyle != null && this.gc != null && shape instanceof Polygon) {
            this.fStyle.fillPolygon(this.gc, (Polygon)shape);
            if (this.lStyle != null) {
                this.fStyle.drawOutlinePolygon(this.gc, (Polygon)shape, this.lStyle);
                this.lStyle.resetGraphics(this.gc);
            }
        }
    }

    public void fillOutlinePolygon(Shape shape, Color color) {
        if (this.fStyle != null && this.gc != null && shape instanceof Polygon) {
            this.fStyle.fillOutlinePolygon(this.gc, (Polygon)shape, color);
        }
    }

    public void fillOutlinePolygon(Shape shape, int n2, int n3) {
        if (this.fStyle != null && this.gc != null && shape instanceof Polygon) {
            this.fStyle.fillPolygon(this.gc, (Polygon)shape);
            if (this.lStyle != null) {
                this.fStyle.drawOutlineLine(this.gc, (Polygon)shape, n2, n3, this.lStyle);
                this.lStyle.resetGraphics(this.gc);
            }
        }
    }

    public void fillOutlinePartialPolygon(Shape shape) {
        if (this.fStyle != null && this.gc != null && shape instanceof Polygon) {
            this.fStyle.fillOutlinePartialPolygon(this.gc, (Polygon)shape, this.lStyle);
            if (this.lStyle != null) {
                this.lStyle.resetGraphics(this.gc);
            }
        }
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.gc != null && this.fStyle != null) {
            this.fStyle.fillArc(this.gc, d2, d3, d4, d5, d6, d7);
        }
    }

    public void fillArcShadow(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.gc != null && this.fStyle != null) {
            this.fStyle.fillArcShadow(this.gc, d2, d3, d4, d5, d6, d7);
        }
    }

    public void fillArcRegion(Point point, Point point2, double d2, double d3) {
        if (point == null || point2 == null || this.fStyle == null) {
            return;
        }
        double d4 = point2.distance(d2, d3);
        double d5 = point.distance(d2, d3);
        Graphics2D graphics2D = (Graphics2D)this.gc;
        double d6 = Math.abs(d4 - d5);
        graphics2D.setStroke(new BasicStroke((float)d6, 0, 0));
        double d7 = (d4 + d5) / 2.0;
        double d8 = d2 - d7;
        double d9 = d3 - d7;
        double d10 = 2.0 * d7;
        Arc2D.Double double_ = new Arc2D.Double(d8, d9, d10, d10, 0.0, 360.0, 0);
        Color color = this.fStyle.getBackground();
        if (this.fStyle.getPattern() == 11 && color != null) {
            graphics2D.setColor(color);
            graphics2D.draw(double_);
        }
        double d11 = Math.max(d5, d4);
        d8 = d2 - d11;
        d9 = d3 - d11;
        d10 = 2.0 * d11;
        this.fStyle.updateAnchorRect(new Rectangle2D.Double(d8, d9, d10, d10));
        this.fStyle.updateGraphics(graphics2D);
        graphics2D.draw(double_);
        this.fStyle.updateAnchorRect(null);
        this.fStyle.resetGraphics(graphics2D);
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    public void drawSymbol(double d2, double d3, Color color) {
        if (this.gc != null && this.sStyle != null) {
            if (this.usingDoublePixels) {
                this.sStyle.draw(this.gc, d2, d3, color);
            } else {
                this.sStyle.draw(this.gc, (int)d2, (int)d3, color);
            }
        }
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        if (this.lineGC != null && this.lStyle != null) {
            this.lStyle.drawLine(this.lineGC, d2, d3, d4, d5);
        }
    }

    public void drawLine(Line2D.Double double_, Color color) {
        Graphics2D graphics2D = (Graphics2D)this.lineGC;
        if (graphics2D != null && double_ != null) {
            if (color != null && !graphics2D.getColor().equals(color)) {
                graphics2D.setColor(color);
            }
            graphics2D.draw(double_);
        }
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.lineGC != null && this.lStyle != null) {
            this.lStyle.drawArc(this.lineGC, d2, d3, d4, d5, d6, d7);
        }
    }

    public void drawCircle(double d2, double d3, double d4) {
        if (this.lineGC != null && this.lStyle != null) {
            this.lStyle.drawCircle(this.lineGC, (int)d2, (int)d3, (int)d4);
        }
    }

    public void drawShape(Shape shape) {
        if (shape != null && this.lineGC != null && this.lStyle != null) {
            this.lStyle.drawShape(this.lineGC, shape);
        }
    }

    public void drawString(String string, int n2, int n3) {
        if (this.gc != null) {
            this.gc.drawString(string, n2, n3);
        }
    }

    public void setColor(Color color) {
        if (this.gc != null) {
            this.gc.setColor(color);
        }
    }

    public void setClip(Shape shape) {
        if (this.gc != null) {
            this.gc.setClip(shape);
        }
        if (this.lineGC != null && this.lineGC != this.gc) {
            this.lineGC.setClip(shape);
        }
    }

    public Shape getClip() {
        if (this.gc != null) {
            return this.gc.getClip();
        }
        if (this.lineGC != null) {
            return this.lineGC.getClip();
        }
        return null;
    }

    public boolean isWithinClip() {
        return true;
    }

    public FontMetrics getFontMetrics() {
        if (this.gc != null) {
            return this.gc.getFontMetrics();
        }
        return null;
    }
}

