/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.LogAxisHandler;
import com.klg.jclass.chart.LogAxisScaleHandler;
import com.klg.jclass.chart.RectangularChartAxisHandler;
import java.awt.Dimension;

class RectangularChartLogAxisHandler
extends RectangularChartAxisHandler
implements LogAxisHandler {
    RectangularChartLogAxisHandler() {
        this.axisScaleHandler = new LogAxisScaleHandler();
    }

    protected double toData(int n2) {
        if (this.parent.i_vertical) {
            n2 = this.parent.getHeight() - n2;
        }
        return Math.pow(10.0, ((double)n2 - this.shift) / this.scale);
    }

    protected int toPixel(double d2) {
        if (d2 <= 0.0) {
            d2 = this.parent.min.value;
        }
        int n2 = JCChartUtil.ifloor(this.scale * JCChartUtil.log10(d2) + this.shift + 0.5);
        return this.parent.i_vertical ? this.parent.getHeight() - n2 : n2;
    }

    protected int toPixelInternal(double d2, AxisHandler.ClusterAdjustment clusterAdjustment) {
        return this.toPixel(d2);
    }

    protected double toPixelDouble(double d2) {
        if (d2 <= 0.0) {
            d2 = this.parent.min.value;
        }
        double d3 = this.scale * JCChartUtil.log10(d2) + this.shift;
        return this.parent.i_vertical ? (double)this.parent.getHeight() - d3 : d3;
    }

    protected void calcParams() {
        int n2;
        int n3;
        int n4;
        double d2 = this.parent.dataLimits == null ? 1.0 : this.parent.dataLimits.min;
        double d3 = this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max;
        int n5 = 0;
        int n6 = 0;
        d2 = this.parent.min.isDefault ? d2 : this.parent.min.value;
        d3 = this.parent.max.isDefault ? d3 : this.parent.max.value;
        int n7 = JCChartUtil.ifloor(JCChartUtil.precCorrect(10, JCChartUtil.log10(d2)));
        int n8 = JCChartUtil.iceil(JCChartUtil.log10(d3));
        do {
            this.calcPrecision();
        } while (this.axisScaleHandler.fixBounds());
        if (this.parent.i_vertical) {
            if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
                if (this.parent.chartType == 9 || this.parent.chartType == 10 || this.parent.chartType == 12 || this.parent.chartType == 8) {
                    --n7;
                }
            } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
                n4 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
                if (n4 < n7 && this.parent.min.isDefault) {
                    n7 = n4;
                }
                if (n4 > n8 && this.parent.max.isDefault) {
                    n8 = n4;
                }
            }
        } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
            n4 = JCChartUtil.ifloor(JCChartUtil.log10(this.parent.origin.value));
            if (n4 < n7 && this.parent.min.isDefault) {
                n7 = n4;
            }
            if (n4 > n8 && this.parent.max.isDefault) {
                n8 = n4;
            }
        }
        n4 = 0;
        Dimension dimension = new Dimension();
        int n9 = this.parent.pixelLength();
        for (n3 = 1; n3 <= 5; ++n3) {
            n5 = n7;
            n6 = n8;
            int n10 = n2 = JCChartUtil.abs(n6) > JCChartUtil.abs(n5) ? 1 : 0;
            while ((n6 - n5) % n3 != 0) {
                if (n2 != 0) {
                    ++n6;
                } else {
                    --n5;
                }
                n2 = n2 == 0 ? 1 : 0;
            }
            int n11 = this.parent.getAnnotationRotation();
            if (n11 == 4) {
                n4 = this.calcRotatedAnnoSpacing(n5, n6);
            } else {
                boolean bl;
                this.getAnnoExtent(dimension, n6, this.parent.getPrecision());
                this.getAnnoExtent(dimension, n5, this.parent.getPrecision());
                boolean bl2 = bl = n11 == 0;
                if (this.parent.i_vertical) {
                    n4 = bl ? dimension.height * 2 : dimension.width + dimension.width / 2;
                } else {
                    int n12 = n4 = bl ? dimension.width + dimension.width / 2 : dimension.height * 2;
                }
            }
            if ((n6 - n5) / n3 * n4 < n9) break;
        }
        if (n3 <= 5) {
            this.parent.tickSpacing.value = JCChartUtil.pow10(n3);
        } else {
            n5 = n7;
            n6 = n8;
            n2 = Math.max(n6 - n5, 1);
            this.parent.tickSpacing.value = JCChartUtil.pow10(n2);
        }
        this.parent.numSpacing.value = this.parent.tickSpacing.value;
        if (this.parent.min.isDefault) {
            this.parent.min.value = JCChartUtil.pow10(n5);
        }
        if (this.parent.max.isDefault) {
            this.parent.max.value = JCChartUtil.pow10(n6);
        }
        if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
            switch (this.parent.originPlacement.value) {
                case 2: {
                    this.parent.origin.value = this.parent.max.value;
                    break;
                }
                case 0: 
                case 1: 
                case 3: {
                    this.parent.origin.value = this.parent.min.value;
                }
            }
        }
        if (this.parent.i_vertical) {
            n2 = this.parent.visible ? n4 + 1 + this.parent.tickLength / 2 : 0;
            this.parent.setSize(n2, this.parent.getHeight());
        } else {
            n2 = this.parent.visible ? dimension.height + 1 + this.parent.tickLength / 2 : 0;
            this.parent.setSize(this.parent.getWidth(), n2);
        }
    }

    protected void calcTransformation() {
        int n2 = this.parent.pixelLength();
        this.computeTransformation(JCChartUtil.log10(this.parent.min.value), JCChartUtil.log10(this.parent.max.value), n2);
    }
}

