/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

public class PolarChartDraw
extends ChartDraw {
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    protected boolean isRadar = false;
    Line2D.Double perpendicular = null;
    Point prev = null;
    Point next = null;
    Point last = null;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n2, int n3) {
        this.recalc(n2, n3, -1);
    }

    public void recalc(int n2, int n3, int n4) {
        if (!this.isChanged()) {
            return;
        }
        boolean bl = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
            bl = true;
        }
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        if (this.xaxis == null || this.yaxis == null) {
            return;
        }
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.i_vertical;
        if (bl) {
            int n5 = 0;
            int n6 = this.seriesList.size();
            for (int i2 = n5; i2 < n6; ++i2) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
                if (!chartDataViewSeries.isVisible() || chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) continue;
                double[] dArray = chartDataViewSeries.getY();
                for (int i3 = n2; i3 <= n3; ++i3) {
                    this.ylim.setMinMax(dArray[i3], this.holeValue, this.yaxis.isLogarithmic());
                }
            }
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        } else if (n4 == -1 || n4 == 0) {
            if (this.dataObject.getXLimits() == null) {
                return;
            }
            if (this.dataObject.getYLimits() == null) {
                return;
            }
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n2, int n3) {
        Shape shape;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.seriesList == null || this.xaxis == null || this.yaxis == null) {
            return;
        }
        boolean bl = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
            bl = true;
        }
        Graphics graphics2 = graphics.create();
        double d2 = this.yaxis.pixelLength();
        double d3 = this.yaxis.polarAxisParams.xCenter;
        double d4 = this.yaxis.polarAxisParams.yCenter;
        if (this.dataObject.getChartType() == 2 || this.yaxis.polarAxisParams.isCircularGrid()) {
            shape = new Ellipse2D.Double(d3 - d2, d4 - d2, 2.0 * d2, 2.0 * d2);
        } else {
            int n4 = ChartDataView.getNumRadarSpokes(this.dataObject);
            shape = this.yaxis.createWebbedShape(d2, n4);
        }
        graphics2.setClip(shape);
        DefineShape defineShape = null;
        DefineShape defineShape2 = null;
        if (graphics2 instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics2);
            defineShape2 = (DefineShape)((Object)graphics);
        }
        int n5 = 0;
        int n6 = this.seriesList.size();
        for (int i2 = n5; i2 < n6; ++i2) {
            JCLineStyle jCLineStyle;
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(i2);
            if (!chartDataViewSeries.isVisible() || chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) continue;
            if (!bl) {
                n2 = this.getFirstPoint(chartDataViewSeries);
                n3 = this.getLastPoint(chartDataViewSeries);
            } else {
                int n7 = chartDataViewSeries.getLastPoint();
                if (n2 < n7) {
                    n2 = n7;
                }
            }
            double[] dArray = chartDataViewSeries.getX();
            double[] dArray2 = chartDataViewSeries.getY();
            double d5 = 0.0;
            double d6 = this.holeValue;
            if (bl && n2 > 0) {
                d5 = dArray[n2 - 1];
                d6 = dArray2[n2 - 1];
            }
            if ((jCChartStyle = chartDataViewSeries.getStyle()) == null) continue;
            JCLineStyle jCLineStyle2 = jCLineStyle = jCChartStyle.getLineStyle();
            jCLineStyle2.updateGraphics(graphics2);
            Line2D.Double double_ = new Line2D.Double();
            JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
            boolean bl2 = jCSymbolStyle.getShape() == 0;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            JCLineStyle jCLineStyle3 = null;
            JCChartStyle jCChartStyle2 = chartDataViewSeries.getHoleStyle();
            if (jCChartStyle2 != null && !bl && !this.isRadar && (jCLineStyle3 = jCChartStyle2.getLineStyle()) != null && jCLineStyle3.getPattern() != 0 && jCLineStyle3.getWidth() > 0) {
                bl5 = true;
            }
            PlotPoint plotPoint = new PlotPoint();
            int n8 = n3 - n2 + 1;
            boolean bl6 = this.yaxis.isLogarithmic();
            for (int i3 = n2; i3 <= n3; ++i3) {
                double d7 = dArray[i3];
                double d8 = dArray2[i3];
                if (bl6 && d8 <= 0.0) {
                    d8 = this.holeValue;
                }
                if ((d7 == this.holeValue || d8 == this.holeValue) && plotPoint.valid && bl5 && i3 < n3) {
                    bl4 = true;
                    continue;
                }
                PlotPoint plotPoint2 = this.getPlotPoint(i3 - n2, n8, d7, d8);
                boolean bl7 = false;
                if (plotPoint.valid && plotPoint2.valid) {
                    jCLineStyle2 = bl4 ? jCLineStyle3 : jCLineStyle;
                    boolean bl8 = bl3 ^ bl4;
                    bl3 = bl4;
                    this.drawLine(graphics2, plotPoint, plotPoint2, jCLineStyle2, bl8, this.getLineColor(d5, d6, d7, d8, jCLineStyle2), defineShape, double_);
                    bl7 = true;
                }
                if (plotPoint.valid && plotPoint.drawPoint && !bl2) {
                    this.drawSymbol(graphics, plotPoint, chartDataViewSeries, i3 - 1, jCSymbolStyle, this.getSymbolColor(d5, d6), defineShape2);
                }
                if (bl7 || !bl4) {
                    plotPoint.px = plotPoint2.px;
                    plotPoint.py = plotPoint2.py;
                    plotPoint.drawPoint = plotPoint2.drawPoint;
                    plotPoint.valid = plotPoint2.valid;
                    d5 = d7;
                    d6 = d8;
                }
                bl4 = false;
            }
            if (this.isRadar) {
                double d9 = dArray[n2];
                double d10 = dArray2[n2];
                if (bl6 && d10 <= 0.0) {
                    d10 = this.holeValue;
                }
                PlotPoint plotPoint3 = this.getPlotPoint(0, n8, d9, d10);
                if (plotPoint.valid && plotPoint3.valid) {
                    this.drawLine(graphics2, plotPoint, plotPoint3, jCLineStyle2, false, this.getLineColor(d5, d6, d9, d10, jCLineStyle2), defineShape, double_);
                }
            }
            if (!plotPoint.valid || !plotPoint.drawPoint || bl2) continue;
            this.drawSymbol(graphics, plotPoint, chartDataViewSeries, n3, jCSymbolStyle, this.getSymbolColor(d5, d6), defineShape2);
        }
        graphics2.dispose();
    }

    private void drawSymbol(Graphics graphics, PlotPoint plotPoint, ChartDataViewSeries chartDataViewSeries, int n2, JCSymbolStyle jCSymbolStyle, Color color, DefineShape defineShape) {
        if (defineShape != null) {
            defineShape.markShape(new JCDataIndex(n2, chartDataViewSeries));
        }
        jCSymbolStyle.draw(graphics, plotPoint.px, plotPoint.py, color);
        if (defineShape != null) {
            defineShape.unmarkShape();
        }
    }

    private void drawLine(Graphics graphics, PlotPoint plotPoint, PlotPoint plotPoint2, JCLineStyle jCLineStyle, boolean bl, Color color, DefineShape defineShape, Line2D.Double double_) {
        boolean bl2 = true;
        if (jCLineStyle != null) {
            boolean bl3 = bl2 = jCLineStyle.getPattern() == 0 || jCLineStyle.getWidth() <= 0;
            if (bl && !bl2) {
                jCLineStyle.updateGraphics(graphics);
            }
        }
        if (!bl2) {
            if (color != null && !graphics.getColor().equals(color)) {
                graphics.setColor(color);
            }
            if (defineShape != null) {
                defineShape.beginShape();
            }
            double_.setLine(plotPoint.px, plotPoint.py, plotPoint2.px, plotPoint2.py);
            ((Graphics2D)graphics).draw(double_);
            if (defineShape != null) {
                defineShape.endShape(true);
            }
        }
    }

    protected int getFirstPoint(ChartDataViewSeries chartDataViewSeries) {
        return chartDataViewSeries.getFirstPoint();
    }

    protected int getLastPoint(ChartDataViewSeries chartDataViewSeries) {
        return chartDataViewSeries.getLastPoint();
    }

    protected PlotPoint getPlotPoint(int n2, int n3, double d2, double d3) {
        PlotPoint plotPoint = new PlotPoint();
        if (this.xaxis != null && this.yaxis != null && d3 != this.holeValue) {
            int n4 = this.dataObject.getParent().chartArea.getAngleUnit();
            double d4 = JCChartUtil.convertAngle(n4, 2, d2);
            Point point = this.yaxis.toPixelPolar(d4, d3, true);
            plotPoint.px = point.x;
            plotPoint.py = point.y;
            plotPoint.drawPoint = true;
            plotPoint.valid = true;
        } else {
            plotPoint.px = 2.147483647E9;
            plotPoint.py = 2.147483647E9;
            plotPoint.drawPoint = false;
            plotPoint.valid = false;
        }
        return plotPoint;
    }

    protected double getThetaValue(int n2, int n3, int n4, double[] dArray) {
        return dArray[n2];
    }

    public JCDataIndex pick(Point point, int n2) {
        return this.pickInternal(point, n2, false);
    }

    public JCDataIndex pickSeries(Point point, int n2) {
        if (n2 != 0) {
            throw new UnsupportedOperationException("Only PICK_FOCUS_XY is supported for pickSeries");
        }
        return this.pickInternal(point, n2, true);
    }

    protected JCDataIndex pickInternal(Point point, int n2, boolean bl) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        JCDataIndex jCDataIndex = null;
        if (this.yaxis == null) {
            return jCDataIndex;
        }
        JCDataCoord jCDataCoord = this.yaxis.toDataPolar(n3, n4);
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n5 = 0;
        int n6 = this.seriesList.size();
        int n7 = -1;
        int n8 = -1;
        double d2 = Double.MAX_VALUE;
        int n9 = Integer.MAX_VALUE;
        try {
            int n10;
            int n11;
            int n12;
            JCDataIndex jCDataIndex2 = new JCDataIndex();
            for (n12 = n5; n12 < n6; ++n12) {
                double d3;
                double d4 = d3 = bl ? this.findClosestLine(n12, jCDataIndex2, n3, n4) : this.findClosestPointPrimary(n2, n12, jCDataIndex2, n3, n4, jCDataCoord);
                if (!(d3 < d2)) continue;
                d2 = d3;
                n7 = n12;
                n8 = jCDataIndex2.point;
                n9 = jCDataIndex2.distance;
            }
            jCDataIndex2.seriesIndex = n7;
            jCDataIndex2.point = n8;
            jCDataIndex2.distance = n9;
            n12 = -1;
            int n13 = -1;
            int n14 = Integer.MAX_VALUE;
            if (n2 != 0 && !bl) {
                JCDataIndex jCDataIndex3 = new JCDataIndex();
                for (n11 = n5; n11 < n6; ++n11) {
                    n10 = this.findClosestPointSecondary(n2, n11, jCDataIndex2, jCDataIndex3, n3, n4, jCDataCoord) ? 1 : 0;
                    if (n10 == 0 || jCDataIndex3.distance >= n14) continue;
                    n14 = jCDataIndex3.distance;
                    n12 = n11;
                    n13 = jCDataIndex3.point;
                }
            }
            if (n7 >= 0 && n8 >= 0) {
                int n15 = n7;
                n11 = n8;
                n10 = n9;
                if (n12 >= 0 && n13 >= 0 && n14 < n9) {
                    n15 = n12;
                    n11 = n13;
                    n10 = n14;
                }
                jCDataIndex = new JCDataIndex(n11, (ChartDataViewSeries)this.seriesList.get(n15), n15);
                jCDataIndex.distance = n10;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            JCChart jCChart = (JCChart)this.chartArea.getParent();
            if (jCChart != null) {
                jCChart.getErrorLog().logErrorMessage("picking", exception);
            }
            return null;
        }
    }

    private double findClosestPointPrimary(int n2, int n3, JCDataIndex jCDataIndex, int n4, int n5, JCDataCoord jCDataCoord) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null || !chartDataViewSeries.isVisible()) {
            return 2.147483647E9;
        }
        int n6 = this.getFirstPoint(chartDataViewSeries);
        int n7 = this.getLastPoint(chartDataViewSeries);
        if (n6 == Integer.MAX_VALUE || n7 == Integer.MAX_VALUE) {
            return 2.147483647E9;
        }
        double[] dArray = chartDataViewSeries.getX();
        double[] dArray2 = chartDataViewSeries.getY();
        double d2 = Double.MAX_VALUE;
        int n8 = -1;
        double d3 = this.holeValue;
        double d4 = this.holeValue;
        boolean bl = this.yaxis.isLogarithmic();
        int n9 = this.yaxis.chartArea.getAngleUnit();
        for (int i2 = n6; i2 <= n7; ++i2) {
            double d5;
            double d6 = this.getThetaValue(i2, n6, n7, dArray);
            double d7 = dArray2[i2];
            if (d6 == this.holeValue || d7 == this.holeValue || d7 > this.ylim.max || bl && d7 <= 0.0) continue;
            if (!this.isRadar && !this.yaxis.isReversed() && d7 < 0.0) {
                d7 *= -1.0;
                d6 += JCChartUtil.convertAngle(1, n9, 180.0);
            }
            double d8 = JCChartUtil.boundAngle(n9, d6);
            switch (n2) {
                case 1: {
                    d5 = Math.abs(d8 - jCDataCoord.x);
                    d5 = Math.min(d5, JCChartUtil.boundAngle(n9, -d5));
                    break;
                }
                case 2: {
                    d5 = Math.abs(jCDataCoord.y - d7);
                    break;
                }
                default: {
                    d5 = this.calcXYDistance(n4, n5, d6, d7);
                }
            }
            if (!(d5 < d2)) continue;
            n8 = i2;
            d3 = d6;
            d4 = d7;
            d2 = d5;
        }
        jCDataIndex.seriesIndex = n3;
        jCDataIndex.point = n8;
        jCDataIndex.distance = n2 == 0 ? (int)Math.round(d2) : (d3 != this.holeValue && d4 != this.holeValue ? (int)Math.round(this.calcXYDistance(n4, n5, d3, d4)) : Integer.MAX_VALUE);
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean findClosestPointSecondary(int n2, int n3, JCDataIndex jCDataIndex, JCDataIndex jCDataIndex2, int n4, int n5, JCDataCoord jCDataCoord) {
        if (n2 != 1 && n2 != 2) {
            return false;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(jCDataIndex.seriesIndex);
        if (chartDataViewSeries == null) return false;
        if (!chartDataViewSeries.isVisible()) {
            return false;
        }
        double[] dArray = chartDataViewSeries.getX();
        double[] dArray2 = chartDataViewSeries.getY();
        double d2 = dArray[jCDataIndex.point];
        double d3 = dArray2[jCDataIndex.point];
        ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries2 == null) return false;
        if (!chartDataViewSeries2.isVisible()) {
            return false;
        }
        int n6 = this.getFirstPoint(chartDataViewSeries2);
        int n7 = this.getLastPoint(chartDataViewSeries2);
        if (n6 == Integer.MAX_VALUE) return false;
        if (n7 == Integer.MAX_VALUE) {
            return false;
        }
        double[] dArray3 = chartDataViewSeries2.getX();
        double[] dArray4 = chartDataViewSeries2.getY();
        int n8 = -1;
        double d4 = 2.147483647E9;
        double d5 = this.holeValue;
        double d6 = this.holeValue;
        boolean bl = this.yaxis.isLogarithmic();
        int n9 = this.yaxis.chartArea.getAngleUnit();
        block4: for (int i2 = n6; i2 <= n7; ++i2) {
            double d7 = this.getThetaValue(i2, n6, n7, dArray3);
            double d8 = dArray4[i2];
            if (d7 == this.holeValue || d8 == this.holeValue || d8 > this.ylim.max || bl && d8 <= 0.0) continue;
            if (!this.isRadar && !this.yaxis.isReversed() && d8 < 0.0) {
                d8 *= -1.0;
                d7 += JCChartUtil.convertAngle(1, n9, 180.0);
            }
            double d9 = JCChartUtil.boundAngle(n9, d7);
            double d10 = Double.MAX_VALUE;
            switch (n2) {
                case 1: {
                    if (d7 != d2) continue block4;
                    d10 = Math.abs(jCDataCoord.y - d8);
                    break;
                }
                case 2: {
                    if (d8 != d3) continue block4;
                    d10 = Math.abs(d9 - jCDataCoord.x);
                    d10 = Math.min(d10, JCChartUtil.boundAngle(n9, -d10));
                }
            }
            if (!(d10 < d4)) continue;
            n8 = i2;
            d4 = d10;
            d5 = d7;
            d6 = d8;
        }
        jCDataIndex2.seriesIndex = n3;
        jCDataIndex2.point = n8;
        if (d5 != this.holeValue && d6 != this.holeValue) {
            jCDataIndex2.distance = (int)this.calcXYDistance(n4, n5, d5, d6);
            return true;
        }
        jCDataIndex2.distance = Integer.MAX_VALUE;
        return true;
    }

    private double findClosestLine(int n2, JCDataIndex jCDataIndex, int n3, int n4) {
        JCLineStyle jCLineStyle;
        jCDataIndex.seriesIndex = n2;
        jCDataIndex.point = -1;
        jCDataIndex.distance = Integer.MAX_VALUE;
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        if (chartDataViewSeries == null || !chartDataViewSeries.isVisible()) {
            return jCDataIndex.distance;
        }
        int n5 = this.getFirstPoint(chartDataViewSeries);
        int n6 = this.getLastPoint(chartDataViewSeries);
        if (n5 == Integer.MAX_VALUE || n6 == Integer.MAX_VALUE) {
            return jCDataIndex.distance;
        }
        double[] dArray = chartDataViewSeries.getX();
        double[] dArray2 = chartDataViewSeries.getY();
        boolean bl = false;
        JCChartStyle jCChartStyle = chartDataViewSeries.getHoleStyle();
        if (jCChartStyle != null && !this.isRadar && (jCLineStyle = jCChartStyle.getLineStyle()) != null) {
            bl = true;
        }
        boolean bl2 = false;
        Line2D.Double double_ = new Line2D.Double();
        PlotPoint plotPoint = new PlotPoint();
        int n7 = -1;
        int n8 = n6 - n5 + 1;
        boolean bl3 = this.yaxis.isLogarithmic();
        for (int i2 = n5; i2 <= n6; ++i2) {
            double d2 = dArray[i2];
            double d3 = dArray2[i2];
            if (bl3 && d3 <= 0.0) {
                d3 = this.holeValue;
            }
            if (d3 != this.holeValue && d3 > this.ylim.max) continue;
            if (d2 == this.holeValue || d3 == this.holeValue) {
                bl2 = true;
                continue;
            }
            PlotPoint plotPoint2 = this.getPlotPoint(i2 - n5, n8, d2, d3);
            boolean bl4 = false;
            if (plotPoint.valid && plotPoint2.valid) {
                bl4 = true;
                this.updateLineDistance(jCDataIndex, n3, n4, plotPoint, plotPoint2, n7, i2, double_, !bl2 || bl);
            }
            if (bl4 || plotPoint2.valid) {
                plotPoint.px = plotPoint2.px;
                plotPoint.py = plotPoint2.py;
                plotPoint.valid = plotPoint2.valid;
                n7 = i2;
            }
            bl2 = false;
        }
        if (this.isRadar) {
            double d4 = dArray[n5];
            double d5 = dArray2[n5];
            if (bl3 && d5 <= 0.0) {
                d5 = this.holeValue;
            }
            PlotPoint plotPoint3 = this.getPlotPoint(0, n8, d4, d5);
            if (plotPoint.valid && plotPoint3.valid) {
                this.updateLineDistance(jCDataIndex, n3, n4, plotPoint, plotPoint3, n7, n5, double_, true);
            }
        }
        return jCDataIndex.distance;
    }

    private void updateLineDistance(JCDataIndex jCDataIndex, int n2, int n3, PlotPoint plotPoint, PlotPoint plotPoint2, int n4, int n5, Line2D.Double double_, boolean bl) {
        int n6;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        if (bl) {
            double_.setLine(plotPoint.px, plotPoint.py, plotPoint2.px, plotPoint2.py);
            n6 = (int)double_.ptSegDist(n2, n3);
        } else {
            d2 = JCChartUtil.distance(plotPoint.px, plotPoint.py, (double)n2, (double)n3);
            d3 = JCChartUtil.distance(plotPoint2.px, plotPoint2.py, (double)n2, (double)n3);
            n6 = (int)Math.min(d2, d3);
        }
        if (n6 < jCDataIndex.distance) {
            jCDataIndex.distance = n6;
            if (d2 == Double.MAX_VALUE) {
                d2 = JCChartUtil.distance(plotPoint.px, plotPoint.py, (double)n2, (double)n3);
            }
            if (d3 == Double.MAX_VALUE) {
                d3 = JCChartUtil.distance(plotPoint2.px, plotPoint2.py, (double)n2, (double)n3);
            }
            jCDataIndex.point = d2 <= d3 ? n4 : n5;
        }
    }

    protected JCDataIndex findClosestPointInSeries(int n2, int n3, int n4, int n5, JCDataCoord jCDataCoord) {
        this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        JCDataIndex jCDataIndex = null;
        JCDataIndex jCDataIndex2 = new JCDataIndex();
        jCDataIndex2.setSeries(this.dataObject.getSeries(n2));
        double d2 = this.findClosestPointPrimary(n3, n2, jCDataIndex2, n4, n5, jCDataCoord);
        if (d2 >= 0.0) {
            if (n3 != 0) {
                JCDataIndex jCDataIndex3 = new JCDataIndex();
                jCDataIndex3.setSeries(this.dataObject.getSeries(n2));
                boolean bl = this.findClosestPointSecondary(n3, n2, jCDataIndex2, jCDataIndex3, n4, n5, jCDataCoord);
                jCDataIndex = bl && jCDataIndex3.distance < jCDataIndex2.distance ? jCDataIndex3 : jCDataIndex2;
            } else {
                jCDataIndex = jCDataIndex2;
            }
        }
        return jCDataIndex;
    }

    private double calcXYDistance(int n2, int n3, double d2, double d3) {
        int n4 = this.dataObject.getParent().chartArea.getAngleUnit();
        double d4 = this.isRadar ? d2 : JCChartUtil.convertAngle(n4, 2, d2);
        Point point = this.yaxis.toPixelPolar(d4, d3, true);
        int n5 = point.x - n2;
        int n6 = point.y - n3;
        return Math.sqrt(n5 * n5 + n6 * n6);
    }

    public Point unpick(int n2, int n3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        if (this.yaxis != null && d2 != this.holeValue && d3 != this.holeValue) {
            int n4 = this.dataObject.getParent().chartArea.getAngleUnit();
            d3 = JCChartUtil.convertAngle(n4, 2, d3);
            return this.yaxis.toPixelPolar(d3, d2, true);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d2;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        this.last = null;
        this.next = null;
        this.prev = null;
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        int n2 = jCDataIndex.point;
        double d3 = chartDataViewSeries.getX(n2);
        double d4 = chartDataViewSeries.getY(n2);
        boolean bl = !this.isRadar && chartDataViewSeries.getHoleStyle() != null;
        double d5 = this.dataObject.getHoleValue();
        if (d3 != Double.MAX_VALUE && d4 != Double.MAX_VALUE && d3 != d5 && d4 != d5) {
            d2 = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d3);
            double d6 = this.yaxis.isReversed() ? this.yaxis.min.value : this.yaxis.max.value;
            Point point = this.yaxis.toPixelPolar(JCChartUtil.boundAngle(2, d2 + 1.5707963267948966), d6, true);
            Point point2 = this.yaxis.toPixelPolar(JCChartUtil.boundAngle(2, d2 - 1.5707963267948966), d6, true);
            this.perpendicular = new Line2D.Double(point.x, point.y, point2.x, point2.y);
        }
        n2 = jCDataIndex.point - 1;
        while (this.prev == null && n2 >= chartDataViewSeries.getFirstPoint()) {
            d3 = chartDataViewSeries.getX(n2);
            d4 = chartDataViewSeries.getY(n2);
            if (d3 != Double.MAX_VALUE && d4 != Double.MAX_VALUE && d3 != d5 && d4 != d5) {
                d2 = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d3);
                this.prev = this.yaxis.toPixelPolar(d2, d4, true);
            }
            n2 = bl ? n2 - 1 : -1;
        }
        n2 = jCDataIndex.point + 1;
        while (this.next == null && n2 <= chartDataViewSeries.getLastPoint()) {
            d3 = chartDataViewSeries.getX(n2);
            d4 = chartDataViewSeries.getY(n2);
            if (d3 != Double.MAX_VALUE && d4 != Double.MAX_VALUE && d3 != d5 && d4 != d5) {
                d2 = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d3);
                this.next = this.yaxis.toPixelPolar(d2, d4, true);
            }
            n2 = bl ? n2 + 1 : Integer.MAX_VALUE;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || this.perpendicular == null) {
            return;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        double d2 = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, jCDataIndex.series.getX(jCDataIndex.point));
        double d3 = this.perpendicular.ptLineDist(n2, n3);
        int n4 = this.perpendicular.relativeCCW(n2, n3);
        if (n4 == -1) {
            d3 *= -1.0;
        }
        JCAxis jCAxis = jCDataIndex.dataView.getYAxis();
        this.last = jCAxis.toPixelPolar(d2, d3, false);
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || this.perpendicular == null) {
            return Integer.MIN_VALUE;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        double d2 = this.perpendicular.ptLineDist(n2, n3);
        int n4 = this.perpendicular.relativeCCW(n2, n3);
        if (n4 == -1) {
            d2 *= -1.0;
        }
        return (int)Math.round(d2);
    }
}

