/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.PlotArea;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.LegendComponentLayout;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class PlotPriorityLayout
extends LegendComponentLayout {
    protected double minComponentAreaWidth = 0.6;
    protected double minComponentAreaHeight = 0.7;
    protected double minPlotAreaWidth = 0.4;
    protected double minPlotAreaHeight = 0.4;
    protected int minMargin = 1;
    protected boolean legendVisible = true;

    public PlotPriorityLayout() {
    }

    public PlotPriorityLayout(double d2, double d3, double d4, double d5, boolean bl) {
        this.minComponentAreaWidth = d2;
        this.minComponentAreaHeight = d3;
        this.minPlotAreaWidth = d4;
        this.minPlotAreaHeight = d5;
        this.legendVisible = bl;
    }

    public void layoutContainer(Container container) {
        if (!(container instanceof LegendComponentLayoutUser)) {
            return;
        }
        LegendComponentLayoutUser legendComponentLayoutUser = (LegendComponentLayoutUser)((Object)container);
        JComponent jComponent = legendComponentLayoutUser.getComponentArea();
        JComponent jComponent2 = legendComponentLayoutUser.getHeader();
        JComponent jComponent3 = legendComponentLayoutUser.getFooter();
        JCLegend jCLegend = legendComponentLayoutUser.getLegend();
        if (jCLegend != null) {
            jCLegend.setVisible(this.legendVisible);
        }
        if (jComponent2 != null) {
            jComponent2.setVisible(true);
        }
        if (jComponent3 != null) {
            jComponent3.setVisible(true);
        }
        JCChart jCChart = null;
        JCChartArea jCChartArea = null;
        if (jComponent instanceof JCChartArea) {
            jCChartArea = (JCChartArea)jComponent;
            jCChart = (JCChart)container;
            this.setXAxisTitlesVisible(jCChartArea, true);
            this.setYAxisTitlesVisible(jCChartArea, true);
            this.setXAxisAnnotationsVisible(jCChartArea, true);
            this.setYAxisAnnotationsVisible(jCChartArea, true);
            this.setPlotAreaMargins(jCChartArea, true);
            jCChartArea.layoutChartArea();
        }
        Dimension dimension = jComponent.getSize();
        Point point = jComponent.getLocation();
        Point point2 = jCLegend == null ? new Point(0, 0) : jCLegend.getLocation();
        Point point3 = jComponent2 == null ? new Point(0, 0) : jComponent2.getLocation();
        Point point4 = jComponent3 == null ? new Point(0, 0) : jComponent3.getLocation();
        Graphics graphics = null;
        Dimension dimension2 = this.getPreferredSize(graphics, jComponent2);
        Dimension dimension3 = this.getPreferredSize(graphics, jComponent3);
        Insets insets = container.getInsets();
        int n2 = jCLegend == null ? 0 : jCLegend.getAnchor();
        int n3 = n2 & 0xF;
        int n4 = n2 & 0xF0;
        Dimension dimension4 = null;
        Dimension dimension5 = null;
        if (jCLegend != null) {
            dimension4 = dimension5 = jCLegend.getPreferredSize();
            if (n3 > 0 && n4 == 0) {
                dimension4 = new Dimension(dimension5.width, container.getHeight());
            } else if (n4 > 0 && n3 == 0) {
                dimension4 = new Dimension(container.getWidth(), dimension5.height);
            }
            jCLegend.setPreferredSize(dimension4);
        }
        this.computeLayout(legendComponentLayoutUser, jComponent2, jComponent3, jComponent, jCLegend, point, point2, point3, point4, dimension, insets, dimension2, dimension3, dimension4);
        Dimension dimension6 = new Dimension();
        dimension6.width = container.getWidth();
        dimension6.height = container.getHeight();
        double d2 = (double)dimension.width / (double)dimension6.width;
        double d3 = (double)dimension.height / (double)dimension6.height;
        if (d2 < this.minComponentAreaWidth && jCLegend != null && n3 > 0) {
            jCLegend.setVisible(false);
            this.computeLayout(legendComponentLayoutUser, jComponent2, jComponent3, jComponent, jCLegend, point, point2, point3, point4, dimension, insets, dimension2, dimension3, dimension4);
            d3 = (double)dimension.height / (double)dimension6.height;
        }
        boolean bl = false;
        if (jComponent2 != null && dimension2.width > dimension6.width) {
            jComponent2.setVisible(false);
            bl = true;
        }
        if (jComponent3 != null && dimension3.width > dimension6.width) {
            jComponent3.setVisible(false);
            bl = true;
        }
        if (bl) {
            this.computeLayout(legendComponentLayoutUser, jComponent2, jComponent3, jComponent, jCLegend, point, point2, point3, point4, dimension, insets, dimension2, dimension3, dimension4);
            d3 = (double)dimension.height / (double)dimension6.height;
        }
        if (d3 < this.minComponentAreaHeight) {
            if (jCLegend != null && jCLegend.isVisible() && n4 > 0) {
                jCLegend.setVisible(false);
                this.computeLayout(legendComponentLayoutUser, jComponent2, jComponent3, jComponent, jCLegend, point, point2, point3, point4, dimension, insets, dimension2, dimension3, dimension4);
                d3 = (double)dimension.height / (double)dimension6.height;
            }
            if (d3 < this.minComponentAreaHeight) {
                if (jComponent3 != null && jComponent3.isVisible()) {
                    jComponent3.setVisible(false);
                    this.computeLayout(legendComponentLayoutUser, jComponent2, jComponent3, jComponent, jCLegend, point, point2, point3, point4, dimension, insets, dimension2, dimension3, dimension4);
                    d3 = (double)dimension.height / (double)dimension6.height;
                }
                if (d3 < this.minComponentAreaHeight && jComponent2 != null && jComponent2.isVisible()) {
                    jComponent2.setVisible(false);
                    this.computeLayout(legendComponentLayoutUser, jComponent2, jComponent3, jComponent, jCLegend, point, point2, point3, point4, dimension, insets, dimension2, dimension3, dimension4);
                }
            }
        }
        super.layoutContainer(container);
        if (!(dimension2.width != 0 && dimension2.height != 0 && jComponent2 != null && jComponent2.isVisible() || dimension3.width != 0 && dimension3.height != 0 && jComponent3 != null && jComponent3.isVisible() || jCChartArea == null)) {
            Rectangle rectangle = jCChartArea.getPlotRect();
            d2 = (double)rectangle.width / (double)dimension.width;
            d3 = (double)rectangle.height / (double)dimension.height;
            ChartDataView chartDataView = jCChart.getDataView(0);
            bl = false;
            if (d2 < this.minPlotAreaWidth) {
                if (chartDataView.isInverted()) {
                    this.setXAxisAnnotationsVisible(jCChartArea, false);
                    this.setXAxisTitlesVisible(jCChartArea, false);
                } else {
                    this.setYAxisAnnotationsVisible(jCChartArea, false);
                    this.setYAxisTitlesVisible(jCChartArea, false);
                }
                bl = true;
            }
            if (d3 < this.minPlotAreaHeight) {
                if (chartDataView.isInverted()) {
                    this.setYAxisAnnotationsVisible(jCChartArea, false);
                    this.setYAxisTitlesVisible(jCChartArea, false);
                } else {
                    this.setXAxisAnnotationsVisible(jCChartArea, false);
                    this.setXAxisTitlesVisible(jCChartArea, false);
                }
                bl = true;
            }
            if (bl) {
                this.setPlotAreaMargins(jCChartArea, false);
                jCChartArea.layoutChartArea();
                this.computeLayout(legendComponentLayoutUser, jComponent2, jComponent3, jComponent, jCLegend, point, point2, point3, point4, dimension, insets, dimension2, dimension3, dimension4);
            }
        }
        if (jCLegend != null) {
            jCLegend.setPreferredSize(dimension5);
        }
        super.layoutContainer(container);
    }

    protected void setXAxisTitlesVisible(JCChartArea jCChartArea, boolean bl) {
        List<JCAxis> list = jCChartArea.getXAxes();
        for (JCAxis jCAxis : list) {
            jCAxis.getTitle().visible = bl;
            jCAxis.calcAnnotationExtents();
        }
    }

    protected void setYAxisTitlesVisible(JCChartArea jCChartArea, boolean bl) {
        List<JCAxis> list = jCChartArea.getYAxes();
        for (JCAxis jCAxis : list) {
            jCAxis.getTitle().visible = bl;
            jCAxis.calcAnnotationExtents();
        }
    }

    protected void setXAxisAnnotationsVisible(JCChartArea jCChartArea, boolean bl) {
        List<JCAxis> list = jCChartArea.getXAxes();
        for (JCAxis jCAxis : list) {
            jCAxis.setAnnotationVisible(bl);
            jCAxis.calcAnnotationExtents();
        }
    }

    protected void setYAxisAnnotationsVisible(JCChartArea jCChartArea, boolean bl) {
        List<JCAxis> list = jCChartArea.getYAxes();
        for (JCAxis jCAxis : list) {
            jCAxis.setAnnotationVisible(bl);
            jCAxis.calcAnnotationExtents();
        }
    }

    protected void setPlotAreaMargins(JCChartArea jCChartArea, boolean bl) {
        PlotArea plotArea = jCChartArea.getPlotArea();
        if (bl) {
            plotArea.top.isDefault = true;
            plotArea.left.isDefault = true;
            plotArea.bottom.isDefault = true;
            plotArea.right.isDefault = true;
        } else {
            plotArea.top.value = this.minMargin;
            plotArea.top.isDefault = false;
            plotArea.bottom.value = this.minMargin;
            plotArea.bottom.isDefault = false;
            plotArea.left.value = this.minMargin;
            plotArea.left.isDefault = false;
            plotArea.right.value = this.minMargin;
            plotArea.right.isDefault = false;
        }
    }

    public void setLegendVisible(boolean bl) {
        this.legendVisible = bl;
    }

    public boolean getLegendVisible() {
        return this.legendVisible;
    }
}

