/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.PickShape;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.ProcessShapeArea;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;

public class PickShapeArea
extends PickShape
implements ProcessShapeArea {
    protected AreaPolygon areaPolygon = null;
    protected double[] xvals = null;
    protected double[] yvals = null;
    protected JCAxis xaxis = null;
    protected JCAxis yaxis = null;
    protected int baseValue;
    protected double holeValue;
    protected JCChartArea chartArea = null;

    public PickShapeArea(Picker picker, boolean bl) {
        super(picker, false, bl);
    }

    public void setPickShapeData(AreaPolygon areaPolygon, double[] dArray, double[] dArray2, double d2, JCAxis jCAxis, JCAxis jCAxis2) {
        this.areaPolygon = areaPolygon;
        this.xvals = dArray;
        this.yvals = dArray2;
        this.holeValue = d2;
        this.xaxis = jCAxis;
        this.yaxis = jCAxis2;
        this.baseValue = this.yaxis.toPixel(this.yaxis.origin.value, false);
        this.chartArea = this.yaxis.getChartArea();
    }

    protected double getDistanceToVertex(int n2, int n3) {
        double d2;
        switch (this.picker.focus) {
            case 1: {
                if (this.picker.pix_x < n2) {
                    d2 = n2 - this.picker.pix_x;
                    break;
                }
                d2 = this.picker.pix_x - n2;
                break;
            }
            case 2: {
                if (this.picker.pix_y < n3) {
                    d2 = n3 - this.picker.pix_y;
                    break;
                }
                d2 = this.picker.pix_y - n3;
                break;
            }
            default: {
                Point2D.Double double_ = new Point2D.Double(this.picker.pix_x, this.picker.pix_y);
                Point2D.Double double_2 = new Point2D.Double(n2, n3);
                d2 = double_.distance(double_2);
            }
        }
        return d2;
    }

    protected boolean includeVertexInCalculation(int n2) {
        boolean bl = false;
        if (n2 >= 0 && n2 < this.xvals.length) {
            bl = !this.xaxis.skipValue(this.xvals[n2], this.holeValue);
        }
        return bl;
    }

    protected void findClosestVertex() {
        int n2;
        int n3;
        if (this.fillStyleNull && this.areaPolygon.hole) {
            return;
        }
        Polygon polygon = this.areaPolygon.poly;
        int n4 = polygon.npoints;
        int n5 = this.areaPolygon.isLeading ? 0 : 1;
        int n6 = n4 == 2 ? 1 : n5;
        int n7 = -1;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        int n8 = -1;
        int n9 = -1;
        int n10 = n4 == 2 ? 0 : 1;
        int n11 = this.areaPolygon.startPoint;
        for (n3 = n11 + n10; n3 <= this.areaPolygon.endPoint; ++n3) {
            if (!this.includeVertexInCalculation(n3)) continue;
            n2 = n6 + n10;
            Polygon polygon2 = this.createTrapezoid(n6, n2);
            double d4 = this.getTrapezoidDistance(this.picker.pix_x, this.picker.pix_y, this.picker.focus, polygon2);
            if (d4 < d2) {
                d2 = d4;
                d3 = JCChartUtil.getPolygonDistance(this.picker.pix_x, this.picker.pix_y, polygon2);
                n7 = n6;
                n8 = n11;
                n9 = n3;
            }
            ++n6;
            n11 = n3;
        }
        n3 = polygon.contains(this.picker.pix_x, this.picker.pix_y) ? 1 : 0;
        if (n7 >= 0 && this.isCloser(n3 != 0, d2)) {
            boolean bl;
            n2 = n7 + n10;
            double d5 = this.getDistanceToVertex(polygon.xpoints[n7], polygon.ypoints[n7]);
            double d6 = this.getDistanceToVertex(polygon.xpoints[n2], polygon.ypoints[n2]);
            Rectangle rectangle = this.chartArea.getPlotRect();
            int n12 = rectangle.x;
            int n13 = rectangle.x + rectangle.width;
            boolean bl2 = polygon.xpoints[n7] >= n12 && polygon.xpoints[n7] <= n13 && (!this.areaPolygon.isLeading || n8 != this.areaPolygon.startPoint);
            boolean bl3 = bl = polygon.xpoints[n2] >= n12 && polygon.xpoints[n2] <= n13 && (!this.areaPolygon.isTrailing || n9 != this.areaPolygon.endPoint);
            int n14 = d5 < d6 ? (bl2 ? n8 : (bl ? n9 : this.getClosestVertex(n8))) : (bl ? n9 : (bl2 ? n8 : this.getClosestVertex(n9)));
            if (n14 >= 0) {
                this.picker.point = n14;
                this.picker.series = this.areaPolygon.series;
                this.picker.distance = n3 != 0 ? 0 : (int)Math.round(d3);
                this.picker.pickDistance = n3 != 0 ? 0 : (int)Math.round(d2);
                this.picker.isHole = this.areaPolygon.hole;
            }
        }
    }

    protected boolean isCloser(boolean bl, double d2) {
        if (bl && (double)this.picker.pickDistance > 0.0) {
            return true;
        }
        if (this.picker.series == this.areaPolygon.series && d2 == (double)this.picker.pickDistance) {
            if (this.picker.isHole && !this.areaPolygon.hole) {
                return true;
            }
            if (!this.picker.isHole && this.areaPolygon.hole) {
                return false;
            }
        }
        return d2 <= (double)this.picker.pickDistance;
    }

    protected int getClosestVertex(int n2) {
        return -1;
    }

    protected Polygon createTrapezoid(int n2, int n3) {
        Polygon polygon = this.areaPolygon.poly;
        Polygon polygon2 = new Polygon();
        if (this.inverted) {
            polygon2.addPoint(polygon.xpoints[n2], polygon.ypoints[n2]);
            polygon2.addPoint(this.baseValue, polygon.ypoints[n2]);
            polygon2.addPoint(this.baseValue, polygon.ypoints[n3]);
            polygon2.addPoint(polygon.xpoints[n3], polygon.ypoints[n3]);
            polygon2.addPoint(polygon.xpoints[n2], polygon.ypoints[n2]);
        } else {
            polygon2.addPoint(polygon.xpoints[n2], polygon.ypoints[n2]);
            polygon2.addPoint(polygon.xpoints[n3], polygon.ypoints[n3]);
            polygon2.addPoint(polygon.xpoints[n3], this.baseValue);
            polygon2.addPoint(polygon.xpoints[n2], this.baseValue);
            polygon2.addPoint(polygon.xpoints[n2], polygon.ypoints[n2]);
        }
        return polygon2;
    }

    protected double getTrapezoidDistance(int n2, int n3, int n4, Polygon polygon) {
        double d2;
        int n5;
        if (polygon.contains(n2, n3)) {
            return 0.0;
        }
        int n6 = polygon.xpoints[0];
        int n7 = polygon.ypoints[0];
        int n8 = this.inverted ? polygon.xpoints[3] : polygon.xpoints[1];
        int n9 = n5 = this.inverted ? polygon.ypoints[3] : polygon.ypoints[1];
        if (n4 == 1) {
            double d3 = Math.abs(n2 - n6);
            double d4 = Math.abs(n2 - n8);
            d2 = Math.min(d3, d4);
        } else if (n4 == 2) {
            double d5 = Math.abs(n3 - n7);
            double d6 = Math.abs(n3 - n5);
            d2 = Math.min(d5, d6);
        } else {
            d2 = JCChartUtil.getPolygonDistance(n2, n3, polygon);
        }
        return d2;
    }

    public void fillPolygon(Shape shape) {
        this.findClosestVertex();
    }

    public void fillOutlinePolygon(Shape shape) {
        this.fillPolygon(shape);
    }
}

