/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class PickShape
implements ProcessShape,
Serializable {
    public static final int PICK_SERIES = 1;
    public static final int PICK_MARKER = 2;
    protected Picker picker = null;
    protected boolean pickSeries = false;
    protected boolean pickMarker = false;
    protected boolean inverted = false;
    protected boolean lineStyleNull = true;
    protected boolean fillStyleNull = true;
    protected Shape clipShape = null;
    protected int chartType = -1;

    public PickShape(Picker picker, boolean bl, boolean bl2) {
        this.picker = picker;
        this.pickSeries = bl;
        this.inverted = bl2;
    }

    public PickShape(Picker picker, int n2, boolean bl) {
        this.picker = picker;
        this.pickSeries = n2 == 1;
        this.pickMarker = n2 == 2;
        this.inverted = bl;
    }

    public int getShapeType() {
        return 1;
    }

    public void setChartType(int n2) {
        this.chartType = n2;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        this.lineStyleNull = jCLineStyle == null;
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        this.fillStyleNull = jCFillStyle == null;
    }

    public void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
    }

    public void setChartStyle(JCChartStyle jCChartStyle) {
    }

    public void tagData(JCDataIndex jCDataIndex) {
        if (this.picker != null && jCDataIndex != null) {
            this.picker.tag_series = jCDataIndex.getSeriesIndex();
            this.picker.tag_point = this.picker.tag_point2 = jCDataIndex.getPoint();
        }
    }

    public void tagData(int n2, ChartDataViewSeries chartDataViewSeries, int n3) {
        if (this.picker != null) {
            this.picker.tag_series = n3;
            this.picker.tag_point = this.picker.tag_point2 = n2;
        }
    }

    public void tagDataLine(int n2, int n3, ChartDataViewSeries chartDataViewSeries, int n4) {
        if (this.picker != null) {
            this.picker.tag_series = n4;
            this.picker.tag_point = n2;
            this.picker.tag_point2 = n3;
        }
    }

    public void updateFillOrientation(Rectangle2D rectangle2D, int n2) {
    }

    public void resetFillOrientation() {
    }

    public void fillPolygon(Shape shape) {
        int n2 = this.getDistanceToShape(shape, this.picker.pix_x, this.picker.pix_y, this.picker.focus);
        this.updatePicker(n2);
    }

    public void fillPolygonShadow(Shape shape) {
        this.fillPolygon(shape);
    }

    public void fillOutlinePolygon(Shape shape) {
        this.fillPolygon(shape);
    }

    public void fillOutlinePolygon(Shape shape, Color color) {
        this.fillPolygon(shape);
    }

    public void fillOutlinePolygon(Shape shape, int n2, int n3) {
        this.fillOutlinePolygon(shape);
    }

    public void fillOutlinePartialPolygon(Shape shape) {
        this.fillOutlinePolygon(shape);
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 / 2.0;
        double d9 = d5 / 2.0;
        double d10 = d2 + d8;
        double d11 = d3 + d9;
        if (d4 != 0.0 && d5 != 0.0) {
            if (this.picker.pix_x == (int)Math.round(d10) && this.picker.pix_y == (int)Math.round(d11)) {
                this.picker.distance = 0;
                this.picker.series = this.picker.tag_series;
                this.picker.point = this.picker.tag_point;
            } else {
                double d12;
                double d13 = (double)this.picker.pix_x - d10;
                double d14 = (double)this.picker.pix_y - d11;
                double d15 = Math.sqrt(d13 * d13 + d14 * d14);
                double d16 = Math.atan2(-d14 / d5, d13 / d4);
                if ((d16 = JCChartUtil.convertAngle(2, 1, d16)) < 0.0) {
                    d16 += 360.0;
                }
                d16 = d6 < 0.0 ? (d16 += (double)((int)Math.round(d6) / 360 - 1) * 360.0) : (d16 += (double)((int)Math.round(d6) / 360) * 360.0);
                double d17 = d6 + d7;
                if (this.withinRange(d16, d6, d7)) {
                    double d18;
                    double d19 = d10 + Math.cos(d16 = JCChartUtil.convertAngle(1, 2, d16)) * d8;
                    double d20 = JCChartUtil.distance(d10, d11, d19, d18 = d11 - Math.sin(d16) * d9);
                    d12 = d15 > d20 ? d15 - d20 : 0.0;
                } else {
                    double d21 = JCChartUtil.convertAngle(1, 2, d6);
                    double d22 = d10 + Math.cos(d21) * d8;
                    double d23 = d11 - Math.sin(d21) * d9;
                    d21 = JCChartUtil.convertAngle(1, 2, d17);
                    double d24 = d10 + Math.cos(d21) * d8;
                    double d25 = d11 - Math.sin(d21) * d9;
                    double d26 = this.picker.pix_x;
                    double d27 = this.picker.pix_y;
                    Point2D.Double double_ = new Point2D.Double(d10, d11);
                    Point2D.Double double_2 = new Point2D.Double(d26, d27);
                    Point2D.Double double_3 = new Point2D.Double(d22, d23);
                    Point2D.Double double_4 = new Point2D.Double(d24, d25);
                    double d28 = JCChartUtil.getDistanceToVector(double_, double_3, double_2);
                    double d29 = JCChartUtil.getDistanceToVector(double_, double_4, double_2);
                    d12 = Math.min(d28, d29);
                }
                this.updatePicker((int)Math.round(d12));
            }
        }
    }

    public void fillArcShadow(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.fillArc(d2, d3, d4, d5, d6, d7);
    }

    protected boolean withinRange(double d2, double d3, double d4) {
        boolean bl = false;
        d2 = this.boundAngle(d2);
        d3 = this.boundAngle(d3);
        double d5 = d3 + d4;
        if (d4 < 0.0) {
            if (d5 >= 0.0) {
                if (d2 <= d3 && d2 >= d5) {
                    bl = true;
                }
            } else {
                d5 += 360.0;
                if (d2 <= d3 || d2 >= d5) {
                    bl = true;
                }
            }
        } else if (d5 <= 360.0) {
            if (d2 >= d3 && d2 <= d5) {
                bl = true;
            }
        } else {
            d5 = this.boundAngle(d5);
            if (d2 >= d3 || d2 <= d5) {
                bl = true;
            }
        }
        return bl;
    }

    protected double boundAngle(double d2) {
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    public void fillArcRegion(Point point, Point point2, double d2, double d3) {
        if (point == null || point2 == null) {
            return;
        }
        double d4 = point2.distance(d2, d3);
        double d5 = point.distance(d2, d3);
        double d6 = this.picker.pix_x;
        double d7 = this.picker.pix_y;
        double d8 = JCNumberUtil.distance(d2, d3, d6, d7);
        double d9 = Math.min(d5, d4);
        double d10 = Math.max(d5, d4);
        if (d8 < d9) {
            this.updatePicker((int)(d9 - d8));
        } else if (d8 > d10) {
            this.updatePicker((int)(d8 - d10));
        } else {
            this.updatePicker(0);
        }
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        this.drawLine(new Line2D.Double(d2, d3, d4, d5), null);
    }

    public void drawLine(Line2D.Double double_, Color color) {
        if (double_ != null && (this.pickSeries || this.pickMarker)) {
            double d2;
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MAX_VALUE;
            double d5 = this.picker.pix_x;
            double d6 = this.picker.pix_y;
            double d7 = double_.getX1();
            double d8 = double_.getY1();
            double d9 = double_.getX2();
            double d10 = double_.getY2();
            switch (this.picker.focus) {
                case 1: {
                    if (this.pickMarker) {
                        double d11 = JCChartUtil.clamp(d5, Math.min(d7, d9), Math.max(d7, d9));
                        if (!this.inverted && d11 == d5) {
                            d2 = 0.0;
                            break;
                        }
                        d2 = Math.min(Math.abs(d5 - d7), Math.abs(d5 - d9));
                        break;
                    }
                }
                case 2: {
                    double d12 = JCChartUtil.clamp(d6, Math.min(d8, d10), Math.max(d8, d10));
                    if (this.pickMarker) {
                        if (this.inverted && d12 == d6) {
                            d2 = 0.0;
                            break;
                        }
                        d2 = Math.min(Math.abs(d6 - d8), Math.abs(d6 - d10));
                        break;
                    }
                }
                default: {
                    if (this.lineStyleNull && !this.pickMarker) {
                        d3 = JCChartUtil.distance(d7, d8, d5, d6);
                        d4 = JCChartUtil.distance(d9, d10, d5, d6);
                        d2 = Math.min(d3, d4);
                        break;
                    }
                    d2 = (int)double_.ptSegDist(d5, d6);
                }
            }
            if ((int)d2 <= this.picker.distance) {
                this.picker.distance = (int)d2;
                this.picker.series = this.picker.tag_series;
                if (d3 == Double.MAX_VALUE) {
                    d3 = JCChartUtil.distance(d7, d8, d5, d6);
                }
                if (d4 == Double.MAX_VALUE) {
                    d4 = JCChartUtil.distance(d9, d10, d5, d6);
                }
                this.picker.point = d3 <= d4 ? this.picker.tag_point : this.picker.tag_point2;
            }
        }
    }

    public void drawShape(Shape shape) {
    }

    public void drawSymbol(double d2, double d3, Color color) {
        if (!this.pickSeries) {
            double d4;
            double d5 = this.picker.pix_x;
            double d6 = this.picker.pix_y;
            switch (this.picker.focus) {
                case 1: {
                    d4 = Math.abs(d5 - d2);
                    break;
                }
                case 2: {
                    d4 = Math.abs(d6 - d3);
                    break;
                }
                default: {
                    d4 = JCChartUtil.distance(d2, d3, d5, d6);
                }
            }
            this.updatePicker((int)d4);
        }
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        Arc2D.Double double_ = new Arc2D.Double(d2, d3, d4, d5, d6, d7, 0);
        Point2D.Double double_2 = new Point2D.Double(this.picker.pix_x, this.picker.pix_y);
        double d8 = JCChartUtil.getShapeDistance(double_2, double_, 0.7, false);
        this.updatePicker((int)Math.round(d8));
    }

    public void drawCircle(double d2, double d3, double d4) {
        double d5 = JCChartUtil.distance(d2, d3, (double)this.picker.pix_x, (double)this.picker.pix_y);
        double d6 = d5 > d4 ? d5 - d4 : d4 - d5;
        this.updatePicker((int)Math.round(d6));
    }

    public void drawString(String string, int n2, int n3) {
        if (this.clipShape != null) {
            this.fillPolygon(this.clipShape);
        }
    }

    public void setColor(Color color) {
    }

    public void setClip(Shape shape) {
        this.clipShape = shape;
    }

    public Shape getClip() {
        return this.clipShape;
    }

    public boolean isWithinClip() {
        if (this.clipShape != null) {
            double d2 = this.picker.pix_x;
            double d3 = this.picker.pix_y;
            return this.clipShape.contains(d2, d3);
        }
        return true;
    }

    protected int getDistanceToShape(Shape shape, int n2, int n3, int n4) {
        int n5;
        switch (n4) {
            case 1: {
                Rectangle rectangle = shape.getBounds();
                int n6 = rectangle.x + rectangle.width;
                if (n2 < rectangle.x) {
                    n5 = rectangle.x - n2;
                    break;
                }
                if (n2 > n6) {
                    n5 = n2 - n6;
                    break;
                }
                n5 = 0;
                break;
            }
            case 2: {
                Rectangle rectangle = shape.getBounds();
                int n7 = rectangle.y + rectangle.height;
                if (n3 < rectangle.y) {
                    n5 = rectangle.y - n3;
                    break;
                }
                if (n3 > n7) {
                    n5 = n3 - n7;
                    break;
                }
                n5 = 0;
                break;
            }
            default: {
                Point2D.Double double_ = new Point2D.Double(n2, n3);
                n5 = (int)Math.round(JCChartUtil.getShapeDistance(double_, shape, 2.0));
            }
        }
        return n5;
    }

    protected void updatePicker(int n2) {
        if (n2 <= this.picker.distance) {
            this.picker.distance = n2;
            this.picker.series = this.picker.tag_series;
            this.picker.point = this.picker.tag_point;
        }
    }

    public FontMetrics getFontMetrics() {
        return null;
    }
}

