/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCValueLabel;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper {
    protected Vector<Object> shapesInDrawingOrder = new Vector();
    protected Map<Object, Object> hash = null;
    protected JCDataIndex currentDataIndex = null;
    protected ChartDataView restrictedDataView = null;
    protected int restrictedSeries = -1;
    protected int restrictedPoint = -1;

    public Mapper(Map<Object, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("Null hash table set on mapper");
        }
        this.hash = map;
    }

    public void addShape(Object object) {
        if (this.hasValidDataIndex()) {
            return;
        }
        this.shapesInDrawingOrder.add(object);
        this.addToHash(object);
    }

    public boolean hasValidDataIndex() {
        return this.currentDataIndex != null && (this.restrictedDataView != null && this.restrictedDataView != this.currentDataIndex.getDataView() || this.restrictedSeries != -1 && this.restrictedSeries != this.currentDataIndex.getSeriesIndex() || this.restrictedPoint != -1 && this.restrictedPoint != this.currentDataIndex.getPoint());
    }

    public void addLabelShape(Object object, JCValueLabel jCValueLabel) {
        this.shapesInDrawingOrder.add(object);
        this.hash.put(object, jCValueLabel);
    }

    public void addToHash(Object object) {
        if (object == null || this.currentDataIndex == null) {
            return;
        }
        this.hash.put(object, this.currentDataIndex);
    }

    public Vector<Object> getShapeList() {
        return this.shapesInDrawingOrder;
    }

    public void setDataIndex(JCDataIndex jCDataIndex) {
        this.currentDataIndex = jCDataIndex;
    }

    public JCDataIndex getDataIndex() {
        return this.currentDataIndex;
    }

    public ChartDataView getRestrictedDataView() {
        return this.restrictedDataView;
    }

    public void setRestrictedDataView(ChartDataView chartDataView) {
        this.restrictedDataView = chartDataView;
    }

    public int getRestrictedSeries() {
        return this.restrictedSeries;
    }

    public void setRestrictedSeries(int n2) {
        this.restrictedSeries = n2;
    }

    public int getRestrictedPoint() {
        return this.restrictedPoint;
    }

    public void setRestrictedPoint(int n2) {
        this.restrictedPoint = n2;
    }
}

