/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartNumberFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.util.ImageMapInfo;
import java.io.Serializable;

public class JCValueLabel
implements Serializable {
    protected double value = 0.0;
    protected ChartText label = new ChartText();
    protected boolean drawTick = true;
    protected boolean drawLabel = true;
    protected boolean drawGrid = true;
    protected JCAnno anno = null;
    protected JCDataIndex dataIndex = null;
    protected ImageMapInfo imageMapInfo = null;

    public ChartText getChartText() {
        return this.label;
    }

    public JCAnno getAnno() {
        return this.anno;
    }

    public void setAnno(JCAnno jCAnno) {
        this.anno = jCAnno;
        if (jCAnno != null) {
            this.drawTick = jCAnno.getDrawTicks();
            this.drawLabel = jCAnno.getDrawLabels();
            this.label.foreground = jCAnno.getLabelColor();
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d2) {
        if (this.value == d2) {
            return;
        }
        this.value = d2;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public JCValueLabel() {
        this.value = 0.0;
        this.label.setValueLabel(this);
    }

    public JCValueLabel(double d2, String string, JCAxis jCAxis) {
        this.value = d2;
        this.label = new ChartText(null, string, jCAxis);
        this.label.setValueLabel(this);
    }

    protected JCValueLabel(double d2, String string, String string2, JCAxis jCAxis) {
        this(d2, string, jCAxis);
        this.label.setValueLabel(this);
        this.label.setFullText(string2);
    }

    public JCValueLabel(double d2, String string, JCAxis jCAxis, boolean bl, boolean bl2, boolean bl3) {
        this(d2, string, jCAxis);
        this.drawTick = bl;
        this.drawLabel = bl2;
        this.drawGrid = bl3;
    }

    protected JCValueLabel(double d2, String string, String string2, JCAxis jCAxis, boolean bl, boolean bl2, boolean bl3) {
        this(d2, string, jCAxis, bl, bl2, bl3);
        this.label.setValueLabel(this);
        this.label.setFullText(string2);
    }

    public JCValueLabel(double d2, String string) {
        this.value = d2;
        this.label.updateParent = false;
        this.label.setText(string);
        this.label.setValueLabel(this);
        this.label.updateParent = true;
    }

    public JCValueLabel(JCAnno jCAnno, double d2) {
        this.value = d2;
        this.anno = jCAnno;
        if (jCAnno != null) {
            this.drawTick = jCAnno.getDrawTicks();
            this.drawLabel = jCAnno.getDrawLabels();
            this.initValueLabel(jCAnno.getParent(), d2, jCAnno.getPrecision());
            this.label.foreground = jCAnno.getLabelColor();
        }
        this.label.setValueLabel(this);
    }

    protected void setParent(JCAxis jCAxis) {
        if (this.label.parentChart == null) {
            this.label.setParentChart(jCAxis.getParentChart());
        }
        this.label.setParentAxis(jCAxis);
        if (this.label.getHeight() == 0) {
            this.label.setChanged(true, 2, false);
            this.label.recalc();
        }
    }

    private void initValueLabel(JCAxis jCAxis, double d2, int n2) {
        this.value = d2;
        if (this.drawLabel) {
            JCChart jCChart;
            JCChart jCChart2 = jCChart = jCAxis == null ? null : jCAxis.getParentChart();
            if (jCAxis != null && jCAxis.labelGenerator != null) {
                this.setGeneratedLabel(jCChart, d2, n2, jCAxis.labelGenerator, jCAxis);
            } else {
                String string = JCChartUtil.format(d2, n2);
                if (jCAxis != null) {
                    if (jCAxis.scientificNotation) {
                        n2 = 1;
                    }
                    JCChartNumberFormat jCChartNumberFormat = jCAxis.getNumberFormatter();
                    String string2 = jCChartNumberFormat.localize(string, n2);
                    this.label = new ChartText(jCChart, string2, jCAxis);
                } else {
                    this.label = new ChartText(jCChart, string, jCAxis);
                }
                this.label.setValueLabel(this);
                this.label.updateParent = false;
                if (jCAxis != null) {
                    this.label.setRotation(jCAxis.getAnnotationRotation());
                }
                this.label.updateParent = true;
            }
        }
        this.setParent(jCAxis);
    }

    protected JCValueLabel(JCAxis jCAxis, double d2, int n2) {
        this.initValueLabel(jCAxis, d2, n2);
    }

    protected JCValueLabel(JCAxis jCAxis, int n2, int n3) {
        this.value = JCChartUtil.pow10(n2);
        if (this.drawLabel) {
            JCChart jCChart;
            JCChart jCChart2 = jCChart = jCAxis == null ? null : jCAxis.getParentChart();
            if (jCAxis != null && jCAxis.labelGenerator != null) {
                this.setGeneratedLabel(jCChart, this.value, n3, jCAxis.labelGenerator, jCAxis);
            } else {
                String string = JCChartUtil.logFormat(n2);
                if (jCAxis != null) {
                    JCChartNumberFormat jCChartNumberFormat = jCAxis.getNumberFormatter();
                    String string2 = jCChartNumberFormat.localize(string, n3);
                    this.label = new ChartText(jCChart, string2, jCAxis);
                } else {
                    this.label = new ChartText(jCChart, string, jCAxis);
                }
                this.label.setValueLabel(this);
                this.label.updateParent = false;
                if (jCAxis != null) {
                    this.label.setRotation(jCAxis.getAnnotationRotation());
                }
                this.label.updateParent = true;
            }
        }
        this.setParent(jCAxis);
    }

    private void setGeneratedLabel(JCChart jCChart, double d2, int n2, JCLabelGenerator jCLabelGenerator, JCAxis jCAxis) {
        if (jCLabelGenerator == null) {
            return;
        }
        Object object = jCLabelGenerator.makeLabel(d2, n2);
        if (object instanceof ChartText) {
            this.label = (ChartText)object;
            this.label.setParentChart(jCChart);
        } else {
            String string = object instanceof String ? (String)object : object.toString();
            this.label = new ChartText(jCChart, string, jCAxis);
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.getAnnotationRotation());
            }
            this.label.updateParent = true;
        }
        this.label.setValueLabel(this);
    }

    public String toString() {
        return this.label.getText();
    }

    public boolean isDrawTick() {
        return this.drawTick;
    }

    public void setDrawTick(boolean bl) {
        this.drawTick = bl;
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean bl) {
        this.drawGrid = bl;
    }

    public boolean isDrawLabel() {
        return this.drawLabel;
    }

    public void setDrawLabel(boolean bl) {
        this.drawLabel = bl;
    }

    public JCDataIndex getDataIndex() {
        return this.dataIndex;
    }

    protected void setDataIndex(JCDataIndex jCDataIndex) {
        this.dataIndex = jCDataIndex;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }
}

