/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartDateFormat;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.util.calendar.ICalendar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;

public class JCTimeExclusion
implements Serializable {
    protected JCAxis parent;
    protected Date startTime;
    protected boolean startTimeOmitted = false;
    protected Date stopTime;
    protected boolean stopTimeOmitted = false;
    protected boolean active = true;
    protected RecurrencePattern recurrencePattern = RecurrencePattern.None;
    protected TimeZone timeZone;
    protected Locale locale;
    protected Date startInternal = null;
    protected Date stopInternal = null;
    protected Date switchListBegin = null;
    protected Date switchListEnd = null;
    protected List<ExcludeSwitch> switchList = null;
    protected boolean skipWeekend = false;
    protected boolean useable = true;
    protected Stack<ICalendar> calendars = new Stack();

    public JCTimeExclusion() {
        this(null, null, RecurrencePattern.None);
    }

    public JCTimeExclusion(Date date, Date date2) {
        this(date, date2, RecurrencePattern.None);
    }

    public JCTimeExclusion(Date date, Date date2, RecurrencePattern recurrencePattern) {
        this(date, date2, false, false, recurrencePattern, Locale.getDefault(), TimeZone.getDefault());
    }

    public JCTimeExclusion(Date date, Date date2, boolean bl, boolean bl2, RecurrencePattern recurrencePattern) {
        this(date, date2, bl, bl2, recurrencePattern, Locale.getDefault(), TimeZone.getDefault());
    }

    public JCTimeExclusion(Date date, Date date2, boolean bl, boolean bl2, RecurrencePattern recurrencePattern, Locale locale, TimeZone timeZone) {
        this(date, date2, bl, bl2, recurrencePattern, locale, timeZone, true);
    }

    public JCTimeExclusion(Date date, Date date2, boolean bl, boolean bl2, RecurrencePattern recurrencePattern, Locale locale, TimeZone timeZone, boolean bl3) {
        this.startTime = date;
        this.stopTime = date2;
        this.startTimeOmitted = bl;
        this.stopTimeOmitted = bl2;
        this.recurrencePattern = recurrencePattern;
        this.locale = locale;
        this.timeZone = timeZone;
        this.active = bl3;
        this.getInternalTime();
    }

    public JCAxis getParent() {
        return this.parent;
    }

    public void setParent(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date date) {
        if (this.startTime != null && this.startTime.equals(date)) {
            return;
        }
        this.startTime = date;
        this.resetSwitchList();
        this.getInternalTime();
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isStartTimeOmitted() {
        return this.startTimeOmitted;
    }

    public void setStartTimeOmitted(boolean bl) {
        if (this.startTimeOmitted == bl) {
            return;
        }
        this.startTimeOmitted = bl;
        this.resetSwitchList();
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public Date getStartInternal() {
        return this.startInternal;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Date date) {
        if (this.stopTime != null && this.stopTime.equals(date)) {
            return;
        }
        this.stopTime = date;
        this.getInternalTime();
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isStopTimeOmitted() {
        return this.stopTimeOmitted;
    }

    public void setStopTimeOmitted(boolean bl) {
        if (this.stopTimeOmitted == bl) {
            return;
        }
        this.stopTimeOmitted = bl;
        this.resetSwitchList();
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public Date getStopInternal() {
        return this.stopInternal;
    }

    public void computeExcludeSwitchList(Date date, Date date2) {
        if (!this.useable || date == null || date2 == null || date.after(date2)) {
            return;
        }
        if (this.switchList != null && this.switchListBegin != null && this.switchListBegin.equals(date) && this.switchListEnd != null && this.switchListEnd.equals(date2)) {
            return;
        }
        this.switchListBegin = date;
        this.switchListEnd = date2;
        this.switchList = null;
        if (this.recurrencePattern == RecurrencePattern.None) {
            return;
        }
        this.switchList = new ArrayList<ExcludeSwitch>();
        while (date != null && date.before(date2)) {
            boolean bl = this.isTimeExcluded(date, this.startTimeOmitted, this.stopTimeOmitted, false);
            if ((date = bl ? this.getNextAvailableTime(date, this.startTimeOmitted, this.stopTimeOmitted, false) : this.getNextExcludedTime(date, this.startTimeOmitted, this.stopTimeOmitted, false)) == null) continue;
            this.switchList.add(new ExcludeSwitch(date, !bl));
        }
    }

    protected void resetSwitchList() {
        this.switchListBegin = null;
        this.switchListEnd = null;
        this.switchList = null;
    }

    protected ExcludeSwitch findSwitch(Date date, boolean bl) {
        ExcludeSwitch excludeSwitch;
        if (this.switchList == null || this.switchList.size() == 0 || date == null) {
            return null;
        }
        int n2 = this.switchList.size();
        if (n2 < 3) {
            for (ExcludeSwitch excludeSwitch2 : this.switchList) {
                if (excludeSwitch2 == null || !date.before(excludeSwitch2.getSwitchTime())) continue;
                if (bl ^ excludeSwitch2.excluded) {
                    return excludeSwitch2;
                }
                return new ExcludeSwitch(date, bl);
            }
            return null;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 < n4 - 1) {
            int n5 = (n3 + n4) / 2;
            excludeSwitch = this.switchList.get(n5);
            if (date.before(excludeSwitch.getSwitchTime())) {
                n4 = n5;
                continue;
            }
            n3 = n5;
        }
        ExcludeSwitch excludeSwitch3 = this.switchList.get(n4);
        excludeSwitch = this.switchList.get(n3);
        if (n3 == 0 && date.before(excludeSwitch.getSwitchTime())) {
            excludeSwitch3 = excludeSwitch;
        }
        if (excludeSwitch3 == excludeSwitch || date.before(excludeSwitch3.getSwitchTime())) {
            if (bl ^ excludeSwitch3.excluded) {
                return excludeSwitch3;
            }
            return new ExcludeSwitch(date, bl);
        }
        return null;
    }

    public RecurrencePattern getRecurrencePattern() {
        return this.recurrencePattern;
    }

    public void setRecurrencePattern(RecurrencePattern recurrencePattern) {
        if (this.recurrencePattern == recurrencePattern) {
            return;
        }
        this.recurrencePattern = recurrencePattern;
        this.resetSwitchList();
        this.getInternalTime();
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.calendars.clear();
        this.resetSwitchList();
        this.getInternalTime();
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.calendars.clear();
        this.resetSwitchList();
        this.getInternalTime();
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public boolean isUseable() {
        return this.useable;
    }

    public boolean isSkipWeekend() {
        return this.skipWeekend;
    }

    protected void setSkipWeekend(boolean bl) {
        this.skipWeekend = bl;
    }

    public String toString() {
        return "Start Time:" + this.startTime + " Stop time:" + this.stopTime + " Start Time Omitted:" + this.startTimeOmitted + " Stop Time Omitted:" + this.stopTimeOmitted + " Recurrence Pattern:" + (Object)((Object)this.recurrencePattern);
    }

    public boolean isTimeExcluded(Date date) {
        return this.isTimeExcluded(date, this.startTimeOmitted, this.stopTimeOmitted, true);
    }

    public boolean isTimeExcluded(Date date, boolean bl, boolean bl2, boolean bl3) {
        ExcludeSwitch excludeSwitch;
        if (date == null) {
            return false;
        }
        if (bl3 && this.switchList != null && this.recurrencePattern != RecurrencePattern.None && !date.before(this.switchListBegin) && !date.after(this.switchListEnd) && (excludeSwitch = this.findSwitch(date, false)) != null) {
            return date.equals(excludeSwitch.getSwitchTime());
        }
        boolean bl4 = true;
        Date date2 = null;
        ICalendar iCalendar = null;
        switch (this.recurrencePattern) {
            case None: {
                if (date.before(this.startInternal) || date.after(this.stopInternal)) {
                    bl4 = false;
                    break;
                }
                if (bl && date.equals(this.startInternal)) {
                    bl4 = false;
                    break;
                }
                if (!bl2 || !date.equals(this.stopInternal)) break;
                bl4 = false;
                break;
            }
            case Daily: {
                iCalendar = this.getCalendar();
                iCalendar.setTime(date);
                this.setCalToDate(iCalendar, this.startInternal);
                date2 = iCalendar.getTime();
                break;
            }
            case Weekly: {
                iCalendar = this.getCalendar();
                iCalendar.setTime(date);
                int n2 = iCalendar.get(7);
                this.setCalToDate(iCalendar, this.startInternal);
                JCChartUtil.setToGivenDayOfWeek(iCalendar, n2);
                date2 = iCalendar.getTime();
            }
        }
        this.releaseCalendar(iCalendar);
        if (this.recurrencePattern != RecurrencePattern.None && date2 != null) {
            if (this.startInternal.before(this.stopInternal)) {
                if (date2.before(this.startInternal) || date2.after(this.stopInternal)) {
                    bl4 = false;
                }
            } else if (this.startInternal.after(this.stopInternal) && date2.before(this.startInternal) && date2.after(this.stopInternal)) {
                bl4 = false;
            }
            if (bl4 && bl && date2.equals(this.startInternal)) {
                bl4 = false;
            }
            if (bl4 && bl2 && date2.equals(this.stopInternal)) {
                bl4 = false;
            }
        }
        return bl4;
    }

    public Date getNextAvailableTime(Date date) {
        return this.getNextAvailableTime(date, this.startTimeOmitted, this.stopTimeOmitted, true);
    }

    public Date getNextAvailableTime(Date date, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (date == null || !this.useable) {
            return null;
        }
        if (!this.isTimeExcluded(date, bl, bl2, bl3)) {
            return date;
        }
        if (bl3 && this.switchList != null && this.recurrencePattern != RecurrencePattern.None && !date.before(this.switchListBegin) && !date.after(this.switchListEnd) && (object = this.findSwitch(date, true)) != null) {
            return ((ExcludeSwitch)object).getSwitchTime();
        }
        object = null;
        ICalendar iCalendar = null;
        switch (this.recurrencePattern) {
            case None: {
                if (date.before(this.startInternal) || date.after(this.stopInternal)) {
                    return date;
                }
                if (date.equals(this.startInternal) && bl) {
                    return date;
                }
                date = new Date(this.stopInternal.getTime());
                if (bl2) break;
                date = this.adjustDate(date, true);
                break;
            }
            case Daily: {
                iCalendar = this.getCalendar();
                iCalendar.setTime(this.stopInternal);
                object = this.getCalendar();
                object.setTime(date);
                if (JCChartUtil.isEndOfDay(iCalendar) && !bl2) {
                    object.add(5, 1);
                    JCChartUtil.setToStartOfDay((ICalendar)object);
                    date = object.getTime();
                    break;
                }
                this.setCalToDate(iCalendar, date);
                if (this.startInternal.after(this.stopInternal) && iCalendar.before(object)) {
                    iCalendar.add(5, 1);
                }
                date = iCalendar.getTime();
                if (bl2) break;
                date = this.adjustDate(date, true);
                break;
            }
            case Weekly: {
                iCalendar = this.getCalendar();
                iCalendar.setTime(this.stopInternal);
                object = this.getCalendar();
                object.setTime(date);
                if (JCChartUtil.isEndOfWeek(iCalendar) && !bl2) {
                    object.add(5, 1);
                    while (object.get(7) != object.getFirstDayOfWeek()) {
                        object.add(5, 1);
                    }
                    JCChartUtil.setToStartOfDay((ICalendar)object);
                    date = object.getTime();
                    break;
                }
                int n2 = iCalendar.get(7);
                this.setCalToDate(iCalendar, date);
                JCChartUtil.setToGivenDayOfWeek(iCalendar, n2);
                if (this.startInternal.after(this.stopInternal) && iCalendar.before(object)) {
                    iCalendar.add(5, 7);
                }
                boolean bl4 = false;
                if (JCChartUtil.isEndOfDay(iCalendar) && !bl2) {
                    iCalendar.add(5, 1);
                    JCChartUtil.setToStartOfDay(iCalendar);
                    bl4 = true;
                }
                date = iCalendar.getTime();
                if (bl2 || bl4) break;
                date = this.adjustDate(date, true);
            }
        }
        this.releaseCalendar((ICalendar)object);
        this.releaseCalendar(iCalendar);
        return date;
    }

    public Date getPrevAvailableTime(Date date) {
        if (date == null || !this.useable) {
            return null;
        }
        if (!this.isTimeExcluded(date)) {
            return date;
        }
        ICalendar iCalendar = null;
        ICalendar iCalendar2 = null;
        switch (this.recurrencePattern) {
            case None: {
                if (date.before(this.startInternal) || date.after(this.stopInternal)) {
                    return date;
                }
                if (date.equals(this.stopInternal) && this.stopTimeOmitted) {
                    return date;
                }
                date = new Date(this.startInternal.getTime());
                if (this.startTimeOmitted) break;
                date = this.adjustDate(date, false);
                break;
            }
            case Daily: {
                iCalendar2 = this.getCalendar();
                iCalendar2.setTime(this.startInternal);
                iCalendar = this.getCalendar();
                iCalendar.setTime(date);
                if (JCChartUtil.isStartOfDay(iCalendar2) && !this.startTimeOmitted) {
                    iCalendar.add(5, -1);
                    JCChartUtil.setToEndOfDay(iCalendar);
                    date = iCalendar.getTime();
                    break;
                }
                this.setCalToDate(iCalendar2, date);
                if (this.startInternal.after(this.stopInternal) && iCalendar2.after(iCalendar)) {
                    iCalendar2.add(5, -1);
                }
                date = iCalendar2.getTime();
                if (this.startTimeOmitted) break;
                date = this.adjustDate(date, false);
                break;
            }
            case Weekly: {
                iCalendar2 = this.getCalendar();
                iCalendar2.setTime(this.startInternal);
                iCalendar = this.getCalendar();
                iCalendar.setTime(date);
                if (JCChartUtil.isStartOfWeek(iCalendar2) && !this.startTimeOmitted) {
                    while (iCalendar.get(7) != iCalendar.getFirstDayOfWeek()) {
                        iCalendar.add(5, -1);
                    }
                    iCalendar.add(5, -1);
                    JCChartUtil.setToEndOfDay(iCalendar);
                    date = iCalendar.getTime();
                    break;
                }
                int n2 = iCalendar2.get(7);
                this.setCalToDate(iCalendar2, date);
                JCChartUtil.setToGivenDayOfWeek(iCalendar2, n2);
                if (this.startInternal.after(this.stopInternal) && iCalendar2.after(iCalendar)) {
                    iCalendar2.add(5, -7);
                }
                boolean bl = false;
                if (JCChartUtil.isStartOfDay(iCalendar2) && !this.startTimeOmitted) {
                    iCalendar2.add(5, -1);
                    JCChartUtil.setToEndOfDay(iCalendar2);
                    bl = true;
                }
                date = iCalendar2.getTime();
                if (this.startTimeOmitted || bl) break;
                date = this.adjustDate(date, false);
            }
        }
        this.releaseCalendar(iCalendar);
        this.releaseCalendar(iCalendar2);
        return date;
    }

    public Date getNextExcludedTime(Date date) {
        return this.getNextExcludedTime(date, this.startTimeOmitted, this.stopTimeOmitted, true);
    }

    public Date getNextExcludedTime(Date date, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (date == null || !this.useable) {
            return null;
        }
        if (this.isTimeExcluded(date, bl, bl2, bl3)) {
            return date;
        }
        if (bl3 && this.switchList != null && this.recurrencePattern != RecurrencePattern.None && !date.before(this.switchListBegin) && !date.after(this.switchListEnd) && (object = this.findSwitch(date, false)) != null) {
            return ((ExcludeSwitch)object).getSwitchTime();
        }
        object = null;
        ICalendar iCalendar = null;
        ICalendar iCalendar2 = null;
        switch (this.recurrencePattern) {
            case None: {
                if (date.before(this.startInternal) || bl && date.equals(this.startInternal)) {
                    date = new Date(this.startInternal.getTime());
                    break;
                }
                if (date.after(this.stopInternal)) {
                    date = null;
                    break;
                }
                if (!bl2 || !date.equals(this.stopInternal)) break;
                date = null;
                break;
            }
            case Daily: {
                iCalendar = this.getCalendar();
                iCalendar.setTime(this.startInternal);
                iCalendar2 = this.getCalendar();
                iCalendar2.setTime(this.stopInternal);
                object = this.getCalendar();
                object.setTime(date);
                this.setCalToDate((ICalendar)object, this.startInternal);
                if (object.before(iCalendar) || bl && object.equals(iCalendar)) {
                    this.setCalToDate(iCalendar, date);
                    date = iCalendar.getTime();
                    break;
                }
                if (!object.after(iCalendar2) && (!bl2 || !object.equals(iCalendar2))) break;
                object.setTime(this.startInternal);
                this.setCalToDate((ICalendar)object, date);
                object.add(5, 1);
                date = object.getTime();
                break;
            }
            case Weekly: {
                iCalendar = this.getCalendar();
                iCalendar.setTime(this.startInternal);
                iCalendar2 = this.getCalendar();
                iCalendar2.setTime(this.stopInternal);
                object = this.getCalendar();
                object.setTime(date);
                int n2 = object.get(7);
                this.setCalToDate((ICalendar)object, this.startInternal);
                JCChartUtil.setToGivenDayOfWeek((ICalendar)object, n2);
                n2 = iCalendar.get(7);
                if (object.before(iCalendar) || bl && object.equals(iCalendar)) {
                    this.setCalToDate(iCalendar, date);
                    JCChartUtil.setToGivenDayOfWeek(iCalendar, n2);
                    date = iCalendar.getTime();
                    break;
                }
                if (!object.after(iCalendar2) && (!bl2 || !object.equals(iCalendar2))) break;
                this.setCalToDate(iCalendar, date);
                JCChartUtil.setToGivenDayOfWeek(iCalendar, n2);
                iCalendar.add(5, 7);
                date = iCalendar.getTime();
            }
        }
        this.releaseCalendar((ICalendar)object);
        this.releaseCalendar(iCalendar);
        this.releaseCalendar(iCalendar2);
        if (bl) {
            date = this.adjustDate(date, true);
        }
        return date;
    }

    private Date adjustDate(Date date, boolean bl) {
        if (date != null) {
            Object object;
            JCChartDateFormat jCChartDateFormat = null;
            if (this.parent != null && (object = this.parent.getAnnotationHandler()) != null) {
                jCChartDateFormat = ((AnnotationHandler)object).getDateFormatter();
            }
            if (jCChartDateFormat == null) {
                jCChartDateFormat = new JCChartDateFormat();
            }
            object = bl ? JCChartDateFormat.AdjustType.POSITIVE : JCChartDateFormat.AdjustType.NEGATIVE;
            jCChartDateFormat.roundTime(date, 1000L, (JCChartDateFormat.AdjustType)((Object)object));
        }
        return date;
    }

    private void getInternalTime() {
        Date date = new Date(System.currentTimeMillis());
        ICalendar iCalendar = null;
        ICalendar iCalendar2 = null;
        this.useable = true;
        switch (this.recurrencePattern) {
            case None: {
                this.startInternal = this.startTime == null ? date : this.startTime;
                Date date2 = this.stopInternal = this.stopTime == null ? date : this.stopTime;
                if (this.startTime == null && this.stopTime != null) {
                    this.startInternal = this.stopTime;
                }
                if (this.startTime != null && this.stopTime == null) {
                    this.stopInternal = this.startTime;
                }
                if (!this.startInternal.after(this.stopInternal)) break;
                this.useable = false;
                break;
            }
            case Daily: {
                iCalendar = this.getCalendar();
                if (this.startTime == null) {
                    iCalendar.setTime(date);
                    JCChartUtil.setToStartOfDay(iCalendar);
                } else {
                    iCalendar.setTime(this.startTime);
                    this.setCalToDate(iCalendar, date);
                }
                this.startInternal = iCalendar.getTime();
                iCalendar2 = this.getCalendar();
                if (this.stopTime == null) {
                    iCalendar2.setTime(date);
                    JCChartUtil.setToEndOfDay(iCalendar2);
                } else {
                    iCalendar2.setTime(this.stopTime);
                    this.setCalToDate(iCalendar2, date);
                }
                this.stopInternal = iCalendar2.getTime();
                if (!this.startInternal.equals(this.stopInternal) && (!JCChartUtil.isStartOfDay(iCalendar) || !JCChartUtil.isEndOfDay(iCalendar2))) break;
                this.useable = false;
                break;
            }
            case Weekly: {
                int n2;
                iCalendar = this.getCalendar();
                if (this.startTime == null) {
                    iCalendar.setTime(date);
                    JCChartUtil.setToStartOfWeek(iCalendar);
                } else {
                    iCalendar.setTime(this.startTime);
                    n2 = iCalendar.get(7);
                    this.setCalToDate(iCalendar, date);
                    JCChartUtil.setToGivenDayOfWeek(iCalendar, n2);
                }
                this.startInternal = iCalendar.getTime();
                iCalendar2 = this.getCalendar();
                if (this.stopTime == null) {
                    iCalendar2.setTime(date);
                    JCChartUtil.setToEndOfWeek(iCalendar2);
                } else {
                    iCalendar2.setTime(this.stopTime);
                    n2 = iCalendar2.get(7);
                    this.setCalToDate(iCalendar2, date);
                    JCChartUtil.setToGivenDayOfWeek(iCalendar2, n2);
                }
                this.stopInternal = iCalendar2.getTime();
                if (!this.startInternal.equals(this.stopInternal) && (!JCChartUtil.isStartOfWeek(iCalendar) || !JCChartUtil.isEndOfWeek(iCalendar2))) break;
                this.useable = false;
            }
        }
        this.releaseCalendar(iCalendar);
        this.releaseCalendar(iCalendar2);
    }

    protected synchronized ICalendar getCalendar() {
        if (this.calendars.isEmpty()) {
            return JCChartUtil.getGregorianCalendar(true, this.timeZone, this.locale);
        }
        return this.calendars.pop();
    }

    protected synchronized void releaseCalendar(ICalendar iCalendar) {
        if (iCalendar != null) {
            this.calendars.push(iCalendar);
        }
    }

    private void setCalToDate(ICalendar iCalendar, Date date) {
        ICalendar iCalendar2 = this.getCalendar();
        iCalendar2.setTime(date);
        iCalendar.set(iCalendar2.get(1), iCalendar2.get(2), iCalendar2.get(5));
        this.releaseCalendar(iCalendar2);
    }

    public static JCTimeExclusion createWeekendExclusion(TimeZone timeZone, Locale locale, boolean bl) {
        ICalendar iCalendar = JCChartUtil.getGregorianCalendar(true, timeZone, locale);
        if (iCalendar.isWeekend()) {
            while (iCalendar.isWeekend()) {
                iCalendar.add(5, -1);
            }
            iCalendar.add(5, 1);
        } else {
            while (!iCalendar.isWeekend()) {
                iCalendar.add(5, 1);
            }
        }
        JCChartUtil.setToStartOfDay(iCalendar);
        Date date = iCalendar.getTime();
        while (iCalendar.isWeekend()) {
            iCalendar.add(5, 1);
        }
        iCalendar.add(5, -1);
        JCChartUtil.setToEndOfDay(iCalendar);
        Date date2 = iCalendar.getTime();
        JCTimeExclusion jCTimeExclusion = new JCTimeExclusion(date, date2, false, false, RecurrencePattern.Weekly, locale, timeZone, bl);
        jCTimeExclusion.setSkipWeekend(true);
        return jCTimeExclusion;
    }

    protected class ExcludeSwitch {
        protected Date switchTime = null;
        protected boolean excluded = false;

        protected ExcludeSwitch(Date date, boolean bl) {
            this.switchTime = date;
            this.excluded = bl;
        }

        public Date getSwitchTime() {
            return this.switchTime;
        }

        public void setSwitchTime(Date date) {
            this.switchTime = date;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean bl) {
            this.excluded = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecurrencePattern {
        None,
        Daily,
        Weekly;

    }
}

