/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPickItem;
import com.klg.jclass.chart.LegendEntry;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PickShape;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.PolarAxisParams;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.graphics.DefineShape;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCMarker
implements LegendEntry,
Serializable {
    protected ChartDataView dataView;
    protected String label;
    protected double value = -1.7976931348623157E308;
    protected JCLineStyle lineStyle = new JCLineStyle(1, Color.black, 1);
    protected double startPoint = -1.7976931348623157E308;
    protected double endPoint = Double.MAX_VALUE;
    protected boolean visibleInLegend = false;
    protected boolean drawnBeforeData = false;
    protected JCChartLabel chartLabel = null;
    protected boolean associatedWithYAxis = true;
    protected boolean includedInDataBounds = false;
    protected ImageMapInfo legendImageMapInfo = null;
    protected int pickFocus = 0;
    private JCAxis axis;
    private double axisMin;
    private double axisMax;
    private JCAxis oppositeAxis;
    private double oppositeMin;
    private double oppositeMax;
    private JCChartArea area;
    private double adjValue;
    private double adjStartPoint;
    private double adjEndPoint;
    private TextRenderer textRenderer = null;
    private boolean notDrawnForRadar = false;
    private boolean isRectangular = false;
    private boolean isRadar = false;
    private boolean isWebbed = false;
    private boolean isCircular = false;

    public JCMarker() {
    }

    public JCMarker(String string, double d2) {
        this.label = string;
        this.value = d2;
    }

    public JCMarker(String string, double d2, boolean bl) {
        this.label = string;
        this.value = d2;
        this.associatedWithYAxis = bl;
    }

    public JCMarker(String string, double d2, JCLineStyle jCLineStyle, double d3, double d4, boolean bl, boolean bl2, boolean bl3, JCChartLabel jCChartLabel) {
        this.label = string;
        this.value = d2;
        this.lineStyle = jCLineStyle;
        this.startPoint = d3;
        this.endPoint = d4;
        this.associatedWithYAxis = bl;
        this.visibleInLegend = bl2;
        this.drawnBeforeData = bl3;
        this.chartLabel = jCChartLabel;
    }

    public ChartDataView getParent() {
        return this.dataView;
    }

    public void setLabel(String string) {
        this.label = string;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d2) {
        this.value = d2;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public double getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(double d2) {
        this.startPoint = d2;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public double getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(double d2) {
        this.endPoint = d2;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public boolean isAssociatedWithYAxis() {
        return this.associatedWithYAxis;
    }

    public void setAssociatedWithYAxis(boolean bl) {
        this.associatedWithYAxis = bl;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public boolean isIncludedInDataBounds() {
        return this.includedInDataBounds;
    }

    public void setIncludedInDataBounds(boolean bl) {
        this.includedInDataBounds = bl;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public void setVisibleInLegend(boolean bl) {
        this.visibleInLegend = bl;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public int getDrawType() {
        return 4;
    }

    public boolean isDrawnBeforeData() {
        return this.drawnBeforeData;
    }

    public void setDrawnBeforeData(boolean bl) {
        this.drawnBeforeData = bl;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public JCLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        this.lineStyle = jCLineStyle;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public JCChartLabel getChartLabel() {
        return this.chartLabel;
    }

    public void setChartLabel(JCChartLabel jCChartLabel) {
        if (this.chartLabel == jCChartLabel) {
            return;
        }
        this.chartLabel = jCChartLabel;
        if (this.dataView != null) {
            this.dataView.setChanged(true, 34);
        }
    }

    public ImageMapInfo getLegendImageMapInfo() {
        return this.legendImageMapInfo;
    }

    public void setLegendImageMapInfo(ImageMapInfo imageMapInfo) {
        this.legendImageMapInfo = imageMapInfo;
    }

    public void setPickFocus(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("pickFocus must be one of ChartDataView.PICK_FOCUS_XY, ChartDataView.PICK_FOCUS_X, ChartDataView.PICK_FOCUS_Y, or ChartDataView.PICK_FOCUS_NONE");
        }
        this.pickFocus = n2;
    }

    public int getPickFocus() {
        return this.pickFocus;
    }

    protected void adjustMinMax(MinMax minMax, boolean bl) {
        if (minMax == null || this.dataView == null) {
            return;
        }
        if (bl ^ this.associatedWithYAxis) {
            return;
        }
        this.calcValues();
        if (this.axis == null) {
            return;
        }
        if (!bl && (this.axis.isPolar() || this.axis.isRadar())) {
            return;
        }
        minMax.setMinMax(this.adjValue, this.dataView.getHoleValue(), this.axis.isLogarithmic());
    }

    private void calcValues() {
        if (this.dataView == null) {
            return;
        }
        if (this.associatedWithYAxis) {
            this.axis = this.dataView.getYAxis();
            this.oppositeAxis = this.dataView.getXAxis();
        } else {
            this.axis = this.dataView.getXAxis();
            this.oppositeAxis = this.dataView.getYAxis();
        }
        if (this.axis == null) {
            return;
        }
        this.area = this.axis.getChartArea();
        int n2 = this.dataView.getChartType();
        boolean bl = n2 == 3 || n2 == 4;
        int n3 = bl ? ChartDataView.getNumRadarSpokes(this.dataView) : 0;
        this.axisMin = this.axis.getMin();
        this.axisMax = this.axis.getMax();
        if (bl && !this.associatedWithYAxis) {
            this.axisMin = 0.0;
            this.axisMax = n3;
        }
        this.adjValue = this.value;
        if (this.adjValue == -1.7976931348623157E308) {
            this.adjValue = this.axisMin;
        } else if (this.adjValue == Double.MAX_VALUE) {
            this.adjValue = this.axisMax;
        }
        if (this.associatedWithYAxis && bl) {
            this.oppositeMin = 0.0;
            this.oppositeMax = n3;
        } else if (this.oppositeAxis != null) {
            this.oppositeMin = this.oppositeAxis.getMin();
            this.oppositeMax = this.oppositeAxis.getMax();
        } else {
            this.oppositeMin = -1.7976931348623157E308;
            this.oppositeMax = Double.MAX_VALUE;
        }
        this.adjStartPoint = JCNumberUtil.clamp(this.startPoint, this.oppositeMin, this.oppositeMax);
        this.adjEndPoint = JCNumberUtil.clamp(this.endPoint, this.oppositeMin, this.oppositeMax);
    }

    protected void draw(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        if (this.dataView == null) {
            return;
        }
        this.isRectangular = bl;
        this.isRadar = bl2;
        this.isWebbed = bl3;
        this.isCircular = !bl && (!bl2 || !bl3);
        boolean bl4 = graphics instanceof DefineShape;
        Graphics graphics2 = bl4 ? graphics.create() : graphics;
        Shape shape = graphics2.getClip();
        if (this.area == null) {
            this.area = this.dataView.getParent().getChartArea();
        }
        Rectangle rectangle = this.area.clipForDrawing(0);
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        RenderShape renderShape = new RenderShape(graphics2, graphics2, this.dataView.isUsingDoublePixels());
        renderShape.setLineStyle(this.lineStyle);
        this.processMarker(renderShape);
        if (bl4) {
            graphics2.dispose();
        } else {
            if (this.lineStyle != null) {
                this.lineStyle.resetGraphics(graphics);
            }
            graphics2.setClip(shape);
        }
    }

    protected void processMarker(ProcessShape processShape) {
        if (this.isRectangular) {
            this.processRectangular(processShape);
        } else if (this.isRadar && this.isWebbed) {
            this.processWebbed(processShape);
        } else if (this.isCircular) {
            this.processCircular(processShape);
        }
    }

    protected void processRectangular(ProcessShape processShape) {
        double d2;
        double d3;
        double d4;
        if (this.dataView == null || processShape == null) {
            return;
        }
        if (this.lineStyle == null) {
            return;
        }
        this.calcValues();
        if (this.adjValue < this.axisMin || this.adjValue > this.axisMax) {
            return;
        }
        if (this.adjEndPoint <= this.adjStartPoint) {
            return;
        }
        if (this.area == null || this.axis == null || this.oppositeAxis == null) {
            return;
        }
        boolean bl = !this.area.draw3D || !this.drawnBeforeData;
        double d5 = d4 = this.axis.usingDoublePixels ? this.axis.toPixelDouble(this.adjValue, bl) : (double)this.axis.toPixel(this.adjValue, bl);
        if (this.oppositeAxis.usingDoublePixels) {
            d3 = this.oppositeAxis.toPixelDouble(this.adjStartPoint, bl);
            d2 = this.oppositeAxis.toPixelDouble(this.adjEndPoint, bl);
        } else {
            d3 = this.oppositeAxis.toPixel(this.adjStartPoint, bl);
            d2 = this.oppositeAxis.toPixel(this.adjEndPoint, bl);
        }
        if (this.axis.i_vertical) {
            processShape.drawLine(d3, d4, d2, d4);
        } else {
            processShape.drawLine(d4, d3, d4, d2);
        }
    }

    protected void processWebbed(ProcessShape processShape) {
        this.notDrawnForRadar = true;
        if (this.dataView == null || processShape == null) {
            return;
        }
        if (this.lineStyle == null) {
            return;
        }
        this.calcValues();
        if (this.adjValue < this.axisMin || this.adjValue > this.axisMax) {
            return;
        }
        if (this.area == null || this.axis == null || this.associatedWithYAxis && this.oppositeAxis == null) {
            return;
        }
        JCAxis jCAxis = this.dataView.getXAxis();
        if (jCAxis == null) {
            return;
        }
        PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
        double d2 = Math.round(polarAxisParams.xCenter);
        double d3 = Math.round(polarAxisParams.yCenter);
        int n2 = ChartDataView.getNumRadarSpokes(this.dataView);
        if (n2 <= 0) {
            return;
        }
        double d4 = JCChartUtil.getRadarAngle(2, n2, 1, false);
        this.notDrawnForRadar = false;
        if (this.associatedWithYAxis) {
            int n3;
            boolean bl;
            int n4 = (int)Math.floor(this.adjStartPoint);
            int n5 = (int)Math.ceil(this.adjStartPoint) % n2;
            int n6 = (int)Math.floor(this.adjEndPoint);
            boolean bl2 = bl = this.adjStartPoint == this.adjEndPoint || this.adjStartPoint == this.oppositeMin && this.adjEndPoint == this.oppositeMax;
            if (!(bl || n4 != n6 && n5 != n6)) {
                this.notDrawnForRadar = true;
                return;
            }
            Point point = this.oppositeAxis.toPixelPolar(0.0, this.adjValue, true);
            double d5 = point.distance(d2, d3);
            if (bl) {
                this.adjStartPoint = 0.0;
                this.adjEndPoint = n2;
                if (!this.isWebbed) {
                    processShape.drawCircle((int)d2, (int)d3, (int)d5);
                    return;
                }
            }
            int n7 = n5;
            int n8 = n3 = bl ? n6 + 1 : n6;
            if (n3 <= n7) {
                n3 += n2;
            }
            if (!bl) {
                this.adjStartPoint = n7;
                this.adjEndPoint = n3 % n2;
            }
            for (int i2 = n7; i2 < n3; ++i2) {
                int n9 = i2 % n2;
                this.processWebSegment(processShape, d5, d4, n9, n2, jCAxis);
            }
        } else {
            if (this.adjStartPoint >= this.adjEndPoint) {
                return;
            }
            int n10 = (int)Math.rint(this.adjValue) % n2;
            double d6 = JCChartUtil.getRadarAngle(2, n2, n10, false);
            Point point = this.axis.toPixelPolar(d6, this.adjStartPoint, true);
            Point point2 = this.axis.toPixelPolar(d6, this.adjEndPoint, true);
            processShape.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    protected void processWebSegment(ProcessShape processShape, double d2, double d3, int n2, int n3, JCAxis jCAxis) {
        Point point = jCAxis.toPixelPolar((double)(n2 %= n3) * d3, d2, false);
        n2 = (n2 + 1) % n3;
        Point point2 = jCAxis.toPixelPolar((double)n2 * d3, d2, false);
        processShape.drawLine(point.x, point.y, point2.x, point2.y);
    }

    protected void processCircular(ProcessShape processShape) {
        if (this.dataView == null || processShape == null) {
            return;
        }
        if (this.lineStyle == null) {
            return;
        }
        this.calcValues();
        if (this.adjValue < this.axisMin || this.adjValue > this.axisMax) {
            return;
        }
        if (this.area == null || this.axis == null || this.associatedWithYAxis && this.oppositeAxis == null) {
            return;
        }
        JCAxis jCAxis = this.dataView.getXAxis();
        if (jCAxis == null) {
            return;
        }
        PolarAxisParams polarAxisParams = jCAxis.polarAxisParams;
        double d2 = Math.round(polarAxisParams.xCenter);
        double d3 = Math.round(polarAxisParams.yCenter);
        if (this.associatedWithYAxis) {
            Point point = this.oppositeAxis.toPixelPolar(0.0, this.adjValue, true);
            double d4 = point.distance(d2, d3);
            if (this.adjStartPoint == this.adjEndPoint || this.adjStartPoint == this.oppositeMin && this.adjEndPoint == this.oppositeMax) {
                processShape.drawCircle((int)d2, (int)d3, (int)d4);
            } else {
                double d5 = this.area.getAngleFromXValue(this.dataView, this.adjStartPoint, false, 1);
                double d6 = this.area.getAngleFromXValue(this.dataView, this.adjEndPoint, false, 1);
                double d7 = 2.0 * d4;
                double d8 = d6 - d5;
                if (d8 < 0.0 ^ jCAxis.isReversed()) {
                    d8 += d8 < 0.0 ? 360.0 : -360.0;
                }
                processShape.drawArc(d2 - d4, d3 - d4, d7, d7, d5, d8);
            }
        } else {
            if (this.adjStartPoint >= this.adjEndPoint) {
                return;
            }
            double d9 = JCChartUtil.convertAngle(this.area.getAngleUnit(), 2, this.adjValue);
            Point point = jCAxis.toPixelPolar(d9, this.adjStartPoint, true);
            Point point2 = jCAxis.toPixelPolar(d9, this.adjEndPoint, true);
            processShape.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawChartLabel(Graphics graphics) {
        if (graphics == null || this.chartLabel == null || this.dataView == null || this.notDrawnForRadar) {
            return;
        }
        if (this.axis == null) {
            this.calcValues();
        }
        if (this.area == null) {
            return;
        }
        JComponent jComponent = this.chartLabel.getComponent();
        if (jComponent == null || !jComponent.isVisible()) {
            return;
        }
        if (!(jComponent instanceof JLabel)) {
            throw new IllegalArgumentException("Marker chart label must be an instance of a JLabel");
        }
        JLabel jLabel = (JLabel)jComponent;
        if (this.chartLabel.isDwellLabel()) {
            throw new IllegalArgumentException("Marker label cannot be a dwell label");
        }
        if (this.chartLabel.getParentManager() != null) {
            throw new IllegalArgumentException("Marker chart label must not have been added to a JCChartLabelManager.");
        }
        int n2 = this.dataView.getChartType();
        boolean bl = n2 == 2;
        boolean bl2 = n2 == 3 || n2 == 4;
        boolean bl3 = bl || bl2;
        this.chartLabel.setDataView(this.dataView);
        this.chartLabel.setAttachMethod(2);
        int n3 = 0;
        if (bl2) {
            n3 = ChartDataView.getNumRadarSpokes(this.dataView);
            if (n3 <= 0) {
                return;
            }
            if (!this.associatedWithYAxis) {
                this.adjValue = (int)Math.rint(this.adjValue) % n3;
            }
        }
        double d2 = (this.adjStartPoint + this.adjEndPoint) / 2.0;
        if (bl3 && this.associatedWithYAxis && this.adjEndPoint < this.adjStartPoint) {
            double d3 = (this.oppositeMax - this.adjStartPoint + this.adjEndPoint) / 2.0;
            d2 = this.adjEndPoint - d3;
            if (d2 < 0.0) {
                d2 += this.oppositeMax;
            }
        } else if (this.adjEndPoint < this.adjStartPoint) {
            return;
        }
        JCDataCoord jCDataCoord = this.chartLabel.getDataCoord();
        double d4 = jCDataCoord.x;
        double d5 = jCDataCoord.y;
        boolean bl4 = this.chartLabel.dataCoordIsDefault;
        if (this.associatedWithYAxis) {
            double d6;
            double d7;
            if (bl3) {
                double d8;
                d7 = JCChartUtil.convertAngle(2, this.area.getAngleUnit(), Math.PI * 2);
                double d9 = d8 = bl2 ? (double)n3 : d7;
                for (d6 = d4; d6 < this.oppositeMin; d6 += d8) {
                }
                while (d6 > this.oppositeMax) {
                    d6 -= d8;
                }
            }
            if (bl3 && this.adjEndPoint < this.adjStartPoint) {
                if (d6 > this.adjEndPoint && d6 < this.adjStartPoint) {
                    d7 = (this.adjStartPoint + this.adjEndPoint) / 2.0;
                    d6 = d6 < d7 ? this.adjEndPoint : this.adjStartPoint;
                }
            } else {
                d6 = JCNumberUtil.clamp(d6, this.adjStartPoint, this.adjEndPoint);
            }
            jCDataCoord.x = bl4 ? d2 : d6;
            jCDataCoord.y = this.adjValue;
        } else {
            jCDataCoord.x = this.adjValue;
            jCDataCoord.y = bl4 ? d2 : JCNumberUtil.clamp(jCDataCoord.y, this.adjStartPoint, this.adjEndPoint);
        }
        this.chartLabel.setDataCoord(jCDataCoord);
        this.chartLabel.dataAttachX = d4;
        this.chartLabel.dataAttachY = d5;
        this.chartLabel.dataCoordIsDefault = bl4;
        Dimension dimension = jLabel.getSize();
        Point point = jLabel.getLocation();
        Point point2 = this.area.getLocation();
        Rectangle rectangle = this.area.getDrawingArea();
        int n4 = -point2.x - rectangle.x;
        int n5 = -point2.y - rectangle.y;
        graphics.translate(n4, n5);
        try {
            String string;
            graphics.setColor(jLabel.getForeground());
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(1.0f));
            this.chartLabel.drawConnector(graphics);
            CellRendererPane cellRendererPane = this.area.getCellRendererPane();
            String string2 = string = this.chartLabel.text == null ? this.chartLabel.defaultText : this.chartLabel.text;
            if (this.textRenderer == null) {
                this.textRenderer = new TextRenderer();
            }
            this.textRenderer.drawHTMLText(graphics, jLabel, cellRendererPane, this.area, string, point.x, point.y, dimension.width, dimension.height);
        }
        finally {
            graphics.translate(-n4, -n5);
        }
    }

    public JCPickItem pick(Point point) {
        this.calcValues();
        if (this.area == null || this.dataView == null || this.axis == null || this.pickFocus == 3) {
            return null;
        }
        Point point2 = this.area.getLocation();
        int n2 = point.x - point2.x;
        int n3 = point.y - point2.y;
        boolean bl = !this.axis.i_vertical;
        int n4 = this.isRectangular ? this.pickFocus : 0;
        Picker picker = new Picker(n2, n3, n4);
        PickShape pickShape = new PickShape(picker, 2, bl);
        this.processMarker(pickShape);
        return new JCPickItem(this, this.area, picker.distance);
    }
}

