/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCAbstractThreshold;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPickItem;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PickShape;
import com.klg.jclass.chart.Picker;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.chart.RenderShape;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;

public class JCEnvelope
extends JCAbstractThreshold {
    protected double[] xValues = null;
    protected double[][] yValues = null;
    protected JCChartStyle holeStyle = null;
    protected boolean drawnWithData = false;
    private JCChartArea area;
    private JCAxis axis;
    private JCAxis oppositeAxis;

    public JCEnvelope() {
    }

    public JCEnvelope(String string, JCChartStyle jCChartStyle, boolean bl) {
        this.label = string;
        this.chartStyle = jCChartStyle;
        this.chartStyleDefault = false;
        this.visibleInLegend = bl;
    }

    public double[] getXValues() {
        return this.xValues;
    }

    public void setXValues(double[] dArray) {
        this.xValues = dArray;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public double[][] getYValues() {
        return this.yValues;
    }

    public void setYValues(double[][] dArray) {
        this.yValues = dArray;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public JCChartStyle getHoleStyle() {
        return this.holeStyle;
    }

    public void setHoleStyle(JCChartStyle jCChartStyle) {
        this.holeStyle = jCChartStyle;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public void setDrawnWithData(boolean bl) {
        this.drawnWithData = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isDrawnWithData() {
        return this.drawnWithData;
    }

    public int getDrawType() {
        JCChartStyle jCChartStyle = this.getChartStyle();
        if (jCChartStyle == null) {
            return 0;
        }
        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
        if (jCFillStyle != null && jCFillStyle.getPattern() != 0) {
            return 1;
        }
        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
        if (jCLineStyle != null && jCLineStyle.getPattern() != 0 && jCLineStyle.getWidth() > 0) {
            return 4;
        }
        JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
        if (jCSymbolStyle != null && jCSymbolStyle.getShape() != 0 && jCSymbolStyle.getSize() > 0) {
            return 4;
        }
        return 0;
    }

    protected void adjustMinMax(MinMax minMax, boolean bl) {
        block8: {
            double d2;
            boolean bl2;
            block7: {
                if (minMax == null || this.parent == null) {
                    return;
                }
                this.calcValues();
                if (this.axis == null) {
                    return;
                }
                if (!bl && (this.axis.isPolar() || this.axis.isRadar())) {
                    return;
                }
                bl2 = this.axis.isLogarithmic();
                d2 = this.getHoleValue();
                if (!bl) break block7;
                if (this.yValues == null) break block8;
                for (int i2 = 0; i2 < Math.min(this.yValues.length, 2); ++i2) {
                    double[] dArray = this.yValues[i2];
                    if (dArray == null) continue;
                    for (double d3 : dArray) {
                        minMax.setMinMax(d3, d2, bl2);
                    }
                }
                break block8;
            }
            if (JCEnvelope.checkXValues(this.xValues, this.getHoleValue())) {
                for (double d4 : this.xValues) {
                    minMax.setMinMax(d4, d2, bl2);
                }
            }
        }
    }

    private void calcValues() {
        JCChart jCChart;
        if (this.parent == null) {
            return;
        }
        if (this.chartStyle == null && this.chartStyleDefault) {
            this.chartStyle = this.calcDefaultChartStyle();
        }
        this.axis = this.parent.getYAxis();
        this.oppositeAxis = this.parent.getXAxis();
        this.area = null;
        if (this.axis != null) {
            this.area = this.axis.getChartArea();
        }
        if (this.area == null && (jCChart = this.parent.getParent()) != null) {
            this.area = jCChart.getChartArea();
        }
    }

    public static boolean checkXValues(double[] dArray, double d2) {
        if (dArray == null) {
            return false;
        }
        if (dArray.length < 1) {
            return false;
        }
        double d3 = dArray[0];
        boolean bl = JCEnvelope.isValid(d3, d2);
        int n2 = bl ? 1 : 0;
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            double d4 = dArray[i2];
            if (!JCEnvelope.isValid(d4, d2)) continue;
            ++n2;
            if (bl && d3 > d4) {
                return false;
            }
            d3 = d4;
            bl = true;
        }
        return n2 >= 1;
    }

    protected Point[] transformLimitArray(double[] dArray, int n2, int n3) {
        if (this.xValues == null || dArray == null) {
            return null;
        }
        if (n2 > n3) {
            return null;
        }
        int n4 = 0;
        Point[] pointArray = new Point[n3 - n2 + 1];
        for (int i2 = n2; i2 <= n3; ++i2) {
            double d2 = this.xValues[i2];
            double d3 = dArray[i2];
            pointArray[n4] = this.getPoint(d2, d3);
            ++n4;
        }
        return pointArray;
    }

    protected Point getPoint(double d2, double d3) {
        boolean bl = !this.area.draw3D;
        int n2 = this.transform(d2, this.oppositeAxis, bl);
        int n3 = this.transform(d3, this.axis, bl);
        return this.axis.i_vertical ? new Point(n2, n3) : new Point(n3, n2);
    }

    protected void draw(Graphics graphics) {
        this.calcValues();
        if (this.area == null || this.parent == null || this.axis == null) {
            return;
        }
        int n2 = this.parent.getChartType();
        if (n2 != 0 && n2 != 1) {
            return;
        }
        this.drawWithClip(graphics, 0, true);
        JCSymbolStyle jCSymbolStyle = this.chartStyle.getSymbolStyle();
        int n3 = 0;
        if (jCSymbolStyle != null && jCSymbolStyle.getShape() != 0) {
            n3 = (jCSymbolStyle.getSize() + 1) / 2;
        }
        this.drawWithClip(graphics, n3, false);
    }

    protected void drawWithClip(Graphics graphics, int n2, boolean bl) {
        boolean bl2 = graphics instanceof DefineShape;
        Graphics graphics2 = bl2 ? graphics.create() : graphics;
        Shape shape = graphics2.getClip();
        Rectangle rectangle = this.area.clipForDrawing(n2);
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        RenderShape renderShape = new RenderShape(graphics2, graphics2, this.parent.isUsingDoublePixels());
        this.processEnvelope(renderShape, bl, false);
        if (bl2) {
            graphics2.dispose();
        } else {
            graphics2.setClip(shape);
        }
    }

    protected JCPickItem pick(Point point) {
        this.calcValues();
        if (this.area == null || this.parent == null || this.axis == null || this.pickFocus == 3) {
            return null;
        }
        int n2 = this.parent.getChartType();
        if (n2 != 0 && n2 != 1) {
            return null;
        }
        Point point2 = this.area.getLocation();
        int n3 = point.x - point2.x;
        int n4 = point.y - point2.y;
        Picker picker = new Picker(n3, n4, this.pickFocus);
        PickShape pickShape = new PickShape(picker, false, this.axis.i_vertical);
        this.processEnvelope(pickShape, true, true);
        JCPickItem jCPickItem = null;
        if (picker.distance <= 0) {
            jCPickItem = new JCPickItem(this, this.area, 0);
        }
        return jCPickItem;
    }

    protected void processEnvelope(ProcessShape processShape, boolean bl, boolean bl2) {
        if (processShape == null) {
            return;
        }
        if (!JCEnvelope.checkXValues(this.xValues, this.getHoleValue())) {
            return;
        }
        if (this.yValues == null || this.yValues.length < 2) {
            return;
        }
        JCLineStyle jCLineStyle = this.chartStyle.getLineStyle();
        JCFillStyle jCFillStyle = this.chartStyle.getFillStyle();
        JCSymbolStyle jCSymbolStyle = this.chartStyle.getSymbolStyle();
        if (jCLineStyle == null && jCFillStyle == null && jCSymbolStyle == null) {
            return;
        }
        if (!bl && jCLineStyle == null && jCSymbolStyle == null) {
            return;
        }
        if (bl && jCFillStyle == null && !bl2) {
            return;
        }
        double[] dArray = this.yValues[0];
        double[] dArray2 = this.yValues[1];
        int n2 = Math.min(this.xValues.length, Math.min(dArray.length, dArray2.length));
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        Point[] pointArray = null;
        Point[] pointArray2 = null;
        boolean bl3 = false;
        while (!bl3) {
            boolean bl4 = false;
            for (int i2 = n3; i2 < n2; ++i2) {
                if (!JCEnvelope.isValid(this.xValues[i2], this.getHoleValue()) || !JCEnvelope.isValid(dArray[i2], this.getHoleValue()) || !JCEnvelope.isValid(dArray2[i2], this.getHoleValue())) continue;
                n3 = i2;
                bl4 = true;
                break;
            }
            Object var16_16 = null;
            Point point = null;
            if (pointArray != null && pointArray2 != null) {
                var16_16 = pointArray[pointArray.length - 1];
                point = pointArray2[pointArray2.length - 1];
            }
            if (bl4 && var16_16 != null && point != null && this.holeStyle != null) {
                pointArray = new Point[2];
                pointArray2 = new Point[2];
                pointArray[0] = var16_16;
                pointArray2[0] = point;
                pointArray[1] = this.getPoint(this.xValues[n3], dArray[n3]);
                pointArray2[1] = this.getPoint(this.xValues[n3], dArray2[n3]);
                this.processSegment(processShape, pointArray, pointArray2, this.holeStyle, true, false, bl);
            }
            if (var16_16 != null && point != null && jCSymbolStyle != null) {
                pointArray = new Point[1];
                pointArray2 = new Point[1];
                pointArray[0] = var16_16;
                pointArray2[0] = point;
                this.processSegment(processShape, pointArray, pointArray2, this.chartStyle, false, true, bl);
            }
            if (!bl4) {
                bl3 = true;
                continue;
            }
            bl4 = false;
            for (int i3 = n3 + 1; i3 < n2; ++i3) {
                if (JCEnvelope.isValid(this.xValues[i3], this.getHoleValue()) && JCEnvelope.isValid(dArray[i3], this.getHoleValue()) && JCEnvelope.isValid(dArray2[i3], this.getHoleValue())) continue;
                n4 = i3 - 1;
                bl4 = true;
                break;
            }
            if (!bl4) {
                n4 = n2 - 1;
                bl3 = true;
            }
            pointArray = this.transformLimitArray(dArray, n3, n4);
            pointArray2 = this.transformLimitArray(dArray2, n3, n4);
            this.processSegment(processShape, pointArray, pointArray2, this.chartStyle, false, bl3, bl);
            n3 = n4 + 1;
        }
    }

    protected void processSegment(ProcessShape processShape, Point[] pointArray, Point[] pointArray2, JCChartStyle jCChartStyle, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        processShape.setChartStyle(jCChartStyle);
        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
        JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
        boolean bl5 = bl4 = pointArray.length > 1 && pointArray2.length > 1;
        if (bl4) {
            Polygon polygon = new Polygon();
            for (Point point : pointArray) {
                if (point == null) continue;
                polygon.addPoint(point.x, point.y);
            }
            for (int i2 = pointArray2.length - 1; i2 >= 0; --i2) {
                if (pointArray2[i2] == null) continue;
                polygon.addPoint(pointArray2[i2].x, pointArray2[i2].y);
            }
            if (jCFillStyle != null && bl3) {
                jCFillStyle.updateAnchorRect(polygon.getBounds());
                processShape.fillPolygon(polygon);
                jCFillStyle.updateAnchorRect(null);
            }
            if (jCLineStyle != null && !bl3) {
                this.processEnvelopeLine(processShape, pointArray, jCChartStyle, true, bl2);
                this.processEnvelopeLine(processShape, pointArray2, jCChartStyle, true, bl2);
            }
        }
        if (jCSymbolStyle != null && !bl && !bl3) {
            this.processEnvelopeLine(processShape, pointArray, jCChartStyle, false, bl2);
            this.processEnvelopeLine(processShape, pointArray2, jCChartStyle, false, bl2);
        }
    }

    protected void processEnvelopeLine(ProcessShape processShape, Point[] pointArray, JCChartStyle jCChartStyle, boolean bl, boolean bl2) {
        Point point;
        int n2;
        Cloneable cloneable;
        if (pointArray == null || pointArray.length == 0 || jCChartStyle == null) {
            return;
        }
        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
        if (bl && jCLineStyle != null && pointArray.length > 1) {
            cloneable = new GeneralPath();
            Point point2 = pointArray[0];
            ((Path2D.Float)cloneable).moveTo(point2.x, point2.y);
            for (n2 = 1; n2 < pointArray.length; ++n2) {
                point = pointArray[n2];
                if (point == null) continue;
                ((Path2D.Float)cloneable).lineTo(point.x, point.y);
            }
            processShape.drawShape((Shape)((Object)cloneable));
        }
        cloneable = jCChartStyle.getSymbolStyle();
        if (!bl && cloneable != null) {
            int n3 = bl2 ? pointArray.length : pointArray.length - 1;
            for (n2 = 0; n2 < n3; ++n2) {
                point = pointArray[n2];
                if (point == null) continue;
                processShape.drawSymbol(point.x, point.y, null);
            }
        }
    }
}

