/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.TimeLineState;
import java.io.Serializable;

public class JCDataRange
implements Serializable,
Cloneable {
    protected double min = -1.7976931348623157E308;
    protected double max = Double.MAX_VALUE;
    protected boolean minValueIncluded = true;
    protected boolean maxValueIncluded = true;
    protected Object parent = null;

    public JCDataRange() {
    }

    public JCDataRange(double d2, double d3) {
        this.min = Math.min(d2, d3);
        this.max = Math.max(d2, d3);
    }

    public JCDataRange(double d2, double d3, boolean bl, boolean bl2) {
        this.min = Math.min(d2, d3);
        this.max = Math.max(d2, d3);
        this.minValueIncluded = bl;
        this.maxValueIncluded = bl2;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double d2) {
        TimeLineState timeLineState;
        ChartDataView chartDataView;
        if (d2 > this.max) {
            this.min = this.max;
            this.max = d2;
        } else {
            this.min = d2;
        }
        if (this.parent instanceof TimeLineState && (chartDataView = (timeLineState = (TimeLineState)this.parent).getParent()) != null) {
            chartDataView.setChanged(true, 34);
        }
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double d2) {
        TimeLineState timeLineState;
        ChartDataView chartDataView;
        if (d2 < this.min) {
            this.max = this.min;
            this.min = d2;
        } else {
            this.max = d2;
        }
        if (this.parent instanceof TimeLineState && (chartDataView = (timeLineState = (TimeLineState)this.parent).getParent()) != null) {
            chartDataView.setChanged(true, 34);
        }
    }

    public boolean isMinValueIncluded() {
        return this.minValueIncluded;
    }

    public void setMinValueIncluded(boolean bl) {
        this.minValueIncluded = bl;
    }

    public boolean isMaxValueIncluded() {
        return this.maxValueIncluded;
    }

    public void setMaxValueIncluded(boolean bl) {
        this.maxValueIncluded = bl;
    }

    public boolean isIncluded(double d2) {
        if (d2 > this.max || d2 < this.min) {
            return false;
        }
        boolean bl = true;
        if (d2 == this.max && !this.maxValueIncluded) {
            bl = false;
        }
        if (d2 == this.min && !this.minValueIncluded) {
            bl = false;
        }
        return bl;
    }

    public double getValueInRange() {
        if (this.minValueIncluded) {
            return this.min;
        }
        if (this.maxValueIncluded) {
            return this.max;
        }
        if (this.max == this.min) {
            return Double.NaN;
        }
        return (this.max - this.min) / 2.0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("min= ");
        stringBuffer.append(this.min);
        stringBuffer.append(" max=");
        stringBuffer.append(this.max);
        stringBuffer.append(" minValueIncluded=");
        stringBuffer.append(this.minValueIncluded);
        stringBuffer.append(" maxValueIncluded=");
        stringBuffer.append(this.maxValueIncluded);
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + new Double(this.min).hashCode();
        n2 = 37 * n2 + new Double(this.max).hashCode();
        n2 = 37 * n2 + (this.minValueIncluded ? 1231 : 1237);
        n2 = 37 * n2 + (this.maxValueIncluded ? 11 : 43);
        return n2;
    }

    public boolean equals(Object object) {
        JCDataRange jCDataRange;
        boolean bl = false;
        if (object != null && object.getClass().equals(this.getClass()) && (this == (jCDataRange = (JCDataRange)object) || this.min == jCDataRange.min && this.max == jCDataRange.max && this.minValueIncluded == jCDataRange.minValueIncluded && this.maxValueIncluded == jCDataRange.maxValueIncluded)) {
            bl = true;
        }
        return bl;
    }

    public Object clone() throws CloneNotSupportedException {
        JCDataRange jCDataRange = (JCDataRange)super.clone();
        jCDataRange.min = this.min;
        jCDataRange.max = this.max;
        jCDataRange.minValueIncluded = this.minValueIncluded;
        jCDataRange.maxValueIncluded = this.maxValueIncluded;
        jCDataRange.parent = null;
        return jCDataRange;
    }
}

