/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import java.io.Serializable;

public class JCDataIndex
implements Serializable {
    protected Object obj = null;
    protected ChartDataView dataView = null;
    protected ChartDataViewSeries series = null;
    protected int seriesIndex = -1;
    protected int point = -1;
    protected int distance = Integer.MAX_VALUE;

    public JCDataIndex() {
    }

    public JCDataIndex(int n2, ChartDataViewSeries chartDataViewSeries) {
        this.point = n2;
        this.series = chartDataViewSeries;
        if (chartDataViewSeries != null) {
            ChartDataView chartDataView = chartDataViewSeries.getParent();
            this.seriesIndex = chartDataView != null ? chartDataView.getSeriesIndex(chartDataViewSeries) : -1;
            this.dataView = chartDataView;
        }
    }

    public JCDataIndex(ChartDataView chartDataView, ChartDataViewSeries chartDataViewSeries, int n2, int n3) {
        this.dataView = chartDataView;
        this.point = n3;
        this.series = chartDataViewSeries;
        this.seriesIndex = n2;
    }

    JCDataIndex(int n2, ChartDataViewSeries chartDataViewSeries, int n3) {
        this.point = n2;
        this.series = chartDataViewSeries;
        if (chartDataViewSeries != null) {
            this.dataView = chartDataViewSeries.getParent();
        }
        this.seriesIndex = n3;
    }

    public ChartDataViewSeries getSeries() {
        if (this.series == null && this.dataView != null && this.seriesIndex >= 0) {
            try {
                this.series = this.dataView.getSeries(this.seriesIndex);
            }
            catch (Exception exception) {
                this.series = null;
            }
        }
        return this.series;
    }

    public void setSeries(ChartDataViewSeries chartDataViewSeries) {
        this.series = chartDataViewSeries;
        if (chartDataViewSeries != null) {
            ChartDataView chartDataView = chartDataViewSeries.getParent();
            this.seriesIndex = chartDataView != null ? chartDataView.getSeriesIndex(chartDataViewSeries) : -1;
            this.dataView = chartDataView;
        }
    }

    public ChartDataView getDataView() {
        return this.dataView;
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
        if (this.dataView != null && this.seriesIndex >= 0 && this.seriesIndex < this.dataView.getNumSeries()) {
            this.series = this.dataView.getSeries(this.seriesIndex);
        }
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int n2) {
        this.seriesIndex = n2;
        this.series = this.dataView != null && n2 >= 0 ? this.dataView.getSeries(n2) : null;
    }

    public int getPoint() {
        return this.point;
    }

    public void setPoint(int n2) {
        this.point = n2;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int n2) {
        this.distance = n2;
    }

    public Object getObject() {
        return this.obj;
    }

    public void setObject(Object object) {
        this.obj = object;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof JCDataIndex) {
            JCDataIndex jCDataIndex = (JCDataIndex)object;
            return this.dataView == jCDataIndex.dataView && this.seriesIndex == jCDataIndex.seriesIndex && this.point == jCDataIndex.point;
        }
        return false;
    }

    public boolean equalsDataIndex(Object object) {
        return this.equals(object);
    }

    public int hashCode() {
        int n2 = this.dataView == null ? 29 : this.dataView.hashCode();
        return n2 + 10000 * this.seriesIndex + this.point;
    }

    public String toString() {
        return "JCDataIndex: point " + this.point + " series " + this.seriesIndex + " dataview " + this.dataView;
    }
}

