/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.calendar.ICalendar;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCChartUtil
extends JCNumberUtil {
    static int distanceToFrontRect(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8) {
        int n9;
        int n10 = n4 + n6;
        int n11 = n5 + n7;
        int n12 = 0;
        if (n2 > n10) {
            n12 = n2 - n10;
        } else if (n2 < n4) {
            n12 = n4 - n2;
        }
        int n13 = 0;
        if (n3 < n5) {
            n13 = n5 - n3;
        } else if (n3 > n11) {
            n13 = n3 - n11;
        }
        switch (n8) {
            case 1: {
                n9 = bl ? n13 : n12;
                break;
            }
            case 2: {
                n9 = bl ? n12 : n13;
                break;
            }
            default: {
                n9 = n12 + n13;
            }
        }
        return n9;
    }

    static int distanceTo3dPolygon(int n2, int n3, Point[] pointArray, boolean bl, int n4) {
        int n5;
        if (pointArray == null) {
            return Integer.MAX_VALUE;
        }
        int n6 = pointArray[0].x;
        if (pointArray[1].x < 0) {
            n6 += pointArray[1].x;
        }
        int n7 = pointArray[0].y;
        if (pointArray[1].y > 0) {
            n7 += pointArray[1].y;
        }
        int n8 = Math.abs(pointArray[1].x);
        int n9 = Math.abs(pointArray[1].y);
        int n10 = Math.abs(pointArray[2].x);
        int n11 = Math.abs(pointArray[2].y);
        if (pointArray[2].y == 0) {
            if (pointArray[2].x < 0) {
                n6 += pointArray[2].x;
            }
            n5 = pointArray[1].x > 0 && pointArray[1].y > 0 || pointArray[1].x < 0 && pointArray[1].y < 0 ? JCChartUtil.distanceTo2ndTop(n2, n3, n6, n7, n10, n8, n9, bl, n4) : JCChartUtil.distanceToMainTop(n2, n3, n6, n7, n10, n8, n9, bl, n4);
        } else {
            if (pointArray[2].y > 0) {
                n7 += pointArray[2].y;
            }
            n5 = pointArray[1].x > 0 && pointArray[1].y > 0 || pointArray[1].x < 0 && pointArray[1].y < 0 ? JCChartUtil.distanceTo2ndSide(n2, n3, n6, n7, n11, n8, n9, bl, n4) : JCChartUtil.distanceToMainSide(n2, n3, n6, n7, n11, n8, n9, bl, n4);
        }
        return n5;
    }

    static int distanceToMainSide(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        int n10;
        if (n7 == 0) {
            return JCChartUtil.distanceToFrontRect(n2, n3, n4, n5 - n6 - n8, 0, n6 + n8, bl, n9);
        }
        int n11 = n4 + n7;
        int n12 = n5 - n6 - n8;
        int n13 = n5 - n6;
        int n14 = n5 - n8;
        double d2 = (double)n8 / (double)n7;
        int n15 = 0;
        int n16 = 0;
        if (n3 <= n12) {
            n15 = Math.abs(n2 - n11);
        } else if (n3 >= n5) {
            n15 = Math.abs(n2 - n4);
        } else {
            n15 = n3 < n13 ? (int)Math.max((long)n15, (long)n4 + Math.round((double)(n13 - n3) / d2) - (long)n2) : Math.max(n15, n4 - n2);
            n15 = n3 <= n14 ? Math.max(n15, n2 - n11) : (int)Math.max((long)n15, (long)n2 - ((long)n4 + Math.round((double)(n5 - n3) / d2)));
        }
        if (n4 < n2 && n2 < n11) {
            n16 = (int)Math.max((long)n16, (long)n13 - Math.round((double)(n2 - n4) * d2) - (long)n3);
            n16 = (int)Math.max((long)n16, (long)n3 - ((long)n5 - Math.round((double)(n2 - n4) * d2)));
        } else {
            n16 = Math.max(n16, n12 - n3);
            n16 = Math.max(n16, n3 - n5);
        }
        switch (n9) {
            case 1: {
                n10 = bl ? n16 : n15;
                break;
            }
            case 2: {
                n10 = bl ? n15 : n16;
                break;
            }
            default: {
                n10 = n15 + n16;
            }
        }
        return n10;
    }

    static int distanceTo2ndSide(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        int n10;
        if (n7 == 0) {
            return JCChartUtil.distanceToFrontRect(n2, n3, n4, n5 - n6 - n8, 0, n6 + n8, bl, n9);
        }
        int n11 = n4 + n7;
        int n12 = n5 - n6 - n8;
        int n13 = n5 - n8;
        int n14 = n5 - n6;
        double d2 = (double)n8 / (double)n7;
        int n15 = 0;
        int n16 = 0;
        if (n3 <= n12) {
            n15 = Math.abs(n2 - n4);
        } else if (n3 >= n5) {
            n15 = Math.abs(n2 - n11);
        } else {
            n15 = n3 < n14 ? (int)Math.max((long)n15, (long)(n2 - n11) + Math.round((double)(n14 - n3) / d2)) : Math.max(n15, n2 - n11);
            n15 = n3 <= n13 ? Math.max(n15, n4 - n2) : (int)Math.max((long)n15, (long)(n11 - n2) - Math.round((double)(n5 - n3) / d2));
        }
        if (n4 < n2 && n2 < n11) {
            n16 = (int)Math.max((long)n16, (long)n14 - Math.round((double)(n11 - n2) * d2) - (long)n3);
            n16 = (int)Math.max((long)n16, (long)n3 - ((long)n5 - Math.round((double)(n11 - n2) * d2)));
        } else {
            n16 = Math.max(n16, n12 - n3);
            n16 = Math.max(n16, n3 - n5);
        }
        switch (n9) {
            case 1: {
                n10 = bl ? n16 : n15;
                break;
            }
            case 2: {
                n10 = bl ? n15 : n16;
                break;
            }
            default: {
                n10 = n15 + n16;
            }
        }
        return n10;
    }

    static int distanceToMainTop(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        int n10;
        if (n7 == 0) {
            return JCChartUtil.distanceToFrontRect(n2, n3, n4, n5 - n8, n6, n8, bl, n9);
        }
        int n11 = n4 + n6 + n7;
        int n12 = n5 - n8;
        int n13 = n4 + n7;
        int n14 = n4 + n6;
        double d2 = (double)n8 / (double)n7;
        int n15 = 0;
        int n16 = 0;
        if (n12 < n3 && n3 < n5) {
            n15 = (int)Math.max((long)n15, (long)n4 + Math.round((double)(n5 - n3) / d2) - (long)n2);
            n15 = (int)Math.max((long)n15, (long)n2 - ((long)n14 + Math.round((double)(n5 - n3) / d2)));
        } else {
            n15 = Math.max(n15, n4 - n2);
            n15 = Math.max(n15, n2 - n11);
        }
        if (n2 <= n4) {
            n16 = Math.abs(n3 - n5);
        } else if (n2 >= n11) {
            n16 = Math.abs(n3 - n12);
        } else {
            n16 = n2 < n13 ? (int)Math.max((long)n16, (long)n5 - Math.round((double)(n2 - n4) * d2) - (long)n3) : Math.max(n16, n12 - n3);
            if (n2 <= n14) {
                n16 = Math.max(n16, n3 - n5);
            } else {
                n10 = n3 - (n5 - (int)Math.round((double)(n2 - n14) * d2));
                n16 = Math.max(n16, n10);
            }
        }
        switch (n9) {
            case 1: {
                n10 = bl ? n16 : n15;
                break;
            }
            case 2: {
                n10 = bl ? n15 : n16;
                break;
            }
            default: {
                n10 = n15 + n16;
            }
        }
        return n10;
    }

    static int distanceTo2ndTop(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        int n10;
        if (n7 == 0) {
            return JCChartUtil.distanceToFrontRect(n2, n3, n4, n5 - n8, n6, n8, bl, n9);
        }
        int n11 = n4 + n6 + n7;
        int n12 = n5 - n8;
        int n13 = n4 + n6;
        int n14 = n4 + n7;
        double d2 = (double)n8 / (double)n7;
        int n15 = 0;
        int n16 = 0;
        if (n12 < n3 && n3 < n5) {
            n15 = (int)Math.max((long)n15, (long)n4 + Math.round((double)(n3 - n12) / d2) - (long)n2);
            n15 = (int)Math.max((long)n15, (long)n2 - ((long)n13 + Math.round((double)(n3 - n12) / d2)));
        } else {
            n15 = Math.max(n15, n4 - n2);
            n15 = Math.max(n15, n2 - n11);
        }
        if (n2 <= n4) {
            n16 = Math.abs(n3 - n12);
        } else if (n2 >= n11) {
            n16 = Math.abs(n3 - n5);
        } else {
            n16 = n2 < n14 ? (int)Math.max((long)n16, (long)(n3 - n12) - Math.round((double)(n2 - n4) * d2)) : Math.max(n16, n3 - n5);
            n16 = n2 <= n13 ? Math.max(n16, n12 - n3) : (int)Math.max((long)n16, (long)(n5 - n3) + Math.round((double)(n2 - n11) * d2));
        }
        switch (n9) {
            case 1: {
                n10 = bl ? n16 : n15;
                break;
            }
            case 2: {
                n10 = bl ? n15 : n16;
                break;
            }
            default: {
                n10 = n15 + n16;
            }
        }
        return n10;
    }

    public static Line2D.Double[] getLineSegments(Polygon polygon) {
        int n2 = polygon.npoints - 1;
        Line2D.Double[] doubleArray = new Line2D.Double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            doubleArray[i2] = new Line2D.Double(polygon.xpoints[i2], polygon.ypoints[i2], polygon.xpoints[i2 + 1], polygon.ypoints[i2 + 1]);
        }
        return doubleArray;
    }

    public static double getPolygonDistance(int n2, int n3, Polygon polygon) {
        Line2D.Double[] doubleArray;
        if (polygon.contains(n2, n3)) {
            return 0.0;
        }
        double d2 = Double.MAX_VALUE;
        for (Line2D.Double double_ : doubleArray = JCChartUtil.getLineSegments(polygon)) {
            double d3 = double_.ptSegDist(n2, n3);
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    public static double getShapeDistance(Point2D.Double double_, Shape shape, double d2, boolean bl) {
        if (bl && shape.contains(double_)) {
            return 0.0;
        }
        Point2D.Double double_2 = null;
        Point2D.Double double_3 = null;
        double d3 = Double.MAX_VALUE;
        PathIterator pathIterator = shape.getPathIterator(null, d2);
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    double_2 = double_3 = new Point2D.Double(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    Point2D.Double double_4 = new Point2D.Double(dArray[0], dArray[1]);
                    Line2D.Double double_5 = new Line2D.Double(double_3, double_4);
                    double_3 = double_4;
                    double d4 = double_5.ptSegDist(double_);
                    if (!(d4 < d3)) break;
                    d3 = d4;
                    break;
                }
                case 4: {
                    Line2D.Double double_5 = new Line2D.Double(double_3, double_2);
                    double d4 = double_5.ptSegDist(double_);
                    if (!(d4 < d3)) break;
                    d3 = d4;
                    break;
                }
            }
            pathIterator.next();
        }
        return d3;
    }

    public static double getShapeDistance(Point2D.Double double_, Shape shape, double d2) {
        return JCChartUtil.getShapeDistance(double_, shape, d2, true);
    }

    public static double getDistanceToVector(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        Line2D.Double double_4 = new Line2D.Double(double_, double_2);
        return double_4.ptSegDist(double_3.x, double_3.y);
    }

    public static DoubleCoord calcTik(double d2, int n2) {
        return JCChartUtil.calcTik(d2, n2, 0.0, false);
    }

    public static DoubleCoord calcTik(double d2, int n2, double d3, boolean bl) {
        DoubleCoord doubleCoord;
        char[] cArray = JCChartUtil.internalFormat(d2, n2).toCharArray();
        if (n2 > 0) {
            int n3 = cArray.length - 1;
            switch (cArray[n3]) {
                case '1': 
                case '2': 
                case '3': 
                case '4': {
                    cArray[n3] = 53;
                    break;
                }
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    cArray[n3] = 48;
                    --n3;
                    while (n3 >= 0) {
                        if (cArray[n3] != JCChartUtil.getDecimalPointChar()) {
                            if (cArray[n3] != '9') {
                                int n4 = n3;
                                cArray[n4] = (char)(cArray[n4] + '\u0001');
                                break;
                            }
                            cArray[n3] = 48;
                        }
                        --n3;
                    }
                    if (n3 >= 0) break;
                    char[] cArray2 = cArray;
                    cArray = new char[cArray2.length + 1];
                    for (n3 = cArray.length - 1; n3 > 0; --n3) {
                        cArray[n3] = cArray2[n3 - 1];
                    }
                    cArray[0] = 49;
                }
            }
        }
        double d4 = Double.valueOf(new String(cArray));
        if (bl && d3 > 0.0 && n2 <= 0 && d4 != 0.0) {
            int n5 = (int)JCChartUtil.calcBaseValue(n2);
            int n6 = (int)d3;
            int n7 = (int)d4;
            int n8 = 2 * n7;
            boolean bl2 = n6 % n8 == 0;
            boolean bl3 = false;
            if (!bl2) {
                while (!bl2 && n8 < n6) {
                    bl2 = n6 % (n8 += 2 * n5) == 0;
                    if (!bl2) continue;
                    bl3 = true;
                }
                if (n8 <= n6) {
                    n7 = n8 / 2;
                }
            }
            if (bl3) {
                d4 = n7;
            }
        }
        if (d4 == 0.0) {
            double d5 = JCChartUtil.calcBaseValue(n2);
            doubleCoord = new DoubleCoord(d5 / 2.0, d5);
        } else {
            doubleCoord = new DoubleCoord(d4, 2.0 * d4);
        }
        return doubleCoord;
    }

    private static double calcBaseValue(int n2) {
        double d2 = 1.0;
        if (n2 >= 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                d2 /= 10.0;
            }
        } else {
            n2 = -n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                d2 *= 10.0;
            }
        }
        return d2;
    }

    public static double getRadarAngle(int n2, int n3, int n4, boolean bl) {
        return JCChartUtil.getRadarAngle(n2, n3, (double)n4, bl);
    }

    public static double getRadarAngle(int n2, int n3, double d2, boolean bl) {
        double d3;
        if (n3 <= 0) {
            return 0.0;
        }
        switch (n2) {
            case 1: {
                d3 = 360.0;
                break;
            }
            case 3: {
                d3 = 400.0;
                break;
            }
            default: {
                d3 = Math.PI * 2;
            }
        }
        double d4 = 0.0;
        if (n3 != 0) {
            d4 = d2 * d3 / (double)n3;
        }
        if (bl) {
            d4 *= -1.0;
        }
        return d4;
    }

    protected static double getAngleRatio(int n2, double d2, double d3) {
        double d4;
        double d5 = d3 + d2;
        boolean bl = d5 < 0.0;
        switch (n2) {
            case 1: {
                d4 = 360.0;
                break;
            }
            case 3: {
                d4 = 400.0;
                break;
            }
            default: {
                d4 = Math.PI * 2;
            }
        }
        d5 = JCChartUtil.fmod(Math.abs(d5), d4);
        if (bl && d5 != 0.0) {
            d5 = d4 - d5;
        }
        double d6 = d5 / d4 + 0.005;
        int n3 = (int)(d6 * 100.0);
        d6 = (double)n3 / 100.0;
        d6 = Math.max(0.0, d6);
        d6 = Math.min(1.0, d6);
        return d6;
    }

    public static Class<?> getCalendarClass(boolean bl) {
        Class<?> clazz = null;
        try {
            String string = "com.klg.jclass.util.calendar.";
            clazz = bl ? Class.forName(string + "GregorianCalendarICU") : Class.forName(string + "JCGregorianCalendar");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return clazz;
    }

    public static ICalendar getGregorianCalendar(boolean bl) {
        ICalendar iCalendar = null;
        try {
            Class<?> clazz = JCChartUtil.getCalendarClass(bl);
            if (clazz != null) {
                iCalendar = (ICalendar)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return iCalendar;
    }

    public static ICalendar getGregorianCalendar(boolean bl, Locale locale) {
        ICalendar iCalendar = null;
        Class<?> clazz = JCChartUtil.getCalendarClass(bl);
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{Class.forName("java.util.Locale")};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{locale};
                iCalendar = (ICalendar)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return iCalendar;
    }

    public static ICalendar getGregorianCalendar(boolean bl, TimeZone timeZone, Locale locale) {
        ICalendar iCalendar = JCChartUtil.getGregorianCalendar(bl, locale);
        if (iCalendar != null) {
            iCalendar.setTimeZone(timeZone);
        }
        return iCalendar;
    }

    public static void setToStartOfDay(ICalendar iCalendar) {
        if (iCalendar == null) {
            return;
        }
        int n2 = iCalendar.get(1);
        int n3 = iCalendar.get(2);
        int n4 = iCalendar.get(5);
        iCalendar.clear();
        iCalendar.set(n2, n3, n4);
    }

    public static boolean isStartOfDay(ICalendar iCalendar) {
        if (iCalendar == null) {
            return false;
        }
        int n2 = iCalendar.getMinimum(11);
        int n3 = iCalendar.getMinimum(12);
        int n4 = iCalendar.getMinimum(13);
        return iCalendar.get(11) == n2 && iCalendar.get(12) == n3 && iCalendar.get(13) == n4;
    }

    public static void setToEndOfDay(ICalendar iCalendar) {
        if (iCalendar == null) {
            return;
        }
        int n2 = iCalendar.get(1);
        int n3 = iCalendar.get(2);
        int n4 = iCalendar.get(5);
        iCalendar.clear();
        iCalendar.set(n2, n3, n4, iCalendar.getMaximum(11), iCalendar.getMaximum(12), iCalendar.getMaximum(13));
    }

    public static boolean isEndOfDay(ICalendar iCalendar) {
        if (iCalendar == null) {
            return false;
        }
        int n2 = iCalendar.getMaximum(11);
        int n3 = iCalendar.getMaximum(12);
        int n4 = iCalendar.getMaximum(13) - 4;
        return iCalendar.get(11) == n2 && iCalendar.get(12) == n3 && iCalendar.get(13) >= n4;
    }

    public static void setToStartOfWeek(ICalendar iCalendar) {
        if (iCalendar == null) {
            return;
        }
        JCChartUtil.setToStartOfDay(iCalendar);
        int n2 = iCalendar.getFirstDayOfWeek();
        int n3 = iCalendar.get(7);
        while (n3 != n2) {
            iCalendar.add(5, -1);
            n3 = iCalendar.get(7);
        }
    }

    public static boolean isStartOfWeek(ICalendar iCalendar) {
        if (iCalendar == null) {
            return false;
        }
        int n2 = iCalendar.getFirstDayOfWeek();
        int n3 = iCalendar.get(7);
        return n3 == n2 && JCChartUtil.isStartOfDay(iCalendar);
    }

    public static boolean isStartOfWeekend(ICalendar iCalendar, TimeZone timeZone, Locale locale) {
        if (iCalendar == null) {
            return false;
        }
        Date date = iCalendar.getTime();
        ICalendar iCalendar2 = JCChartUtil.getGregorianCalendar(true, timeZone, locale);
        iCalendar2.setTime(date);
        if (iCalendar2.isWeekend()) {
            iCalendar2.add(5, -1);
            if (iCalendar2.isWeekend()) {
                return false;
            }
        } else {
            return false;
        }
        return JCChartUtil.isStartOfDay(iCalendar);
    }

    public static void setToEndOfWeek(ICalendar iCalendar) {
        if (iCalendar == null) {
            return;
        }
        JCChartUtil.setToEndOfDay(iCalendar);
        int n2 = iCalendar.getFirstDayOfWeek();
        int n3 = (n2 - 1 + 6) % 7 + 1;
        int n4 = iCalendar.get(7);
        while (n4 != n3) {
            iCalendar.add(5, 1);
            n4 = iCalendar.get(7);
        }
    }

    public static boolean isEndOfWeek(ICalendar iCalendar) {
        if (iCalendar == null) {
            return false;
        }
        int n2 = iCalendar.getFirstDayOfWeek();
        int n3 = (n2 - 1 + 6) % 7 + 1;
        int n4 = iCalendar.get(7);
        return n4 == n3 && JCChartUtil.isEndOfDay(iCalendar);
    }

    public static boolean isEndOfWeekend(ICalendar iCalendar, TimeZone timeZone, Locale locale) {
        if (iCalendar == null) {
            return false;
        }
        Date date = iCalendar.getTime();
        ICalendar iCalendar2 = JCChartUtil.getGregorianCalendar(true, timeZone, locale);
        iCalendar2.setTime(date);
        if (iCalendar2.isWeekend()) {
            iCalendar2.add(5, 1);
            if (iCalendar2.isWeekend()) {
                return false;
            }
        } else {
            return false;
        }
        return JCChartUtil.isEndOfDay(iCalendar);
    }

    public static void setToGivenDayOfWeek(ICalendar iCalendar, int n2) {
        block7: {
            int n3;
            int n4;
            block6: {
                if (iCalendar == null) {
                    return;
                }
                if (n2 < iCalendar.getMinimum(7) || n2 > iCalendar.getMaximum(7)) {
                    return;
                }
                n4 = iCalendar.getFirstDayOfWeek();
                n3 = iCalendar.get(7);
                if (n3 < n4) {
                    n3 += 7;
                }
                if (n2 < n4) {
                    n2 += 7;
                }
                if (n3 >= n2) break block6;
                while (n3 != n2) {
                    iCalendar.add(5, 1);
                    n3 = iCalendar.get(7);
                    if (n3 >= n4) continue;
                    n3 += 7;
                }
                break block7;
            }
            if (n3 <= n2) break block7;
            while (n3 != n2) {
                iCalendar.add(5, -1);
                n3 = iCalendar.get(7);
                if (n3 >= n4) continue;
                n3 += 7;
            }
        }
    }
}

