/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartLabelLine;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.TrackChange;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.label.JCLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCChartLabel
extends TrackChange
implements Serializable {
    public static final int NORTHEAST = 1;
    public static final int NORTH = 2;
    public static final int NORTHWEST = 3;
    public static final int EAST = 4;
    public static final int WEST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTH = 7;
    public static final int SOUTHWEST = 8;
    public static final int CENTER = 9;
    public static final int AUTO = 10;
    public static final int ATTACH_NONE = 0;
    public static final int ATTACH_COORD = 1;
    public static final int ATTACH_DATACOORD = 2;
    public static final int ATTACH_DATAINDEX = 3;
    public static final int DATAINDEX_MODE_DEFAULT = 0;
    public static final int DATAINDEX_MODE_MINOR = 1;
    public static final int DATAINDEX_MODE_CENTER = 2;
    public static final int DATAINDEX_MODE_MAJOR = 3;
    public static final int CONNECTED_ATTACH_MODE_MINIMUM = 1;
    public static final int CONNECTED_ATTACH_MODE_CENTER = 2;
    public static final int CONNECTED_ATTACH_MODE_MAXIMUM = 3;
    public static final int NOWHERE = -9999;
    protected int anchor = 9;
    protected int attachMethod = 1;
    protected int attachX = 0;
    protected int attachY = 0;
    protected double dataAttachX = 0.0;
    protected double dataAttachY = 0.0;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected int dataIndexMode = 0;
    protected JCDataIndex attachDataIndex = null;
    protected ChartDataView dataView = null;
    protected boolean dwellLabel = false;
    protected int dwellDelay = 0;
    protected boolean connected = false;
    protected boolean saveLabel = true;
    protected int connectedAttachMode = 2;
    protected ImageMapInfo imageMapInfo = null;
    protected JComponent component = this.createDefaultComponent("");
    protected JCChartLabelLine line = null;
    protected JCLineStyle connectedLineStyle = null;
    protected JCLineStyle defaultConnectedLineStyle = null;
    protected String text = null;
    protected String defaultText = null;
    protected JCChartLabelManager parent = null;
    private Point attachBeforeAnchor = null;
    protected Point attachPoint = null;
    protected boolean dataCoordIsDefault = true;

    public JCChartLabel(String string) {
        this.setText(string);
        this.component.setVisible(true);
        this.defaultConnectedLineStyle = new JCLineStyle(1, this.component.getForeground(), 1);
    }

    public JCChartLabel() {
        this(null);
    }

    protected JLabel createDefaultComponent(String string) {
        return string == null ? new JCLabel() : new JCLabel(string);
    }

    public void setComponent(JComponent jComponent) {
        if (this.component == jComponent) {
            return;
        }
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && !this.dwellLabel && this.component != null) {
            if (this.isConnected() && this.line != null) {
                jCChart.remove(this.line);
            }
            jCChart.remove(this.component);
        }
        this.component = jComponent;
        if (jCChart != null && !this.dwellLabel && this.component != null) {
            if (this.isConnected() && this.line != null) {
                jCChart.add((Component)this.line, 0);
            }
            jCChart.add((Component)this.component, 0);
        }
        if (!(this.component instanceof JLabel)) {
            this.text = "";
        } else {
            this.text = ((JLabel)this.component).getText();
            this.defaultText = null;
        }
        this.setChanged(true, 2);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setText(String string) {
        this.text = string;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        if (this.component == null) {
            this.component = this.createDefaultComponent(string2);
        } else if (this.component instanceof JLabel) {
            ((JLabel)this.component).setText(string2);
        }
        this.defaultText = null;
        this.setChanged(true, 2);
    }

    public String getSetText() {
        return this.text;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public JCChart getParentChart() {
        JCChartLabelManager jCChartLabelManager = this.getParentManager();
        if (jCChartLabelManager != null) {
            return jCChartLabelManager.getParentChart();
        }
        return null;
    }

    public JCChartLabelManager getParentManager() {
        return this.parent;
    }

    public void setParentManager(JCChartLabelManager jCChartLabelManager) {
        this.parent = jCChartLabelManager;
    }

    public void recalc() {
        ChartDataViewSeries chartDataViewSeries;
        int n2;
        if (this.component == null) {
            return;
        }
        if (this.text == null) {
            this.getDefaultLabel();
        }
        this.setChanged(true, 2, false);
        Dimension dimension = this.component.getPreferredSize();
        this.component.setSize(dimension.width, dimension.height);
        this.component.validate();
        ChartDataView chartDataView = this.getEffectiveDataView();
        if (chartDataView == null) {
            return;
        }
        Point point = null;
        int n3 = chartDataView.getChartType();
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = n3 == 3 || n3 == 4;
        boolean bl2 = n3 == 2;
        boolean bl3 = n3 == 11;
        boolean bl4 = n3 == 12 || n3 == 10;
        boolean bl5 = n3 == 13;
        boolean bl6 = !bl3;
        boolean bl7 = false;
        JCAxis jCAxis = chartDataView.getXAxis();
        JCAxis jCAxis2 = chartDataView.getYAxis();
        switch (this.attachMethod) {
            case 1: {
                point = new Point(this.attachX, this.attachY);
                break;
            }
            case 2: {
                if (bl3) break;
                point = chartDataView.dataCoordToCoord(this.dataAttachX, this.dataAttachY);
                d2 = this.dataAttachX;
                d3 = this.dataAttachY;
                break;
            }
            case 3: {
                if (this.attachDataIndex == null) break;
                point = this.calcDataIndexAttachPosition(chartDataView, this.attachDataIndex);
                n2 = this.attachDataIndex.getSeriesIndex();
                if (!bl5 && n2 != -10) {
                    chartDataViewSeries = this.attachDataIndex.getSeries();
                    if (chartDataViewSeries == null) break;
                    bl7 = !chartDataViewSeries.isVisible();
                    d2 = chartDataViewSeries.getX(this.attachDataIndex.point);
                    d3 = chartDataViewSeries.getCalculatedY(this.attachDataIndex.point);
                    break;
                }
                bl6 = false;
                break;
            }
            default: {
                return;
            }
        }
        switch (this.attachMethod) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (!bl6 || point == null) break;
                if (bl4 && this.attachMethod == 3) {
                    JCDataCoord jCDataCoord = chartDataView.map(point.x, point.y);
                    d2 = jCDataCoord.getX();
                    d3 = jCDataCoord.getY();
                    chartDataViewSeries = this.attachDataIndex.getSeries();
                    double d4 = chartDataViewSeries.getY(this.attachDataIndex.getPoint());
                    if (d4 >= jCAxis2.getMin() && d4 <= jCAxis2.getMax()) {
                        if (d3 < jCAxis2.getMin()) {
                            d3 = jCAxis2.getMin();
                            if (jCAxis2.i_vertical) {
                                point.y = jCAxis2.toPixel(jCAxis2.getMin()) + jCAxis2.getChartArea().getY();
                            } else {
                                point.x = jCAxis2.toPixel(jCAxis2.getMin()) + jCAxis2.getChartArea().getX();
                            }
                        } else if (d3 > jCAxis2.getMax()) {
                            d3 = jCAxis2.getMax();
                            if (jCAxis2.i_vertical) {
                                point.y = jCAxis2.toPixel(jCAxis2.getMax()) + jCAxis2.getChartArea().getY();
                            } else {
                                point.x = jCAxis2.toPixel(jCAxis2.getMax()) + jCAxis2.getChartArea().getX();
                            }
                        }
                    }
                }
                if (bl2) {
                    if (!(d3 > jCAxis2.getMax())) break;
                    point = null;
                    break;
                }
                if (bl) {
                    if (!(d3 < jCAxis2.getMin()) && !(d3 > jCAxis2.getMax())) break;
                    point = null;
                    break;
                }
                if (!(d2 < jCAxis.getMin() || d2 > jCAxis.getMax() || d3 < jCAxis2.getMin()) && !(d3 > jCAxis2.getMax())) break;
                point = null;
            }
        }
        if (point == null || bl7) {
            this.attachBeforeAnchor = null;
            point = new Point(-9999, -9999);
        } else {
            n2 = this.component.getWidth() / 2;
            int n4 = this.component.getHeight() / 2;
            this.attachBeforeAnchor = new Point(point.x, point.y);
            point.x -= n2;
            point.y -= n4;
            switch (this.anchor) {
                case 1: 
                case 4: 
                case 6: {
                    point.x += n2;
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    point.x -= n2;
                }
            }
            switch (this.anchor) {
                case 1: 
                case 2: 
                case 3: {
                    point.y -= n4;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    point.y += n4;
                }
            }
            point.x += this.offsetX;
            point.y += this.offsetY;
            this.setChanged(false, 0);
        }
        this.component.setLocation(point.x, point.y);
        this.attachPoint = new Point(point.x, point.y);
        if (this.line != null && this.isConnected() && !this.dwellLabel) {
            this.calcLineBounds(this.line);
        }
    }

    protected Point getAttachPoint() {
        return this.attachPoint;
    }

    public void drawConnector(Graphics graphics) {
        if (this.component == null || graphics == null) {
            return;
        }
        Point point = new Point(0, 0);
        if (this.calcConnectingLine(point)) {
            graphics.drawLine(this.attachBeforeAnchor.x, this.attachBeforeAnchor.y, point.x, point.y);
        }
    }

    protected void calcLineBounds(JCChartLabelLine jCChartLabelLine) {
        if (jCChartLabelLine == null) {
            return;
        }
        if (this.component == null || this.line == null) {
            jCChartLabelLine.setBounds(new Rectangle(0, 0, 0, 0));
            return;
        }
        Point point = new Point(0, 0);
        if (this.calcConnectingLine(point)) {
            int n2;
            JCLineStyle jCLineStyle;
            Rectangle rectangle = new Rectangle();
            rectangle.x = Math.min(this.attachBeforeAnchor.x, point.x);
            rectangle.y = Math.min(this.attachBeforeAnchor.y, point.y);
            rectangle.width = Math.abs(this.attachBeforeAnchor.x - point.x) + 1;
            rectangle.height = Math.abs(this.attachBeforeAnchor.y - point.y) + 1;
            if (this.line != null && (jCLineStyle = this.line.getLineStyle()) != null && (n2 = jCLineStyle.getWidth()) > 1) {
                rectangle.x -= n2 / 2;
                rectangle.width += n2;
                rectangle.y -= n2 / 2;
                rectangle.height += n2;
            }
            jCChartLabelLine.setBounds(rectangle);
            jCChartLabelLine.setStartPoint(new Point(this.attachBeforeAnchor.x - rectangle.x, this.attachBeforeAnchor.y - rectangle.y));
            jCChartLabelLine.setEndPoint(new Point(point.x - rectangle.x, point.y - rectangle.y));
            return;
        }
        jCChartLabelLine.setBounds(new Rectangle(0, 0, 0, 0));
    }

    protected boolean calcConnectingLine(Point point) {
        if (this.attachBeforeAnchor != null) {
            Point point2;
            ChartDataView chartDataView = this.getEffectiveDataView();
            if (chartDataView != null && (this.attachMethod == 2 || this.attachMethod == 3)) {
                JCChart jCChart = this.getParentChart();
                if (jCChart == null) {
                    jCChart = chartDataView.getParent();
                }
                if (jCChart == null) {
                    return false;
                }
                JCChartArea jCChartArea = jCChart.getChartArea();
                point2 = jCChartArea.getLocation();
                Rectangle rectangle = jCChartArea.getPlotRect();
                Insets insets = jCChartArea.getInsets();
                if (this.attachBeforeAnchor.x < rectangle.x + point2.x || this.attachBeforeAnchor.x > rectangle.x + point2.x + rectangle.width + insets.left + insets.right || this.attachBeforeAnchor.y < rectangle.y + point2.y || this.attachBeforeAnchor.y > rectangle.y + point2.y + rectangle.height + insets.top + insets.bottom) {
                    return false;
                }
            }
            if (this.connected && this.attachPoint != null) {
                int n2 = this.component.getWidth();
                int n3 = this.component.getHeight();
                point2 = null;
                int n4 = this.attachPoint.x;
                int n5 = this.attachPoint.y;
                if (this.attachPoint.y + n3 < this.attachBeforeAnchor.y) {
                    if (this.connectedAttachMode == 2) {
                        n4 += n2 / 2;
                    } else if (this.connectedAttachMode == 3) {
                        n4 += n2;
                    }
                    point2 = new Point(n4, n5 + n3);
                } else if (this.attachPoint.y > this.attachBeforeAnchor.y) {
                    if (this.connectedAttachMode == 2) {
                        n4 += n2 / 2;
                    } else if (this.connectedAttachMode == 3) {
                        n4 += n2;
                    }
                    point2 = new Point(n4, n5);
                } else if (this.attachPoint.x > this.attachBeforeAnchor.x) {
                    if (this.connectedAttachMode == 2) {
                        n5 += n3 / 2;
                    } else if (this.connectedAttachMode == 1) {
                        n5 += n3;
                    }
                    point2 = new Point(n4, n5);
                } else if (this.attachPoint.x + n2 < this.attachBeforeAnchor.x) {
                    if (this.connectedAttachMode == 2) {
                        n5 += n3 / 2;
                    } else if (this.connectedAttachMode == 1) {
                        n5 += n3;
                    }
                    point2 = new Point(n4 + n2, n5);
                }
                if (point2 != null && point != null) {
                    point.x = point2.x;
                    point.y = point2.y;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void setAnchor(int n2) {
        if (n2 == this.anchor) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.anchor = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Anchor value in JCChartLabel.  Should be one of NORTH, SOUTH, EAST, WEST, NORTHEAST, SOUTHEAST, NORTHWEST, SOUTHWEST, CENTER or AUTO.");
            }
        }
        this.setChanged(true, 2);
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAttachMethod(int n2) {
        if (n2 == this.attachMethod) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.attachMethod = n2;
                this.setChanged(true, 2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AttachMethod in JCChartLabel. Should be one of ATTACH_NONE, ATTACH_COORD, ATTACH_DATACOORD, ATTACH_DATAINDEX.");
            }
        }
    }

    public int getAttachMethod() {
        return this.attachMethod;
    }

    public void setCoord(Point point) {
        if (point == null) {
            return;
        }
        this.attachX = point.x;
        this.attachY = point.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public Point getCoord() {
        return new Point(this.attachX, this.attachY);
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
        this.setChanged(true, 2);
    }

    public ChartDataView getDataView() {
        ChartDataView chartDataView = this.dataView;
        if (chartDataView == null) {
            chartDataView = this.getEffectiveDataView();
        }
        return chartDataView;
    }

    public ChartDataView getSetDataView() {
        return this.dataView;
    }

    public ChartDataView getEffectiveDataView() {
        ChartDataView chartDataView = null;
        if (this.attachMethod == 3 && this.attachDataIndex != null && this.attachDataIndex.getDataView() != null) {
            chartDataView = this.attachDataIndex.getDataView();
        }
        if (chartDataView == null) {
            chartDataView = this.getSetDataView();
        }
        if (chartDataView == null && this.getParentChart() != null) {
            chartDataView = this.getParentChart().getDataView(0);
        }
        return chartDataView;
    }

    public void setDataCoord(JCDataCoord jCDataCoord) {
        if (jCDataCoord == null) {
            return;
        }
        this.dataAttachX = jCDataCoord.x;
        this.dataAttachY = jCDataCoord.y;
        this.dataCoordIsDefault = false;
        this.setChanged(true, 2);
        this.recalc();
    }

    public JCDataCoord getDataCoord() {
        return new JCDataCoord(this.dataAttachX, this.dataAttachY);
    }

    public void setDataIndex(JCDataIndex jCDataIndex) {
        this.attachDataIndex = jCDataIndex;
        this.setChanged(true, 2);
        this.recalc();
    }

    public JCDataIndex getDataIndex() {
        return this.attachDataIndex;
    }

    public void setOffset(Point point) {
        if (point == null) {
            return;
        }
        this.offsetX = point.x;
        this.offsetY = point.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public Point getOffset() {
        return new Point(this.offsetX, this.offsetY);
    }

    public int getDataIndexMode() {
        return this.dataIndexMode;
    }

    public void setDataIndexMode(int n2) {
        if (n2 == this.dataIndexMode) {
            return;
        }
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Invalid dataIndexMode in JCChartLabel. Should be one of DATAINDEX_MODE_DEFAULT, DATAINDEX_MODE_MINOR, DATAINDEX_MODE_CENTER, orDATAINDEX_MODE_MAJOR.");
        }
        this.dataIndexMode = n2;
        this.setChanged(true, 2);
        this.recalc();
    }

    protected Point calcDataIndexAttachPosition(ChartDataView chartDataView, JCDataIndex jCDataIndex) {
        if (this.dataIndexMode == 0) {
            return chartDataView.dataIndexToCoord(this.attachDataIndex);
        }
        JCChart jCChart = this.getParentChart();
        if (jCChart == null) {
            jCChart = chartDataView.getParent();
        }
        if (jCChart == null) {
            return null;
        }
        JCChartArea jCChartArea = jCChart.getChartArea();
        ChartDraw chartDraw = jCChartArea.getDrawable(chartDataView);
        Point point = null;
        if (chartDraw != null) {
            point = chartDraw.calcDataIndexPosition(this, jCDataIndex, this.dataIndexMode);
            if (point == null) {
                return chartDataView.dataIndexToCoord(this.attachDataIndex);
            }
            Point point2 = jCChartArea.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            Rectangle rectangle = jCChartArea.getDrawingArea();
            point.x += rectangle.x;
            point.y += rectangle.y;
        }
        return point;
    }

    public void setConnected(boolean bl) {
        if (bl == this.connected) {
            return;
        }
        this.connected = bl;
        if (this.connected) {
            this.addConnectedLine();
        } else {
            this.removeConnectedLine();
        }
        this.setChanged(true, 2);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnectedLineStyle(JCLineStyle jCLineStyle) {
        this.connectedLineStyle = jCLineStyle;
        if (this.line != null) {
            this.line.setLineStyle(jCLineStyle == null ? this.defaultConnectedLineStyle : jCLineStyle);
        }
        this.setChanged(true, 2);
        this.recalc();
    }

    public JCLineStyle getConnectedLineStyle() {
        return this.connectedLineStyle == null ? this.defaultConnectedLineStyle : this.connectedLineStyle;
    }

    public void setConnectedAttachMode(int n2) {
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException("Invalid connectedAttachMode in JCChartLabel. Should be one of CONNECTED_ATTACH_MODE_MINIMUM, CONNECTED_ATTACH_MODE_CENTER,  orCONNECTED_ATTACH_MODE_MAXIMUM.");
        }
        this.connectedAttachMode = n2;
        this.setChanged(true, 2);
        this.recalc();
    }

    public int getConnectedAttachMode() {
        return this.connectedAttachMode;
    }

    public boolean isSaveLabel() {
        return this.saveLabel;
    }

    public void setSaveLabel(boolean bl) {
        this.saveLabel = bl;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }

    public void setDwellLabel(boolean bl) {
        if (bl == this.dwellLabel) {
            return;
        }
        this.dwellLabel = bl;
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            if (bl) {
                if (this.component != null) {
                    jCChart.remove(this.component);
                }
                if (this.isConnected() && this.line != null) {
                    jCChart.remove(this.line);
                }
                this.getParentManager().addToDwellLabels(this);
            } else {
                jCChart.getChartLabelManager().removeFromDwellLabels(this);
                if (this.component != null) {
                    if (this.isConnected() && this.line != null) {
                        jCChart.add((Component)this.line, 0);
                    }
                    jCChart.add((Component)this.component, 0);
                }
            }
        }
        this.setChanged(true, 2);
    }

    public boolean isDwellLabel() {
        return this.dwellLabel;
    }

    public boolean shouldPopupHere(JCDataIndex jCDataIndex) {
        if (this.attachMethod != 3) {
            return false;
        }
        return jCDataIndex != null && jCDataIndex.equalsDataIndex(this.attachDataIndex) && this.component != null && this.component.isVisible();
    }

    protected void addConnectedLine() {
        this.line = new JCChartLabelLine(this);
        this.line.setLineStyle(this.getConnectedLineStyle());
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && this.component != null && !this.dwellLabel) {
            Component[] componentArray = jCChart.getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (componentArray[i2] != this.component) continue;
                jCChart.add((Component)this.line, i2 + 1);
                break;
            }
        }
    }

    protected void removeConnectedLine() {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && this.line != null && !this.dwellLabel) {
            jCChart.remove(this.line);
        }
        this.line = null;
    }

    public void setChanged(boolean bl, int n2) {
        if (bl != this.getChanged() || !this.getChanged(n2)) {
            super.setChanged(bl, n2);
        }
        if (bl && this.parent != null && this.parent.getParentChart() != null) {
            this.parent.updateParent(n2);
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        super.setChanged(bl, n2, bl2);
    }

    protected void getDefaultLabel() {
        Serializable serializable;
        if (!(this.component instanceof JLabel)) {
            return;
        }
        String string = "";
        if (this.attachMethod == 3 && this.attachDataIndex != null) {
            JCChartLabelManager jCChartLabelManager;
            serializable = this.getEffectiveDataView();
            int n2 = this.attachDataIndex.getSeriesIndex();
            int n3 = this.attachDataIndex.getPoint();
            if (serializable != null && (n2 >= 0 || n2 == -10) && n3 >= 0 && (jCChartLabelManager = this.getParentManager()) != null) {
                string = jCChartLabelManager.createAutoLabelText((ChartDataView)serializable, n2, n3);
            }
        } else if (this.attachMethod == 2) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(" (");
            ((StringBuffer)serializable).append(this.dataAttachX);
            ((StringBuffer)serializable).append(",");
            ((StringBuffer)serializable).append(this.dataAttachY);
            ((StringBuffer)serializable).append(") ");
            string = ((StringBuffer)serializable).toString();
        } else if (this.attachMethod == 1) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append(" (");
            ((StringBuffer)serializable).append(this.attachX);
            ((StringBuffer)serializable).append(",");
            ((StringBuffer)serializable).append(this.attachY);
            ((StringBuffer)serializable).append(") ");
            string = ((StringBuffer)serializable).toString();
        }
        serializable = (JLabel)this.component;
        ((JLabel)serializable).setText(string);
        this.defaultText = string;
    }
}

