/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.chart.data.JCDefaultDataInterpreter;
import com.klg.jclass.chart.data.JCInputStreamDataSource;
import com.klg.jclass.chart.data.JCReaderDataSource;
import com.klg.jclass.chart.data.JCXMLDataInterpreter;
import com.klg.jclass.chart.property.PropertyLoadFactory;
import com.klg.jclass.chart.property.PropertySaveFactory;
import com.klg.jclass.chart.property.xml.JCXMLFileAccessor;
import com.klg.jclass.chart.property.xml.JCXMLStringAccessor;
import com.klg.jclass.util.io.JCIOException;
import com.klg.jclass.util.io.JCParseException;
import com.klg.jclass.util.io.LoadProperties;
import com.klg.jclass.util.io.OutputDataProperties;
import com.klg.jclass.util.property.JCFileAccessor;
import com.klg.jclass.util.property.JCFilePersistor;
import com.klg.jclass.util.property.JCStringAccessor;
import com.klg.jclass.util.property.JCStringPersistor;
import com.klg.jclass.util.property.PropertyLoadModel;
import com.klg.jclass.util.property.PropertySaveModel;
import com.klg.jclass.util.property.html.JCHTMLFileAccessor;
import com.klg.jclass.util.property.html.JCHTMLFilePersistor;
import com.klg.jclass.util.property.html.JCHTMLStringAccessor;
import com.klg.jclass.util.property.html.JCHTMLStringPersistor;
import com.klg.jclass.util.property.xml.JCXMLFilePersistor;
import com.klg.jclass.util.property.xml.JCXMLStringPersistor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.List;

public class JCChartFactory {
    public static final int HTML = 0;
    public static final int XML = 1;
    public static final int NO_DATA = 0;
    public static final int EMBED_DATA = 1;
    public static final int DATA_FILE_TEXT = 2;
    public static final int DATA_FILE_XML = 3;

    public static void updateChartWithData(JCChart jCChart, int n2, Object object, LoadProperties loadProperties) throws IOException {
        JCChartFactory.updateChartWithData(jCChart, n2, object, 0, loadProperties);
    }

    public static void updateChartWithData(JCChart jCChart, int n2, Object object, String string, LoadProperties loadProperties) throws IOException {
        if (jCChart == null) {
            return;
        }
        List<ChartDataView> list = jCChart.getDataView();
        if (list == null) {
            return;
        }
        int n3 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string2;
            ChartDataView chartDataView = list.get(i2);
            if (chartDataView == null || (string2 = chartDataView.getName()) == null || !string2.equals(string)) continue;
            n3 = i2;
            break;
        }
        if (n3 >= 0) {
            JCChartFactory.updateChartWithData(jCChart, n2, object, n3, loadProperties);
        }
    }

    public static void updateChartWithData(JCChart jCChart, int n2, Object object, int n3, LoadProperties loadProperties) throws IOException {
        Object object2;
        if (jCChart == null || object == null) {
            return;
        }
        if (n2 != 2 && n2 != 3) {
            return;
        }
        List<ChartDataView> list = jCChart.getDataView();
        if (list == null || n3 < 0) {
            return;
        }
        if (loadProperties == null) {
            loadProperties = new LoadProperties();
        }
        if (n3 >= list.size()) {
            object2 = new ChartDataView();
            jCChart.setDataView(n3, (ChartDataView)object2);
        }
        object2 = null;
        boolean bl = false;
        Reader reader = null;
        if (object instanceof String) {
            object2 = new FileInputStream((String)object);
            bl = true;
        } else if (object instanceof InputStream) {
            object2 = (InputStream)object;
        } else if (object instanceof Reader) {
            reader = (Reader)object;
        }
        if (object2 == null && reader == null) {
            return;
        }
        JCDataInterpreter jCDataInterpreter = null;
        switch (n2) {
            case 2: {
                jCDataInterpreter = new JCDefaultDataInterpreter();
                break;
            }
            case 3: {
                jCDataInterpreter = new JCXMLDataInterpreter(loadProperties);
            }
        }
        JCInputStreamDataSource jCInputStreamDataSource = object2 != null ? new JCInputStreamDataSource((InputStream)object2, jCDataInterpreter) : new JCReaderDataSource(reader, jCDataInterpreter);
        jCChart.getDataView(n3).setDataSource(jCInputStreamDataSource);
        if (bl) {
            ((InputStream)object2).close();
        }
    }

    public static void updateChart(JCChart jCChart, String string, int n2, Object object, LoadProperties loadProperties) throws IOException {
        JCFileAccessor jCFileAccessor;
        if (jCChart == null) {
            return;
        }
        jCChart.setName(string);
        if (!(object instanceof String || object instanceof URL || object instanceof InputStream || object instanceof Reader)) {
            throw new IllegalArgumentException("Bad input source.  Must be one of String, URL, InputStream, or Reader ");
        }
        if (loadProperties == null) {
            loadProperties = new LoadProperties();
        }
        switch (n2) {
            case 0: {
                jCFileAccessor = new JCHTMLFileAccessor(jCChart, loadProperties);
                break;
            }
            case 1: {
                jCFileAccessor = new JCXMLFileAccessor(jCChart, loadProperties);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart input type");
            }
        }
        jCFileAccessor.getProperties(object);
        PropertyLoadModel propertyLoadModel = PropertyLoadFactory.makeLoader(jCChart, jCFileAccessor);
        if (propertyLoadModel != null) {
            propertyLoadModel.loadProperties(jCFileAccessor, null);
        }
    }

    public static JCChart makeChartFromStream(InputStream inputStream, LoadProperties loadProperties, String string, int n2) throws IOException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromStream(jCChart, inputStream, loadProperties, string, n2);
        return jCChart;
    }

    public static JCChart makeChartFromStream(InputStream inputStream, String string, int n2) throws IOException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromStream(jCChart, inputStream, null, string, n2);
        return jCChart;
    }

    public static void updateChartFromStream(JCChart jCChart, InputStream inputStream, LoadProperties loadProperties, String string, int n2) throws IOException {
        JCChartFactory.updateChart(jCChart, string, n2, inputStream, loadProperties);
    }

    public static void updateChartFromStream(JCChart jCChart, InputStream inputStream, String string, int n2) throws IOException {
        JCChartFactory.updateChart(jCChart, string, n2, inputStream, null);
    }

    public static JCChart makeChartFromReader(Reader reader, LoadProperties loadProperties, String string, int n2) throws IOException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromReader(jCChart, reader, loadProperties, string, n2);
        return jCChart;
    }

    public static JCChart makeChartFromReader(Reader reader, String string, int n2) throws IOException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromReader(jCChart, reader, null, string, n2);
        return jCChart;
    }

    public static void updateChartFromReader(JCChart jCChart, Reader reader, LoadProperties loadProperties, String string, int n2) throws IOException {
        JCChartFactory.updateChart(jCChart, string, n2, reader, loadProperties);
    }

    public static void updateChartFromReader(JCChart jCChart, Reader reader, String string, int n2) throws IOException {
        JCChartFactory.updateChart(jCChart, string, n2, reader, null);
    }

    public static JCChart makeChartFromFile(String string, LoadProperties loadProperties, String string2, int n2) throws IOException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromFile(jCChart, string, loadProperties, string2, n2);
        return jCChart;
    }

    public static JCChart makeChartFromFile(String string, String string2, int n2) throws IOException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromFile(jCChart, string, null, string2, n2);
        return jCChart;
    }

    public static void updateChartFromFile(JCChart jCChart, String string, LoadProperties loadProperties, String string2, int n2) throws IOException {
        JCChartFactory.updateChart(jCChart, string2, n2, string, loadProperties);
    }

    public static void updateChartFromFile(JCChart jCChart, String string, String string2, int n2) throws IOException {
        JCChartFactory.updateChart(jCChart, string2, n2, string, null);
    }

    public static JCChart makeChartFromFile(String string, String string2) {
        JCChart jCChart = null;
        try {
            jCChart = JCChartFactory.makeChartFromFile(string, string2, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jCChart;
    }

    public static JCChart makeChartFromString(String string, LoadProperties loadProperties, String string2, int n2) throws JCIOException, JCParseException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromString(jCChart, string, loadProperties, string2, n2);
        return jCChart;
    }

    public static JCChart makeChartFromString(String string, String string2, int n2) throws JCIOException, JCParseException {
        JCChart jCChart = new JCChart();
        JCChartFactory.updateChartFromString(jCChart, string, null, string2, n2);
        return jCChart;
    }

    public static void updateChartFromString(JCChart jCChart, String string, LoadProperties loadProperties, String string2, int n2) throws JCIOException, JCParseException {
        JCStringAccessor jCStringAccessor;
        if (jCChart == null) {
            return;
        }
        jCChart.setName(string2);
        if (loadProperties == null) {
            loadProperties = new LoadProperties();
        }
        switch (n2) {
            case 0: {
                jCStringAccessor = new JCHTMLStringAccessor(jCChart, loadProperties);
                break;
            }
            case 1: {
                jCStringAccessor = new JCXMLStringAccessor(jCChart, loadProperties);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart file type");
            }
        }
        try {
            jCStringAccessor.getProperties(string);
        }
        catch (JCIOException jCIOException) {
            throw jCIOException;
        }
        catch (JCParseException jCParseException) {
            throw jCParseException;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PropertyLoadModel propertyLoadModel = PropertyLoadFactory.makeLoader(jCChart, jCStringAccessor);
        if (propertyLoadModel != null) {
            propertyLoadModel.loadProperties(jCStringAccessor, null);
        }
    }

    public static void updateChartFromString(JCChart jCChart, String string, String string2, int n2) throws JCIOException, JCParseException {
        JCChartFactory.updateChartFromString(jCChart, string, null, string2, n2);
    }

    public static JCChart makeChartFromString(String string, String string2) {
        JCChart jCChart = null;
        try {
            jCChart = JCChartFactory.makeChartFromString(string, string2, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jCChart;
    }

    public static void setOutputDataPropertiesOnChart(JCChart jCChart, int n2, String string) {
        if (jCChart == null) {
            return;
        }
        List<ChartDataView> list = jCChart.getDataView();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ChartDataView chartDataView = list.get(i2);
                if (chartDataView == null) continue;
                OutputDataProperties outputDataProperties = chartDataView.getOutputDataProperties();
                if (outputDataProperties == null) {
                    outputDataProperties = new OutputDataProperties();
                }
                String string2 = i2 > 0 ? "" + i2 : "";
                String string3 = n2 == 2 ? ".dat" : ".xml";
                String string4 = string;
                if (string4 != null) {
                    if (n2 == 2 && string4.endsWith(".txt")) {
                        string3 = ".txt";
                    }
                    if (string4.endsWith(string3)) {
                        if (i2 > 0) {
                            int n3 = string4.length() - string3.length();
                            String string5 = string4.substring(0, n3);
                            string4 = string5 + string2 + string3;
                        }
                    } else {
                        string4 = string4 + string2 + string3;
                    }
                } else {
                    string4 = "jcchartdata" + string2 + string3;
                }
                outputDataProperties.setOutputFileName(string4);
                outputDataProperties.setPropertyName(string);
                outputDataProperties.setSaveType(n2);
                chartDataView.setOutputDataProperties(outputDataProperties);
            }
        }
    }

    public static void saveChartToFile(JCChart jCChart, String string, int n2, int n3, String string2) throws IOException {
        JCChartFactory.setOutputDataPropertiesOnChart(jCChart, n3, string2);
        JCChartFactory.saveChart(jCChart, string, n2, true);
    }

    public static void saveChartToFile(JCChart jCChart, String string, int n2) throws IOException {
        JCChartFactory.saveChart(jCChart, string, n2, true);
    }

    public static void saveChartToStream(JCChart jCChart, OutputStream outputStream, int n2, int n3, String string) throws IOException {
        JCChartFactory.setOutputDataPropertiesOnChart(jCChart, n3, string);
        JCChartFactory.saveChart(jCChart, outputStream, n2, true);
    }

    public static void saveChartToStream(JCChart jCChart, OutputStream outputStream, int n2) throws IOException {
        JCChartFactory.saveChart(jCChart, outputStream, n2, true);
    }

    public static void saveChart(JCChart jCChart, Object object, int n2, boolean bl) throws IOException {
        JCFilePersistor jCFilePersistor;
        if (jCChart == null) {
            return;
        }
        if (!(object instanceof String || object instanceof OutputStream || object instanceof Writer)) {
            throw new IllegalArgumentException("Bad outputTarget.  Must be one of String, OutputStream, or Writer.");
        }
        switch (n2) {
            case 0: {
                jCFilePersistor = new JCHTMLFilePersistor(object, (Object)jCChart);
                break;
            }
            case 1: {
                jCFilePersistor = new JCXMLFilePersistor(object, (Object)jCChart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart file type");
            }
        }
        jCFilePersistor.setPrintErrors(bl);
        PropertySaveModel propertySaveModel = PropertySaveFactory.makeSaver(jCChart, new JCChart(), PropertySaveFactory.getPackage(), jCFilePersistor.getSubDirectory(), jCFilePersistor.getType());
        if (propertySaveModel != null) {
            propertySaveModel.saveProperties(jCFilePersistor, null, 0);
        }
        jCFilePersistor.dispose();
    }

    public static String saveChartToString(JCChart jCChart, int n2, int n3, String string) {
        String string2;
        block2: {
            JCChartFactory.setOutputDataPropertiesOnChart(jCChart, n3, string);
            string2 = null;
            try {
                string2 = JCChartFactory.saveChartToString(jCChart, n2);
            }
            catch (IOException iOException) {
                if (jCChart == null) break block2;
                jCChart.getErrorLog().logErrorMessage("saveChartToString", iOException);
            }
        }
        return string2;
    }

    public static String saveChartToString(JCChart jCChart, int n2) throws JCIOException {
        JCStringPersistor jCStringPersistor;
        if (jCChart == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (n2) {
            case 0: {
                jCStringPersistor = new JCHTMLStringPersistor(stringBuffer, jCChart);
                break;
            }
            case 1: {
                jCStringPersistor = new JCXMLStringPersistor(stringBuffer, jCChart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart file type");
            }
        }
        jCStringPersistor.setPrintErrors(true);
        PropertySaveModel propertySaveModel = PropertySaveFactory.makeSaver(jCChart, new JCChart(), PropertySaveFactory.getPackage(), jCStringPersistor.getSubDirectory(), jCStringPersistor.getType());
        if (propertySaveModel != null) {
            propertySaveModel.saveProperties(jCStringPersistor, null, 0);
        }
        return stringBuffer.toString();
    }
}

