/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class JCChartDateFormat {
    private static final String engYearSym = "y";
    private static final String engMonthSym = "M";
    private static final String engDaySym = "dEDFwW";
    private static final String engHourSym = "ahHkKz";
    private static final String engMinuteSym = "m";
    private static final String engSecondSym = "s";
    private String secondSym = null;
    private String minuteSym = null;
    private String hourSym = null;
    private String daySym = null;
    private String monthSym = null;
    private String yearSym = null;
    private Calendar calendar = null;
    private Locale locale = Locale.getDefault();
    private TimeZone timeZone = TimeZone.getDefault();
    private int dateStyle = 3;
    private int timeStyle = 3;
    private SimpleDateFormat formatter = null;
    private SimpleDateFormat longFormatter = null;
    private String largestTimeLabel = null;
    private String currentPattern = "";
    private static Date minTime = null;
    private static Date maxTime = null;
    private boolean skipWeekends = false;
    private double secondsThreshold = 3600000.0;

    public JCChartDateFormat() {
        this.init();
    }

    protected void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.init();
    }

    protected void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.timeZone = timeZone;
        this.init();
    }

    public void setDateStyle(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Illegal date style " + n2);
        }
        this.dateStyle = n2;
        this.init();
    }

    public int getDateStyle() {
        return this.dateStyle;
    }

    public void setTimeStyle(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("Illegal time style " + n2);
        }
        this.timeStyle = n2;
        this.init();
    }

    public int getTimeStyle() {
        return this.timeStyle;
    }

    private void init() {
        this.calendar = Calendar.getInstance(this.timeZone, this.locale);
        this.formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale);
        this.formatter.setCalendar(this.calendar);
        this.longFormatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(0, 0, this.locale);
        this.longFormatter.setCalendar(this.calendar);
        this.currentPattern = "";
        this.largestTimeLabel = this.getLargestLocaleTimeLabel();
        this.secondSym = this.getLocalizedPattern(engSecondSym);
        this.minuteSym = this.getLocalizedPattern(engMinuteSym);
        this.hourSym = this.getLocalizedPattern(engHourSym);
        this.daySym = this.getLocalizedPattern(engDaySym);
        this.monthSym = this.getLocalizedPattern(engMonthSym);
        this.yearSym = this.getLocalizedPattern(engYearSym);
    }

    protected String timeLabel(Date date) {
        return this.formatter.format(date);
    }

    protected static String timeLabel(int n2, Date date, Locale locale) {
        String string;
        Calendar calendar = Calendar.getInstance(locale);
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(n2, n2, locale);
                dateFormat.setCalendar(calendar);
                string = dateFormat.format(date);
                break;
            }
            default: {
                string = date.toString();
            }
        }
        return string;
    }

    protected String timeLabel(String string, Date date) {
        this.formatter.applyLocalizedPattern(this.getLocalizedPattern(string));
        return this.formatter.format(date);
    }

    protected static Date getMinTime() {
        if (minTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(calendar.getMinimum(1), calendar.getMinimum(2), calendar.getMinimum(5), calendar.getMinimum(11), calendar.getMinimum(12), calendar.getMinimum(13));
            minTime = calendar.getTime();
        }
        return minTime;
    }

    protected static Date getMaxTime() {
        if (maxTime == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(calendar.getMaximum(1) - 1, calendar.getMaximum(2), calendar.getMaximum(5), calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13));
            maxTime = calendar.getTime();
        }
        return maxTime;
    }

    protected String getLargestTimeLabel(String string) {
        this.calculateLargestTimeLabel(string);
        return this.largestTimeLabel;
    }

    protected void calculateLargestTimeLabel(String string) {
        int n2;
        if (string.compareTo(this.currentPattern) == 0) {
            return;
        }
        this.currentPattern = string;
        String[] stringArray = this.longFormatter.getDateFormatSymbols().getMonths();
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < 12; ++i2) {
            n2 = stringArray[i2].length();
            if (n4 >= n2) continue;
            n4 = n2;
            n3 = i2;
        }
        String[] stringArray2 = this.longFormatter.getDateFormatSymbols().getWeekdays();
        n2 = 0;
        n4 = 0;
        for (int i3 = 1; i3 <= 7; ++i3) {
            int n5 = stringArray2[i3].length();
            if (n4 >= n5) continue;
            n4 = n5;
            n2 = i3;
        }
        this.calendar.set(2, n3);
        this.calendar.set(5, 1);
        while (this.calendar.get(7) != n2) {
            this.calendar.roll(5, true);
        }
        this.formatter.applyLocalizedPattern(this.getLocalizedPattern(string));
        this.largestTimeLabel = this.formatter.format(this.calendar.getTime());
        this.calendar.setTime(new Date());
    }

    protected String getLargestLocaleTimeLabel() {
        return this.getLargestTimeLabel(this.longFormatter.toPattern());
    }

    protected void roundTime(Date date, long l2, AdjustType adjustType) {
        if (date == null) {
            return;
        }
        int n2 = 0;
        switch (adjustType) {
            case NEGATIVE: {
                n2 = -1;
                break;
            }
            case ZERO: {
                n2 = 0;
                break;
            }
            case POSITIVE: {
                n2 = 1;
            }
        }
        this.calendar.setTime(date);
        if (l2 < 1000L) {
            int n3 = this.calendar.get(14);
            this.calendar.set(14, (n3 / 1000 + n2) * 1000);
        } else {
            this.calendar.set(14, 0);
            if (l2 < 60000L) {
                int n4 = this.calendar.get(13);
                this.calendar.set(13, (int)(((long)n4 / (l2 /= 1000L) + (long)n2) * l2));
            } else {
                this.calendar.set(13, 0);
                if (l2 < 3600000L) {
                    int n5 = this.calendar.get(12);
                    this.calendar.set(12, (int)(((long)n5 / (l2 /= 60000L) + (long)n2) * l2));
                } else {
                    this.calendar.set(12, 0);
                    if (l2 < 86400000L) {
                        int n6 = this.calendar.get(11);
                        this.calendar.set(11, (int)(((long)n6 / (l2 /= 3600000L) + (long)n2) * l2));
                    } else {
                        this.calendar.set(11, 0);
                        long l3 = (long)n2 * l2;
                        if (l2 < 2678400000L) {
                            if (adjustType != AdjustType.ZERO) {
                                int n7 = this.calendar.get(5);
                                this.calendar.set(5, (int)((long)n7 + l3 / 86400000L));
                            }
                        } else {
                            this.calendar.set(5, 1);
                            if (l2 < 31536000000L) {
                                if (adjustType != AdjustType.ZERO) {
                                    int n8 = this.calendar.get(2);
                                    this.calendar.set(2, (int)((long)n8 + l3 / 2678400000L));
                                }
                            } else {
                                this.calendar.set(2, 0);
                                if (adjustType != AdjustType.ZERO) {
                                    int n9 = this.calendar.get(1);
                                    this.calendar.set(1, (int)((long)n9 + l3 / 31536000000L));
                                }
                            }
                        }
                    }
                }
            }
        }
        date.setTime(this.calendar.getTime().getTime());
        this.calendar.setTime(new Date());
    }

    protected long niceInc(long l2, String string) {
        long l3 = JCChartDateFormat.getMaxTime().getTime();
        String string2 = this.getLocalizedPattern(string);
        if (this.matchPattern(string2, this.secondSym)) {
            l3 = 1000L;
        } else if (this.matchPattern(string2, this.minuteSym)) {
            l3 = Math.min(l3, 60000L);
        } else if (this.matchPattern(string2, this.hourSym)) {
            l3 = Math.min(l3, 3600000L);
        } else if (this.matchPattern(string2, this.daySym)) {
            l3 = Math.min(l3, 86400000L);
        } else if (this.matchPattern(string2, this.monthSym)) {
            l3 = Math.min(l3, 2678400000L);
        } else if (this.matchPattern(string2, this.yearSym)) {
            l3 = Math.min(l3, 31536000000L);
        }
        if (l3 == JCChartDateFormat.getMaxTime().getTime()) {
            l3 = 1L;
        }
        if (l3 < 60000L) {
            if (l2 <= 1000L) {
                return 1000L;
            }
            if (l2 <= 5000L) {
                return 5000L;
            }
            if (l2 <= 10000L) {
                return 10000L;
            }
            if (l2 <= 15000L) {
                return 15000L;
            }
            if (l2 <= 30000L) {
                return 30000L;
            }
            l3 = 60000L;
        }
        if (l3 < 3600000L) {
            if (l2 <= l3) {
                return l3;
            }
            if (l2 <= 5L * l3) {
                return 5L * l3;
            }
            if (l2 <= 10L * l3) {
                return 10L * l3;
            }
            if (l2 <= 15L * l3) {
                return 15L * l3;
            }
            if (l2 <= 30L * l3) {
                return 30L * l3;
            }
            l3 = 3600000L;
        }
        if (l3 < 86400000L) {
            if (l2 <= l3) {
                return l3;
            }
            if (l2 <= 3L * l3) {
                return 3L * l3;
            }
            if (l2 <= 6L * l3) {
                return 6L * l3;
            }
            if (l2 <= 12L * l3) {
                return 12L * l3;
            }
            l3 = 86400000L;
        }
        if (l3 < 2678400000L) {
            if (l2 <= l3) {
                return l3;
            }
            if (l2 <= 2L * l3) {
                return 2L * l3;
            }
            if (this.skipWeekends) {
                if (l2 <= 5L * l3) {
                    return 5L * l3;
                }
                if (l2 <= 10L * l3) {
                    return 10L * l3;
                }
            } else {
                if (l2 <= 7L * l3) {
                    return 7L * l3;
                }
                if (l2 <= 14L * l3) {
                    return 14L * l3;
                }
            }
            l3 = 2678400000L;
        }
        if (l3 < 31536000000L) {
            if (l2 <= l3) {
                return l3;
            }
            if (l2 <= 2L * l3) {
                return 2L * l3;
            }
            if (l2 <= 3L * l3) {
                return 3L * l3;
            }
            if (l2 <= 4L * l3) {
                return 4L * l3;
            }
            if (l2 <= 6L * l3) {
                return 6L * l3;
            }
            l3 = 31536000000L;
        }
        if (l2 <= l3) {
            return l3;
        }
        if (l2 <= 2L * l3) {
            return 2L * l3;
        }
        if (l2 <= 5L * l3) {
            return 5L * l3;
        }
        if (l2 <= 10L * l3) {
            return 10L * l3;
        }
        return 20L * l3;
    }

    protected static long timeIncUnits(long l2) {
        if (l2 < 60000L) {
            return 1000L;
        }
        if (l2 < 3600000L) {
            return 60000L;
        }
        if (l2 < 86400000L) {
            return 3600000L;
        }
        if (l2 < 2678400000L) {
            return 86400000L;
        }
        if (l2 < 31536000000L) {
            return 2678400000L;
        }
        return 31536000000L;
    }

    protected void addToUnit(Date date, long l2, int n2) {
        if (date == null) {
            return;
        }
        this.calendar.setTime(date);
        if (l2 < 1000L) {
            this.calendar.add(14, n2);
        } else if (l2 < 60000L) {
            this.calendar.add(13, n2);
        } else if (l2 < 3600000L) {
            this.calendar.add(12, n2);
        } else if (l2 < 86400000L) {
            this.calendar.add(11, n2);
        } else if (l2 < 2678400000L) {
            this.calendar.add(5, n2);
        } else if (l2 < 31536000000L) {
            this.calendar.add(2, n2);
        } else {
            this.calendar.add(1, n2);
        }
        if (this.calendar.getTime().getTime() < JCChartDateFormat.getMinTime().getTime()) {
            this.calendar.setTime(JCChartDateFormat.getMinTime());
        }
        if (this.calendar.getTime().getTime() > JCChartDateFormat.getMaxTime().getTime()) {
            this.calendar.setTime(JCChartDateFormat.getMaxTime());
        }
        date.setTime(this.calendar.getTime().getTime());
        this.calendar.setTime(new Date());
    }

    public void setSecondsThreshold(double d2) {
        this.secondsThreshold = d2;
    }

    public double getSecondsThreshold() {
        return this.secondsThreshold;
    }

    protected String getDefaultTimeFormat(double d2) {
        String string = d2 > 6.3072E10 ? "yyyy" : (d2 > 3.1536E10 ? "MMM yy" : (d2 > 8.0352E9 ? "MMM" : (d2 > 1.2096E9 ? "MMM dd" : (d2 > 1.728E8 ? "EE dd" : (d2 > 8.64E7 ? "EE HH:mm" : (d2 > this.secondsThreshold ? "HH:mm" : "HH:mm:ss"))))));
        return string;
    }

    private String getLocalizedPattern(String string) {
        this.formatter.applyPattern(string);
        return this.formatter.toLocalizedPattern();
    }

    private boolean matchPattern(String string, String string2) {
        boolean bl = false;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string.indexOf(string2.charAt(i2)) < 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void skipWeekends(boolean bl) {
        this.skipWeekends = bl;
    }

    public boolean skippingWeekends() {
        return this.skipWeekends;
    }

    public static void main(String[] stringArray) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2004, 2, 29, 18, 22, 32);
        Date date = gregorianCalendar.getTime();
        long l2 = date.getTime();
        System.out.println("Original Date:" + date.toString() + " msecs=" + l2);
        JCChartDateFormat jCChartDateFormat = new JCChartDateFormat();
        AdjustType adjustType = AdjustType.POSITIVE;
        date.setTime(l2);
        jCChartDateFormat.roundTime(date, 1000L, adjustType);
        System.out.println("Date(seconds):" + date.toString() + " msecs=" + date.getTime());
        date.setTime(l2);
        jCChartDateFormat.roundTime(date, 60000L, adjustType);
        System.out.println("Date(minutes):" + date.toString() + " msecs=" + date.getTime());
        date.setTime(l2);
        jCChartDateFormat.roundTime(date, 3600000L, adjustType);
        System.out.println("Date(hours):" + date.toString() + " msecs=" + date.getTime());
        date.setTime(l2);
        jCChartDateFormat.roundTime(date, 86400000L, adjustType);
        System.out.println("Date(days):" + date.toString() + " msecs=" + date.getTime());
        date.setTime(l2);
        jCChartDateFormat.roundTime(date, 2678400000L, adjustType);
        System.out.println("Date(months):" + date.toString() + " msecs=" + date.getTime());
        date.setTime(l2);
        jCChartDateFormat.roundTime(date, 31536000000L, adjustType);
        System.out.println("Date(years):" + date.toString() + " msecs=" + date.getTime());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdjustType {
        NEGATIVE,
        ZERO,
        POSITIVE;

    }
}

