/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxis;

public class JCAxisTitle
extends ChartText {
    protected DerivedInt placement = new DerivedInt(16, true);
    protected int effectivePlacement = 16;

    public JCAxisTitle() {
        this.setVisible(false);
    }

    public JCAxisTitle(String string) {
        this.setText(string);
    }

    protected void setParentAxis(JCAxis jCAxis) {
        super.setParentAxis(jCAxis);
        this.fixPlacement(jCAxis);
    }

    public void setText(String string, boolean bl) {
        super.setText(string, bl);
        if (this.getWidth() == 0) {
            this.setChanged(true, 2);
        }
    }

    public void setPlacement(int n2) {
        if (!this.placement.isDefault && n2 == this.placement.value) {
            return;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 33: 
            case 34: {
                this.placement.value = n2;
                this.placement.isDefault = false;
                this.fixPlacement(this.parentAxis);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid title Placement in JCAxisTitle");
            }
        }
        this.setChanged(true, 2);
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        this.fixPlacement(this.parentAxis);
        this.setChanged(true, 2);
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    public int getEffectivePlacement() {
        return this.effectivePlacement;
    }

    protected void fixPlacement(JCAxis jCAxis) {
        this.effectivePlacement = this.placement.value;
        if (jCAxis == null) {
            return;
        }
        if (this.placement.isDefault) {
            this.effectivePlacement = !this.parentAxis.i_vertical && this.rotation != 0 ? jCAxis.getAnnotationAnchor() : (this.parentAxis.otherAxis != null && this.parentAxis.otherAxis.getAnnotationAnchor() == 16 ? (this.parentAxis.getAnnotationAnchor() == 1 ? 33 : 34) : (this.parentAxis.getAnnotationAnchor() == 1 ? 17 : 18));
        }
        if (jCAxis.i_vertical) {
            switch (this.effectivePlacement) {
                case 1: 
                case 2: 
                case 17: 
                case 18: 
                case 33: 
                case 34: {
                    break;
                }
                default: {
                    this.effectivePlacement = jCAxis.getAnnotationAnchor();
                    break;
                }
            }
        } else {
            switch (this.effectivePlacement) {
                case 16: 
                case 32: {
                    break;
                }
                default: {
                    this.effectivePlacement = jCAxis.getAnnotationAnchor();
                }
            }
        }
    }

    public void layout() {
        if (this.visible) {
            if (this.parentAxis.i_vertical) {
                int n2 = this.parentAxis.getTop() + (this.parentAxis.getHeight() - this.getHeight()) / 2;
                int n3 = this.parentAxis.getLeft();
                int n4 = this.parentAxis.getLeft() + this.parentAxis.getWidth() - this.getWidth();
                Extents extents = this.parentAxis.getExtents();
                switch (this.effectivePlacement) {
                    case 18: {
                        this.setLocation(n3, this.parentAxis.getTop() - extents.minor);
                        break;
                    }
                    case 2: {
                        this.setLocation(n3, n2);
                        break;
                    }
                    case 34: {
                        this.setLocation(n3, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                        break;
                    }
                    case 17: {
                        this.setLocation(n4, this.parentAxis.getTop() - extents.minor);
                        break;
                    }
                    case 1: {
                        this.setLocation(n4, n2);
                        break;
                    }
                    case 33: {
                        this.setLocation(n4, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                    }
                }
            } else {
                int n5 = this.parentAxis.getLeft() + (this.parentAxis.getWidth() - this.getWidth()) / 2;
                switch (this.effectivePlacement) {
                    case 16: {
                        this.setLocation(n5, this.parentAxis.getTop() + 1);
                        break;
                    }
                    case 32: {
                        this.setLocation(n5, this.parentAxis.getTop() + this.parentAxis.getHeight() - this.getHeight());
                    }
                }
            }
        }
    }
}

