/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnoBoundsInfo;
import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.CircularChartAnnoHandler;
import com.klg.jclass.chart.CircularChartAxisHandler;
import com.klg.jclass.chart.CircularChartLogAxisHandler;
import com.klg.jclass.chart.DerivedDouble;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.DerivedString;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAnno;
import com.klg.jclass.chart.JCAxisFormula;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartDateFormat;
import com.klg.jclass.chart.JCChartEnumMappings;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCGrid;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPickItem;
import com.klg.jclass.chart.JCTimeExclusion;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.LogAxisHandler;
import com.klg.jclass.chart.Mapper;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotArea;
import com.klg.jclass.chart.PolarAxisParams;
import com.klg.jclass.chart.RectangularChartAxisHandler;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCAxis
extends ChartInteriorRegion
implements Serializable {
    protected int gap = 3;
    protected JCAxisTitle title = null;
    protected DerivedDouble min = new DerivedDouble(0.0, true);
    protected DerivedDouble max = new DerivedDouble(0.0, true);
    protected DerivedDouble origin = new DerivedDouble(0.0, true);
    protected DerivedInt originPlacement = new DerivedInt(0, true);
    protected DerivedInt placement = new DerivedInt(0, true);
    protected boolean gridVisible = false;
    protected JCAxisFormula formula = null;
    protected boolean editable = true;
    protected boolean logarithmic = false;
    protected boolean reversed = false;
    protected boolean vertical = false;
    protected boolean i_vertical = false;
    protected int annotationRotation = 0;
    protected JCAxis placementAxis = null;
    protected double placementLocation = 0.0;
    protected JCLabelGenerator labelGenerator = null;
    protected boolean decimalPadded = true;
    protected int savedAxisAnnotationMethod;
    protected long timeUnit = 1000L;
    protected DerivedString timeFormat = new DerivedString("", true);
    protected Date timeBase = null;
    public boolean isTimeBaseSet = false;
    protected Polygon sideplane;
    protected int tickLength = 4;
    protected JCChartArea chartArea = null;
    protected Locale locale = Locale.getDefault();
    protected TimeZone timeZone = TimeZone.getDefault();
    protected double step = 1.0;
    public static final long SECONDS = 1000L;
    public static final long MINUTES = 60000L;
    public static final long HOURS = 3600000L;
    public static final long DAYS = 86400000L;
    public static final long WEEKS = 604800000L;
    public static final long MONTHS = 2678400000L;
    public static final long YEARS = 31536000000L;
    protected MinMax dataLimits = null;
    protected MinMax originalDataLimits = null;
    protected boolean scientificNotation = false;
    protected DerivedInt precision = new DerivedInt(1, true);
    protected DerivedInt radianPrecision = new DerivedInt(2, true);
    protected DerivedInt degreeGradPrecision = new DerivedInt(0, true);
    public static final int MIN_PRECISION = -14;
    public static final int MAX_PRECISION = 14;
    protected int minimumPrecision = -14;
    protected int maximumPrecision = 14;
    protected DerivedDouble numSpacing = new DerivedDouble(0.0, true);
    protected DerivedDouble tickSpacing = new DerivedDouble(0.0, true);
    public static final int AUTOMATIC = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int ZERO = 3;
    public static final int VALUE_ANCHORED = 4;
    public static final int ORIGIN = 5;
    public static final int VALUE = 0;
    public static final int VALUE_LABELS = 1;
    public static final int TIME_LABELS = 2;
    public static final int POINT_LABELS = 3;
    protected int annotationMethod = 0;
    protected double annotationRotationAngle = 0.0;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;
    public static final int ROTATE_OTHER = 4;
    protected transient int chartType;
    protected transient boolean isPrimary;
    protected transient JCAxis otherAxis;
    private transient AxisHandler axisHandler = null;
    protected AnnotationHandler annoHandler = null;
    private boolean axisDrawn = false;
    private static int axisNum = 0;
    private boolean hasBar = false;
    protected boolean frontPlane = true;
    protected boolean is100Percent = false;
    protected PolarAxisParams polarAxisParams = null;
    protected double yAxisAngle = 0.0;
    protected boolean usingDoublePixels = false;
    protected List<JCAnno> annoList = null;
    protected List<JCGrid> gridList = null;
    protected boolean gridDefault = true;
    protected boolean useAnnoTicks = false;
    protected boolean dropTicksForHiddenLabels = false;
    protected boolean annotateToRange = false;
    protected Mapper mapper = null;
    protected ImageMapInfo imageMapInfo = null;
    protected boolean truncatedLabelTooltipEnabled = true;
    protected boolean skipWeekends = false;
    protected List<JCTimeExclusion> timeExclusions = new ArrayList<JCTimeExclusion>();
    private boolean hasTimeExclusions = false;
    protected boolean usePrecisionCalculatedBoundsForInvisibleAxis = true;
    protected boolean showGridLinesOnInvisibleAxis = false;
    protected boolean drawAxis = true;
    private boolean fTimelineXAxis = false;
    private boolean fTimelineYAxis = false;
    static final int TROUGH_TOP = 1;
    static final int TROUGH_BOTTOM = 2;
    static final int TROUGH_LEFT = 1;
    static final int TROUGH_RIGHT = 2;

    private void init() {
        this.setTitle(new JCAxisTitle());
        this.setName(JCChartBundle.string("com.klg.jclass.chart.Key6", this.locale) + " " + ++axisNum);
        if (this.chartArea != null) {
            this.polarAxisParams = this.chartArea.polarChartParams;
        }
        this.annoList = new ArrayList<JCAnno>();
        this.makeDefaultAnnotations();
        this.gridList = new ArrayList<JCGrid>();
        this.gridList.add(new JCGrid(this));
    }

    public JCAxis(JCChartArea jCChartArea, boolean bl, int n2) {
        this.vertical = bl;
        this.i_vertical = bl;
        this.annotationMethod = n2;
        this.chartArea = jCChartArea;
        this.createAnnoHandler();
        this.setLocale(this.chartArea.getLocale());
        this.init();
    }

    public JCAxis() {
        this.createAnnoHandler();
        this.init();
    }

    public JCAxis(Locale locale) {
        this.setLocale(locale);
        this.createAnnoHandler();
        this.init();
    }

    private void createAnnoHandler() {
        this.annoHandler = this.isPolarRadar() ? new CircularChartAnnoHandler(this) : new AnnotationHandler(this);
    }

    protected void updateAnnoHandler(int n2) {
        if (this.annoHandler instanceof CircularChartAnnoHandler && !this.isPolarRadar(n2)) {
            this.annoHandler = new AnnotationHandler(this.annoHandler);
        } else if (!(this.annoHandler instanceof CircularChartAnnoHandler) && this.isPolarRadar(n2)) {
            this.annoHandler = new CircularChartAnnoHandler(this.annoHandler);
        }
    }

    @Override
    public void setParentChart(JCChart jCChart) {
        if (this.parentChart == jCChart) {
            return;
        }
        super.setParentChart(jCChart);
        if (jCChart != null) {
            this.chartArea = jCChart.getChartArea();
            this.setLocale(this.chartArea.getLocale());
        }
        if (this.chartArea != null) {
            this.polarAxisParams = this.chartArea.polarChartParams;
        }
        this.setParentRegion(this.chartArea);
        if (this.title != null) {
            this.title.setParentAxis(this);
            this.title.setParentChart(jCChart);
            this.title.setParentRegion(this.chartArea);
        }
        if (this.annoHandler != null) {
            this.annoHandler.setValueLabelParent(jCChart);
        }
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        this.getNumberFormatter().setNumberFormatterLocale(locale);
        this.getAnnotationHandler().getDateFormatter().setLocale(locale);
        if (this.skipWeekends) {
            boolean bl = this.hasActiveWeekendExclusion();
            this.removeSkipWeekendExclusion();
            this.addTimeExclusion(JCTimeExclusion.createWeekendExclusion(this.getTimeZone(), this.getLocale(), bl));
        }
        this.getAxisHandler().updateCalendarObject(this.hasTimeExclusions());
        this.setChanged(true, 1);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        this.timeZone = timeZone;
        this.getAnnotationHandler().getDateFormatter().setTimeZone(timeZone);
        if (this.skipWeekends) {
            boolean bl = this.hasActiveWeekendExclusion();
            this.removeSkipWeekendExclusion();
            this.addTimeExclusion(JCTimeExclusion.createWeekendExclusion(this.getTimeZone(), this.getLocale(), bl));
        }
        this.getAxisHandler().updateCalendarObject(this.hasTimeExclusions());
        this.setChanged(true, 1);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public boolean isAnnotationVisible() {
        return this.annoHandler.annotationVisible;
    }

    public void setAnnotationVisible(boolean bl) {
        this.annoHandler.annotationVisible = bl;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        if (bl == this.gridVisible) {
            return;
        }
        this.gridVisible = bl;
        this.setChanged(true, 2);
    }

    public void setGridDefault(boolean bl) {
        if (this.gridDefault == bl) {
            return;
        }
        this.gridDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean isGridDefault() {
        return this.gridDefault;
    }

    public double getGridSpacing() {
        JCGrid jCGrid;
        double d2 = 0.0;
        if (this.gridList.size() > 0 && (jCGrid = this.gridList.get(0)) != null) {
            d2 = jCGrid.getIncrementValue();
        }
        return d2;
    }

    public void setGridSpacing(double d2) {
        JCGrid jCGrid;
        if (this.gridList.size() > 0 && (jCGrid = this.gridList.get(0)) != null) {
            if (jCGrid.getIncrementValue() == d2) {
                return;
            }
            jCGrid.setIncrementValue(d2);
            this.gridDefault = false;
            this.setChanged(true, 2);
        }
    }

    public void setGridSpacingIsDefault(boolean bl) {
        JCGrid jCGrid;
        this.gridDefault = bl;
        if (this.gridList.size() > 0 && (jCGrid = this.gridList.get(0)) != null) {
            if (jCGrid.getIncrementIsDefault() == bl) {
                return;
            }
            jCGrid.setIncrementIsDefault(bl);
            this.setChanged(true, 2);
        }
    }

    public boolean getGridSpacingIsDefault() {
        JCGrid jCGrid;
        boolean bl = false;
        if (this.gridList.size() > 0 && (jCGrid = this.gridList.get(0)) != null) {
            bl = jCGrid.getIncrementIsDefault();
        }
        return bl;
    }

    public JCChartStyle getGridStyle() {
        JCGrid jCGrid;
        JCChartStyle jCChartStyle = null;
        if (this.gridList.size() > 0 && (jCGrid = this.gridList.get(0)) != null) {
            jCChartStyle = jCGrid.getGridStyle();
        }
        if (jCChartStyle == null) {
            jCChartStyle = new JCChartStyle();
            jCChartStyle.setLineStyle(new JCLineStyle(1, this.getForeground(), 1));
            jCChartStyle.addParent(this);
        }
        return jCChartStyle;
    }

    public void setGridStyle(JCChartStyle jCChartStyle) {
        JCGrid jCGrid;
        if (this.gridList.size() > 0 && (jCGrid = this.gridList.get(0)) != null) {
            if (jCGrid.getGridStyle().equals(jCChartStyle)) {
                return;
            }
            jCGrid.setGridStyle(jCChartStyle);
            this.setChanged(true, 2);
        }
    }

    public void setLogarithmic(boolean bl) {
        if (this.logarithmic == bl) {
            return;
        }
        this.logarithmic = bl;
        this.axisHandler = null;
        this.setChanged(true, 2);
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setDecimalPadded(boolean bl) {
        this.decimalPadded = bl;
    }

    public boolean isDecimalPadded() {
        return this.decimalPadded;
    }

    public void setMin(double d2) {
        this.min.value = d2;
        this.min.isDefault = false;
        this.setChanged(true, 2);
    }

    public double getMin() {
        return this.min.value;
    }

    public void setMinIsDefault(boolean bl) {
        if (this.min.isDefault == bl) {
            return;
        }
        this.min.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getMinIsDefault() {
        return this.min.isDefault;
    }

    public void setMax(double d2) {
        this.max.value = d2;
        this.max.isDefault = false;
        this.setChanged(true, 2);
    }

    public double getMax() {
        return this.max.value;
    }

    public void setMaxIsDefault(boolean bl) {
        if (this.max.isDefault == bl) {
            return;
        }
        this.max.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getMaxIsDefault() {
        return this.max.isDefault;
    }

    public void setOrigin(double d2) {
        this.origin.value = d2;
        this.origin.isDefault = false;
        this.setChanged(true, 2);
    }

    public double getOrigin() {
        return this.origin.value;
    }

    public void setOriginIsDefault(boolean bl) {
        if (this.origin.isDefault == bl) {
            return;
        }
        this.origin.isDefault = bl;
        this.setChanged(true, 2);
    }

    public boolean getOriginIsDefault() {
        return this.origin.isDefault;
    }

    public void setOriginPlacement(int n2) {
        if (!this.originPlacement.isDefault && this.originPlacement.value == n2) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.originPlacement.value = n2;
                this.originPlacement.isDefault = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid OriginPlacement in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public int getOriginPlacement() {
        return this.originPlacement.value;
    }

    public void setOriginPlacementIsDefault(boolean bl) {
        if (this.originPlacement.isDefault == bl) {
            return;
        }
        this.originPlacement.isDefault = bl;
        if (bl) {
            this.originPlacement.value = 0;
        }
        this.setChanged(true, 2);
    }

    public boolean getOriginPlacementIsDefault() {
        return this.originPlacement.isDefault;
    }

    public JCAxisTitle getTitle() {
        if (this.title == null) {
            this.title = new JCAxisTitle();
            this.title.setParentAxis(this);
            this.title.setParentChart(this.parentChart);
            this.title.setParentRegion(this.chartArea);
        }
        return this.title;
    }

    public void setTitle(JCAxisTitle jCAxisTitle) {
        if (jCAxisTitle == null) {
            return;
        }
        this.title = jCAxisTitle;
        this.title.setParentAxis(this);
        this.title.setParentChart(this.parentChart);
        this.title.setParentRegion(this.chartArea);
        this.setChanged(true, 2);
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.setChanged(true, 2);
    }

    public boolean isReversed() {
        return !this.isTimelineXAxis() && this.reversed;
    }

    public JCAxisFormula getFormula() {
        if (this.formula == null) {
            this.formula = new JCAxisFormula(this);
        }
        return this.formula;
    }

    public void setAnnotationRotation(int n2) {
        if (n2 == this.annotationRotation) {
            return;
        }
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("Invalid AnnotationRotation value in JCAxis: " + n2);
        }
        this.annotationRotation = n2;
        this.setChanged(true, 2);
    }

    public int getAnnotationRotation() {
        return this.isTimelineYAxis() ? 0 : this.annotationRotation;
    }

    public void setAnnotationRotationAngle(int n2, double d2) {
        String string = JCTypeConverter.fromEnum(n2, JCChartEnumMappings.angleUnit_strings, JCChartEnumMappings.angleUnit_values);
        if (string == null) {
            throw new IllegalArgumentException("Invalid angle unit: " + n2);
        }
        double d3 = JCChartUtil.boundAngle(n2, d2);
        if (!this.isBoundAngle(n2, d3)) {
            throw new IllegalArgumentException("Unable to normalize input angle " + d2 + " " + string);
        }
        this.annotationRotationAngle = JCChartUtil.convertAngle(n2, 2, d3);
        this.setChanged(true, 2);
    }

    private boolean isBoundAngle(int n2, double d2) {
        double d3 = JCChartUtil.convertAngle(n2, 1, d2);
        return -360.0 <= d3 && d3 <= 360.0;
    }

    public double getAnnotationRotationAngle(int n2) {
        if (!JCChartUtil.validUnit(n2)) {
            throw new IllegalArgumentException("Invalid angle unit: " + n2);
        }
        return JCChartUtil.convertAngle(2, n2, this.annotationRotationAngle);
    }

    public void setPlacement(int n2) {
        if (!this.placement.isDefault && this.placement.value == n2) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.placement.value = n2;
                this.placement.isDefault = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Placement value in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public void setPlacement(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setPlacement(5);
    }

    public void setPlacement(JCAxis jCAxis, double d2) {
        this.placementAxis = jCAxis;
        this.placementLocation = d2;
        this.setPlacement(4);
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        if (bl) {
            this.placement.value = 0;
        }
        this.setChanged(true, 2);
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    public void setPlacementAxis(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setChanged(true, 2);
    }

    public JCAxis getPlacementAxis() {
        return this.placementAxis;
    }

    public void setPlacementLocation(double d2) {
        this.placementLocation = d2;
        this.setChanged(true, 2);
    }

    public double getPlacementLocation() {
        return this.placementLocation;
    }

    public void setAnnotationMethod(int n2) {
        if (n2 == this.annotationMethod) {
            this.savedAxisAnnotationMethod = this.annotationMethod;
            return;
        }
        switch (n2) {
            case 0: 
            case 3: {
                JCAnno jCAnno;
                if (this.useAnnoTicks && (jCAnno = this.getDefaultLabels()) != null) {
                    jCAnno.drawLabels = true;
                }
            }
            case 1: {
                this.savedAxisAnnotationMethod = this.annotationMethod = n2;
                break;
            }
            case 2: {
                if (this.isRadar() && !this.i_vertical) {
                    return;
                }
                this.savedAxisAnnotationMethod = this.annotationMethod = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AnnotationMethod value in JCAxis");
            }
        }
        this.calcHasTimeExclusions();
        this.setChanged(true, 2);
    }

    public int getAnnotationMethod() {
        return this.annotationMethod;
    }

    public void setPrecision(int n2) {
        DerivedInt derivedInt = this.getPrecisionObject();
        derivedInt.value = n2;
        derivedInt.isDefault = false;
        JCAnno jCAnno = this.getDefaultLabels();
        if (jCAnno != null) {
            jCAnno.precision.value = n2;
            jCAnno.precision.isDefault = false;
        }
        this.setChanged(true, 2);
    }

    protected void setPrecisionInternal(int n2) {
        DerivedInt derivedInt = this.getPrecisionObject();
        derivedInt.value = n2;
        this.updateAnnoDefPrecision(n2);
    }

    protected void updateAnnoDefPrecision(int n2) {
        JCAnno jCAnno = this.getDefaultLabels();
        if (jCAnno != null) {
            jCAnno.setDefaultPrecision(n2);
            if (jCAnno.getPrecisionIsDefault()) {
                jCAnno.precision.value = n2;
            }
        }
    }

    public int getPrecision() {
        int n2 = this.getPrecisionObject().value;
        JCAnno jCAnno = this.getDefaultLabels();
        if (jCAnno != null) {
            n2 = jCAnno.getPrecision();
        }
        return n2;
    }

    public void setPrecisionIsDefault(boolean bl) {
        DerivedInt derivedInt = this.getPrecisionObject();
        derivedInt.isDefault = bl;
        JCAnno jCAnno = this.getDefaultLabels();
        if (jCAnno != null) {
            jCAnno.precision.isDefault = bl;
            if (bl) {
                jCAnno.precision.value = jCAnno.defPrecision;
            }
        }
        this.setChanged(true, 2);
    }

    private DerivedInt getPrecisionObject() {
        DerivedInt derivedInt = this.precision;
        if (this.isPolar() && !this.i_vertical) {
            int n2 = this.chartArea.getAngleUnit();
            switch (n2) {
                case 2: {
                    derivedInt = this.radianPrecision;
                    break;
                }
                case 1: 
                case 3: {
                    derivedInt = this.degreeGradPrecision;
                    break;
                }
            }
        }
        return derivedInt;
    }

    private int getDefaultPrecision(int n2) {
        int n3;
        int n4 = 0;
        if (n2 == 2 && !this.i_vertical && (n3 = this.chartArea.getAngleUnit()) == 2) {
            n4 = 2;
        }
        return n4;
    }

    public void setMinPrecision(int n2) {
        this.minimumPrecision = n2;
    }

    public int getMinPrecision() {
        return this.minimumPrecision;
    }

    public void setMaxPrecision(int n2) {
        this.maximumPrecision = n2;
    }

    public int getMaxPrecision() {
        return this.maximumPrecision;
    }

    public boolean getPrecisionIsDefault() {
        DerivedInt derivedInt = this.getPrecisionObject();
        return derivedInt.isDefault;
    }

    protected void updateAnnoDefaultPrecision(int n2) {
        if (this.annoList != null) {
            int n3 = this.annoList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                JCAnno jCAnno = this.annoList.get(i2);
                if (jCAnno == null) continue;
                int n4 = this.getDefaultPrecision(n2);
                jCAnno.setDefaultPrecision(n4);
                if (!jCAnno.precision.isDefault) continue;
                jCAnno.precision.value = n4;
            }
        }
    }

    public void setNumSpacing(double d2) {
        this.numSpacing.value = d2;
        this.numSpacing.isDefault = false;
        JCAnno jCAnno = this.getDefaultLabels();
        if (jCAnno != null) {
            jCAnno.setIncrementValue(d2);
        }
        this.setChanged(true, 2);
    }

    public double getNumSpacing() {
        return this.numSpacing.value;
    }

    public void setNumSpacingIsDefault(boolean bl) {
        this.numSpacing.isDefault = bl;
        JCAnno jCAnno = this.getDefaultLabels();
        if (jCAnno != null) {
            jCAnno.setIncrementIsDefault(bl);
        }
        this.setChanged(true, 2);
    }

    public boolean getNumSpacingIsDefault() {
        if (!this.numSpacing.isDefault) {
            return false;
        }
        JCAnno jCAnno = this.getDefaultLabels();
        boolean bl = false;
        if (jCAnno != null) {
            bl = jCAnno.getIncrementIsDefault();
        }
        return bl;
    }

    public double getTickSpacing() {
        return this.tickSpacing.value;
    }

    public void setTickSpacing(double d2) {
        JCAnno jCAnno;
        this.tickSpacing.value = d2;
        this.tickSpacing.isDefault = false;
        this.useAnnoTicks = true;
        if (this.numSpacing.isDefault) {
            this.setNumSpacing(d2);
        }
        if ((jCAnno = this.getDefaultTicks()) != null && jCAnno.incrementValue.isDefault) {
            jCAnno.incrementValue.value = d2;
        }
        this.setChanged(true, 2);
    }

    public void setTickSpacingIsDefault(boolean bl) {
        this.tickSpacing.isDefault = bl;
        this.useAnnoTicks = !bl;
        this.setChanged(true, 2);
    }

    public boolean getTickSpacingIsDefault() {
        if (!this.tickSpacing.isDefault) {
            return false;
        }
        JCAnno jCAnno = this.getDefaultTicks();
        boolean bl = false;
        if (jCAnno != null) {
            bl = jCAnno.getIncrementIsDefault();
        }
        return bl;
    }

    public double getStep() {
        return this.step;
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        if (this.labelGenerator == jCLabelGenerator) {
            return;
        }
        this.labelGenerator = jCLabelGenerator;
        this.numberLocalization = false;
        this.setChanged(true, 2);
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setTimeUnit(long l2) {
        if (this.timeUnit == l2) {
            return;
        }
        if (l2 != 1000L && l2 != 60000L && l2 != 3600000L && l2 != 86400000L && l2 != 604800000L && l2 != 2678400000L && l2 != 31536000000L) {
            throw new IllegalArgumentException("Invalid TimeUnit value in JCAxis");
        }
        this.timeUnit = l2;
        this.calcHasTimeExclusions();
        this.setChanged(true, 2);
    }

    public long getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeBase(Date date) {
        if (date == null) {
            this.isTimeBaseSet = false;
            return;
        }
        if (this.timeBase != null && this.timeBase.equals(date)) {
            return;
        }
        this.timeBase = (Date)date.clone();
        this.isTimeBaseSet = true;
        this.setChanged(true, 2);
    }

    public Date getTimeBase() {
        if (this.timeBase == null) {
            this.timeBase = new Date();
        }
        return this.timeBase;
    }

    public String timeBaseToString(boolean bl) {
        JCChartDateFormat jCChartDateFormat = this.annoHandler.getDateFormatter();
        return bl ? jCChartDateFormat.timeLabel(this.timeFormat.value, this.getTimeBase()) : jCChartDateFormat.timeLabel(this.getTimeBase());
    }

    public void setTimeFormat(String string) {
        this.setTimeFormat(string, true);
    }

    public void setTimeFormat(String string, boolean bl) {
        this.timeFormat.isDefault = false;
        if (this.timeFormat.value != null && this.timeFormat.value.equals(string)) {
            return;
        }
        this.timeFormat.value = string;
        if (bl) {
            this.setChanged(true, 2);
        }
    }

    public String getTimeFormat() {
        return this.timeFormat.value;
    }

    public void setTimeFormatIsDefault(boolean bl) {
        this.setTimeFormatIsDefault(bl, true);
    }

    public void setTimeFormatIsDefault(boolean bl, boolean bl2) {
        if (this.timeFormat.isDefault == bl) {
            return;
        }
        this.timeFormat.isDefault = bl;
        if (bl2) {
            this.setChanged(true, 2);
        }
    }

    public boolean getTimeFormatIsDefault() {
        return this.timeFormat.isDefault;
    }

    public void setVertical(boolean bl) {
        if (this.vertical == bl) {
            return;
        }
        this.vertical = bl;
        this.i_vertical = bl;
        this.setChanged(true, 2);
    }

    protected void setVerticalInternal(boolean bl) {
        if (this.i_vertical == bl) {
            return;
        }
        this.i_vertical = bl;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setGap(int n2) {
        if (this.gap == n2) {
            return;
        }
        this.gap = n2;
        this.setChanged(true, 2);
    }

    public int getGap() {
        return this.gap;
    }

    public void setDropOverlappingLabels(boolean bl) {
        AnnotationHandler annotationHandler = this.getAnnotationHandler();
        if (annotationHandler.dropOverlappingLabels == bl) {
            return;
        }
        annotationHandler.dropOverlappingLabels = bl;
        this.setChanged(true, 2);
    }

    public boolean getDropOverlappingLabels() {
        return this.getAnnotationHandler().dropOverlappingLabels;
    }

    private JCValueLabel getValueLabel(Vector<JCValueLabel> vector, double d2) {
        if (vector == null) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        double d3 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            JCValueLabel jCValueLabel2 = vector.elementAt(i2);
            if (d2 == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            double d4 = Math.abs(d2 - jCValueLabel2.value);
            if (!(d4 < d3)) continue;
            jCValueLabel = jCValueLabel2;
            d3 = d4;
        }
        return jCValueLabel;
    }

    public JCValueLabel getValueLabel(double d2) {
        return this.getValueLabel(this.annoHandler.userValueLabels, d2);
    }

    public JCValueLabel getGeneratedValueLabel(double d2) {
        return this.getValueLabel(this.annoHandler.valueLabels, d2);
    }

    public void addValueLabel(JCValueLabel jCValueLabel) {
        int n2 = -1;
        int n3 = -1;
        for (int i2 = 0; i2 < this.annoHandler.userValueLabels.size(); ++i2) {
            JCValueLabel jCValueLabel2 = this.annoHandler.userValueLabels.elementAt(i2);
            if (jCValueLabel2.value > jCValueLabel.value && n3 < 0) {
                n3 = i2;
                break;
            }
            if (jCValueLabel2.value != jCValueLabel.value) continue;
            n2 = i2;
            break;
        }
        if (n2 >= 0) {
            this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n2);
        } else if (n3 >= 0) {
            this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n3);
        } else {
            this.annoHandler.userValueLabels.addElement(jCValueLabel);
        }
        jCValueLabel.setParent(this);
        this.setChanged(true, 2);
    }

    public void removeValueLabel(int n2) {
        this.annoHandler.userValueLabels.remove(n2);
        this.setChanged(true, 2);
    }

    public JCValueLabel[] getValueLabels() {
        if (this.annoHandler.userValueLabels == null || this.annoHandler.userValueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.userValueLabels.size()];
        for (int i2 = 0; i2 < jCValueLabelArray.length; ++i2) {
            jCValueLabelArray[i2] = this.annoHandler.userValueLabels.elementAt(i2);
        }
        return jCValueLabelArray;
    }

    public Vector<JCValueLabel> getUserValueLabels() {
        return this.annoHandler.userValueLabels;
    }

    public JCValueLabel[] getGeneratedValueLabels() {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.valueLabels.size()];
        for (int i2 = 0; i2 < jCValueLabelArray.length; ++i2) {
            jCValueLabelArray[i2] = this.annoHandler.valueLabels.elementAt(i2);
        }
        return jCValueLabelArray;
    }

    public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
        this.annoHandler.userValueLabels = new Vector();
        if (jCValueLabelArray == null) {
            return;
        }
        for (JCValueLabel jCValueLabel : jCValueLabelArray) {
            if (jCValueLabel != null) {
                jCValueLabel.setParent(this);
            }
            this.annoHandler.userValueLabels.addElement(jCValueLabel);
        }
        this.annoHandler.sortValueLabels();
        this.setChanged(true, 2);
    }

    public JCValueLabel getValueLabels(int n2) {
        Vector<JCValueLabel> vector = this.annoHandler.userValueLabels;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        if (n2 < 0 || n2 >= vector.size()) {
            return null;
        }
        return vector.elementAt(n2);
    }

    public JCValueLabel getGeneratedValueLabels(int n2) {
        Vector<JCValueLabel> vector = this.annoHandler.valueLabels;
        if (vector == null || vector.size() == 0) {
            return null;
        }
        if (n2 < 0 || n2 >= vector.size()) {
            return null;
        }
        return vector.elementAt(n2);
    }

    public void setValueLabels(int n2, JCValueLabel jCValueLabel) {
        if (this.annoHandler.userValueLabels == null) {
            this.annoHandler.userValueLabels = new Vector();
        }
        if (n2 < 0 || n2 > this.annoHandler.userValueLabels.size()) {
            throw new IllegalArgumentException("Invalid ValueLabels index in JCAxis");
        }
        if (jCValueLabel != null) {
            jCValueLabel.setParent(this);
        }
        if (n2 < this.annoHandler.userValueLabels.size()) {
            this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n2);
        } else {
            this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n2);
        }
        this.setChanged(true, 2);
    }

    public String toString() {
        String string = this.getName();
        String string2 = JCChartBundle.string("com.klg.jclass.chart.Key141", this.locale);
        String string3 = this.i_vertical ? JCChartBundle.string("com.klg.jclass.chart.Key147", this.locale) : JCChartBundle.string("com.klg.jclass.chart.Key44", this.locale);
        String string4 = JCChartBundle.string("com.klg.jclass.chart.Key6", this.locale);
        return string == null ? string2 + string3 + " " + string4 : string;
    }

    public int toPixel(double d2) {
        return this.toPixelInternal(d2, AxisHandler.ClusterAdjustment.NONE);
    }

    protected int toPixelInternal(double d2, AxisHandler.ClusterAdjustment clusterAdjustment) {
        AxisHandler axisHandler = this.getAxisHandler();
        if (axisHandler instanceof RectangularChartAxisHandler) {
            RectangularChartAxisHandler rectangularChartAxisHandler = (RectangularChartAxisHandler)axisHandler;
            return rectangularChartAxisHandler.toPixelInternal(d2, clusterAdjustment);
        }
        return Integer.MAX_VALUE;
    }

    public double toPixelDouble(double d2) {
        AxisHandler axisHandler = this.getAxisHandler();
        if (axisHandler instanceof RectangularChartAxisHandler) {
            RectangularChartAxisHandler rectangularChartAxisHandler = (RectangularChartAxisHandler)axisHandler;
            return rectangularChartAxisHandler.toPixelDouble(d2);
        }
        return Double.MAX_VALUE;
    }

    public Point toPixelPolar(double d2, double d3, boolean bl) {
        Point point = null;
        AxisHandler axisHandler = null;
        if (this.i_vertical) {
            axisHandler = this.getAxisHandler();
        } else if (this.otherAxis != null) {
            axisHandler = this.otherAxis.getAxisHandler();
        }
        if (axisHandler instanceof CircularChartAxisHandler) {
            CircularChartAxisHandler circularChartAxisHandler = (CircularChartAxisHandler)axisHandler;
            point = circularChartAxisHandler.toPixelPolar(d2, d3, bl);
        }
        return point;
    }

    protected double applyDataToPixelScaling(double d2) {
        double d3 = Double.MAX_VALUE;
        if (this.i_vertical) {
            d3 = this.getAxisHandler().scale * d2;
        } else if (this.otherAxis != null) {
            d3 = this.otherAxis.getAxisHandler().scale * d2;
        }
        return d3;
    }

    protected double applyPixelToDataScaling(double d2) {
        double d3 = Double.MAX_VALUE;
        if (this.i_vertical) {
            d3 = d2 / this.getAxisHandler().scale;
        } else if (this.otherAxis != null) {
            d3 = d2 / this.otherAxis.getAxisHandler().scale;
        }
        return d3;
    }

    public int toPixel(double d2, boolean bl) {
        return this.toPixelInternal(d2, bl, AxisHandler.ClusterAdjustment.NONE);
    }

    protected int toPixelInternal(double d2, boolean bl, AxisHandler.ClusterAdjustment clusterAdjustment) {
        int n2 = 0;
        if (this.chartArea != null) {
            int n3 = n2 = this.i_vertical ? this.chartArea.getDeltaY() : this.chartArea.getDeltaX();
        }
        if (this.frontPlane && !bl) {
            return this.toPixelInternal(d2, clusterAdjustment) + n2;
        }
        if (!this.frontPlane && bl) {
            return this.toPixelInternal(d2, clusterAdjustment) - n2;
        }
        return this.toPixelInternal(d2, clusterAdjustment);
    }

    public double toPixelDouble(double d2, boolean bl) {
        int n2 = 0;
        if (this.chartArea != null) {
            int n3 = n2 = this.i_vertical ? this.chartArea.getDeltaY() : this.chartArea.getDeltaX();
        }
        if (this.frontPlane && !bl) {
            return this.toPixelDouble(d2) + (double)n2;
        }
        if (!this.frontPlane && bl) {
            return this.toPixelDouble(d2) - (double)n2;
        }
        return this.toPixelDouble(d2);
    }

    public double toData(int n2) {
        AxisHandler axisHandler = this.getAxisHandler();
        if (axisHandler instanceof RectangularChartAxisHandler) {
            return ((RectangularChartAxisHandler)axisHandler).toData(n2);
        }
        return Double.MAX_VALUE;
    }

    public double toData(int n2, boolean bl) {
        int n3 = 0;
        if (this.chartArea != null) {
            int n4 = n3 = this.i_vertical ? this.chartArea.getDeltaY() : this.chartArea.getDeltaX();
        }
        if (this.frontPlane && !bl) {
            return this.toData(n2 - n3);
        }
        if (!this.frontPlane && bl) {
            return this.toData(n2 + n3);
        }
        return this.toData(n2);
    }

    public JCDataCoord toDataPolar(int n2, int n3) {
        JCDataCoord jCDataCoord = null;
        AxisHandler axisHandler = null;
        if (this.i_vertical) {
            axisHandler = this.getAxisHandler();
        } else if (this.otherAxis != null) {
            axisHandler = this.otherAxis.getAxisHandler();
        }
        if (axisHandler instanceof CircularChartAxisHandler) {
            jCDataCoord = ((CircularChartAxisHandler)axisHandler).toDataPolar(n2, n3);
        }
        return jCDataCoord;
    }

    @Override
    public void draw(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (graphics == null) {
            return;
        }
        DefineShape defineShape = null;
        if (graphics instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics);
            defineShape.beginShape();
        }
        this.axisDrawn = false;
        this.axisDrawn = this.i_vertical ? this.drawVertical(graphics) : this.drawHorizontal(graphics);
        if (defineShape != null) {
            defineShape.endShape(true);
        }
    }

    public void drawAnnotationsAndTitle(Graphics graphics) {
        this.drawAnnotationsAndTitle(graphics, true, true, false);
    }

    public void drawAnnotationsAndTitle(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        Graphics graphics2;
        if (!this.visible || !bl && !bl2) {
            return;
        }
        Graphics graphics3 = graphics2 = graphics == null ? null : graphics.create();
        if (this.axisDrawn || bl3) {
            if (bl) {
                this.annoHandler.draw(graphics2);
            }
            if (bl2 && this.title != null && !this.isPolar() && !this.isRadar()) {
                this.title.draw(graphics2);
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
    }

    @Override
    public void setBounds(int n2, int n3, int n4, int n5) {
        if (this.getLeft() == n2 && this.getTop() == n3 && this.getWidth() == n4 && this.getHeight() == n5) {
            return;
        }
        super.setBounds(n2, n3, n4, n5);
        this.setChanged(true, 2, false);
        this.calcTransformation();
    }

    protected boolean isTimelineAbscissa() {
        List<ChartDataView> list = this.getParentChart().getOriginalDataView();
        if (list != null) {
            for (ChartDataView chartDataView : list) {
                if (chartDataView.getXAxis() != this || chartDataView.getChartType() != 13) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTimelineOrdinateAxis() {
        List<ChartDataView> list = this.getParentChart().getOriginalDataView();
        if (list != null) {
            for (ChartDataView chartDataView : list) {
                if (chartDataView.getYAxis() != this || chartDataView.getChartType() != 13) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void recalc() {
        this.fTimelineXAxis = this.isTimelineAbscissa();
        this.fTimelineYAxis = this.isTimelineOrdinateAxis();
        this.setChanged(false, 0, false);
    }

    public double dateToValue(Date date) {
        this.getTimeBase();
        return this.annoHandler.timeToData(date, this.timeUnit);
    }

    public Date valueToDate(double d2) {
        this.getTimeBase();
        return this.annoHandler.dataToTime(d2, this.timeUnit);
    }

    protected void preDrawCalc() {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            int[] nArray = new int[5];
            int[] nArray2 = new int[5];
            if (this.i_vertical) {
                nArray[0] = nArray[1] = this.linePosition();
                nArray2[0] = this.getTop() + this.getHeight();
                nArray2[1] = this.getTop();
                nArray[3] = nArray[2] = nArray[1] + this.chartArea.getDeltaX();
                nArray2[2] = nArray2[1] + this.chartArea.getDeltaY();
                nArray2[3] = nArray2[0] + this.chartArea.getDeltaY();
            } else {
                nArray[0] = this.getLeft() + this.getWidth();
                nArray[1] = this.getLeft();
                nArray2[0] = nArray2[1] = this.linePosition();
                nArray[2] = nArray[1] + this.chartArea.getDeltaX();
                nArray2[2] = nArray2[3] = nArray2[1] + this.chartArea.getDeltaY();
                nArray[3] = nArray[0] + this.chartArea.getDeltaX();
            }
            nArray[4] = nArray[0];
            nArray2[4] = nArray2[0];
            this.sideplane = new Polygon();
            for (int i2 = 0; i2 < 5; ++i2) {
                this.sideplane.addPoint(nArray[i2], nArray2[i2]);
            }
        }
    }

    protected void preDraw(Graphics graphics, boolean bl, boolean bl2) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            Serializable serializable;
            Color color = null;
            PlotArea plotArea = this.chartArea.getPlotArea();
            if (plotArea.isOpaque()) {
                color = this.chartArea.isOpaque() && plotArea.getOpaqueIsDefault() ? this.chartArea.getBackground() : plotArea.getBackground();
            } else {
                for (serializable = this.chartArea; serializable != null && serializable instanceof JComponent && !((Component)serializable).isOpaque(); serializable = ((Component)serializable).getParent()) {
                }
                if (serializable != null && serializable instanceof JComponent && ((Component)serializable).isOpaque()) {
                    color = ((Component)serializable).getBackground();
                } else if (serializable != null && !(serializable instanceof JComponent)) {
                    color = ((Component)serializable).getBackground();
                }
            }
            if (color == null) {
                return;
            }
            serializable = new JCFillStyle(color, 1);
            if (bl) {
                if (!this.i_vertical && this.chartArea.getDeltaY() <= 0 || this.i_vertical && this.chartArea.getDeltaX() <= 0) {
                    ((com.klg.jclass.util.style.JCFillStyle)serializable).fillPolygonHighlight(graphics, this.sideplane);
                } else {
                    ((com.klg.jclass.util.style.JCFillStyle)serializable).fillPolygonShadow(graphics, this.sideplane);
                }
            } else {
                int n2;
                int n3 = n2 = this.otherAxis != null ? this.otherAxis.linePosition() : 0;
                if (bl2) {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.i_vertical) {
                        polygon.ypoints[1] = n2;
                        polygon.ypoints[2] = n2 + this.chartArea.getDeltaY();
                    } else {
                        polygon.xpoints[0] = n2;
                        polygon.xpoints[4] = n2;
                        polygon.xpoints[3] = n2 + this.chartArea.getDeltaX();
                    }
                    if (!this.i_vertical && this.chartArea.getDeltaY() <= 0 || this.i_vertical && this.chartArea.getDeltaX() <= 0) {
                        ((com.klg.jclass.util.style.JCFillStyle)serializable).fillPolygonHighlight(graphics, polygon);
                    } else {
                        ((com.klg.jclass.util.style.JCFillStyle)serializable).fillPolygonShadow(graphics, polygon);
                    }
                } else {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.i_vertical) {
                        polygon.ypoints[0] = n2;
                        polygon.ypoints[4] = n2;
                        polygon.ypoints[3] = n2 + this.chartArea.getDeltaY();
                    } else {
                        polygon.xpoints[1] = n2;
                        polygon.xpoints[2] = n2 + this.chartArea.getDeltaX();
                    }
                    if (!this.i_vertical && this.chartArea.getDeltaY() <= 0 || this.i_vertical && this.chartArea.getDeltaX() <= 0) {
                        ((com.klg.jclass.util.style.JCFillStyle)serializable).fillPolygonHighlight(graphics, polygon);
                    } else {
                        ((com.klg.jclass.util.style.JCFillStyle)serializable).fillPolygonShadow(graphics, polygon);
                    }
                }
            }
        }
    }

    protected void preDrawOutlineTrough(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            jCFillStyle.drawOutlinePolygon(graphics, this.sideplane, this.getForeground());
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void postDrawOutlineTrough(Graphics graphics, int n2) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D() && this.sideplane != null) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            boolean bl = this.isPrimary && this.i_vertical || !this.isPrimary && !this.i_vertical;
            boolean bl2 = this.isReversed();
            if (!bl && !bl2 && (n2 & 1) != 0 || !bl && bl2 && (n2 & 2) != 0 || bl && !bl2 && (n2 & 2) != 0 || bl && bl2 && (n2 & 1) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 1, 2, this.getForeground());
            }
            if (!bl && !bl2 && (n2 & 2) != 0 || !bl && bl2 && (n2 & 1) != 0 || bl && !bl2 && (n2 & 1) != 0 || bl && bl2 && (n2 & 2) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 3, 4, this.getForeground());
            }
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void clearLimits() {
        this.dataLimits = null;
        this.originalDataLimits = null;
    }

    protected void setLimits(MinMax minMax) {
        if (this.dataLimits == null) {
            this.dataLimits = new MinMax();
        }
        this.dataLimits.union(minMax);
        if (this.dataLimits.min > this.dataLimits.max) {
            this.dataLimits = null;
        }
    }

    protected void setOriginalLimits(MinMax minMax) {
        if (this.originalDataLimits == null) {
            this.originalDataLimits = new MinMax();
        }
        this.originalDataLimits.union(minMax);
        if (this.originalDataLimits.min > this.originalDataLimits.max) {
            this.originalDataLimits = null;
        }
    }

    protected void setInitialSize() {
        if (this.i_vertical) {
            this.setBounds(0, 0, 30, this.chartArea.getSize().height);
        } else {
            this.setBounds(0, this.chartArea.getSize().height - 30, this.chartArea.getSize().width, 30);
        }
    }

    public boolean isTimelineXAxis() {
        return this.fTimelineXAxis;
    }

    public boolean isTimelineYAxis() {
        return this.fTimelineYAxis;
    }

    protected void calcAxisParams(boolean bl) {
        boolean bl2;
        this.setInitialSize();
        this.chartType = -1;
        JCAxis jCAxis = this;
        boolean bl3 = bl2 = this.formula != null && this.formula.getOriginator() != null;
        if (bl2) {
            jCAxis = this.formula.getOriginator();
        }
        this.hasBar = false;
        boolean bl4 = false;
        for (ChartDataView chartDataView : this.getParentChart().getOriginalDataView()) {
            int n2;
            this.usingDoublePixels = chartDataView.isUsingDoublePixels();
            if (chartDataView.getXAxis() == jCAxis) {
                n2 = chartDataView.getChartType();
                if (!bl4) {
                    this.chartType = n2;
                    this.isPrimary = !bl2;
                    this.otherAxis = chartDataView.getYAxis();
                    bl4 = true;
                }
                if (!(bl2 || n2 != 9 && n2 != 10)) {
                    this.hasBar = true;
                }
            }
            if (chartDataView.getYAxis() != jCAxis) continue;
            n2 = chartDataView.getChartType();
            if (!bl4) {
                this.chartType = n2;
                this.isPrimary = false;
                this.otherAxis = chartDataView.getXAxis();
                bl4 = true;
            }
            if (bl2 || n2 != 9 && n2 != 10) continue;
            this.hasBar = true;
        }
        this.frontPlane = this.hasBar || !this.is3D();
        this.getAxisHandler().calcParams();
        this.recalc();
    }

    protected void checkAnnotations() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.checkAnnotations();
    }

    protected void calcAnchors() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.calcAnchor();
        if (this.title.visible) {
            this.title.recalc(true);
            this.title.fixPlacement(this);
        }
    }

    protected void calcAnnotationExtents() {
        this.calcAnnotationExtents(false);
    }

    protected void calcAnnotationExtents(boolean bl) {
        this.annoHandler.calcAnnotationExtents(this.annoList, bl);
    }

    protected boolean isRightSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed();
        }
        return this.i_vertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    protected boolean isLeftSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed();
        }
        return this.i_vertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    protected boolean isBottomSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed();
        }
        return !this.i_vertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    protected boolean isTopSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.isReversed();
        }
        return !this.i_vertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    protected void adjustForOrthoExtent() {
        if (!this.visible) {
            return;
        }
        if (this.annoHandler.realPlacement == 1 || this.annoHandler.realPlacement == 2) {
            return;
        }
        if (this.placementAxis == null) {
            return;
        }
        Rectangle rectangle = this.chartArea.getPlotRect();
        Rectangle rectangle2 = this.chartArea.getChartAreaRect();
        if (this.i_vertical) {
            int n2 = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n2 < this.placementAxis.getLeft() || n2 > this.placementAxis.getLeft() + this.placementAxis.getWidth()) {
                return;
            }
            if (n2 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getLeftIsDefault()) {
                    int n3 = this.annoHandler.extents.ortho - n2;
                    rectangle.width -= n3;
                    rectangle.x += n3;
                }
                this.setSize(this.annoHandler.extents.ortho, this.getHeight());
            } else if (rectangle2.width - n2 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getRightIsDefault()) {
                    int n4 = this.annoHandler.extents.ortho - (rectangle2.width - n2);
                    rectangle.width -= n4;
                }
                this.setSize(this.annoHandler.extents.ortho, this.getHeight());
            }
        } else {
            int n5 = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n5 < this.placementAxis.getTop() || n5 > this.placementAxis.getTop() + this.placementAxis.getHeight()) {
                return;
            }
            if (rectangle2.height - n5 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getBottomIsDefault()) {
                    int n6 = this.annoHandler.extents.ortho - (rectangle2.height - n5);
                    rectangle.height -= n6;
                }
                this.setSize(this.getWidth(), this.annoHandler.extents.ortho);
            } else if (n5 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getTopIsDefault()) {
                    int n7 = this.annoHandler.extents.ortho - n5;
                    rectangle.height -= n7;
                    rectangle.y += n7;
                }
                this.setSize(this.getWidth(), this.annoHandler.extents.ortho);
            }
        }
    }

    protected void setPolarAxisParams(PolarAxisParams polarAxisParams) {
        this.polarAxisParams = polarAxisParams;
    }

    protected PolarAxisParams getPolarAxisParams() {
        return this.polarAxisParams;
    }

    protected void layoutPolarAxis() {
        double d2;
        if (!this.isPolar() && !this.isRadar()) {
            return;
        }
        Rectangle rectangle = this.chartArea.getChartAreaRect();
        double d3 = rectangle.width;
        double d4 = rectangle.height;
        double d5 = 0.95;
        if (this.isRadar() && !this.polarAxisParams.isCircularGrid()) {
            d5 = 1.414;
        }
        if (Math.abs(this.polarAxisParams.radius - (d2 = d5 * Math.min(d3, d4) / 2.0)) < 1.0) {
            return;
        }
        this.polarAxisParams.radius = d2;
        this.polarAxisParams.xCenter = (double)rectangle.x + d3 / 2.0;
        this.polarAxisParams.yCenter = (double)rectangle.y + d4 / 2.0;
        this.chartArea.recalc();
    }

    protected void adjustCenterAndRadius(int n2, int n3, int n4) {
        this.polarAxisParams.xCenter += (double)n2;
        this.polarAxisParams.yCenter += (double)n3;
        this.polarAxisParams.radius += (double)n4;
        this.getAxisHandler().calcTransformation();
    }

    protected AnnoBoundsInfo getPolarAnnotationBounds() {
        AnnotationHandler annotationHandler = this.getAnnotationHandler();
        if (annotationHandler instanceof CircularChartAnnoHandler) {
            CircularChartAnnoHandler circularChartAnnoHandler = (CircularChartAnnoHandler)annotationHandler;
            return circularChartAnnoHandler.getPolarAnnotationBounds();
        }
        return null;
    }

    protected int getThetaAxisLabelOffset() {
        if (this.i_vertical) {
            CircularChartAnnoHandler circularChartAnnoHandler = (CircularChartAnnoHandler)this.otherAxis.getAnnotationHandler();
            return circularChartAnnoHandler.thetaAxisLabelOffset;
        }
        CircularChartAnnoHandler circularChartAnnoHandler = (CircularChartAnnoHandler)this.getAnnotationHandler();
        return circularChartAnnoHandler.thetaAxisLabelOffset;
    }

    protected void layoutAxis(boolean bl) {
        int n2 = Math.max(-this.chartArea.getDeltaX(), 0);
        int n3 = Math.max(-this.chartArea.getDeltaY(), 0);
        int n4 = this.chartArea.getDeltaX();
        int n5 = this.chartArea.getDeltaY();
        int n6 = bl ? 1 : 0;
        Rectangle rectangle = this.chartArea.getPlotRect();
        if (this.i_vertical) {
            if (!this.isPolar() && !this.isRadar()) {
                if (!this.is3D()) {
                    this.setBounds(this.getLeft(), rectangle.y, this.getWidth(), rectangle.height);
                } else if (this.isBar()) {
                    if (this.getLeft() < rectangle.x) {
                        this.setBounds(this.getLeft() + n2 * n6, rectangle.y + n3, this.getWidth(), rectangle.height - JCChartUtil.abs(n5));
                    } else {
                        n2 = Math.max(this.chartArea.getDeltaX(), 0);
                        this.setBounds(this.getLeft() - n2 * n6, rectangle.y + n3, this.getWidth(), rectangle.height - JCChartUtil.abs(n5));
                    }
                } else {
                    n3 = Math.max(this.chartArea.getDeltaY(), 0);
                    if (this.getLeft() <= rectangle.x) {
                        n2 = Math.max(this.chartArea.getDeltaX(), 0);
                        this.setBounds(rectangle.x + n2 * n6 - this.getWidth(), rectangle.y + n3, this.getWidth(), rectangle.height - JCChartUtil.abs(n5));
                    } else {
                        this.setBounds(rectangle.x + rectangle.width - n2 * n6, rectangle.y + n3, this.getWidth(), rectangle.height - JCChartUtil.abs(n5));
                    }
                }
            }
        } else if (this.isPolar() || this.isRadar()) {
            this.layoutPolarAxis();
        } else if (!this.is3D()) {
            this.setBounds(rectangle.x, this.getTop(), rectangle.width, this.getHeight());
        } else if (this.isBar()) {
            if (this.getTop() <= rectangle.y) {
                this.setBounds(rectangle.x + n2, this.getTop() + n3 * n6, rectangle.width - JCChartUtil.abs(n4), this.getHeight());
            } else {
                n3 = Math.max(this.chartArea.getDeltaY(), 0);
                this.setBounds(rectangle.x + n2, this.getTop() - n3 * n6, rectangle.width - JCChartUtil.abs(n4), this.getHeight());
            }
        } else {
            n2 = Math.max(this.chartArea.getDeltaX(), 0);
            if (this.getTop() <= rectangle.y) {
                n3 = Math.max(this.chartArea.getDeltaY(), 0);
                this.setBounds(rectangle.x + n2, rectangle.y + n3 * n6 - this.getHeight(), rectangle.width - JCChartUtil.abs(n4), this.getHeight());
            } else {
                this.setBounds(rectangle.x + n2, rectangle.y + rectangle.height - n3 * n6, rectangle.width - JCChartUtil.abs(n4), this.getHeight());
            }
        }
    }

    protected void layoutOrigin() {
        int n2 = this.annoHandler.realPlacement;
        if (n2 != 5 && n2 != 4) {
            return;
        }
        if (this.placementAxis == null) {
            this.placementAxis = this.otherAxis;
        }
        if (this.placementAxis == null) {
            return;
        }
        double d2 = n2 == 4 ? this.placementLocation : this.placementAxis.origin.value;
        int n3 = this.placementAxis.toPixel(d2);
        if (this.i_vertical) {
            if (this.annoHandler.anchor == 1) {
                this.setLocation(n3, this.getTop());
            } else {
                this.setLocation(n3 - this.getWidth(), this.getTop());
            }
        } else if (this.annoHandler.anchor == 16) {
            this.setLocation(this.getLeft(), n3 - this.getHeight());
        } else {
            this.setLocation(this.getLeft(), n3);
        }
    }

    protected void layoutAnnotations() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.layout();
        if (this.title != null) {
            this.title.layout();
        }
    }

    protected boolean doUserProvidedLabelsFit() {
        return this.annoHandler.doUserProvidedLabelsFit();
    }

    protected int pixelLength() {
        int n2 = (this.isPolar() || this.isRadar()) && this.i_vertical ? (int)Math.round(this.polarAxisParams.radius) : (this.i_vertical ? this.getHeight() : this.getWidth());
        return n2;
    }

    protected int pixelStart() {
        return this.i_vertical ? -this.getTop() : this.getLeft();
    }

    protected void calcTransformation() {
        this.getAxisHandler().calcTransformation();
    }

    protected int linePosition() {
        int n2 = this.i_vertical ? (this.annoHandler.anchor == 2 ? this.getLeft() + this.getWidth() : (this.annoHandler.anchor == 1 ? this.getLeft() : this.getLeft() + this.getWidth() / 2)) : (this.annoHandler.anchor == 16 ? this.getTop() + this.getHeight() : (this.annoHandler.anchor == 32 ? this.getTop() : this.getTop() + this.getHeight() / 2));
        return n2;
    }

    protected void makeAnnotations() {
        this.annoHandler.makeAnnotations();
    }

    protected AxisHandler getAxisHandler() {
        boolean bl;
        boolean bl2 = this.isPolar() || this.isRadar();
        boolean bl3 = bl = bl2 && !this.i_vertical;
        if (this.axisHandler == null || bl2 && this.axisHandler instanceof RectangularChartAxisHandler || !bl2 && this.axisHandler instanceof CircularChartAxisHandler || bl && this.axisHandler instanceof CircularChartLogAxisHandler || this.logarithmic && !(this.axisHandler instanceof LogAxisHandler) || !this.logarithmic && this.axisHandler instanceof LogAxisHandler) {
            this.axisHandler = AxisHandler.makeAxisHandler(this);
            this.updateAnnoHandler(this.chartType);
        }
        return this.axisHandler;
    }

    protected Extents getExtents() {
        return this.annoHandler.extents;
    }

    protected Vector<JCValueLabel> getAnnotations() {
        return this.annoHandler.valueLabels;
    }

    protected int getAdjustedRealPlacement() {
        if (this.otherAxis != null && this.otherAxis.isReversed()) {
            if (this.annoHandler.realPlacement == 1) {
                return 2;
            }
            return 1;
        }
        return this.annoHandler.realPlacement;
    }

    protected double getRealPlacementLocation() {
        switch (this.annoHandler.realPlacement) {
            case 1: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMin();
            }
            case 2: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMax();
            }
            case 5: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getOrigin();
            }
            case 4: {
                return this.getPlacementLocation();
            }
        }
        return Double.MAX_VALUE;
    }

    protected int getAnnotationAnchor() {
        return this.annoHandler.anchor;
    }

    protected double firstGridInc(double d2) {
        double d3 = this.firstInc(d2);
        double d4 = d3 - this.min.value;
        if (d4 >= d2) {
            d3 -= d2 * Math.floor(d4 / d2);
        }
        return d3;
    }

    protected double firstInc(double d2) {
        double d3 = this.min.value;
        if (d2 == 0.0) {
            return d3;
        }
        d3 = JCChartUtil.precCorrect(this.getPrecision(), d3);
        int n2 = (int)Math.ceil((this.min.value - d3) / d2);
        if (n2 < 0) {
            return d3;
        }
        double d4 = d3 + d2 * (double)n2;
        d4 = JCChartUtil.precCorrect(this.getPrecision(), d4);
        if (d4 > this.max.value) {
            return d3;
        }
        return d4;
    }

    protected double range() {
        return this.getAxisHandler().range();
    }

    protected void translate(double d2) {
        this.getAxisHandler().translate(d2);
        this.setChanged(true, 2, false);
    }

    public boolean isPolar() {
        return this.chartType == 2;
    }

    public boolean isRadar() {
        return this.chartType == 3 || this.chartType == 4;
    }

    public boolean isPolarRadar() {
        return this.chartType == 2 || this.chartType == 3 || this.chartType == 4;
    }

    protected boolean isPolarRadar(int n2) {
        return n2 == 2 || n2 == 3 || n2 == 4;
    }

    public boolean isBar() {
        return this.hasBar;
    }

    private boolean is3D() {
        return this.chartArea != null && this.chartArea.getDraw3D();
    }

    private double dataLength() {
        return this.max.value - this.min.value;
    }

    private void drawGrid(Graphics graphics, boolean bl, double d2, double d3) {
        if (!this.gridVisible) {
            return;
        }
        if (this.gridDefault) {
            JCGrid jCGrid;
            if (this.gridList.size() > 0 && (jCGrid = this.gridList.get(0)) != null) {
                this.drawGridLinesAtLabels(graphics, jCGrid, bl, d2, d3);
            }
        } else {
            for (JCGrid jCGrid : this.gridList) {
                if (jCGrid == null) continue;
                this.drawLinearGridLines(graphics, jCGrid, bl, d2, d3);
            }
        }
    }

    protected void drawGrid(Graphics graphics) {
        this.drawGrid(graphics, false, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    protected void drawGridInTrough(Graphics graphics, double d2, double d3) {
        this.drawGrid(graphics, true, d2, d3);
    }

    protected double[] getGridLineList() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (JCGrid object2 : this.gridList) {
            if (object2 == null) continue;
            ArrayList<Double> i2 = this.isGridDefault() ? this.getGridLinesAtLabelsList() : this.getLinearGridLinesList(object2);
            arrayList.addAll(i2);
        }
        Object[] objectArray = arrayList.toArray();
        double[] dArray = new double[objectArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = (Double)objectArray[i2];
        }
        return dArray;
    }

    private void drawGridLine(Graphics graphics, JCLineStyle jCLineStyle, double d2) {
        boolean bl;
        double d3 = Double.MAX_VALUE;
        boolean bl2 = bl = this.isPolar() || this.isRadar();
        if (!bl) {
            d3 = this.usingDoublePixels ? this.toPixelDouble(d2) : (double)this.toPixel(d2);
        }
        Rectangle rectangle = this.chartArea.getPlotRect();
        int n2 = this.chartArea.getDeltaX();
        int n3 = this.chartArea.getDeltaY();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.i_vertical) {
            boolean bl3;
            boolean bl4 = bl3 = this.otherAxis == null || !this.otherAxis.visible;
            if (bl) {
                double d4 = this.getAxisHandler().scale;
                double d5 = 0.0;
                if (this.reversed) {
                    if (this.isLogarithmic()) {
                        if (this.max.value > 0.0 && d2 > 0.0) {
                            d5 = -d4 * (JCChartUtil.log10(this.max.value) - JCChartUtil.log10(d2));
                        }
                    } else {
                        d5 = -d4 * (this.max.value - d2);
                    }
                } else if (this.isLogarithmic()) {
                    if (this.min.value > 0.0 && d2 > 0.0) {
                        d5 = d4 * (JCChartUtil.log10(d2) - JCChartUtil.log10(this.min.value));
                    }
                } else {
                    d5 = d4 * (d2 - this.min.value);
                }
                if (this.isPolar() && (bl3 || d5 != Math.rint(this.polarAxisParams.radius)) || this.isRadar() && this.polarAxisParams.circularGridLines) {
                    jCLineStyle.drawCircle(graphics, (int)Math.round(this.polarAxisParams.xCenter), (int)Math.round(this.polarAxisParams.yCenter), (int)Math.round(d5));
                } else if (this.isRadar() && !this.polarAxisParams.circularGridLines) {
                    AnnotationHandler annotationHandler = this.otherAxis != null ? this.otherAxis.annoHandler : null;
                    int n4 = annotationHandler != null ? annotationHandler.valueLabels.size() : 0;
                    this.drawWebLine(graphics, jCLineStyle, d5, n4);
                }
            } else {
                int n5 = this.reversed ? 1 : -1;
                boolean bl5 = this.annotationMethod == 0;
                int n6 = bl5 ? this.toPixel(this.max.value) + n5 : rectangle.y + rectangle.height + n5;
                int n7 = bl5 ? this.toPixel(this.min.value) : rectangle.y;
                int n8 = this.is3D() ? n3 : 0;
                int n9 = bl3 ? 1 : 0;
                Rectangle rectangle2 = graphics.getClipBounds();
                graphics.clipRect(rectangle2.x, Math.min(n6, n7) + n8, rectangle2.width, Math.abs(n6 - n7) + n9);
                if (this.is3D()) {
                    if (!this.frontPlane) {
                        n3 = 0;
                    }
                    if (n2 < 0) {
                        graphics2D.draw(new Line2D.Double(rectangle.x, d3 + (double)n3, rectangle.x + rectangle.width + n2, d3 + (double)n3));
                    } else {
                        graphics2D.draw(new Line2D.Double(rectangle.x + n2, d3 + (double)n3, rectangle.x + rectangle.width, d3 + (double)n3));
                    }
                } else {
                    graphics2D.draw(new Line2D.Double(rectangle.x, d3, rectangle.x + rectangle.width, d3));
                }
                graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        } else if (bl) {
            double d6 = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d2);
            if (d6 != Math.PI * 2) {
                this.drawRadialGridLine(graphics, d6);
            }
        } else {
            int n10 = this.isReversed() ? -1 : 1;
            boolean bl6 = this.annotationMethod == 0;
            int n11 = bl6 ? this.toPixel(this.max.value) + n10 : rectangle.x + rectangle.width + n10;
            int n12 = bl6 ? this.toPixel(this.min.value) : rectangle.x;
            int n13 = this.is3D() ? n2 : 0;
            Rectangle rectangle3 = graphics.getClipBounds();
            graphics.clipRect(Math.min(n11, n12) + n13, rectangle3.y, Math.abs(n11 - n12), rectangle3.height);
            if (this.is3D()) {
                if (!this.frontPlane) {
                    n2 = 0;
                }
                if (n3 < 0) {
                    graphics2D.draw(new Line2D.Double((double)n2 + d3, rectangle.y, (double)n2 + d3, rectangle.y + rectangle.height + n3));
                } else {
                    graphics2D.draw(new Line2D.Double((double)n2 + d3, rectangle.y + n3, (double)n2 + d3, rectangle.y + rectangle.height));
                }
            } else {
                graphics2D.draw(new Line2D.Double(d3, rectangle.y, d3, rectangle.y + rectangle.height));
            }
            graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    protected void drawRadialGridLine(Graphics graphics, double d2) {
        AxisHandler axisHandler = this.getAxisHandler();
        if (axisHandler instanceof CircularChartAxisHandler) {
            CircularChartAxisHandler circularChartAxisHandler = (CircularChartAxisHandler)axisHandler;
            Point point = circularChartAxisHandler.toPixelPolar(d2, 0.0, false);
            Point point2 = circularChartAxisHandler.toPixelPolar(d2, this.polarAxisParams.radius, false);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    protected void drawGridLineInTrough(Graphics graphics, JCLineStyle jCLineStyle, double d2) {
        double d3 = this.usingDoublePixels ? this.toPixelDouble(d2) : (double)this.toPixel(d2);
        int n2 = this.chartArea.getDeltaX();
        int n3 = this.chartArea.getDeltaY();
        if (this.i_vertical) {
            if (this.is3D() && this.isBar() && n2 != 0 && d3 >= (double)this.getTop() && d3 <= (double)(this.getTop() + this.getHeight())) {
                int n4 = this.linePosition();
                jCLineStyle.updateGraphics(graphics);
                ((Graphics2D)graphics).draw(new Line2D.Double(n4, d3, n4 + n2, d3 + (double)n3));
                jCLineStyle.resetGraphics(graphics);
            }
        } else if (this.is3D() && this.isBar() && n3 != 0 && d3 >= (double)this.getLeft() && d3 <= (double)(this.getLeft() + this.getWidth())) {
            int n5 = this.linePosition();
            jCLineStyle.updateGraphics(graphics);
            ((Graphics2D)graphics).draw(new Line2D.Double(d3, n5, d3 + (double)n2, n5 + n3));
            jCLineStyle.resetGraphics(graphics);
        }
    }

    private void drawLinearGridLines(Graphics graphics, JCGrid jCGrid, boolean bl, double d2, double d3) {
        double d4;
        int n2;
        if (jCGrid == null) {
            return;
        }
        double d5 = jCGrid.getStartValue();
        double d6 = jCGrid.getStopValue();
        double d7 = jCGrid.getIncrementValue();
        if (d7 * (double)(n2 = this.pixelLength()) / (d4 = this.dataLength()) + 0.5 < 2.0) {
            if (d7 <= 0.0) {
                this.setGridVisible(false);
            } else {
                String string = JCChartBundle.string("com.klg.jclass.chart.Key123", this.locale);
                JCChart jCChart = this.getParentChart();
                jCChart.getErrorLog().logErrorMessage(string);
            }
            return;
        }
        JCLineStyle jCLineStyle = jCGrid.getGridStyle().getLineStyle();
        if (!jCLineStyle.updateGraphics(graphics)) {
            return;
        }
        if (jCLineStyle.getColor() == null) {
            Color color = this.getForeground();
            if (color == null) {
                color = Color.black;
            }
            graphics.setColor(color);
        }
        for (double d8 = d5; d8 <= d6; d8 += d7) {
            if (this.isValueExcluded(d8)) continue;
            if (bl) {
                if (d2 != Double.MAX_VALUE && (!(d8 >= d2) || !(d8 <= d3))) continue;
                this.drawGridLineInTrough(graphics, jCLineStyle, d8);
                continue;
            }
            this.drawGridLine(graphics, jCLineStyle, d8);
        }
        jCLineStyle.resetGraphics(graphics);
    }

    private ArrayList<Double> getLinearGridLinesList(JCGrid jCGrid) {
        double d2 = jCGrid.getIncrementValue();
        int n2 = this.pixelLength();
        double d3 = this.dataLength();
        double d4 = d2 / 2.0;
        if (d4 < 0.0) {
            d4 = -d4;
        }
        if (d2 * (double)n2 / d3 + 0.5 < 2.0) {
            if (d2 <= 0.0) {
                this.setGridVisible(false);
            } else {
                JCChart jCChart = this.getParentChart();
                if (jCChart != null) {
                    String string = JCChartBundle.string("com.klg.jclass.chart.Key123", this.locale);
                    jCChart.getErrorLog().logErrorMessage(string);
                }
            }
            return new ArrayList<Double>();
        }
        int n3 = (int)Math.ceil((this.max.value + d4 - this.min.value) / d2);
        ArrayList<Double> arrayList = new ArrayList<Double>(n3);
        for (double d5 = this.firstGridInc(d2); d5 < this.max.value + d4; d5 += d2) {
            if (this.isValueExcluded(d5)) continue;
            arrayList.add(new Double(d5));
        }
        return arrayList;
    }

    private void drawGridLinesAtLabels(Graphics graphics, JCGrid jCGrid, boolean bl, double d2, double d3) {
        Serializable serializable;
        JCLineStyle jCLineStyle;
        JCLineStyle jCLineStyle2 = jCLineStyle = jCGrid != null ? jCGrid.getGridStyle().getLineStyle() : this.getGridStyle().getLineStyle();
        if (!jCLineStyle.updateGraphics(graphics)) {
            return;
        }
        if (jCLineStyle.getColor() == null) {
            serializable = this.getForeground();
            if (serializable == null) {
                serializable = Color.black;
            }
            graphics.setColor((Color)serializable);
        }
        serializable = this.annoHandler.valueLabels;
        int n2 = serializable.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCValueLabel jCValueLabel = (JCValueLabel)serializable.get(i2);
            if (jCValueLabel == null || !jCValueLabel.isDrawGrid() || !jCValueLabel.isDrawLabel() || !jCValueLabel.getChartText().isVisible()) continue;
            if (bl) {
                if (d2 != Double.MAX_VALUE && (!(jCValueLabel.value >= d2) || !(jCValueLabel.value <= d3))) continue;
                this.drawGridLineInTrough(graphics, jCLineStyle, jCValueLabel.value);
                continue;
            }
            if (this.isRadar() && !this.i_vertical) {
                double d4 = JCChartUtil.getRadarAngle(this.chartArea.getAngleUnit(), n2, i2, this.isReversed());
                this.drawGridLine(graphics, jCLineStyle, d4);
                continue;
            }
            this.drawGridLine(graphics, jCLineStyle, jCValueLabel.value);
        }
        jCLineStyle.resetGraphics(graphics);
    }

    private ArrayList<Double> getGridLinesAtLabelsList() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i2 = 0; i2 < this.annoHandler.valueLabels.size(); ++i2) {
            JCValueLabel jCValueLabel = this.annoHandler.valueLabels.elementAt(i2);
            ChartText chartText = jCValueLabel.getChartText();
            if (!chartText.visible || !jCValueLabel.isDrawLabel()) continue;
            arrayList.add(new Double(jCValueLabel.value));
        }
        return arrayList;
    }

    private boolean drawVertical(Graphics graphics) {
        int n2 = this.getHeight();
        int n3 = this.getTop();
        int n4 = this.linePosition();
        if (this.annoHandler.realPlacement == 5 || this.annoHandler.realPlacement == 4) {
            Rectangle rectangle = this.chartArea.getPlotRect();
            if (n4 > rectangle.x + rectangle.width || n4 < rectangle.x) {
                return false;
            }
        }
        if (this.drawAxis) {
            if (graphics.getColor() != this.getForeground()) {
                graphics.setColor(this.getForeground());
            }
            if (this.isPolar()) {
                this.drawRadialGridLine(graphics, this.yAxisAngle);
            } else if (!this.isRadar()) {
                graphics.drawLine(n4, n3, n4, n3 + n2);
            }
            this.getAxisHandler().drawTicks(graphics);
        }
        return true;
    }

    private boolean drawHorizontal(Graphics graphics) {
        int n2 = this.getWidth();
        int n3 = this.getLeft();
        int n4 = this.linePosition();
        if (this.annoHandler.realPlacement == 5 || this.annoHandler.realPlacement == 4) {
            Rectangle rectangle = this.chartArea.getPlotRect();
            if (n4 > rectangle.y + rectangle.height || n4 < rectangle.y) {
                return false;
            }
        }
        if (this.drawAxis) {
            if (graphics.getColor() != this.getForeground()) {
                graphics.setColor(this.getForeground());
            }
            if (this.isPolar()) {
                int n5 = (int)Math.round(this.polarAxisParams.radius);
                int n6 = 2 * n5;
                int n7 = (int)Math.round(this.polarAxisParams.xCenter) - n5;
                int n8 = (int)Math.round(this.polarAxisParams.yCenter) - n5;
                graphics.drawArc(n7, n8, n6, n6, 0, 360);
            } else if (!this.isRadar()) {
                graphics.drawLine(n3, n4, n3 + n2, n4);
            }
            this.getAxisHandler().drawTicks(graphics);
        }
        return true;
    }

    protected void drawWebSegment(Graphics2D graphics2D, double d2, double d3, int n2, int n3) {
        Point point = this.toPixelPolar((double)(n2 %= n3) * d3, d2, false);
        n2 = (n2 + 1) % n3;
        Point point2 = this.toPixelPolar((double)n2 * d3, d2, false);
        graphics2D.draw(new Line2D.Double(point.x, point.y, point2.x, point2.y));
    }

    protected GeneralPath createWebbedShape(double d2, int n2) {
        if (d2 <= 0.0 || n2 <= 0) {
            return null;
        }
        double d3 = JCChartUtil.getRadarAngle(2, n2, 1, false);
        GeneralPath generalPath = new GeneralPath();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = (double)i2 * d3;
            Point point = this.toPixelPolar(d4, d2, false);
            if (i2 == 0) {
                generalPath.moveTo(point.x, point.y);
                continue;
            }
            generalPath.lineTo(point.x, point.y);
        }
        generalPath.closePath();
        return generalPath;
    }

    protected void drawWebLine(Graphics graphics, JCLineStyle jCLineStyle, double d2, int n2) {
        if (graphics == null || jCLineStyle == null) {
            return;
        }
        if (jCLineStyle.updateGraphics(graphics)) {
            GeneralPath generalPath = this.createWebbedShape(d2, n2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (generalPath != null) {
                graphics2D.draw(generalPath);
            }
            jCLineStyle.resetGraphics(graphics);
        }
    }

    @Override
    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.chartArea != null) {
            return this.chartArea.getForeground();
        }
        return this.parentChart == null ? null : this.parentChart.getForeground();
    }

    @Override
    public Color getBackground() {
        if (this.chartArea != null) {
            return this.chartArea.isOpaque() ? this.chartArea.getBackground() : null;
        }
        if (this.parentChart != null) {
            return this.parentChart.isOpaque() ? this.parentChart.getBackground() : null;
        }
        return null;
    }

    @Override
    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.chartArea != null) {
            return this.chartArea.getFont();
        }
        return this.parentChart == null ? null : this.parentChart.getFont();
    }

    public JCChartArea getChartArea() {
        return this.chartArea;
    }

    public AnnotationHandler getAnnotationHandler() {
        return this.annoHandler;
    }

    public void setYAxisAngle(int n2, double d2) {
        this.yAxisAngle = JCChartUtil.convertAngle(n2, 2, d2);
        this.setChanged(true, 2);
    }

    public double getYAxisAngle(int n2) {
        return JCChartUtil.convertAngle(2, n2, this.yAxisAngle);
    }

    public void setOriginBase(int n2, double d2) {
        this.polarAxisParams.setOriginBase(n2, d2);
        this.setChanged(true, 2);
    }

    public double getOriginBase(int n2) {
        return this.polarAxisParams.getOriginBase(n2);
    }

    public void setHalfRange(boolean bl) {
        this.polarAxisParams.setPolarHalfRange(bl);
        this.setChanged(true, 2);
    }

    public boolean isHalfRange() {
        return this.polarAxisParams.isPolarHalfRange();
    }

    public void setRadarCircularGrid(boolean bl) {
        this.polarAxisParams.setCircularGrid(bl);
        this.setChanged(true, 2);
    }

    public boolean isRadarCircularGrid() {
        return this.polarAxisParams.isCircularGrid();
    }

    public Point2D.Double getPolarRadarCenter() {
        return new Point2D.Double(this.polarAxisParams.xCenter, this.polarAxisParams.yCenter);
    }

    public double getPolarRadarRadius() {
        return this.polarAxisParams.radius;
    }

    public void addAnnotation(JCAnno jCAnno) {
        if (this.annoList != null) {
            jCAnno.setParent(this);
            int n2 = jCAnno.getType();
            if (n2 == 10) {
                this.addDefaultLabels(jCAnno);
            } else if (n2 == 20) {
                this.addDefaultAnnotations(jCAnno);
            } else {
                this.annoList.add(jCAnno);
            }
            this.setChanged(true, 2);
        }
    }

    public void removeAnnotation(JCAnno jCAnno) {
        if (this.annoList != null && jCAnno != null) {
            this.annoList.remove(jCAnno);
            this.setChanged(true, 2);
        }
    }

    public void removeAnnotation(int n2) {
        if (this.annoList != null && n2 >= 0 && n2 < this.annoList.size()) {
            this.annoList.remove(n2);
            this.setChanged(true, 2);
        }
    }

    public boolean containsAnnotation(JCAnno jCAnno) {
        boolean bl = false;
        if (this.annoList != null && jCAnno != null) {
            bl = this.annoList.contains(jCAnno);
        }
        return bl;
    }

    public boolean containsAnnotation(String string) {
        boolean bl = false;
        if (this.annoList != null && string != null) {
            int n2 = this.annoList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JCAnno jCAnno = this.annoList.get(i2);
                String string2 = jCAnno.getName();
                if (string2 == null || !string2.equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void setAnnotationList(List<JCAnno> list) {
        this.annoList = list;
        this.setChanged(true, 2);
    }

    public List<JCAnno> getAnnotationList() {
        return this.annoList;
    }

    public void removeAllAnnotations() {
        if (this.annoList != null) {
            this.annoList.clear();
        }
    }

    public void removeDefaultLabels() {
        this.removeAnnotation(this.getDefaultLabels());
    }

    public void removeDefaultTicks() {
        this.removeAnnotation(this.getDefaultTicks());
    }

    public void removeDefaultGrid() {
        this.gridList.clear();
    }

    protected void updateGridObject(JCGrid jCGrid, double d2, double d3, double d4) {
        if (jCGrid != null) {
            if (jCGrid.getStartValueIsDefault()) {
                jCGrid.startValue.value = d2;
            }
            if (jCGrid.getStopValueIsDefault()) {
                jCGrid.stopValue.value = d3;
            }
            if (jCGrid.getIncrementIsDefault()) {
                jCGrid.incrementValue.value = d4;
            }
        }
    }

    protected void updateGrids() {
        if (this.gridList != null) {
            for (JCGrid jCGrid : this.gridList) {
                this.updateGridObject(jCGrid, this.min.value, this.max.value, this.numSpacing.value);
            }
        }
    }

    private void addDefaultLabels(JCAnno jCAnno) {
        if (this.annoList == null) {
            this.annoList = new ArrayList<JCAnno>();
        }
        if (this.annoList.size() == 0) {
            this.annoList.add(jCAnno);
        } else {
            this.annoList.add(0, jCAnno);
        }
    }

    private void addDefaultAnnotations(JCAnno jCAnno) {
        if (this.annoList == null) {
            this.annoList = new ArrayList<JCAnno>();
        }
        if (this.getDefaultLabels() == null) {
            if (this.annoList.size() == 0) {
                this.annoList.add(jCAnno);
            } else {
                this.annoList.add(0, jCAnno);
            }
        } else if (this.annoList.size() == 1) {
            this.annoList.add(jCAnno);
        } else {
            this.annoList.add(1, jCAnno);
        }
    }

    public void addDefaultLabels() {
        JCAnno jCAnno = new JCAnno(10, this, null);
        this.addDefaultLabels(jCAnno);
        this.setChanged(true, 2);
    }

    public void addDefaultTicks() {
        JCAnno jCAnno = new JCAnno(20, this, null);
        this.addDefaultAnnotations(jCAnno);
        this.setChanged(true, 2);
    }

    protected void makeDefaultAnnotations() {
        this.addDefaultLabels();
        this.addDefaultTicks();
    }

    protected void updateAnnotations() {
        if (this.annoList != null && this.axisHandler != null) {
            for (JCAnno jCAnno : this.annoList) {
                if (jCAnno == null) continue;
                this.axisHandler.updateAnnoObject(jCAnno);
            }
        }
    }

    public void setMaxAnnotationWidth(int n2) {
        this.getAnnotationHandler().maxAnnotationWidth = n2;
    }

    public int getMaxAnnotationWidth() {
        return this.getAnnotationHandler().maxAnnotationWidth;
    }

    public void setAnnotationTruncateMode(int n2) {
        this.getAnnotationHandler().truncateMode = n2;
    }

    public int getAnnotationTruncateMode() {
        return this.getAnnotationHandler().truncateMode;
    }

    public boolean useEllipsisWhenTruncating() {
        return this.getAnnotationHandler().useEllipsisWhenTruncating;
    }

    public void setUseEllipsisWhenTruncating(boolean bl) {
        AnnotationHandler annotationHandler = this.getAnnotationHandler();
        annotationHandler.useEllipsisWhenTruncating = bl;
    }

    protected JCAnno getAnnoObject(int n2) {
        int n3 = this.annoList.size();
        JCAnno jCAnno = null;
        for (int i2 = 0; i2 < n3; ++i2) {
            JCAnno jCAnno2 = this.annoList.get(i2);
            if (jCAnno2.getType() != n2) continue;
            jCAnno = jCAnno2;
            break;
        }
        return jCAnno;
    }

    public JCAnno getDefaultLabels() {
        return this.getAnnoObject(10);
    }

    public JCAnno getDefaultTicks() {
        return this.getAnnoObject(20);
    }

    protected void makeTickLabels() {
        if (this.annotationMethod == 0 || this.useAnnoTicks) {
            int n2 = this.annoList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JCAnno jCAnno = this.annoList.get(i2);
                if (jCAnno == null || this.annotationMethod != 0 && this.useAnnoTicks && jCAnno.drawLabels) continue;
                this.getAxisHandler().makeTickLabels(jCAnno);
            }
        }
    }

    public void setUseAnnoTicks(boolean bl) {
        this.useAnnoTicks = bl;
        this.setChanged(true, 2);
    }

    public boolean getUseAnnoTicks() {
        return this.useAnnoTicks;
    }

    public void setDropTicksForHiddenLabels(boolean bl) {
        if (this.dropTicksForHiddenLabels == bl) {
            return;
        }
        this.dropTicksForHiddenLabels = bl;
        this.setChanged(true, 2);
    }

    public boolean getDropTicksForHiddenLabels() {
        return this.dropTicksForHiddenLabels;
    }

    public boolean isAnnotateToRange() {
        return this.annotateToRange;
    }

    public void setAnnotateToRange(boolean bl) {
        if (this.annotateToRange == bl) {
            return;
        }
        this.annotateToRange = bl;
        this.setChanged(true, 2);
    }

    protected int getMaxTickOuterExtent() {
        int n2 = this.tickLength / 2;
        for (JCAnno jCAnno : this.annoList) {
            if (jCAnno.getOuterExtent() <= n2) continue;
            n2 = jCAnno.getOuterExtent();
        }
        return n2;
    }

    public List<JCGrid> getGridList() {
        return this.gridList;
    }

    public JCGrid getGrid(int n2) {
        JCGrid jCGrid = null;
        if (this.gridList != null && n2 >= 0 && n2 < this.gridList.size()) {
            jCGrid = this.gridList.get(n2);
        }
        return jCGrid;
    }

    public void addGrid(JCGrid jCGrid) {
        if (this.gridList != null) {
            jCGrid.setParent(this);
            this.gridList.add(jCGrid);
            this.setChanged(true, 2);
        }
    }

    public void removeGrid(JCGrid jCGrid) {
        if (this.gridList != null) {
            this.gridList.remove(jCGrid);
            this.setChanged(true, 2);
        }
    }

    public void removeGrid(int n2) {
        if (this.gridList != null && n2 >= 0 && n2 < this.gridList.size()) {
            this.gridList.remove(n2);
            this.setChanged(true, 2);
        }
    }

    public void removeAllGrids() {
        if (this.gridList != null) {
            this.gridList.clear();
        }
    }

    public boolean containsGrid(JCGrid jCGrid) {
        boolean bl = false;
        if (this.gridList != null) {
            bl = this.gridList.contains(jCGrid);
        }
        return bl;
    }

    public boolean containsGrid(String string) {
        boolean bl = false;
        if (this.gridList != null && string != null) {
            int n2 = this.gridList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JCGrid jCGrid = this.gridList.get(i2);
                String string2 = jCGrid.getName();
                if (string2 == null || !string2.equals(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public JCGrid getDefaultGrid() {
        JCGrid jCGrid = null;
        if (this.gridList != null) {
            for (JCGrid jCGrid2 : this.gridList) {
                if (jCGrid2 == null || !jCGrid2.isDefault()) continue;
                jCGrid = jCGrid2;
                break;
            }
        }
        return jCGrid;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setSkipWeekends(boolean bl) {
        this.skipWeekends = bl;
        this.removeSkipWeekendExclusion();
        if (bl) {
            this.addTimeExclusion(JCTimeExclusion.createWeekendExclusion(this.getTimeZone(), this.getLocale(), true));
        }
        if (this.axisHandler != null) {
            this.axisHandler.updateCalendarObject(this.hasTimeExclusions());
        }
        this.setChanged(true, 2);
    }

    private void removeSkipWeekendExclusion() {
        boolean bl = false;
        ListIterator<JCTimeExclusion> listIterator = this.timeExclusions.listIterator();
        while (listIterator.hasNext()) {
            JCTimeExclusion jCTimeExclusion = listIterator.next();
            if (!jCTimeExclusion.isSkipWeekend()) continue;
            listIterator.remove();
            bl = true;
            break;
        }
        if (bl) {
            this.calcHasTimeExclusions();
        }
    }

    private boolean hasActiveWeekendExclusion() {
        boolean bl = false;
        for (JCTimeExclusion jCTimeExclusion : this.timeExclusions) {
            if (jCTimeExclusion == null || !jCTimeExclusion.isSkipWeekend()) continue;
            bl = jCTimeExclusion.isActive();
            break;
        }
        return bl;
    }

    public boolean getSkipWeekends() {
        return this.skipWeekends && this.hasActiveWeekendExclusion();
    }

    public int getNumberOfDaysInWeekend() {
        return this.axisHandler.nDaysInWeekend;
    }

    public boolean hasTimeExclusions() {
        return this.hasTimeExclusions;
    }

    protected void calcHasTimeExclusions() {
        boolean bl = false;
        for (JCTimeExclusion jCTimeExclusion : this.timeExclusions) {
            if (jCTimeExclusion == null || !jCTimeExclusion.isActive() || !jCTimeExclusion.isUseable()) continue;
            bl = true;
            break;
        }
        this.hasTimeExclusions = bl && this.annotationMethod == 2 && this.timeUnit <= 86400000L;
    }

    public void computeExclusionSwitchList(double d2, double d3) {
        if (this.timeExclusions.size() == 0) {
            return;
        }
        Date date = this.annoHandler.dataToTime(d2, this.timeUnit);
        Date date2 = this.annoHandler.dataToTime(d3, this.timeUnit);
        for (JCTimeExclusion jCTimeExclusion : this.timeExclusions) {
            if (jCTimeExclusion == null || !jCTimeExclusion.isActive() || !jCTimeExclusion.isUseable()) continue;
            jCTimeExclusion.computeExcludeSwitchList(date, date2);
        }
    }

    public boolean isValueExcluded(double d2) {
        boolean bl = false;
        if (this.hasTimeExclusions()) {
            Date date = this.annoHandler.dataToTime(d2, this.timeUnit);
            bl = this.axisHandler.isTimeExcluded(date);
        }
        return bl;
    }

    protected boolean skipValue(double d2, double d3) {
        return d2 == d3 || this.isValueExcluded(d2) || this.isLogarithmic() && d2 <= 0.0;
    }

    public List<JCTimeExclusion> getTimeExclusions() {
        return this.timeExclusions;
    }

    public JCTimeExclusion getTimeExclusion(int n2) {
        if (n2 < 0 || n2 >= this.timeExclusions.size()) {
            throw new IllegalArgumentException("Invalid time exclusion index");
        }
        return this.timeExclusions.get(n2);
    }

    public int getNumTimeExclusions() {
        return this.timeExclusions.size();
    }

    public void addTimeExclusion(JCTimeExclusion jCTimeExclusion) {
        if (jCTimeExclusion == null) {
            return;
        }
        jCTimeExclusion.setParent(this);
        if (this.axisHandler != null && this.timeExclusions.size() == 0) {
            this.axisHandler.updateCalendarObject(true);
        }
        this.timeExclusions.add(jCTimeExclusion);
        this.calcHasTimeExclusions();
        this.setChanged(true, 2);
    }

    public void addTimeExclusion(int n2, JCTimeExclusion jCTimeExclusion) {
        if (jCTimeExclusion == null) {
            return;
        }
        if (n2 < 0 || n2 > this.timeExclusions.size()) {
            throw new IllegalArgumentException("Invalid time exclusion index");
        }
        jCTimeExclusion.setParent(this);
        if (this.axisHandler != null && this.timeExclusions.size() == 0) {
            this.axisHandler.updateCalendarObject(true);
        }
        this.timeExclusions.add(n2, jCTimeExclusion);
        this.calcHasTimeExclusions();
        this.setChanged(true, 2);
    }

    public void removeTimeExclusion(JCTimeExclusion jCTimeExclusion) {
        if (jCTimeExclusion == null) {
            return;
        }
        this.timeExclusions.remove(jCTimeExclusion);
        if (this.axisHandler != null && this.timeExclusions.size() == 0) {
            this.axisHandler.updateCalendarObject(false);
        }
        jCTimeExclusion.setParent(null);
        this.calcHasTimeExclusions();
        this.setChanged(true, 2);
    }

    public JCTimeExclusion removeTimeExclusion(int n2) {
        if (n2 < 0 || n2 >= this.timeExclusions.size()) {
            throw new IllegalArgumentException("Invalid time exclusion index");
        }
        JCTimeExclusion jCTimeExclusion = this.timeExclusions.remove(n2);
        if (jCTimeExclusion != null) {
            jCTimeExclusion.setParent(null);
            if (jCTimeExclusion.isSkipWeekend()) {
                this.skipWeekends = false;
            }
        }
        if (this.axisHandler != null && this.timeExclusions.size() == 0) {
            this.axisHandler.updateCalendarObject(false);
        }
        this.calcHasTimeExclusions();
        this.setChanged(true, 2);
        return jCTimeExclusion;
    }

    public void removeAllTimeExclusions() {
        if (this.timeExclusions.size() == 0) {
            return;
        }
        for (JCTimeExclusion jCTimeExclusion : this.timeExclusions) {
            if (jCTimeExclusion == null) continue;
            jCTimeExclusion.setParent(null);
            if (!jCTimeExclusion.isSkipWeekend()) continue;
            this.skipWeekends = false;
        }
        this.timeExclusions.clear();
        if (this.axisHandler != null) {
            this.axisHandler.updateCalendarObject(false);
        }
        this.calcHasTimeExclusions();
        this.setChanged(true, 2);
    }

    public void setUsePrecisionCalculatedBoundsForInvisibleAxis(boolean bl) {
        this.usePrecisionCalculatedBoundsForInvisibleAxis = bl;
    }

    public boolean getUsePrecisionCalculatedBoundsForInvisibleAxis() {
        return this.usePrecisionCalculatedBoundsForInvisibleAxis;
    }

    public void setShowGridLinesOnInvisibleAxis(boolean bl) {
        this.showGridLinesOnInvisibleAxis = bl;
    }

    public boolean getShowGridLinesOnInvisibleAxis() {
        return this.showGridLinesOnInvisibleAxis;
    }

    public void setDrawAxis(boolean bl) {
        this.drawAxis = bl;
    }

    public boolean getDrawAxis() {
        return this.drawAxis;
    }

    public JCPickItem pick(Point point) {
        return this.annoHandler.pick(point);
    }

    public void setTruncatedLabelTooltipEnabled(boolean bl) {
        this.truncatedLabelTooltipEnabled = bl;
    }

    public boolean isTruncatedLabelTooltipEnabled() {
        return this.truncatedLabelTooltipEnabled;
    }

    public ImageMapInfo getImageMapInfo() {
        return this.imageMapInfo;
    }

    public void setImageMapInfo(ImageMapInfo imageMapInfo) {
        this.imageMapInfo = imageMapInfo;
    }
}

