/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.LegendEntry;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.util.ImageMapInfo;
import java.io.Serializable;

public abstract class JCAbstractThreshold
implements LegendEntry,
Serializable {
    protected ChartDataView parent = null;
    protected String label = null;
    protected boolean includedInDataBounds = false;
    protected JCChartStyle chartStyle = null;
    protected boolean chartStyleDefault = true;
    protected boolean visibleInLegend = false;
    protected ImageMapInfo legendImageMapInfo = null;
    protected int pickFocus = 0;
    private double holeValue = Double.NaN;

    public JCAbstractThreshold() {
    }

    public JCAbstractThreshold(String string) {
        this.label = string;
    }

    public ChartDataView getParent() {
        return this.parent;
    }

    protected void setParent(ChartDataView chartDataView) {
        if (this.parent == chartDataView) {
            return;
        }
        ChartDataView chartDataView2 = this.parent;
        this.parent = chartDataView;
        if (this.chartStyle != null) {
            if (chartDataView2 != null) {
                this.chartStyle.removeParent(chartDataView2);
            }
            if (chartDataView != null) {
                this.chartStyle.addParent(chartDataView);
            }
        }
        this.holeValue = chartDataView == null ? Double.NaN : chartDataView.getHoleValue();
    }

    public double getHoleValue() {
        if (this.holeValue == Double.NaN) {
            if (this.parent != null) {
                this.holeValue = this.parent.getHoleValue();
            } else {
                return Double.MAX_VALUE;
            }
        }
        return this.holeValue;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isIncludedInDataBounds() {
        return this.includedInDataBounds;
    }

    public void setIncludedInDataBounds(boolean bl) {
        this.includedInDataBounds = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend && this.getChartStyle() != null;
    }

    public void setVisibleInLegend(boolean bl) {
        this.visibleInLegend = bl;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public ImageMapInfo getLegendImageMapInfo() {
        return this.legendImageMapInfo;
    }

    public void setLegendImageMapInfo(ImageMapInfo imageMapInfo) {
        this.legendImageMapInfo = imageMapInfo;
    }

    public void setPickFocus(int n2) {
        if (n2 < 0 || n2 > 3) {
            throw new IllegalArgumentException("pickFocus must be one of ChartDataView.PICK_FOCUS_XY, ChartDataView.PICK_FOCUS_X, ChartDataView.PICK_FOCUS_Y, or ChartDataView.PICK_FOCUS_NONE");
        }
        this.pickFocus = n2;
    }

    public int getPickFocus() {
        return this.pickFocus;
    }

    public int getDrawType() {
        return 1;
    }

    public JCChartStyle getChartStyle() {
        if (this.chartStyle == null && this.chartStyleDefault) {
            this.chartStyle = this.calcDefaultChartStyle();
        }
        return this.chartStyle;
    }

    public void setChartStyle(JCChartStyle jCChartStyle) {
        this.chartStyle = jCChartStyle;
        this.chartStyleDefault = false;
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    public boolean isChartStyleDefault() {
        return this.chartStyleDefault;
    }

    public void setChartStyleDefault(boolean bl) {
        if (this.chartStyleDefault == bl) {
            return;
        }
        this.chartStyleDefault = bl;
        if (bl) {
            this.chartStyle = this.calcDefaultChartStyle();
        }
        if (this.parent != null) {
            this.parent.setChanged(true, 34);
        }
    }

    protected JCChartStyle calcDefaultChartStyle() {
        return this.parent == null ? new JCChartStyle() : JCChartStyle.makeDefault(this.parent.getParent());
    }

    public boolean isValid(double d2) {
        return JCAbstractThreshold.isValid(d2, this.getHoleValue());
    }

    public static boolean isValid(double d2, double d3) {
        return d2 != d3 && d2 != Double.MAX_VALUE && d2 != -1.7976931348623157E308;
    }

    protected int transform(double d2, JCAxis jCAxis, boolean bl) {
        int n2 = jCAxis != null ? (this.parent != null && this.parent.isUsingDoublePixels() ? (int)jCAxis.toPixelDouble(d2, bl) : jCAxis.toPixel(d2, bl)) : Integer.MAX_VALUE;
        return n2;
    }

    protected int fastTransformInt(double d2, JCAxis jCAxis, boolean bl) {
        return jCAxis != null ? jCAxis.toPixel(d2, bl) : Integer.MAX_VALUE;
    }

    protected int fastTransformDouble(double d2, JCAxis jCAxis, boolean bl) {
        return jCAxis != null ? (int)jCAxis.toPixelDouble(d2, bl) : Integer.MAX_VALUE;
    }

    protected abstract void adjustMinMax(MinMax var1, boolean var2);
}

