/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.Mapper;
import com.klg.jclass.chart.ProcessShape;
import com.klg.jclass.util.Circle;
import com.klg.jclass.util.graphics.GraphicsUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class ImageMapShape
implements ProcessShape,
Serializable {
    public static final int POINT = 0;
    public static final int CLUSTER = 1;
    public static final int SERIES = 2;
    public static final int DEFAULT = 0;
    public static final int AREA_CENTER = 1;
    public static final int AREA_FORWARD = 2;
    protected Mapper mapper = null;
    protected boolean fillStyleNull = true;
    protected Shape clipShape = null;
    protected Point offset = null;
    protected boolean inverted = false;
    protected int chartType = -1;
    protected int mapType = 0;
    protected int mapMethod = 0;
    protected int plotRadius = 10;

    public ImageMapShape(Mapper mapper, Point point, boolean bl, int n2) {
        this.mapper = mapper;
        this.offset = point;
        this.inverted = bl;
        this.chartType = n2;
    }

    public ImageMapShape(Mapper mapper, Point point, boolean bl, int n2, int n3) {
        this(mapper, point, bl, n3);
        this.mapType = n2;
    }

    public ImageMapShape(Mapper mapper, Point point, boolean bl, int n2, int n3, int n4, int n5) {
        this(mapper, point, bl, n2, n5);
        this.mapMethod = n3;
        this.plotRadius = n4;
    }

    public int getShapeType() {
        return 2;
    }

    public void setChartType(int n2) {
        this.chartType = n2;
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        this.fillStyleNull = jCFillStyle == null;
    }

    public void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
    }

    public void setChartStyle(JCChartStyle jCChartStyle) {
    }

    public void tagData(JCDataIndex jCDataIndex) {
        this.mapper.setDataIndex(jCDataIndex);
    }

    public void tagData(int n2, ChartDataViewSeries chartDataViewSeries, int n3) {
        this.mapper.setDataIndex(new JCDataIndex(n2, chartDataViewSeries, n3));
    }

    public void tagDataLine(int n2, int n3, ChartDataViewSeries chartDataViewSeries, int n4) {
        this.tagData(n2, chartDataViewSeries, n4);
    }

    public void updateFillOrientation(Rectangle2D rectangle2D, int n2) {
    }

    public void resetFillOrientation() {
    }

    public void fillPolygon(Shape shape) {
        if (this.mapper != null) {
            if (shape != null && this.offset != null) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.setToTranslation(this.offset.x, this.offset.y);
                PathIterator pathIterator = shape.getPathIterator(affineTransform);
                shape = GraphicsUtil.getPolygonFromPathIterator(pathIterator);
            }
            this.mapper.addShape(shape);
        }
    }

    public void fillPolygonShadow(Shape shape) {
        this.fillPolygon(shape);
    }

    public void fillOutlinePolygon(Shape shape) {
        this.fillPolygon(shape);
    }

    public void fillOutlinePolygon(Shape shape, Color color) {
        this.fillOutlinePolygon(shape);
    }

    public void fillOutlinePolygon(Shape shape, int n2, int n3) {
        this.fillOutlinePolygon(shape);
    }

    public void fillOutlinePartialPolygon(Shape shape) {
        this.fillOutlinePolygon(shape);
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.mapper != null) {
            double d8 = Math.min(d4, d5) * 0.02;
            d8 = Math.max(0.0, d8);
            Arc2D.Double double_ = new Arc2D.Double(d2 -= (d4 *= 1.02) * 0.02 / 2.0, d3 -= (d5 *= 1.02) * 0.02 / 2.0, d4, d5, d6, d7, 2);
            PathIterator pathIterator = double_.getPathIterator(null, d8);
            Polygon polygon = new Polygon();
            while (!pathIterator.isDone()) {
                double[] dArray = new double[6];
                int n2 = pathIterator.currentSegment(dArray);
                switch (n2) {
                    case 0: 
                    case 1: {
                        polygon.addPoint((int)Math.round(dArray[0]), (int)Math.round(dArray[1]));
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        System.out.println("ImageMapShape.fillArc()  Bad PathIterator enum!");
                    }
                }
                pathIterator.next();
            }
            this.mapper.addShape(polygon);
        }
    }

    public void fillArcShadow(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.fillArc(d2, d3, d4, d5, d6, d7);
    }

    public void fillArcRegion(Point point, Point point2, double d2, double d3) {
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
    }

    public void drawLine(Line2D.Double double_, Color color) {
    }

    public void drawShape(Shape shape) {
    }

    public void drawSymbol(double d2, double d3, Color color) {
        if (this.mapper != null && (this.mapType == 0 || this.chartType == 13)) {
            Point point = this.offset != null ? this.offset : new Point(0, 0);
            Circle circle = new Circle((int)d2 + point.x, (int)d3 + point.y, this.plotRadius);
            this.mapper.addShape(circle);
        }
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
    }

    public void drawCircle(double d2, double d3, double d4) {
    }

    public Polygon clipTrapezoid(Polygon polygon, Point point, Point point2, boolean bl) {
        if (polygon == null) {
            return null;
        }
        Polygon polygon2 = new Polygon();
        for (int i2 = 0; i2 < polygon.npoints; ++i2) {
            polygon2.addPoint(polygon.xpoints[i2], polygon.ypoints[i2]);
        }
        if ((polygon2 = this.clipTrapezoidLine(polygon2, 1, polygon2.npoints - 2, point, false, bl)) != null) {
            polygon2 = this.clipTrapezoidLine(polygon2, 1, polygon2.npoints - 2, point2, true, bl);
        }
        if (polygon2 != null) {
            polygon2 = this.clipTrapezoidLine(polygon2, 0, polygon2.npoints - 1, point, false, bl);
        }
        if (polygon2 != null) {
            polygon2 = this.clipTrapezoidLine(polygon2, 0, polygon2.npoints - 1, point2, true, bl);
        }
        return polygon2;
    }

    public Polygon clipTrapezoidLine(Polygon polygon, int n2, int n3, Point point, boolean bl, boolean bl2) {
        int n4;
        int n5;
        int[] nArray;
        int[] nArray2;
        if (polygon == null) {
            return null;
        }
        if (!bl2) {
            nArray2 = polygon.xpoints;
            nArray = polygon.ypoints;
        } else {
            nArray2 = polygon.ypoints;
            nArray = polygon.xpoints;
        }
        if (nArray2[n2] < nArray2[n3]) {
            n5 = bl ? n3 : n2;
            n4 = bl ? n2 : n3;
        } else {
            n5 = bl ? n2 : n3;
            int n6 = n4 = bl ? n3 : n2;
        }
        if (bl ? nArray2[n5] > point.x : nArray2[n5] < point.x) {
            if (bl ? nArray2[n4] > point.x : nArray2[n4] < point.x) {
                return null;
            }
            nArray[n5] = nArray[n5] + (nArray[n4] - nArray[n5]) * (point.x - nArray2[n5]) / (nArray2[n4] - nArray2[n5]);
            nArray2[n5] = point.x;
        }
        int n7 = -1;
        int n8 = -1;
        if (bl ? nArray[n5] > point.y && nArray[n4] > point.y : nArray[n5] < point.y && nArray[n4] < point.y) {
            nArray[n5] = point.y;
            nArray[n4] = point.y;
        } else if (bl ? nArray[n5] > point.y || nArray[n4] > point.y : nArray[n5] < point.y || nArray[n4] < point.y) {
            n7 = nArray2[n5] + (nArray2[n4] - nArray2[n5]) * (point.y - nArray[n5]) / (nArray[n4] - nArray[n5]);
            n8 = point.y;
            if (bl ? nArray[n5] > point.y : nArray[n5] < point.y) {
                nArray[n5] = point.y;
            } else if (bl ? nArray[n4] > point.y : nArray[n4] < point.y) {
                nArray[n4] = point.y;
            }
        }
        if (n7 >= 0 && n8 >= 0) {
            boolean bl3 = false;
            Polygon polygon2 = new Polygon();
            for (int i2 = 0; i2 < polygon.npoints; ++i2) {
                polygon2.addPoint(polygon.xpoints[i2], polygon.ypoints[i2]);
                if (i2 != n5 && i2 != n4 || i2 == 0 || bl3) continue;
                if (!bl2) {
                    polygon2.addPoint(n7, n8);
                } else {
                    polygon2.addPoint(n8, n7);
                }
                bl3 = true;
            }
            polygon = polygon2;
        }
        return polygon;
    }

    public void drawString(String string, int n2, int n3) {
        if (this.clipShape != null) {
            this.fillPolygon(this.clipShape);
        }
    }

    public void setColor(Color color) {
    }

    public void setClip(Shape shape) {
        this.clipShape = shape;
    }

    public Shape getClip() {
        return this.clipShape;
    }

    public boolean isWithinClip() {
        return true;
    }

    public FontMetrics getFontMetrics() {
        return null;
    }
}

